/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputRoutedState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TakeRouterInputResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, TakeRouterInputResponse> {
    private static final SdkField<String> ROUTED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutedState").getter(TakeRouterInputResponse.getter(TakeRouterInputResponse::routedStateAsString)).setter(TakeRouterInputResponse.setter(Builder::routedState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedState").build()}).build();
    private static final SdkField<String> ROUTER_OUTPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouterOutputArn").getter(TakeRouterInputResponse.getter(TakeRouterInputResponse::routerOutputArn)).setter(TakeRouterInputResponse.setter(Builder::routerOutputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerOutputArn").build()}).build();
    private static final SdkField<String> ROUTER_OUTPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouterOutputName").getter(TakeRouterInputResponse.getter(TakeRouterInputResponse::routerOutputName)).setter(TakeRouterInputResponse.setter(Builder::routerOutputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerOutputName").build()}).build();
    private static final SdkField<String> ROUTER_INPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouterInputArn").getter(TakeRouterInputResponse.getter(TakeRouterInputResponse::routerInputArn)).setter(TakeRouterInputResponse.setter(Builder::routerInputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInputArn").build()}).build();
    private static final SdkField<String> ROUTER_INPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouterInputName").getter(TakeRouterInputResponse.getter(TakeRouterInputResponse::routerInputName)).setter(TakeRouterInputResponse.setter(Builder::routerInputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInputName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTED_STATE_FIELD, ROUTER_OUTPUT_ARN_FIELD, ROUTER_OUTPUT_NAME_FIELD, ROUTER_INPUT_ARN_FIELD, ROUTER_INPUT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TakeRouterInputResponse.memberNameToFieldInitializer();
    private final String routedState;
    private final String routerOutputArn;
    private final String routerOutputName;
    private final String routerInputArn;
    private final String routerInputName;

    private TakeRouterInputResponse(BuilderImpl builder) {
        super(builder);
        this.routedState = builder.routedState;
        this.routerOutputArn = builder.routerOutputArn;
        this.routerOutputName = builder.routerOutputName;
        this.routerInputArn = builder.routerInputArn;
        this.routerInputName = builder.routerInputName;
    }

    public final RouterOutputRoutedState routedState() {
        return RouterOutputRoutedState.fromValue(this.routedState);
    }

    public final String routedStateAsString() {
        return this.routedState;
    }

    public final String routerOutputArn() {
        return this.routerOutputArn;
    }

    public final String routerOutputName() {
        return this.routerOutputName;
    }

    public final String routerInputArn() {
        return this.routerInputArn;
    }

    public final String routerInputName() {
        return this.routerInputName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routedStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routerOutputArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routerOutputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.routerInputArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routerInputName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TakeRouterInputResponse)) {
            return false;
        }
        TakeRouterInputResponse other = (TakeRouterInputResponse)((Object)obj);
        return Objects.equals(this.routedStateAsString(), other.routedStateAsString()) && Objects.equals(this.routerOutputArn(), other.routerOutputArn()) && Objects.equals(this.routerOutputName(), other.routerOutputName()) && Objects.equals(this.routerInputArn(), other.routerInputArn()) && Objects.equals(this.routerInputName(), other.routerInputName());
    }

    public final String toString() {
        return ToString.builder((String)"TakeRouterInputResponse").add("RoutedState", (Object)this.routedStateAsString()).add("RouterOutputArn", (Object)this.routerOutputArn()).add("RouterOutputName", (Object)this.routerOutputName()).add("RouterInputArn", (Object)this.routerInputArn()).add("RouterInputName", (Object)this.routerInputName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutedState": {
                return Optional.ofNullable(clazz.cast(this.routedStateAsString()));
            }
            case "RouterOutputArn": {
                return Optional.ofNullable(clazz.cast(this.routerOutputArn()));
            }
            case "RouterOutputName": {
                return Optional.ofNullable(clazz.cast(this.routerOutputName()));
            }
            case "RouterInputArn": {
                return Optional.ofNullable(clazz.cast(this.routerInputArn()));
            }
            case "RouterInputName": {
                return Optional.ofNullable(clazz.cast(this.routerInputName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("routedState", ROUTED_STATE_FIELD);
        map.put("routerOutputArn", ROUTER_OUTPUT_ARN_FIELD);
        map.put("routerOutputName", ROUTER_OUTPUT_NAME_FIELD);
        map.put("routerInputArn", ROUTER_INPUT_ARN_FIELD);
        map.put("routerInputName", ROUTER_INPUT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TakeRouterInputResponse, T> g) {
        return obj -> g.apply((TakeRouterInputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String routedState;
        private String routerOutputArn;
        private String routerOutputName;
        private String routerInputArn;
        private String routerInputName;

        private BuilderImpl() {
        }

        private BuilderImpl(TakeRouterInputResponse model) {
            super(model);
            this.routedState(model.routedState);
            this.routerOutputArn(model.routerOutputArn);
            this.routerOutputName(model.routerOutputName);
            this.routerInputArn(model.routerInputArn);
            this.routerInputName(model.routerInputName);
        }

        public final String getRoutedState() {
            return this.routedState;
        }

        public final void setRoutedState(String routedState) {
            this.routedState = routedState;
        }

        @Override
        public final Builder routedState(String routedState) {
            this.routedState = routedState;
            return this;
        }

        @Override
        public final Builder routedState(RouterOutputRoutedState routedState) {
            this.routedState(routedState == null ? null : routedState.toString());
            return this;
        }

        public final String getRouterOutputArn() {
            return this.routerOutputArn;
        }

        public final void setRouterOutputArn(String routerOutputArn) {
            this.routerOutputArn = routerOutputArn;
        }

        @Override
        public final Builder routerOutputArn(String routerOutputArn) {
            this.routerOutputArn = routerOutputArn;
            return this;
        }

        public final String getRouterOutputName() {
            return this.routerOutputName;
        }

        public final void setRouterOutputName(String routerOutputName) {
            this.routerOutputName = routerOutputName;
        }

        @Override
        public final Builder routerOutputName(String routerOutputName) {
            this.routerOutputName = routerOutputName;
            return this;
        }

        public final String getRouterInputArn() {
            return this.routerInputArn;
        }

        public final void setRouterInputArn(String routerInputArn) {
            this.routerInputArn = routerInputArn;
        }

        @Override
        public final Builder routerInputArn(String routerInputArn) {
            this.routerInputArn = routerInputArn;
            return this;
        }

        public final String getRouterInputName() {
            return this.routerInputName;
        }

        public final void setRouterInputName(String routerInputName) {
            this.routerInputName = routerInputName;
        }

        @Override
        public final Builder routerInputName(String routerInputName) {
            this.routerInputName = routerInputName;
            return this;
        }

        @Override
        public TakeRouterInputResponse build() {
            return new TakeRouterInputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TakeRouterInputResponse> {
        public Builder routedState(String var1);

        public Builder routedState(RouterOutputRoutedState var1);

        public Builder routerOutputArn(String var1);

        public Builder routerOutputName(String var1);

        public Builder routerInputArn(String var1);

        public Builder routerInputName(String var1);
    }
}

