/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectFlowRouterOutputStreamDetails;
import software.amazon.awssdk.services.mediaconnect.model.MediaLiveInputRouterOutputStreamDetails;
import software.amazon.awssdk.services.mediaconnect.model.StandardRouterOutputStreamDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterOutputStreamDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterOutputStreamDetails> {
    private static final SdkField<StandardRouterOutputStreamDetails> STANDARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Standard").getter(RouterOutputStreamDetails.getter(RouterOutputStreamDetails::standard)).setter(RouterOutputStreamDetails.setter(Builder::standard)).constructor(StandardRouterOutputStreamDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standard").build()}).build();
    private static final SdkField<MediaConnectFlowRouterOutputStreamDetails> MEDIA_CONNECT_FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaConnectFlow").getter(RouterOutputStreamDetails.getter(RouterOutputStreamDetails::mediaConnectFlow)).setter(RouterOutputStreamDetails.setter(Builder::mediaConnectFlow)).constructor(MediaConnectFlowRouterOutputStreamDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlow").build()}).build();
    private static final SdkField<MediaLiveInputRouterOutputStreamDetails> MEDIA_LIVE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaLiveInput").getter(RouterOutputStreamDetails.getter(RouterOutputStreamDetails::mediaLiveInput)).setter(RouterOutputStreamDetails.setter(Builder::mediaLiveInput)).constructor(MediaLiveInputRouterOutputStreamDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaLiveInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_FIELD, MEDIA_CONNECT_FLOW_FIELD, MEDIA_LIVE_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterOutputStreamDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final StandardRouterOutputStreamDetails standard;
    private final MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow;
    private final MediaLiveInputRouterOutputStreamDetails mediaLiveInput;
    private final Type type;

    private RouterOutputStreamDetails(BuilderImpl builder) {
        this.standard = builder.standard;
        this.mediaConnectFlow = builder.mediaConnectFlow;
        this.mediaLiveInput = builder.mediaLiveInput;
        this.type = builder.type;
    }

    public final StandardRouterOutputStreamDetails standard() {
        return this.standard;
    }

    public final MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow() {
        return this.mediaConnectFlow;
    }

    public final MediaLiveInputRouterOutputStreamDetails mediaLiveInput() {
        return this.mediaLiveInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standard());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaConnectFlow());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaLiveInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterOutputStreamDetails)) {
            return false;
        }
        RouterOutputStreamDetails other = (RouterOutputStreamDetails)obj;
        return Objects.equals(this.standard(), other.standard()) && Objects.equals(this.mediaConnectFlow(), other.mediaConnectFlow()) && Objects.equals(this.mediaLiveInput(), other.mediaLiveInput());
    }

    public final String toString() {
        return ToString.builder((String)"RouterOutputStreamDetails").add("Standard", (Object)this.standard()).add("MediaConnectFlow", (Object)this.mediaConnectFlow()).add("MediaLiveInput", (Object)this.mediaLiveInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Standard": {
                return Optional.ofNullable(clazz.cast(this.standard()));
            }
            case "MediaConnectFlow": {
                return Optional.ofNullable(clazz.cast(this.mediaConnectFlow()));
            }
            case "MediaLiveInput": {
                return Optional.ofNullable(clazz.cast(this.mediaLiveInput()));
            }
        }
        return Optional.empty();
    }

    public static RouterOutputStreamDetails fromStandard(StandardRouterOutputStreamDetails standard) {
        return (RouterOutputStreamDetails)RouterOutputStreamDetails.builder().standard(standard).build();
    }

    public static RouterOutputStreamDetails fromStandard(Consumer<StandardRouterOutputStreamDetails.Builder> standard) {
        StandardRouterOutputStreamDetails.Builder builder = StandardRouterOutputStreamDetails.builder();
        standard.accept(builder);
        return RouterOutputStreamDetails.fromStandard((StandardRouterOutputStreamDetails)builder.build());
    }

    public static RouterOutputStreamDetails fromMediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow) {
        return (RouterOutputStreamDetails)RouterOutputStreamDetails.builder().mediaConnectFlow(mediaConnectFlow).build();
    }

    public static RouterOutputStreamDetails fromMediaConnectFlow(Consumer<MediaConnectFlowRouterOutputStreamDetails.Builder> mediaConnectFlow) {
        MediaConnectFlowRouterOutputStreamDetails.Builder builder = MediaConnectFlowRouterOutputStreamDetails.builder();
        mediaConnectFlow.accept(builder);
        return RouterOutputStreamDetails.fromMediaConnectFlow((MediaConnectFlowRouterOutputStreamDetails)builder.build());
    }

    public static RouterOutputStreamDetails fromMediaLiveInput(MediaLiveInputRouterOutputStreamDetails mediaLiveInput) {
        return (RouterOutputStreamDetails)RouterOutputStreamDetails.builder().mediaLiveInput(mediaLiveInput).build();
    }

    public static RouterOutputStreamDetails fromMediaLiveInput(Consumer<MediaLiveInputRouterOutputStreamDetails.Builder> mediaLiveInput) {
        MediaLiveInputRouterOutputStreamDetails.Builder builder = MediaLiveInputRouterOutputStreamDetails.builder();
        mediaLiveInput.accept(builder);
        return RouterOutputStreamDetails.fromMediaLiveInput((MediaLiveInputRouterOutputStreamDetails)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("standard", STANDARD_FIELD);
        map.put("mediaConnectFlow", MEDIA_CONNECT_FLOW_FIELD);
        map.put("mediaLiveInput", MEDIA_LIVE_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterOutputStreamDetails, T> g) {
        return obj -> g.apply((RouterOutputStreamDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STANDARD,
        MEDIA_CONNECT_FLOW,
        MEDIA_LIVE_INPUT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private StandardRouterOutputStreamDetails standard;
        private MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow;
        private MediaLiveInputRouterOutputStreamDetails mediaLiveInput;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterOutputStreamDetails model) {
            this.standard(model.standard);
            this.mediaConnectFlow(model.mediaConnectFlow);
            this.mediaLiveInput(model.mediaLiveInput);
        }

        public final StandardRouterOutputStreamDetails.Builder getStandard() {
            return this.standard != null ? this.standard.toBuilder() : null;
        }

        public final void setStandard(StandardRouterOutputStreamDetails.BuilderImpl standard) {
            StandardRouterOutputStreamDetails oldValue = this.standard;
            this.standard = standard != null ? standard.build() : null;
            this.handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
        }

        @Override
        public final Builder standard(StandardRouterOutputStreamDetails standard) {
            StandardRouterOutputStreamDetails oldValue = this.standard;
            this.standard = standard;
            this.handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
            return this;
        }

        public final MediaConnectFlowRouterOutputStreamDetails.Builder getMediaConnectFlow() {
            return this.mediaConnectFlow != null ? this.mediaConnectFlow.toBuilder() : null;
        }

        public final void setMediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails.BuilderImpl mediaConnectFlow) {
            MediaConnectFlowRouterOutputStreamDetails oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow != null ? mediaConnectFlow.build() : null;
            this.handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
        }

        @Override
        public final Builder mediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow) {
            MediaConnectFlowRouterOutputStreamDetails oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow;
            this.handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
            return this;
        }

        public final MediaLiveInputRouterOutputStreamDetails.Builder getMediaLiveInput() {
            return this.mediaLiveInput != null ? this.mediaLiveInput.toBuilder() : null;
        }

        public final void setMediaLiveInput(MediaLiveInputRouterOutputStreamDetails.BuilderImpl mediaLiveInput) {
            MediaLiveInputRouterOutputStreamDetails oldValue = this.mediaLiveInput;
            this.mediaLiveInput = mediaLiveInput != null ? mediaLiveInput.build() : null;
            this.handleUnionValueChange(Type.MEDIA_LIVE_INPUT, oldValue, this.mediaLiveInput);
        }

        @Override
        public final Builder mediaLiveInput(MediaLiveInputRouterOutputStreamDetails mediaLiveInput) {
            MediaLiveInputRouterOutputStreamDetails oldValue = this.mediaLiveInput;
            this.mediaLiveInput = mediaLiveInput;
            this.handleUnionValueChange(Type.MEDIA_LIVE_INPUT, oldValue, this.mediaLiveInput);
            return this;
        }

        public RouterOutputStreamDetails build() {
            return new RouterOutputStreamDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterOutputStreamDetails> {
        public Builder standard(StandardRouterOutputStreamDetails var1);

        default public Builder standard(Consumer<StandardRouterOutputStreamDetails.Builder> standard) {
            return this.standard((StandardRouterOutputStreamDetails)((StandardRouterOutputStreamDetails.Builder)StandardRouterOutputStreamDetails.builder().applyMutation(standard)).build());
        }

        public Builder mediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails var1);

        default public Builder mediaConnectFlow(Consumer<MediaConnectFlowRouterOutputStreamDetails.Builder> mediaConnectFlow) {
            return this.mediaConnectFlow((MediaConnectFlowRouterOutputStreamDetails)((MediaConnectFlowRouterOutputStreamDetails.Builder)MediaConnectFlowRouterOutputStreamDetails.builder().applyMutation(mediaConnectFlow)).build());
        }

        public Builder mediaLiveInput(MediaLiveInputRouterOutputStreamDetails var1);

        default public Builder mediaLiveInput(Consumer<MediaLiveInputRouterOutputStreamDetails.Builder> mediaLiveInput) {
            return this.mediaLiveInput((MediaLiveInputRouterOutputStreamDetails)((MediaLiveInputRouterOutputStreamDetails.Builder)MediaLiveInputRouterOutputStreamDetails.builder().applyMutation(mediaLiveInput)).build());
        }
    }
}

