/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputArnListCopier;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceArnListCopier;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputType;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputTypeListCopier;
import software.amazon.awssdk.services.mediaconnect.model.RoutingScope;
import software.amazon.awssdk.services.mediaconnect.model.RoutingScopeListCopier;
import software.amazon.awssdk.services.mediaconnect.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterOutputFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterOutputFilter> {
    private static final SdkField<List<String>> REGION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionNames").getter(RouterOutputFilter.getter(RouterOutputFilter::regionNames)).setter(RouterOutputFilter.setter(Builder::regionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OUTPUT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputTypes").getter(RouterOutputFilter.getter(RouterOutputFilter::outputTypesAsStrings)).setter(RouterOutputFilter.setter(Builder::outputTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NameContains").getter(RouterOutputFilter.getter(RouterOutputFilter::nameContains)).setter(RouterOutputFilter.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameContains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaceArns").getter(RouterOutputFilter.getter(RouterOutputFilter::networkInterfaceArns)).setter(RouterOutputFilter.setter(Builder::networkInterfaceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ROUTED_INPUT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutedInputArns").getter(RouterOutputFilter.getter(RouterOutputFilter::routedInputArns)).setter(RouterOutputFilter.setter(Builder::routedInputArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedInputArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ROUTING_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingScopes").getter(RouterOutputFilter.getter(RouterOutputFilter::routingScopesAsStrings)).setter(RouterOutputFilter.setter(Builder::routingScopesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAMES_FIELD, OUTPUT_TYPES_FIELD, NAME_CONTAINS_FIELD, NETWORK_INTERFACE_ARNS_FIELD, ROUTED_INPUT_ARNS_FIELD, ROUTING_SCOPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterOutputFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> regionNames;
    private final List<String> outputTypes;
    private final List<String> nameContains;
    private final List<String> networkInterfaceArns;
    private final List<String> routedInputArns;
    private final List<String> routingScopes;
    private final Type type;

    private RouterOutputFilter(BuilderImpl builder) {
        this.regionNames = builder.regionNames;
        this.outputTypes = builder.outputTypes;
        this.nameContains = builder.nameContains;
        this.networkInterfaceArns = builder.networkInterfaceArns;
        this.routedInputArns = builder.routedInputArns;
        this.routingScopes = builder.routingScopes;
        this.type = builder.type;
    }

    public final boolean hasRegionNames() {
        return this.regionNames != null && !(this.regionNames instanceof SdkAutoConstructList);
    }

    public final List<String> regionNames() {
        return this.regionNames;
    }

    public final List<RouterOutputType> outputTypes() {
        return RouterOutputTypeListCopier.copyStringToEnum(this.outputTypes);
    }

    public final boolean hasOutputTypes() {
        return this.outputTypes != null && !(this.outputTypes instanceof SdkAutoConstructList);
    }

    public final List<String> outputTypesAsStrings() {
        return this.outputTypes;
    }

    public final boolean hasNameContains() {
        return this.nameContains != null && !(this.nameContains instanceof SdkAutoConstructList);
    }

    public final List<String> nameContains() {
        return this.nameContains;
    }

    public final boolean hasNetworkInterfaceArns() {
        return this.networkInterfaceArns != null && !(this.networkInterfaceArns instanceof SdkAutoConstructList);
    }

    public final List<String> networkInterfaceArns() {
        return this.networkInterfaceArns;
    }

    public final boolean hasRoutedInputArns() {
        return this.routedInputArns != null && !(this.routedInputArns instanceof SdkAutoConstructList);
    }

    public final List<String> routedInputArns() {
        return this.routedInputArns;
    }

    public final List<RoutingScope> routingScopes() {
        return RoutingScopeListCopier.copyStringToEnum(this.routingScopes);
    }

    public final boolean hasRoutingScopes() {
        return this.routingScopes != null && !(this.routingScopes instanceof SdkAutoConstructList);
    }

    public final List<String> routingScopesAsStrings() {
        return this.routingScopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionNames() ? this.regionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputTypes() ? this.outputTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNameContains() ? this.nameContains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaceArns() ? this.networkInterfaceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutedInputArns() ? this.routedInputArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingScopes() ? this.routingScopesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterOutputFilter)) {
            return false;
        }
        RouterOutputFilter other = (RouterOutputFilter)obj;
        return this.hasRegionNames() == other.hasRegionNames() && Objects.equals(this.regionNames(), other.regionNames()) && this.hasOutputTypes() == other.hasOutputTypes() && Objects.equals(this.outputTypesAsStrings(), other.outputTypesAsStrings()) && this.hasNameContains() == other.hasNameContains() && Objects.equals(this.nameContains(), other.nameContains()) && this.hasNetworkInterfaceArns() == other.hasNetworkInterfaceArns() && Objects.equals(this.networkInterfaceArns(), other.networkInterfaceArns()) && this.hasRoutedInputArns() == other.hasRoutedInputArns() && Objects.equals(this.routedInputArns(), other.routedInputArns()) && this.hasRoutingScopes() == other.hasRoutingScopes() && Objects.equals(this.routingScopesAsStrings(), other.routingScopesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RouterOutputFilter").add("RegionNames", this.hasRegionNames() ? this.regionNames() : null).add("OutputTypes", this.hasOutputTypes() ? this.outputTypesAsStrings() : null).add("NameContains", this.hasNameContains() ? this.nameContains() : null).add("NetworkInterfaceArns", this.hasNetworkInterfaceArns() ? this.networkInterfaceArns() : null).add("RoutedInputArns", this.hasRoutedInputArns() ? this.routedInputArns() : null).add("RoutingScopes", this.hasRoutingScopes() ? this.routingScopesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionNames": {
                return Optional.ofNullable(clazz.cast(this.regionNames()));
            }
            case "OutputTypes": {
                return Optional.ofNullable(clazz.cast(this.outputTypesAsStrings()));
            }
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "NetworkInterfaceArns": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceArns()));
            }
            case "RoutedInputArns": {
                return Optional.ofNullable(clazz.cast(this.routedInputArns()));
            }
            case "RoutingScopes": {
                return Optional.ofNullable(clazz.cast(this.routingScopesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public static RouterOutputFilter fromRegionNames(List<String> regionNames) {
        return (RouterOutputFilter)RouterOutputFilter.builder().regionNames(regionNames).build();
    }

    public static RouterOutputFilter fromOutputTypesWithStrings(List<String> outputTypesWithStrings) {
        return (RouterOutputFilter)RouterOutputFilter.builder().outputTypesWithStrings(outputTypesWithStrings).build();
    }

    public static RouterOutputFilter fromOutputTypes(List<RouterOutputType> outputTypesWithStrings) {
        return (RouterOutputFilter)RouterOutputFilter.builder().outputTypes(outputTypesWithStrings).build();
    }

    public static RouterOutputFilter fromNameContains(List<String> nameContains) {
        return (RouterOutputFilter)RouterOutputFilter.builder().nameContains(nameContains).build();
    }

    public static RouterOutputFilter fromNetworkInterfaceArns(List<String> networkInterfaceArns) {
        return (RouterOutputFilter)RouterOutputFilter.builder().networkInterfaceArns(networkInterfaceArns).build();
    }

    public static RouterOutputFilter fromRoutedInputArns(List<String> routedInputArns) {
        return (RouterOutputFilter)RouterOutputFilter.builder().routedInputArns(routedInputArns).build();
    }

    public static RouterOutputFilter fromRoutingScopesWithStrings(List<String> routingScopesWithStrings) {
        return (RouterOutputFilter)RouterOutputFilter.builder().routingScopesWithStrings(routingScopesWithStrings).build();
    }

    public static RouterOutputFilter fromRoutingScopes(List<RoutingScope> routingScopesWithStrings) {
        return (RouterOutputFilter)RouterOutputFilter.builder().routingScopes(routingScopesWithStrings).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("regionNames", REGION_NAMES_FIELD);
        map.put("outputTypes", OUTPUT_TYPES_FIELD);
        map.put("nameContains", NAME_CONTAINS_FIELD);
        map.put("networkInterfaceArns", NETWORK_INTERFACE_ARNS_FIELD);
        map.put("routedInputArns", ROUTED_INPUT_ARNS_FIELD);
        map.put("routingScopes", ROUTING_SCOPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterOutputFilter, T> g) {
        return obj -> g.apply((RouterOutputFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        REGION_NAMES,
        OUTPUT_TYPES,
        NAME_CONTAINS,
        NETWORK_INTERFACE_ARNS,
        ROUTED_INPUT_ARNS,
        ROUTING_SCOPES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<String> regionNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> outputTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> nameContains = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkInterfaceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> routedInputArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> routingScopes = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterOutputFilter model) {
            this.regionNames(model.regionNames);
            this.outputTypesWithStrings(model.outputTypes);
            this.nameContains(model.nameContains);
            this.networkInterfaceArns(model.networkInterfaceArns);
            this.routedInputArns(model.routedInputArns);
            this.routingScopesWithStrings(model.routingScopes);
        }

        public final Collection<String> getRegionNames() {
            if (this.regionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionNames;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            List<String> oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            this.handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
        }

        @Override
        public final Builder regionNames(Collection<String> regionNames) {
            List<String> oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            this.handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionNames(String ... regionNames) {
            this.regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final Collection<String> getOutputTypes() {
            if (this.outputTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputTypes;
        }

        public final void setOutputTypes(Collection<String> outputTypes) {
            List<String> oldValue = this.outputTypes;
            this.outputTypes = RouterOutputTypeListCopier.copy(outputTypes);
            this.handleUnionValueChange(Type.OUTPUT_TYPES, oldValue, this.outputTypes);
        }

        @Override
        public final Builder outputTypesWithStrings(Collection<String> outputTypes) {
            List<String> oldValue = this.outputTypes;
            this.outputTypes = RouterOutputTypeListCopier.copy(outputTypes);
            this.handleUnionValueChange(Type.OUTPUT_TYPES, oldValue, this.outputTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputTypesWithStrings(String ... outputTypes) {
            this.outputTypesWithStrings(Arrays.asList(outputTypes));
            return this;
        }

        @Override
        public final Builder outputTypes(Collection<RouterOutputType> outputTypes) {
            List<String> oldValue = this.outputTypes;
            this.outputTypes = RouterOutputTypeListCopier.copyEnumToString(outputTypes);
            this.handleUnionValueChange(Type.OUTPUT_TYPES, oldValue, this.outputTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputTypes(RouterOutputType ... outputTypes) {
            this.outputTypes(Arrays.asList(outputTypes));
            return this;
        }

        public final Collection<String> getNameContains() {
            if (this.nameContains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nameContains;
        }

        public final void setNameContains(Collection<String> nameContains) {
            List<String> oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            this.handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
        }

        @Override
        public final Builder nameContains(Collection<String> nameContains) {
            List<String> oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            this.handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameContains(String ... nameContains) {
            this.nameContains(Arrays.asList(nameContains));
            return this;
        }

        public final Collection<String> getNetworkInterfaceArns() {
            if (this.networkInterfaceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfaceArns;
        }

        public final void setNetworkInterfaceArns(Collection<String> networkInterfaceArns) {
            List<String> oldValue = this.networkInterfaceArns;
            this.networkInterfaceArns = RouterNetworkInterfaceArnListCopier.copy(networkInterfaceArns);
            this.handleUnionValueChange(Type.NETWORK_INTERFACE_ARNS, oldValue, this.networkInterfaceArns);
        }

        @Override
        public final Builder networkInterfaceArns(Collection<String> networkInterfaceArns) {
            List<String> oldValue = this.networkInterfaceArns;
            this.networkInterfaceArns = RouterNetworkInterfaceArnListCopier.copy(networkInterfaceArns);
            this.handleUnionValueChange(Type.NETWORK_INTERFACE_ARNS, oldValue, this.networkInterfaceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceArns(String ... networkInterfaceArns) {
            this.networkInterfaceArns(Arrays.asList(networkInterfaceArns));
            return this;
        }

        public final Collection<String> getRoutedInputArns() {
            if (this.routedInputArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routedInputArns;
        }

        public final void setRoutedInputArns(Collection<String> routedInputArns) {
            List<String> oldValue = this.routedInputArns;
            this.routedInputArns = RouterInputArnListCopier.copy(routedInputArns);
            this.handleUnionValueChange(Type.ROUTED_INPUT_ARNS, oldValue, this.routedInputArns);
        }

        @Override
        public final Builder routedInputArns(Collection<String> routedInputArns) {
            List<String> oldValue = this.routedInputArns;
            this.routedInputArns = RouterInputArnListCopier.copy(routedInputArns);
            this.handleUnionValueChange(Type.ROUTED_INPUT_ARNS, oldValue, this.routedInputArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routedInputArns(String ... routedInputArns) {
            this.routedInputArns(Arrays.asList(routedInputArns));
            return this;
        }

        public final Collection<String> getRoutingScopes() {
            if (this.routingScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routingScopes;
        }

        public final void setRoutingScopes(Collection<String> routingScopes) {
            List<String> oldValue = this.routingScopes;
            this.routingScopes = RoutingScopeListCopier.copy(routingScopes);
            this.handleUnionValueChange(Type.ROUTING_SCOPES, oldValue, this.routingScopes);
        }

        @Override
        public final Builder routingScopesWithStrings(Collection<String> routingScopes) {
            List<String> oldValue = this.routingScopes;
            this.routingScopes = RoutingScopeListCopier.copy(routingScopes);
            this.handleUnionValueChange(Type.ROUTING_SCOPES, oldValue, this.routingScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingScopesWithStrings(String ... routingScopes) {
            this.routingScopesWithStrings(Arrays.asList(routingScopes));
            return this;
        }

        @Override
        public final Builder routingScopes(Collection<RoutingScope> routingScopes) {
            List<String> oldValue = this.routingScopes;
            this.routingScopes = RoutingScopeListCopier.copyEnumToString(routingScopes);
            this.handleUnionValueChange(Type.ROUTING_SCOPES, oldValue, this.routingScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingScopes(RoutingScope ... routingScopes) {
            this.routingScopes(Arrays.asList(routingScopes));
            return this;
        }

        public RouterOutputFilter build() {
            return new RouterOutputFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterOutputFilter> {
        public Builder regionNames(Collection<String> var1);

        public Builder regionNames(String ... var1);

        public Builder outputTypesWithStrings(Collection<String> var1);

        public Builder outputTypesWithStrings(String ... var1);

        public Builder outputTypes(Collection<RouterOutputType> var1);

        public Builder outputTypes(RouterOutputType ... var1);

        public Builder nameContains(Collection<String> var1);

        public Builder nameContains(String ... var1);

        public Builder networkInterfaceArns(Collection<String> var1);

        public Builder networkInterfaceArns(String ... var1);

        public Builder routedInputArns(Collection<String> var1);

        public Builder routedInputArns(String ... var1);

        public Builder routingScopesWithStrings(Collection<String> var1);

        public Builder routingScopesWithStrings(String ... var1);

        public Builder routingScopes(Collection<RoutingScope> var1);

        public Builder routingScopes(RoutingScope ... var1);
    }
}

