/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.FailoverRouterInputStreamDetails;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectFlowRouterInputStreamDetails;
import software.amazon.awssdk.services.mediaconnect.model.MergeRouterInputStreamDetails;
import software.amazon.awssdk.services.mediaconnect.model.StandardRouterInputStreamDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterInputStreamDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterInputStreamDetails> {
    private static final SdkField<StandardRouterInputStreamDetails> STANDARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Standard").getter(RouterInputStreamDetails.getter(RouterInputStreamDetails::standard)).setter(RouterInputStreamDetails.setter(Builder::standard)).constructor(StandardRouterInputStreamDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standard").build()}).build();
    private static final SdkField<FailoverRouterInputStreamDetails> FAILOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Failover").getter(RouterInputStreamDetails.getter(RouterInputStreamDetails::failover)).setter(RouterInputStreamDetails.setter(Builder::failover)).constructor(FailoverRouterInputStreamDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failover").build()}).build();
    private static final SdkField<MergeRouterInputStreamDetails> MERGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Merge").getter(RouterInputStreamDetails.getter(RouterInputStreamDetails::merge)).setter(RouterInputStreamDetails.setter(Builder::merge)).constructor(MergeRouterInputStreamDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("merge").build()}).build();
    private static final SdkField<MediaConnectFlowRouterInputStreamDetails> MEDIA_CONNECT_FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaConnectFlow").getter(RouterInputStreamDetails.getter(RouterInputStreamDetails::mediaConnectFlow)).setter(RouterInputStreamDetails.setter(Builder::mediaConnectFlow)).constructor(MediaConnectFlowRouterInputStreamDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_FIELD, FAILOVER_FIELD, MERGE_FIELD, MEDIA_CONNECT_FLOW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterInputStreamDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final StandardRouterInputStreamDetails standard;
    private final FailoverRouterInputStreamDetails failover;
    private final MergeRouterInputStreamDetails merge;
    private final MediaConnectFlowRouterInputStreamDetails mediaConnectFlow;
    private final Type type;

    private RouterInputStreamDetails(BuilderImpl builder) {
        this.standard = builder.standard;
        this.failover = builder.failover;
        this.merge = builder.merge;
        this.mediaConnectFlow = builder.mediaConnectFlow;
        this.type = builder.type;
    }

    public final StandardRouterInputStreamDetails standard() {
        return this.standard;
    }

    public final FailoverRouterInputStreamDetails failover() {
        return this.failover;
    }

    public final MergeRouterInputStreamDetails merge() {
        return this.merge;
    }

    public final MediaConnectFlowRouterInputStreamDetails mediaConnectFlow() {
        return this.mediaConnectFlow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standard());
        hashCode = 31 * hashCode + Objects.hashCode(this.failover());
        hashCode = 31 * hashCode + Objects.hashCode(this.merge());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaConnectFlow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputStreamDetails)) {
            return false;
        }
        RouterInputStreamDetails other = (RouterInputStreamDetails)obj;
        return Objects.equals(this.standard(), other.standard()) && Objects.equals(this.failover(), other.failover()) && Objects.equals(this.merge(), other.merge()) && Objects.equals(this.mediaConnectFlow(), other.mediaConnectFlow());
    }

    public final String toString() {
        return ToString.builder((String)"RouterInputStreamDetails").add("Standard", (Object)this.standard()).add("Failover", (Object)this.failover()).add("Merge", (Object)this.merge()).add("MediaConnectFlow", (Object)this.mediaConnectFlow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Standard": {
                return Optional.ofNullable(clazz.cast(this.standard()));
            }
            case "Failover": {
                return Optional.ofNullable(clazz.cast(this.failover()));
            }
            case "Merge": {
                return Optional.ofNullable(clazz.cast(this.merge()));
            }
            case "MediaConnectFlow": {
                return Optional.ofNullable(clazz.cast(this.mediaConnectFlow()));
            }
        }
        return Optional.empty();
    }

    public static RouterInputStreamDetails fromStandard(StandardRouterInputStreamDetails standard) {
        return (RouterInputStreamDetails)RouterInputStreamDetails.builder().standard(standard).build();
    }

    public static RouterInputStreamDetails fromStandard(Consumer<StandardRouterInputStreamDetails.Builder> standard) {
        StandardRouterInputStreamDetails.Builder builder = StandardRouterInputStreamDetails.builder();
        standard.accept(builder);
        return RouterInputStreamDetails.fromStandard((StandardRouterInputStreamDetails)builder.build());
    }

    public static RouterInputStreamDetails fromFailover(FailoverRouterInputStreamDetails failover) {
        return (RouterInputStreamDetails)RouterInputStreamDetails.builder().failover(failover).build();
    }

    public static RouterInputStreamDetails fromFailover(Consumer<FailoverRouterInputStreamDetails.Builder> failover) {
        FailoverRouterInputStreamDetails.Builder builder = FailoverRouterInputStreamDetails.builder();
        failover.accept(builder);
        return RouterInputStreamDetails.fromFailover((FailoverRouterInputStreamDetails)builder.build());
    }

    public static RouterInputStreamDetails fromMerge(MergeRouterInputStreamDetails merge) {
        return (RouterInputStreamDetails)RouterInputStreamDetails.builder().merge(merge).build();
    }

    public static RouterInputStreamDetails fromMerge(Consumer<MergeRouterInputStreamDetails.Builder> merge) {
        MergeRouterInputStreamDetails.Builder builder = MergeRouterInputStreamDetails.builder();
        merge.accept(builder);
        return RouterInputStreamDetails.fromMerge((MergeRouterInputStreamDetails)builder.build());
    }

    public static RouterInputStreamDetails fromMediaConnectFlow(MediaConnectFlowRouterInputStreamDetails mediaConnectFlow) {
        return (RouterInputStreamDetails)RouterInputStreamDetails.builder().mediaConnectFlow(mediaConnectFlow).build();
    }

    public static RouterInputStreamDetails fromMediaConnectFlow(Consumer<MediaConnectFlowRouterInputStreamDetails.Builder> mediaConnectFlow) {
        MediaConnectFlowRouterInputStreamDetails.Builder builder = MediaConnectFlowRouterInputStreamDetails.builder();
        mediaConnectFlow.accept(builder);
        return RouterInputStreamDetails.fromMediaConnectFlow((MediaConnectFlowRouterInputStreamDetails)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("standard", STANDARD_FIELD);
        map.put("failover", FAILOVER_FIELD);
        map.put("merge", MERGE_FIELD);
        map.put("mediaConnectFlow", MEDIA_CONNECT_FLOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputStreamDetails, T> g) {
        return obj -> g.apply((RouterInputStreamDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STANDARD,
        FAILOVER,
        MERGE,
        MEDIA_CONNECT_FLOW,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private StandardRouterInputStreamDetails standard;
        private FailoverRouterInputStreamDetails failover;
        private MergeRouterInputStreamDetails merge;
        private MediaConnectFlowRouterInputStreamDetails mediaConnectFlow;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputStreamDetails model) {
            this.standard(model.standard);
            this.failover(model.failover);
            this.merge(model.merge);
            this.mediaConnectFlow(model.mediaConnectFlow);
        }

        public final StandardRouterInputStreamDetails.Builder getStandard() {
            return this.standard != null ? this.standard.toBuilder() : null;
        }

        public final void setStandard(StandardRouterInputStreamDetails.BuilderImpl standard) {
            StandardRouterInputStreamDetails oldValue = this.standard;
            this.standard = standard != null ? standard.build() : null;
            this.handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
        }

        @Override
        public final Builder standard(StandardRouterInputStreamDetails standard) {
            StandardRouterInputStreamDetails oldValue = this.standard;
            this.standard = standard;
            this.handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
            return this;
        }

        public final FailoverRouterInputStreamDetails.Builder getFailover() {
            return this.failover != null ? this.failover.toBuilder() : null;
        }

        public final void setFailover(FailoverRouterInputStreamDetails.BuilderImpl failover) {
            FailoverRouterInputStreamDetails oldValue = this.failover;
            this.failover = failover != null ? failover.build() : null;
            this.handleUnionValueChange(Type.FAILOVER, oldValue, this.failover);
        }

        @Override
        public final Builder failover(FailoverRouterInputStreamDetails failover) {
            FailoverRouterInputStreamDetails oldValue = this.failover;
            this.failover = failover;
            this.handleUnionValueChange(Type.FAILOVER, oldValue, this.failover);
            return this;
        }

        public final MergeRouterInputStreamDetails.Builder getMerge() {
            return this.merge != null ? this.merge.toBuilder() : null;
        }

        public final void setMerge(MergeRouterInputStreamDetails.BuilderImpl merge) {
            MergeRouterInputStreamDetails oldValue = this.merge;
            this.merge = merge != null ? merge.build() : null;
            this.handleUnionValueChange(Type.MERGE, oldValue, this.merge);
        }

        @Override
        public final Builder merge(MergeRouterInputStreamDetails merge) {
            MergeRouterInputStreamDetails oldValue = this.merge;
            this.merge = merge;
            this.handleUnionValueChange(Type.MERGE, oldValue, this.merge);
            return this;
        }

        public final MediaConnectFlowRouterInputStreamDetails.Builder getMediaConnectFlow() {
            return this.mediaConnectFlow != null ? this.mediaConnectFlow.toBuilder() : null;
        }

        public final void setMediaConnectFlow(MediaConnectFlowRouterInputStreamDetails.BuilderImpl mediaConnectFlow) {
            MediaConnectFlowRouterInputStreamDetails oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow != null ? mediaConnectFlow.build() : null;
            this.handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
        }

        @Override
        public final Builder mediaConnectFlow(MediaConnectFlowRouterInputStreamDetails mediaConnectFlow) {
            MediaConnectFlowRouterInputStreamDetails oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow;
            this.handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
            return this;
        }

        public RouterInputStreamDetails build() {
            return new RouterInputStreamDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterInputStreamDetails> {
        public Builder standard(StandardRouterInputStreamDetails var1);

        default public Builder standard(Consumer<StandardRouterInputStreamDetails.Builder> standard) {
            return this.standard((StandardRouterInputStreamDetails)((StandardRouterInputStreamDetails.Builder)StandardRouterInputStreamDetails.builder().applyMutation(standard)).build());
        }

        public Builder failover(FailoverRouterInputStreamDetails var1);

        default public Builder failover(Consumer<FailoverRouterInputStreamDetails.Builder> failover) {
            return this.failover((FailoverRouterInputStreamDetails)((FailoverRouterInputStreamDetails.Builder)FailoverRouterInputStreamDetails.builder().applyMutation(failover)).build());
        }

        public Builder merge(MergeRouterInputStreamDetails var1);

        default public Builder merge(Consumer<MergeRouterInputStreamDetails.Builder> merge) {
            return this.merge((MergeRouterInputStreamDetails)((MergeRouterInputStreamDetails.Builder)MergeRouterInputStreamDetails.builder().applyMutation(merge)).build());
        }

        public Builder mediaConnectFlow(MediaConnectFlowRouterInputStreamDetails var1);

        default public Builder mediaConnectFlow(Consumer<MediaConnectFlowRouterInputStreamDetails.Builder> mediaConnectFlow) {
            return this.mediaConnectFlow((MediaConnectFlowRouterInputStreamDetails)((MediaConnectFlowRouterInputStreamDetails.Builder)MediaConnectFlowRouterInputStreamDetails.builder().applyMutation(mediaConnectFlow)).build());
        }
    }
}

