/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouterInputProtocol {
    RTP("RTP"),
    RIST("RIST"),
    SRT_CALLER("SRT_CALLER"),
    SRT_LISTENER("SRT_LISTENER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouterInputProtocol> VALUE_MAP;
    private final String value;

    private RouterInputProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouterInputProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouterInputProtocol> knownValues() {
        EnumSet<RouterInputProtocol> knownValues = EnumSet.allOf(RouterInputProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouterInputProtocol.class, RouterInputProtocol::toString);
    }
}

