/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.TransportMediaInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterInputMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterInputMetadata> {
    private static final SdkField<TransportMediaInfo> TRANSPORT_STREAM_MEDIA_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransportStreamMediaInfo").getter(RouterInputMetadata.getter(RouterInputMetadata::transportStreamMediaInfo)).setter(RouterInputMetadata.setter(Builder::transportStreamMediaInfo)).constructor(TransportMediaInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamMediaInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSPORT_STREAM_MEDIA_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterInputMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TransportMediaInfo transportStreamMediaInfo;
    private final Type type;

    private RouterInputMetadata(BuilderImpl builder) {
        this.transportStreamMediaInfo = builder.transportStreamMediaInfo;
        this.type = builder.type;
    }

    public final TransportMediaInfo transportStreamMediaInfo() {
        return this.transportStreamMediaInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamMediaInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputMetadata)) {
            return false;
        }
        RouterInputMetadata other = (RouterInputMetadata)obj;
        return Objects.equals(this.transportStreamMediaInfo(), other.transportStreamMediaInfo());
    }

    public final String toString() {
        return ToString.builder((String)"RouterInputMetadata").add("TransportStreamMediaInfo", (Object)this.transportStreamMediaInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransportStreamMediaInfo": {
                return Optional.ofNullable(clazz.cast(this.transportStreamMediaInfo()));
            }
        }
        return Optional.empty();
    }

    public static RouterInputMetadata fromTransportStreamMediaInfo(TransportMediaInfo transportStreamMediaInfo) {
        return (RouterInputMetadata)RouterInputMetadata.builder().transportStreamMediaInfo(transportStreamMediaInfo).build();
    }

    public static RouterInputMetadata fromTransportStreamMediaInfo(Consumer<TransportMediaInfo.Builder> transportStreamMediaInfo) {
        TransportMediaInfo.Builder builder = TransportMediaInfo.builder();
        transportStreamMediaInfo.accept(builder);
        return RouterInputMetadata.fromTransportStreamMediaInfo((TransportMediaInfo)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<TransportMediaInfo>> map = new HashMap<String, SdkField<TransportMediaInfo>>();
        map.put("transportStreamMediaInfo", TRANSPORT_STREAM_MEDIA_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputMetadata, T> g) {
        return obj -> g.apply((RouterInputMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TRANSPORT_STREAM_MEDIA_INFO,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TransportMediaInfo transportStreamMediaInfo;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputMetadata model) {
            this.transportStreamMediaInfo(model.transportStreamMediaInfo);
        }

        public final TransportMediaInfo.Builder getTransportStreamMediaInfo() {
            return this.transportStreamMediaInfo != null ? this.transportStreamMediaInfo.toBuilder() : null;
        }

        public final void setTransportStreamMediaInfo(TransportMediaInfo.BuilderImpl transportStreamMediaInfo) {
            TransportMediaInfo oldValue = this.transportStreamMediaInfo;
            this.transportStreamMediaInfo = transportStreamMediaInfo != null ? transportStreamMediaInfo.build() : null;
            this.handleUnionValueChange(Type.TRANSPORT_STREAM_MEDIA_INFO, oldValue, this.transportStreamMediaInfo);
        }

        @Override
        public final Builder transportStreamMediaInfo(TransportMediaInfo transportStreamMediaInfo) {
            TransportMediaInfo oldValue = this.transportStreamMediaInfo;
            this.transportStreamMediaInfo = transportStreamMediaInfo;
            this.handleUnionValueChange(Type.TRANSPORT_STREAM_MEDIA_INFO, oldValue, this.transportStreamMediaInfo);
            return this;
        }

        public RouterInputMetadata build() {
            return new RouterInputMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterInputMetadata> {
        public Builder transportStreamMediaInfo(TransportMediaInfo var1);

        default public Builder transportStreamMediaInfo(Consumer<TransportMediaInfo.Builder> transportStreamMediaInfo) {
            return this.transportStreamMediaInfo((TransportMediaInfo)((TransportMediaInfo.Builder)TransportMediaInfo.builder().applyMutation(transportStreamMediaInfo)).build());
        }
    }
}

