/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputType;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputTypeListCopier;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceArnListCopier;
import software.amazon.awssdk.services.mediaconnect.model.RoutingScope;
import software.amazon.awssdk.services.mediaconnect.model.RoutingScopeListCopier;
import software.amazon.awssdk.services.mediaconnect.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterInputFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterInputFilter> {
    private static final SdkField<List<String>> REGION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionNames").getter(RouterInputFilter.getter(RouterInputFilter::regionNames)).setter(RouterInputFilter.setter(Builder::regionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INPUT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputTypes").getter(RouterInputFilter.getter(RouterInputFilter::inputTypesAsStrings)).setter(RouterInputFilter.setter(Builder::inputTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NameContains").getter(RouterInputFilter.getter(RouterInputFilter::nameContains)).setter(RouterInputFilter.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameContains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaceArns").getter(RouterInputFilter.getter(RouterInputFilter::networkInterfaceArns)).setter(RouterInputFilter.setter(Builder::networkInterfaceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ROUTING_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingScopes").getter(RouterInputFilter.getter(RouterInputFilter::routingScopesAsStrings)).setter(RouterInputFilter.setter(Builder::routingScopesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAMES_FIELD, INPUT_TYPES_FIELD, NAME_CONTAINS_FIELD, NETWORK_INTERFACE_ARNS_FIELD, ROUTING_SCOPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterInputFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> regionNames;
    private final List<String> inputTypes;
    private final List<String> nameContains;
    private final List<String> networkInterfaceArns;
    private final List<String> routingScopes;
    private final Type type;

    private RouterInputFilter(BuilderImpl builder) {
        this.regionNames = builder.regionNames;
        this.inputTypes = builder.inputTypes;
        this.nameContains = builder.nameContains;
        this.networkInterfaceArns = builder.networkInterfaceArns;
        this.routingScopes = builder.routingScopes;
        this.type = builder.type;
    }

    public final boolean hasRegionNames() {
        return this.regionNames != null && !(this.regionNames instanceof SdkAutoConstructList);
    }

    public final List<String> regionNames() {
        return this.regionNames;
    }

    public final List<RouterInputType> inputTypes() {
        return RouterInputTypeListCopier.copyStringToEnum(this.inputTypes);
    }

    public final boolean hasInputTypes() {
        return this.inputTypes != null && !(this.inputTypes instanceof SdkAutoConstructList);
    }

    public final List<String> inputTypesAsStrings() {
        return this.inputTypes;
    }

    public final boolean hasNameContains() {
        return this.nameContains != null && !(this.nameContains instanceof SdkAutoConstructList);
    }

    public final List<String> nameContains() {
        return this.nameContains;
    }

    public final boolean hasNetworkInterfaceArns() {
        return this.networkInterfaceArns != null && !(this.networkInterfaceArns instanceof SdkAutoConstructList);
    }

    public final List<String> networkInterfaceArns() {
        return this.networkInterfaceArns;
    }

    public final List<RoutingScope> routingScopes() {
        return RoutingScopeListCopier.copyStringToEnum(this.routingScopes);
    }

    public final boolean hasRoutingScopes() {
        return this.routingScopes != null && !(this.routingScopes instanceof SdkAutoConstructList);
    }

    public final List<String> routingScopesAsStrings() {
        return this.routingScopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionNames() ? this.regionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputTypes() ? this.inputTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNameContains() ? this.nameContains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaceArns() ? this.networkInterfaceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingScopes() ? this.routingScopesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputFilter)) {
            return false;
        }
        RouterInputFilter other = (RouterInputFilter)obj;
        return this.hasRegionNames() == other.hasRegionNames() && Objects.equals(this.regionNames(), other.regionNames()) && this.hasInputTypes() == other.hasInputTypes() && Objects.equals(this.inputTypesAsStrings(), other.inputTypesAsStrings()) && this.hasNameContains() == other.hasNameContains() && Objects.equals(this.nameContains(), other.nameContains()) && this.hasNetworkInterfaceArns() == other.hasNetworkInterfaceArns() && Objects.equals(this.networkInterfaceArns(), other.networkInterfaceArns()) && this.hasRoutingScopes() == other.hasRoutingScopes() && Objects.equals(this.routingScopesAsStrings(), other.routingScopesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RouterInputFilter").add("RegionNames", this.hasRegionNames() ? this.regionNames() : null).add("InputTypes", this.hasInputTypes() ? this.inputTypesAsStrings() : null).add("NameContains", this.hasNameContains() ? this.nameContains() : null).add("NetworkInterfaceArns", this.hasNetworkInterfaceArns() ? this.networkInterfaceArns() : null).add("RoutingScopes", this.hasRoutingScopes() ? this.routingScopesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionNames": {
                return Optional.ofNullable(clazz.cast(this.regionNames()));
            }
            case "InputTypes": {
                return Optional.ofNullable(clazz.cast(this.inputTypesAsStrings()));
            }
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "NetworkInterfaceArns": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceArns()));
            }
            case "RoutingScopes": {
                return Optional.ofNullable(clazz.cast(this.routingScopesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public static RouterInputFilter fromRegionNames(List<String> regionNames) {
        return (RouterInputFilter)RouterInputFilter.builder().regionNames(regionNames).build();
    }

    public static RouterInputFilter fromInputTypesWithStrings(List<String> inputTypesWithStrings) {
        return (RouterInputFilter)RouterInputFilter.builder().inputTypesWithStrings(inputTypesWithStrings).build();
    }

    public static RouterInputFilter fromInputTypes(List<RouterInputType> inputTypesWithStrings) {
        return (RouterInputFilter)RouterInputFilter.builder().inputTypes(inputTypesWithStrings).build();
    }

    public static RouterInputFilter fromNameContains(List<String> nameContains) {
        return (RouterInputFilter)RouterInputFilter.builder().nameContains(nameContains).build();
    }

    public static RouterInputFilter fromNetworkInterfaceArns(List<String> networkInterfaceArns) {
        return (RouterInputFilter)RouterInputFilter.builder().networkInterfaceArns(networkInterfaceArns).build();
    }

    public static RouterInputFilter fromRoutingScopesWithStrings(List<String> routingScopesWithStrings) {
        return (RouterInputFilter)RouterInputFilter.builder().routingScopesWithStrings(routingScopesWithStrings).build();
    }

    public static RouterInputFilter fromRoutingScopes(List<RoutingScope> routingScopesWithStrings) {
        return (RouterInputFilter)RouterInputFilter.builder().routingScopes(routingScopesWithStrings).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("regionNames", REGION_NAMES_FIELD);
        map.put("inputTypes", INPUT_TYPES_FIELD);
        map.put("nameContains", NAME_CONTAINS_FIELD);
        map.put("networkInterfaceArns", NETWORK_INTERFACE_ARNS_FIELD);
        map.put("routingScopes", ROUTING_SCOPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputFilter, T> g) {
        return obj -> g.apply((RouterInputFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        REGION_NAMES,
        INPUT_TYPES,
        NAME_CONTAINS,
        NETWORK_INTERFACE_ARNS,
        ROUTING_SCOPES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<String> regionNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> inputTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> nameContains = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkInterfaceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> routingScopes = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputFilter model) {
            this.regionNames(model.regionNames);
            this.inputTypesWithStrings(model.inputTypes);
            this.nameContains(model.nameContains);
            this.networkInterfaceArns(model.networkInterfaceArns);
            this.routingScopesWithStrings(model.routingScopes);
        }

        public final Collection<String> getRegionNames() {
            if (this.regionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionNames;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            List<String> oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            this.handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
        }

        @Override
        public final Builder regionNames(Collection<String> regionNames) {
            List<String> oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            this.handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionNames(String ... regionNames) {
            this.regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final Collection<String> getInputTypes() {
            if (this.inputTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputTypes;
        }

        public final void setInputTypes(Collection<String> inputTypes) {
            List<String> oldValue = this.inputTypes;
            this.inputTypes = RouterInputTypeListCopier.copy(inputTypes);
            this.handleUnionValueChange(Type.INPUT_TYPES, oldValue, this.inputTypes);
        }

        @Override
        public final Builder inputTypesWithStrings(Collection<String> inputTypes) {
            List<String> oldValue = this.inputTypes;
            this.inputTypes = RouterInputTypeListCopier.copy(inputTypes);
            this.handleUnionValueChange(Type.INPUT_TYPES, oldValue, this.inputTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputTypesWithStrings(String ... inputTypes) {
            this.inputTypesWithStrings(Arrays.asList(inputTypes));
            return this;
        }

        @Override
        public final Builder inputTypes(Collection<RouterInputType> inputTypes) {
            List<String> oldValue = this.inputTypes;
            this.inputTypes = RouterInputTypeListCopier.copyEnumToString(inputTypes);
            this.handleUnionValueChange(Type.INPUT_TYPES, oldValue, this.inputTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputTypes(RouterInputType ... inputTypes) {
            this.inputTypes(Arrays.asList(inputTypes));
            return this;
        }

        public final Collection<String> getNameContains() {
            if (this.nameContains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nameContains;
        }

        public final void setNameContains(Collection<String> nameContains) {
            List<String> oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            this.handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
        }

        @Override
        public final Builder nameContains(Collection<String> nameContains) {
            List<String> oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            this.handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameContains(String ... nameContains) {
            this.nameContains(Arrays.asList(nameContains));
            return this;
        }

        public final Collection<String> getNetworkInterfaceArns() {
            if (this.networkInterfaceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfaceArns;
        }

        public final void setNetworkInterfaceArns(Collection<String> networkInterfaceArns) {
            List<String> oldValue = this.networkInterfaceArns;
            this.networkInterfaceArns = RouterNetworkInterfaceArnListCopier.copy(networkInterfaceArns);
            this.handleUnionValueChange(Type.NETWORK_INTERFACE_ARNS, oldValue, this.networkInterfaceArns);
        }

        @Override
        public final Builder networkInterfaceArns(Collection<String> networkInterfaceArns) {
            List<String> oldValue = this.networkInterfaceArns;
            this.networkInterfaceArns = RouterNetworkInterfaceArnListCopier.copy(networkInterfaceArns);
            this.handleUnionValueChange(Type.NETWORK_INTERFACE_ARNS, oldValue, this.networkInterfaceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceArns(String ... networkInterfaceArns) {
            this.networkInterfaceArns(Arrays.asList(networkInterfaceArns));
            return this;
        }

        public final Collection<String> getRoutingScopes() {
            if (this.routingScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routingScopes;
        }

        public final void setRoutingScopes(Collection<String> routingScopes) {
            List<String> oldValue = this.routingScopes;
            this.routingScopes = RoutingScopeListCopier.copy(routingScopes);
            this.handleUnionValueChange(Type.ROUTING_SCOPES, oldValue, this.routingScopes);
        }

        @Override
        public final Builder routingScopesWithStrings(Collection<String> routingScopes) {
            List<String> oldValue = this.routingScopes;
            this.routingScopes = RoutingScopeListCopier.copy(routingScopes);
            this.handleUnionValueChange(Type.ROUTING_SCOPES, oldValue, this.routingScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingScopesWithStrings(String ... routingScopes) {
            this.routingScopesWithStrings(Arrays.asList(routingScopes));
            return this;
        }

        @Override
        public final Builder routingScopes(Collection<RoutingScope> routingScopes) {
            List<String> oldValue = this.routingScopes;
            this.routingScopes = RoutingScopeListCopier.copyEnumToString(routingScopes);
            this.handleUnionValueChange(Type.ROUTING_SCOPES, oldValue, this.routingScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingScopes(RoutingScope ... routingScopes) {
            this.routingScopes(Arrays.asList(routingScopes));
            return this;
        }

        public RouterInputFilter build() {
            return new RouterInputFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterInputFilter> {
        public Builder regionNames(Collection<String> var1);

        public Builder regionNames(String ... var1);

        public Builder inputTypesWithStrings(Collection<String> var1);

        public Builder inputTypesWithStrings(String ... var1);

        public Builder inputTypes(Collection<RouterInputType> var1);

        public Builder inputTypes(RouterInputType ... var1);

        public Builder nameContains(Collection<String> var1);

        public Builder nameContains(String ... var1);

        public Builder networkInterfaceArns(Collection<String> var1);

        public Builder networkInterfaceArns(String ... var1);

        public Builder routingScopesWithStrings(Collection<String> var1);

        public Builder routingScopesWithStrings(String ... var1);

        public Builder routingScopes(Collection<RoutingScope> var1);

        public Builder routingScopes(RoutingScope ... var1);
    }
}

