/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceSchedule;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceScheduleType;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceType;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputMessagesCopier;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputState;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputStreamDetails;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputTier;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputTransitEncryption;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputType;
import software.amazon.awssdk.services.mediaconnect.model.RoutingScope;
import software.amazon.awssdk.services.mediaconnect.model.___mapOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RouterInput.getter(RouterInput::name)).setter(RouterInput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RouterInput.getter(RouterInput::arn)).setter(RouterInput.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RouterInput.getter(RouterInput::id)).setter(RouterInput.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RouterInput.getter(RouterInput::stateAsString)).setter(RouterInput.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputType").getter(RouterInput.getter(RouterInput::inputTypeAsString)).setter(RouterInput.setter(Builder::inputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputType").build()}).build();
    private static final SdkField<RouterInputConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(RouterInput.getter(RouterInput::configuration)).setter(RouterInput.setter(Builder::configuration)).constructor(RouterInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Integer> ROUTED_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RoutedOutputs").getter(RouterInput.getter(RouterInput::routedOutputs)).setter(RouterInput.setter(Builder::routedOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedOutputs").build()}).build();
    private static final SdkField<Integer> MAXIMUM_ROUTED_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRoutedOutputs").getter(RouterInput.getter(RouterInput::maximumRoutedOutputs)).setter(RouterInput.setter(Builder::maximumRoutedOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumRoutedOutputs").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(RouterInput.getter(RouterInput::regionName)).setter(RouterInput.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(RouterInput.getter(RouterInput::availabilityZone)).setter(RouterInput.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<Long> MAXIMUM_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaximumBitrate").getter(RouterInput.getter(RouterInput::maximumBitrate)).setter(RouterInput.setter(Builder::maximumBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(RouterInput.getter(RouterInput::tierAsString)).setter(RouterInput.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<String> ROUTING_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingScope").getter(RouterInput.getter(RouterInput::routingScopeAsString)).setter(RouterInput.setter(Builder::routingScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScope").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(RouterInput.getter(RouterInput::createdAt)).setter(RouterInput.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(RouterInput.getter(RouterInput::updatedAt)).setter(RouterInput.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<RouterInputMessage>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Messages").getter(RouterInput.getter(RouterInput::messages)).setter(RouterInput.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouterInputMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouterInputTransitEncryption> TRANSIT_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransitEncryption").getter(RouterInput.getter(RouterInput::transitEncryption)).setter(RouterInput.setter(Builder::transitEncryption)).constructor(RouterInputTransitEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitEncryption").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RouterInput.getter(RouterInput::tags)).setter(RouterInput.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<RouterInputStreamDetails> STREAM_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamDetails").getter(RouterInput.getter(RouterInput::streamDetails)).setter(RouterInput.setter(Builder::streamDetails)).constructor(RouterInputStreamDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamDetails").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(RouterInput.getter(RouterInput::ipAddress)).setter(RouterInput.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> MAINTENANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceType").getter(RouterInput.getter(RouterInput::maintenanceTypeAsString)).setter(RouterInput.setter(Builder::maintenanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceType").build()}).build();
    private static final SdkField<MaintenanceConfiguration> MAINTENANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceConfiguration").getter(RouterInput.getter(RouterInput::maintenanceConfiguration)).setter(RouterInput.setter(Builder::maintenanceConfiguration)).constructor(MaintenanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceConfiguration").build()}).build();
    private static final SdkField<String> MAINTENANCE_SCHEDULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceScheduleType").getter(RouterInput.getter(RouterInput::maintenanceScheduleTypeAsString)).setter(RouterInput.setter(Builder::maintenanceScheduleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceScheduleType").build()}).build();
    private static final SdkField<MaintenanceSchedule> MAINTENANCE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceSchedule").getter(RouterInput.getter(RouterInput::maintenanceSchedule)).setter(RouterInput.setter(Builder::maintenanceSchedule)).constructor(MaintenanceSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceSchedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ID_FIELD, STATE_FIELD, INPUT_TYPE_FIELD, CONFIGURATION_FIELD, ROUTED_OUTPUTS_FIELD, MAXIMUM_ROUTED_OUTPUTS_FIELD, REGION_NAME_FIELD, AVAILABILITY_ZONE_FIELD, MAXIMUM_BITRATE_FIELD, TIER_FIELD, ROUTING_SCOPE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, MESSAGES_FIELD, TRANSIT_ENCRYPTION_FIELD, TAGS_FIELD, STREAM_DETAILS_FIELD, IP_ADDRESS_FIELD, MAINTENANCE_TYPE_FIELD, MAINTENANCE_CONFIGURATION_FIELD, MAINTENANCE_SCHEDULE_TYPE_FIELD, MAINTENANCE_SCHEDULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String id;
    private final String state;
    private final String inputType;
    private final RouterInputConfiguration configuration;
    private final Integer routedOutputs;
    private final Integer maximumRoutedOutputs;
    private final String regionName;
    private final String availabilityZone;
    private final Long maximumBitrate;
    private final String tier;
    private final String routingScope;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<RouterInputMessage> messages;
    private final RouterInputTransitEncryption transitEncryption;
    private final Map<String, String> tags;
    private final RouterInputStreamDetails streamDetails;
    private final String ipAddress;
    private final String maintenanceType;
    private final MaintenanceConfiguration maintenanceConfiguration;
    private final String maintenanceScheduleType;
    private final MaintenanceSchedule maintenanceSchedule;

    private RouterInput(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.state = builder.state;
        this.inputType = builder.inputType;
        this.configuration = builder.configuration;
        this.routedOutputs = builder.routedOutputs;
        this.maximumRoutedOutputs = builder.maximumRoutedOutputs;
        this.regionName = builder.regionName;
        this.availabilityZone = builder.availabilityZone;
        this.maximumBitrate = builder.maximumBitrate;
        this.tier = builder.tier;
        this.routingScope = builder.routingScope;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.messages = builder.messages;
        this.transitEncryption = builder.transitEncryption;
        this.tags = builder.tags;
        this.streamDetails = builder.streamDetails;
        this.ipAddress = builder.ipAddress;
        this.maintenanceType = builder.maintenanceType;
        this.maintenanceConfiguration = builder.maintenanceConfiguration;
        this.maintenanceScheduleType = builder.maintenanceScheduleType;
        this.maintenanceSchedule = builder.maintenanceSchedule;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final RouterInputState state() {
        return RouterInputState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final RouterInputType inputType() {
        return RouterInputType.fromValue(this.inputType);
    }

    public final String inputTypeAsString() {
        return this.inputType;
    }

    public final RouterInputConfiguration configuration() {
        return this.configuration;
    }

    public final Integer routedOutputs() {
        return this.routedOutputs;
    }

    public final Integer maximumRoutedOutputs() {
        return this.maximumRoutedOutputs;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Long maximumBitrate() {
        return this.maximumBitrate;
    }

    public final RouterInputTier tier() {
        return RouterInputTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final RoutingScope routingScope() {
        return RoutingScope.fromValue(this.routingScope);
    }

    public final String routingScopeAsString() {
        return this.routingScope;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<RouterInputMessage> messages() {
        return this.messages;
    }

    public final RouterInputTransitEncryption transitEncryption() {
        return this.transitEncryption;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final RouterInputStreamDetails streamDetails() {
        return this.streamDetails;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final MaintenanceType maintenanceType() {
        return MaintenanceType.fromValue(this.maintenanceType);
    }

    public final String maintenanceTypeAsString() {
        return this.maintenanceType;
    }

    public final MaintenanceConfiguration maintenanceConfiguration() {
        return this.maintenanceConfiguration;
    }

    public final MaintenanceScheduleType maintenanceScheduleType() {
        return MaintenanceScheduleType.fromValue(this.maintenanceScheduleType);
    }

    public final String maintenanceScheduleTypeAsString() {
        return this.maintenanceScheduleType;
    }

    public final MaintenanceSchedule maintenanceSchedule() {
        return this.maintenanceSchedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.routedOutputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRoutedOutputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.streamDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceScheduleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceSchedule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInput)) {
            return false;
        }
        RouterInput other = (RouterInput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.inputTypeAsString(), other.inputTypeAsString()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.routedOutputs(), other.routedOutputs()) && Objects.equals(this.maximumRoutedOutputs(), other.maximumRoutedOutputs()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.maximumBitrate(), other.maximumBitrate()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.routingScopeAsString(), other.routingScopeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.transitEncryption(), other.transitEncryption()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.streamDetails(), other.streamDetails()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.maintenanceTypeAsString(), other.maintenanceTypeAsString()) && Objects.equals(this.maintenanceConfiguration(), other.maintenanceConfiguration()) && Objects.equals(this.maintenanceScheduleTypeAsString(), other.maintenanceScheduleTypeAsString()) && Objects.equals(this.maintenanceSchedule(), other.maintenanceSchedule());
    }

    public final String toString() {
        return ToString.builder((String)"RouterInput").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("State", (Object)this.stateAsString()).add("InputType", (Object)this.inputTypeAsString()).add("Configuration", (Object)this.configuration()).add("RoutedOutputs", (Object)this.routedOutputs()).add("MaximumRoutedOutputs", (Object)this.maximumRoutedOutputs()).add("RegionName", (Object)this.regionName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("MaximumBitrate", (Object)this.maximumBitrate()).add("Tier", (Object)this.tierAsString()).add("RoutingScope", (Object)this.routingScopeAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Messages", this.hasMessages() ? this.messages() : null).add("TransitEncryption", (Object)this.transitEncryption()).add("Tags", this.hasTags() ? this.tags() : null).add("StreamDetails", (Object)this.streamDetails()).add("IpAddress", (Object)this.ipAddress()).add("MaintenanceType", (Object)this.maintenanceTypeAsString()).add("MaintenanceConfiguration", (Object)this.maintenanceConfiguration()).add("MaintenanceScheduleType", (Object)this.maintenanceScheduleTypeAsString()).add("MaintenanceSchedule", (Object)this.maintenanceSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "InputType": {
                return Optional.ofNullable(clazz.cast(this.inputTypeAsString()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "RoutedOutputs": {
                return Optional.ofNullable(clazz.cast(this.routedOutputs()));
            }
            case "MaximumRoutedOutputs": {
                return Optional.ofNullable(clazz.cast(this.maximumRoutedOutputs()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "MaximumBitrate": {
                return Optional.ofNullable(clazz.cast(this.maximumBitrate()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "RoutingScope": {
                return Optional.ofNullable(clazz.cast(this.routingScopeAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "TransitEncryption": {
                return Optional.ofNullable(clazz.cast(this.transitEncryption()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StreamDetails": {
                return Optional.ofNullable(clazz.cast(this.streamDetails()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "MaintenanceType": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTypeAsString()));
            }
            case "MaintenanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.maintenanceConfiguration()));
            }
            case "MaintenanceScheduleType": {
                return Optional.ofNullable(clazz.cast(this.maintenanceScheduleTypeAsString()));
            }
            case "MaintenanceSchedule": {
                return Optional.ofNullable(clazz.cast(this.maintenanceSchedule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("inputType", INPUT_TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("routedOutputs", ROUTED_OUTPUTS_FIELD);
        map.put("maximumRoutedOutputs", MAXIMUM_ROUTED_OUTPUTS_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("maximumBitrate", MAXIMUM_BITRATE_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("routingScope", ROUTING_SCOPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("messages", MESSAGES_FIELD);
        map.put("transitEncryption", TRANSIT_ENCRYPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("streamDetails", STREAM_DETAILS_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("maintenanceType", MAINTENANCE_TYPE_FIELD);
        map.put("maintenanceConfiguration", MAINTENANCE_CONFIGURATION_FIELD);
        map.put("maintenanceScheduleType", MAINTENANCE_SCHEDULE_TYPE_FIELD);
        map.put("maintenanceSchedule", MAINTENANCE_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInput, T> g) {
        return obj -> g.apply((RouterInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String id;
        private String state;
        private String inputType;
        private RouterInputConfiguration configuration;
        private Integer routedOutputs;
        private Integer maximumRoutedOutputs;
        private String regionName;
        private String availabilityZone;
        private Long maximumBitrate;
        private String tier;
        private String routingScope;
        private Instant createdAt;
        private Instant updatedAt;
        private List<RouterInputMessage> messages = DefaultSdkAutoConstructList.getInstance();
        private RouterInputTransitEncryption transitEncryption;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private RouterInputStreamDetails streamDetails;
        private String ipAddress;
        private String maintenanceType;
        private MaintenanceConfiguration maintenanceConfiguration;
        private String maintenanceScheduleType;
        private MaintenanceSchedule maintenanceSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInput model) {
            this.name(model.name);
            this.arn(model.arn);
            this.id(model.id);
            this.state(model.state);
            this.inputType(model.inputType);
            this.configuration(model.configuration);
            this.routedOutputs(model.routedOutputs);
            this.maximumRoutedOutputs(model.maximumRoutedOutputs);
            this.regionName(model.regionName);
            this.availabilityZone(model.availabilityZone);
            this.maximumBitrate(model.maximumBitrate);
            this.tier(model.tier);
            this.routingScope(model.routingScope);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.messages(model.messages);
            this.transitEncryption(model.transitEncryption);
            this.tags(model.tags);
            this.streamDetails(model.streamDetails);
            this.ipAddress(model.ipAddress);
            this.maintenanceType(model.maintenanceType);
            this.maintenanceConfiguration(model.maintenanceConfiguration);
            this.maintenanceScheduleType(model.maintenanceScheduleType);
            this.maintenanceSchedule(model.maintenanceSchedule);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouterInputState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getInputType() {
            return this.inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(RouterInputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        public final RouterInputConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RouterInputConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RouterInputConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Integer getRoutedOutputs() {
            return this.routedOutputs;
        }

        public final void setRoutedOutputs(Integer routedOutputs) {
            this.routedOutputs = routedOutputs;
        }

        @Override
        public final Builder routedOutputs(Integer routedOutputs) {
            this.routedOutputs = routedOutputs;
            return this;
        }

        public final Integer getMaximumRoutedOutputs() {
            return this.maximumRoutedOutputs;
        }

        public final void setMaximumRoutedOutputs(Integer maximumRoutedOutputs) {
            this.maximumRoutedOutputs = maximumRoutedOutputs;
        }

        @Override
        public final Builder maximumRoutedOutputs(Integer maximumRoutedOutputs) {
            this.maximumRoutedOutputs = maximumRoutedOutputs;
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getMaximumBitrate() {
            return this.maximumBitrate;
        }

        public final void setMaximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(RouterInputTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getRoutingScope() {
            return this.routingScope;
        }

        public final void setRoutingScope(String routingScope) {
            this.routingScope = routingScope;
        }

        @Override
        public final Builder routingScope(String routingScope) {
            this.routingScope = routingScope;
            return this;
        }

        @Override
        public final Builder routingScope(RoutingScope routingScope) {
            this.routingScope(routingScope == null ? null : routingScope.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<RouterInputMessage.Builder> getMessages() {
            List<RouterInputMessage.Builder> result = RouterInputMessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<RouterInputMessage.BuilderImpl> messages) {
            this.messages = RouterInputMessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<RouterInputMessage> messages) {
            this.messages = RouterInputMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(RouterInputMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<RouterInputMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (RouterInputMessage)((RouterInputMessage.Builder)RouterInputMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RouterInputTransitEncryption.Builder getTransitEncryption() {
            return this.transitEncryption != null ? this.transitEncryption.toBuilder() : null;
        }

        public final void setTransitEncryption(RouterInputTransitEncryption.BuilderImpl transitEncryption) {
            this.transitEncryption = transitEncryption != null ? transitEncryption.build() : null;
        }

        @Override
        public final Builder transitEncryption(RouterInputTransitEncryption transitEncryption) {
            this.transitEncryption = transitEncryption;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
            return this;
        }

        public final RouterInputStreamDetails.Builder getStreamDetails() {
            return this.streamDetails != null ? this.streamDetails.toBuilder() : null;
        }

        public final void setStreamDetails(RouterInputStreamDetails.BuilderImpl streamDetails) {
            this.streamDetails = streamDetails != null ? streamDetails.build() : null;
        }

        @Override
        public final Builder streamDetails(RouterInputStreamDetails streamDetails) {
            this.streamDetails = streamDetails;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getMaintenanceType() {
            return this.maintenanceType;
        }

        public final void setMaintenanceType(String maintenanceType) {
            this.maintenanceType = maintenanceType;
        }

        @Override
        public final Builder maintenanceType(String maintenanceType) {
            this.maintenanceType = maintenanceType;
            return this;
        }

        @Override
        public final Builder maintenanceType(MaintenanceType maintenanceType) {
            this.maintenanceType(maintenanceType == null ? null : maintenanceType.toString());
            return this;
        }

        public final MaintenanceConfiguration.Builder getMaintenanceConfiguration() {
            return this.maintenanceConfiguration != null ? this.maintenanceConfiguration.toBuilder() : null;
        }

        public final void setMaintenanceConfiguration(MaintenanceConfiguration.BuilderImpl maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration != null ? maintenanceConfiguration.build() : null;
        }

        @Override
        public final Builder maintenanceConfiguration(MaintenanceConfiguration maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration;
            return this;
        }

        public final String getMaintenanceScheduleType() {
            return this.maintenanceScheduleType;
        }

        public final void setMaintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
        }

        @Override
        public final Builder maintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
            return this;
        }

        @Override
        public final Builder maintenanceScheduleType(MaintenanceScheduleType maintenanceScheduleType) {
            this.maintenanceScheduleType(maintenanceScheduleType == null ? null : maintenanceScheduleType.toString());
            return this;
        }

        public final MaintenanceSchedule.Builder getMaintenanceSchedule() {
            return this.maintenanceSchedule != null ? this.maintenanceSchedule.toBuilder() : null;
        }

        public final void setMaintenanceSchedule(MaintenanceSchedule.BuilderImpl maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule != null ? maintenanceSchedule.build() : null;
        }

        @Override
        public final Builder maintenanceSchedule(MaintenanceSchedule maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule;
            return this;
        }

        public RouterInput build() {
            return new RouterInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterInput> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder state(String var1);

        public Builder state(RouterInputState var1);

        public Builder inputType(String var1);

        public Builder inputType(RouterInputType var1);

        public Builder configuration(RouterInputConfiguration var1);

        default public Builder configuration(Consumer<RouterInputConfiguration.Builder> configuration) {
            return this.configuration((RouterInputConfiguration)((RouterInputConfiguration.Builder)RouterInputConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder routedOutputs(Integer var1);

        public Builder maximumRoutedOutputs(Integer var1);

        public Builder regionName(String var1);

        public Builder availabilityZone(String var1);

        public Builder maximumBitrate(Long var1);

        public Builder tier(String var1);

        public Builder tier(RouterInputTier var1);

        public Builder routingScope(String var1);

        public Builder routingScope(RoutingScope var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder messages(Collection<RouterInputMessage> var1);

        public Builder messages(RouterInputMessage ... var1);

        public Builder messages(Consumer<RouterInputMessage.Builder> ... var1);

        public Builder transitEncryption(RouterInputTransitEncryption var1);

        default public Builder transitEncryption(Consumer<RouterInputTransitEncryption.Builder> transitEncryption) {
            return this.transitEncryption((RouterInputTransitEncryption)((RouterInputTransitEncryption.Builder)RouterInputTransitEncryption.builder().applyMutation(transitEncryption)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder streamDetails(RouterInputStreamDetails var1);

        default public Builder streamDetails(Consumer<RouterInputStreamDetails.Builder> streamDetails) {
            return this.streamDetails((RouterInputStreamDetails)((RouterInputStreamDetails.Builder)RouterInputStreamDetails.builder().applyMutation(streamDetails)).build());
        }

        public Builder ipAddress(String var1);

        public Builder maintenanceType(String var1);

        public Builder maintenanceType(MaintenanceType var1);

        public Builder maintenanceConfiguration(MaintenanceConfiguration var1);

        default public Builder maintenanceConfiguration(Consumer<MaintenanceConfiguration.Builder> maintenanceConfiguration) {
            return this.maintenanceConfiguration((MaintenanceConfiguration)((MaintenanceConfiguration.Builder)MaintenanceConfiguration.builder().applyMutation(maintenanceConfiguration)).build());
        }

        public Builder maintenanceScheduleType(String var1);

        public Builder maintenanceScheduleType(MaintenanceScheduleType var1);

        public Builder maintenanceSchedule(MaintenanceSchedule var1);

        default public Builder maintenanceSchedule(Consumer<MaintenanceSchedule.Builder> maintenanceSchedule) {
            return this.maintenanceSchedule((MaintenanceSchedule)((MaintenanceSchedule.Builder)MaintenanceSchedule.builder().applyMutation(maintenanceSchedule)).build());
        }
    }
}

