/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.FlowTransitEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaConnectFlowRouterInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaConnectFlowRouterInputConfiguration> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(MediaConnectFlowRouterInputConfiguration.getter(MediaConnectFlowRouterInputConfiguration::flowArn)).setter(MediaConnectFlowRouterInputConfiguration.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<String> FLOW_OUTPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOutputArn").getter(MediaConnectFlowRouterInputConfiguration.getter(MediaConnectFlowRouterInputConfiguration::flowOutputArn)).setter(MediaConnectFlowRouterInputConfiguration.setter(Builder::flowOutputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowOutputArn").build()}).build();
    private static final SdkField<FlowTransitEncryption> SOURCE_TRANSIT_DECRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceTransitDecryption").getter(MediaConnectFlowRouterInputConfiguration.getter(MediaConnectFlowRouterInputConfiguration::sourceTransitDecryption)).setter(MediaConnectFlowRouterInputConfiguration.setter(Builder::sourceTransitDecryption)).constructor(FlowTransitEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTransitDecryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, FLOW_OUTPUT_ARN_FIELD, SOURCE_TRANSIT_DECRYPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaConnectFlowRouterInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String flowArn;
    private final String flowOutputArn;
    private final FlowTransitEncryption sourceTransitDecryption;

    private MediaConnectFlowRouterInputConfiguration(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.flowOutputArn = builder.flowOutputArn;
        this.sourceTransitDecryption = builder.sourceTransitDecryption;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final String flowOutputArn() {
        return this.flowOutputArn;
    }

    public final FlowTransitEncryption sourceTransitDecryption() {
        return this.sourceTransitDecryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOutputArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTransitDecryption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConnectFlowRouterInputConfiguration)) {
            return false;
        }
        MediaConnectFlowRouterInputConfiguration other = (MediaConnectFlowRouterInputConfiguration)obj;
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.flowOutputArn(), other.flowOutputArn()) && Objects.equals(this.sourceTransitDecryption(), other.sourceTransitDecryption());
    }

    public final String toString() {
        return ToString.builder((String)"MediaConnectFlowRouterInputConfiguration").add("FlowArn", (Object)this.flowArn()).add("FlowOutputArn", (Object)this.flowOutputArn()).add("SourceTransitDecryption", (Object)this.sourceTransitDecryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "FlowOutputArn": {
                return Optional.ofNullable(clazz.cast(this.flowOutputArn()));
            }
            case "SourceTransitDecryption": {
                return Optional.ofNullable(clazz.cast(this.sourceTransitDecryption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("flowOutputArn", FLOW_OUTPUT_ARN_FIELD);
        map.put("sourceTransitDecryption", SOURCE_TRANSIT_DECRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaConnectFlowRouterInputConfiguration, T> g) {
        return obj -> g.apply((MediaConnectFlowRouterInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowArn;
        private String flowOutputArn;
        private FlowTransitEncryption sourceTransitDecryption;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConnectFlowRouterInputConfiguration model) {
            this.flowArn(model.flowArn);
            this.flowOutputArn(model.flowOutputArn);
            this.sourceTransitDecryption(model.sourceTransitDecryption);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getFlowOutputArn() {
            return this.flowOutputArn;
        }

        public final void setFlowOutputArn(String flowOutputArn) {
            this.flowOutputArn = flowOutputArn;
        }

        @Override
        public final Builder flowOutputArn(String flowOutputArn) {
            this.flowOutputArn = flowOutputArn;
            return this;
        }

        public final FlowTransitEncryption.Builder getSourceTransitDecryption() {
            return this.sourceTransitDecryption != null ? this.sourceTransitDecryption.toBuilder() : null;
        }

        public final void setSourceTransitDecryption(FlowTransitEncryption.BuilderImpl sourceTransitDecryption) {
            this.sourceTransitDecryption = sourceTransitDecryption != null ? sourceTransitDecryption.build() : null;
        }

        @Override
        public final Builder sourceTransitDecryption(FlowTransitEncryption sourceTransitDecryption) {
            this.sourceTransitDecryption = sourceTransitDecryption;
            return this;
        }

        public MediaConnectFlowRouterInputConfiguration build() {
            return new MediaConnectFlowRouterInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaConnectFlowRouterInputConfiguration> {
        public Builder flowArn(String var1);

        public Builder flowOutputArn(String var1);

        public Builder sourceTransitDecryption(FlowTransitEncryption var1);

        default public Builder sourceTransitDecryption(Consumer<FlowTransitEncryption.Builder> sourceTransitDecryption) {
            return this.sourceTransitDecryption((FlowTransitEncryption)((FlowTransitEncryption.Builder)FlowTransitEncryption.builder().applyMutation(sourceTransitDecryption)).build());
        }
    }
}

