/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.DefaultMaintenanceConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.PreferredDayTimeMaintenanceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceConfiguration> {
    private static final SdkField<PreferredDayTimeMaintenanceConfiguration> PREFERRED_DAY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreferredDayTime").getter(MaintenanceConfiguration.getter(MaintenanceConfiguration::preferredDayTime)).setter(MaintenanceConfiguration.setter(Builder::preferredDayTime)).constructor(PreferredDayTimeMaintenanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredDayTime").build()}).build();
    private static final SdkField<DefaultMaintenanceConfiguration> DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Default").getter(MaintenanceConfiguration.getter(MaintenanceConfiguration::defaultValue)).setter(MaintenanceConfiguration.setter(Builder::defaultValue)).constructor(DefaultMaintenanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("default").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFERRED_DAY_TIME_FIELD, DEFAULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MaintenanceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PreferredDayTimeMaintenanceConfiguration preferredDayTime;
    private final DefaultMaintenanceConfiguration defaultValue;
    private final Type type;

    private MaintenanceConfiguration(BuilderImpl builder) {
        this.preferredDayTime = builder.preferredDayTime;
        this.defaultValue = builder.defaultValue;
        this.type = builder.type;
    }

    public final PreferredDayTimeMaintenanceConfiguration preferredDayTime() {
        return this.preferredDayTime;
    }

    public final DefaultMaintenanceConfiguration defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredDayTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceConfiguration)) {
            return false;
        }
        MaintenanceConfiguration other = (MaintenanceConfiguration)obj;
        return Objects.equals(this.preferredDayTime(), other.preferredDayTime()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceConfiguration").add("PreferredDayTime", (Object)this.preferredDayTime()).add("Default", (Object)this.defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreferredDayTime": {
                return Optional.ofNullable(clazz.cast(this.preferredDayTime()));
            }
            case "Default": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    public static MaintenanceConfiguration fromPreferredDayTime(PreferredDayTimeMaintenanceConfiguration preferredDayTime) {
        return (MaintenanceConfiguration)MaintenanceConfiguration.builder().preferredDayTime(preferredDayTime).build();
    }

    public static MaintenanceConfiguration fromPreferredDayTime(Consumer<PreferredDayTimeMaintenanceConfiguration.Builder> preferredDayTime) {
        PreferredDayTimeMaintenanceConfiguration.Builder builder = PreferredDayTimeMaintenanceConfiguration.builder();
        preferredDayTime.accept(builder);
        return MaintenanceConfiguration.fromPreferredDayTime((PreferredDayTimeMaintenanceConfiguration)builder.build());
    }

    public static MaintenanceConfiguration fromDefaultValue(DefaultMaintenanceConfiguration defaultValue) {
        return (MaintenanceConfiguration)MaintenanceConfiguration.builder().defaultValue(defaultValue).build();
    }

    public static MaintenanceConfiguration fromDefaultValue(Consumer<DefaultMaintenanceConfiguration.Builder> defaultValue) {
        DefaultMaintenanceConfiguration.Builder builder = DefaultMaintenanceConfiguration.builder();
        defaultValue.accept(builder);
        return MaintenanceConfiguration.fromDefaultValue((DefaultMaintenanceConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("preferredDayTime", PREFERRED_DAY_TIME_FIELD);
        map.put("default", DEFAULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceConfiguration, T> g) {
        return obj -> g.apply((MaintenanceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PREFERRED_DAY_TIME,
        DEFAULT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PreferredDayTimeMaintenanceConfiguration preferredDayTime;
        private DefaultMaintenanceConfiguration defaultValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceConfiguration model) {
            this.preferredDayTime(model.preferredDayTime);
            this.defaultValue(model.defaultValue);
        }

        public final PreferredDayTimeMaintenanceConfiguration.Builder getPreferredDayTime() {
            return this.preferredDayTime != null ? this.preferredDayTime.toBuilder() : null;
        }

        public final void setPreferredDayTime(PreferredDayTimeMaintenanceConfiguration.BuilderImpl preferredDayTime) {
            PreferredDayTimeMaintenanceConfiguration oldValue = this.preferredDayTime;
            this.preferredDayTime = preferredDayTime != null ? preferredDayTime.build() : null;
            this.handleUnionValueChange(Type.PREFERRED_DAY_TIME, oldValue, this.preferredDayTime);
        }

        @Override
        public final Builder preferredDayTime(PreferredDayTimeMaintenanceConfiguration preferredDayTime) {
            PreferredDayTimeMaintenanceConfiguration oldValue = this.preferredDayTime;
            this.preferredDayTime = preferredDayTime;
            this.handleUnionValueChange(Type.PREFERRED_DAY_TIME, oldValue, this.preferredDayTime);
            return this;
        }

        public final DefaultMaintenanceConfiguration.Builder getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(DefaultMaintenanceConfiguration.BuilderImpl defaultValue) {
            DefaultMaintenanceConfiguration oldValue = this.defaultValue;
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
            this.handleUnionValueChange(Type.DEFAULT, oldValue, this.defaultValue);
        }

        @Override
        public final Builder defaultValue(DefaultMaintenanceConfiguration defaultValue) {
            DefaultMaintenanceConfiguration oldValue = this.defaultValue;
            this.defaultValue = defaultValue;
            this.handleUnionValueChange(Type.DEFAULT, oldValue, this.defaultValue);
            return this;
        }

        public MaintenanceConfiguration build() {
            return new MaintenanceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceConfiguration> {
        public Builder preferredDayTime(PreferredDayTimeMaintenanceConfiguration var1);

        default public Builder preferredDayTime(Consumer<PreferredDayTimeMaintenanceConfiguration.Builder> preferredDayTime) {
            return this.preferredDayTime((PreferredDayTimeMaintenanceConfiguration)((PreferredDayTimeMaintenanceConfiguration.Builder)PreferredDayTimeMaintenanceConfiguration.builder().applyMutation(preferredDayTime)).build());
        }

        public Builder defaultValue(DefaultMaintenanceConfiguration var1);

        default public Builder defaultValue(Consumer<DefaultMaintenanceConfiguration.Builder> defaultValue) {
            return this.defaultValue((DefaultMaintenanceConfiguration)((DefaultMaintenanceConfiguration.Builder)DefaultMaintenanceConfiguration.builder().applyMutation(defaultValue)).build());
        }
    }
}

