/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceError;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceErrorListCopier;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterface;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetRouterNetworkInterfaceResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, BatchGetRouterNetworkInterfaceResponse> {
    private static final SdkField<List<RouterNetworkInterface>> ROUTER_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouterNetworkInterfaces").getter(BatchGetRouterNetworkInterfaceResponse.getter(BatchGetRouterNetworkInterfaceResponse::routerNetworkInterfaces)).setter(BatchGetRouterNetworkInterfaceResponse.setter(Builder::routerNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerNetworkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouterNetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetRouterNetworkInterfaceError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetRouterNetworkInterfaceResponse.getter(BatchGetRouterNetworkInterfaceResponse::errors)).setter(BatchGetRouterNetworkInterfaceResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetRouterNetworkInterfaceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_NETWORK_INTERFACES_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetRouterNetworkInterfaceResponse.memberNameToFieldInitializer();
    private final List<RouterNetworkInterface> routerNetworkInterfaces;
    private final List<BatchGetRouterNetworkInterfaceError> errors;

    private BatchGetRouterNetworkInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.routerNetworkInterfaces = builder.routerNetworkInterfaces;
        this.errors = builder.errors;
    }

    public final boolean hasRouterNetworkInterfaces() {
        return this.routerNetworkInterfaces != null && !(this.routerNetworkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<RouterNetworkInterface> routerNetworkInterfaces() {
        return this.routerNetworkInterfaces;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetRouterNetworkInterfaceError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouterNetworkInterfaces() ? this.routerNetworkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRouterNetworkInterfaceResponse)) {
            return false;
        }
        BatchGetRouterNetworkInterfaceResponse other = (BatchGetRouterNetworkInterfaceResponse)((Object)obj);
        return this.hasRouterNetworkInterfaces() == other.hasRouterNetworkInterfaces() && Objects.equals(this.routerNetworkInterfaces(), other.routerNetworkInterfaces()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetRouterNetworkInterfaceResponse").add("RouterNetworkInterfaces", this.hasRouterNetworkInterfaces() ? this.routerNetworkInterfaces() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouterNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.routerNetworkInterfaces()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("routerNetworkInterfaces", ROUTER_NETWORK_INTERFACES_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRouterNetworkInterfaceResponse, T> g) {
        return obj -> g.apply((BatchGetRouterNetworkInterfaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private List<RouterNetworkInterface> routerNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetRouterNetworkInterfaceError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRouterNetworkInterfaceResponse model) {
            super(model);
            this.routerNetworkInterfaces(model.routerNetworkInterfaces);
            this.errors(model.errors);
        }

        public final List<RouterNetworkInterface.Builder> getRouterNetworkInterfaces() {
            List<RouterNetworkInterface.Builder> result = RouterNetworkInterfaceListCopier.copyToBuilder(this.routerNetworkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouterNetworkInterfaces(Collection<RouterNetworkInterface.BuilderImpl> routerNetworkInterfaces) {
            this.routerNetworkInterfaces = RouterNetworkInterfaceListCopier.copyFromBuilder(routerNetworkInterfaces);
        }

        @Override
        public final Builder routerNetworkInterfaces(Collection<RouterNetworkInterface> routerNetworkInterfaces) {
            this.routerNetworkInterfaces = RouterNetworkInterfaceListCopier.copy(routerNetworkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerNetworkInterfaces(RouterNetworkInterface ... routerNetworkInterfaces) {
            this.routerNetworkInterfaces(Arrays.asList(routerNetworkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerNetworkInterfaces(Consumer<RouterNetworkInterface.Builder> ... routerNetworkInterfaces) {
            this.routerNetworkInterfaces(Stream.of(routerNetworkInterfaces).map(c -> (RouterNetworkInterface)((RouterNetworkInterface.Builder)RouterNetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetRouterNetworkInterfaceError.Builder> getErrors() {
            List<BatchGetRouterNetworkInterfaceError.Builder> result = BatchGetRouterNetworkInterfaceErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetRouterNetworkInterfaceError.BuilderImpl> errors) {
            this.errors = BatchGetRouterNetworkInterfaceErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetRouterNetworkInterfaceError> errors) {
            this.errors = BatchGetRouterNetworkInterfaceErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetRouterNetworkInterfaceError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetRouterNetworkInterfaceError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetRouterNetworkInterfaceError)((BatchGetRouterNetworkInterfaceError.Builder)BatchGetRouterNetworkInterfaceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRouterNetworkInterfaceResponse build() {
            return new BatchGetRouterNetworkInterfaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetRouterNetworkInterfaceResponse> {
        public Builder routerNetworkInterfaces(Collection<RouterNetworkInterface> var1);

        public Builder routerNetworkInterfaces(RouterNetworkInterface ... var1);

        public Builder routerNetworkInterfaces(Consumer<RouterNetworkInterface.Builder> ... var1);

        public Builder errors(Collection<BatchGetRouterNetworkInterfaceError> var1);

        public Builder errors(BatchGetRouterNetworkInterfaceError ... var1);

        public Builder errors(Consumer<BatchGetRouterNetworkInterfaceError.Builder> ... var1);
    }
}

