/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputError;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputErrorListCopier;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.RouterInput;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetRouterInputResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, BatchGetRouterInputResponse> {
    private static final SdkField<List<RouterInput>> ROUTER_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouterInputs").getter(BatchGetRouterInputResponse.getter(BatchGetRouterInputResponse::routerInputs)).setter(BatchGetRouterInputResponse.setter(Builder::routerInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouterInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetRouterInputError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetRouterInputResponse.getter(BatchGetRouterInputResponse::errors)).setter(BatchGetRouterInputResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetRouterInputError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_INPUTS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetRouterInputResponse.memberNameToFieldInitializer();
    private final List<RouterInput> routerInputs;
    private final List<BatchGetRouterInputError> errors;

    private BatchGetRouterInputResponse(BuilderImpl builder) {
        super(builder);
        this.routerInputs = builder.routerInputs;
        this.errors = builder.errors;
    }

    public final boolean hasRouterInputs() {
        return this.routerInputs != null && !(this.routerInputs instanceof SdkAutoConstructList);
    }

    public final List<RouterInput> routerInputs() {
        return this.routerInputs;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetRouterInputError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouterInputs() ? this.routerInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRouterInputResponse)) {
            return false;
        }
        BatchGetRouterInputResponse other = (BatchGetRouterInputResponse)((Object)obj);
        return this.hasRouterInputs() == other.hasRouterInputs() && Objects.equals(this.routerInputs(), other.routerInputs()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetRouterInputResponse").add("RouterInputs", this.hasRouterInputs() ? this.routerInputs() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouterInputs": {
                return Optional.ofNullable(clazz.cast(this.routerInputs()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("routerInputs", ROUTER_INPUTS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRouterInputResponse, T> g) {
        return obj -> g.apply((BatchGetRouterInputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private List<RouterInput> routerInputs = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetRouterInputError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRouterInputResponse model) {
            super(model);
            this.routerInputs(model.routerInputs);
            this.errors(model.errors);
        }

        public final List<RouterInput.Builder> getRouterInputs() {
            List<RouterInput.Builder> result = RouterInputListCopier.copyToBuilder(this.routerInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouterInputs(Collection<RouterInput.BuilderImpl> routerInputs) {
            this.routerInputs = RouterInputListCopier.copyFromBuilder(routerInputs);
        }

        @Override
        public final Builder routerInputs(Collection<RouterInput> routerInputs) {
            this.routerInputs = RouterInputListCopier.copy(routerInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerInputs(RouterInput ... routerInputs) {
            this.routerInputs(Arrays.asList(routerInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerInputs(Consumer<RouterInput.Builder> ... routerInputs) {
            this.routerInputs(Stream.of(routerInputs).map(c -> (RouterInput)((RouterInput.Builder)RouterInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetRouterInputError.Builder> getErrors() {
            List<BatchGetRouterInputError.Builder> result = BatchGetRouterInputErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetRouterInputError.BuilderImpl> errors) {
            this.errors = BatchGetRouterInputErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetRouterInputError> errors) {
            this.errors = BatchGetRouterInputErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetRouterInputError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetRouterInputError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetRouterInputError)((BatchGetRouterInputError.Builder)BatchGetRouterInputError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRouterInputResponse build() {
            return new BatchGetRouterInputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetRouterInputResponse> {
        public Builder routerInputs(Collection<RouterInput> var1);

        public Builder routerInputs(RouterInput ... var1);

        public Builder routerInputs(Consumer<RouterInput.Builder> ... var1);

        public Builder errors(Collection<BatchGetRouterInputError> var1);

        public Builder errors(BatchGetRouterInputError ... var1);

        public Builder errors(Consumer<BatchGetRouterInputError.Builder> ... var1);
    }
}

