/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfMediaStreamOutputConfigurationCopier {
    static List<MediaStreamOutputConfiguration> copy(
            Collection<? extends MediaStreamOutputConfiguration> __listOfMediaStreamOutputConfigurationParam) {
        List<MediaStreamOutputConfiguration> list;
        if (__listOfMediaStreamOutputConfigurationParam == null
                || __listOfMediaStreamOutputConfigurationParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MediaStreamOutputConfiguration> modifiableList = new ArrayList<>(
                    __listOfMediaStreamOutputConfigurationParam.size());
            __listOfMediaStreamOutputConfigurationParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MediaStreamOutputConfiguration> copyFromBuilder(
            Collection<? extends MediaStreamOutputConfiguration.Builder> __listOfMediaStreamOutputConfigurationParam) {
        List<MediaStreamOutputConfiguration> list;
        if (__listOfMediaStreamOutputConfigurationParam == null
                || __listOfMediaStreamOutputConfigurationParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MediaStreamOutputConfiguration> modifiableList = new ArrayList<>(
                    __listOfMediaStreamOutputConfigurationParam.size());
            __listOfMediaStreamOutputConfigurationParam.forEach(entry -> {
                MediaStreamOutputConfiguration member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MediaStreamOutputConfiguration.Builder> copyToBuilder(
            Collection<? extends MediaStreamOutputConfiguration> __listOfMediaStreamOutputConfigurationParam) {
        List<MediaStreamOutputConfiguration.Builder> list;
        if (__listOfMediaStreamOutputConfigurationParam == null
                || __listOfMediaStreamOutputConfigurationParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MediaStreamOutputConfiguration.Builder> modifiableList = new ArrayList<>(
                    __listOfMediaStreamOutputConfigurationParam.size());
            __listOfMediaStreamOutputConfigurationParam.forEach(entry -> {
                MediaStreamOutputConfiguration.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
