/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBridgeSourceRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateBridgeSourceRequest.Builder, UpdateBridgeSourceRequest> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeArn").getter(getter(UpdateBridgeSourceRequest::bridgeArn)).setter(setter(Builder::bridgeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("BridgeArn").build()).build();

    private static final SdkField<UpdateBridgeFlowSourceRequest> FLOW_SOURCE_FIELD = SdkField
            .<UpdateBridgeFlowSourceRequest> builder(MarshallingType.SDK_POJO).memberName("FlowSource")
            .getter(getter(UpdateBridgeSourceRequest::flowSource)).setter(setter(Builder::flowSource))
            .constructor(UpdateBridgeFlowSourceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSource").build()).build();

    private static final SdkField<UpdateBridgeNetworkSourceRequest> NETWORK_SOURCE_FIELD = SdkField
            .<UpdateBridgeNetworkSourceRequest> builder(MarshallingType.SDK_POJO).memberName("NetworkSource")
            .getter(getter(UpdateBridgeSourceRequest::networkSource)).setter(setter(Builder::networkSource))
            .constructor(UpdateBridgeNetworkSourceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSource").build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceName").getter(getter(UpdateBridgeSourceRequest::sourceName)).setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD,
            FLOW_SOURCE_FIELD, NETWORK_SOURCE_FIELD, SOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String bridgeArn;

    private final UpdateBridgeFlowSourceRequest flowSource;

    private final UpdateBridgeNetworkSourceRequest networkSource;

    private final String sourceName;

    private UpdateBridgeSourceRequest(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.flowSource = builder.flowSource;
        this.networkSource = builder.networkSource;
        this.sourceName = builder.sourceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the bridge that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the bridge that you want to update.
     */
    public final String bridgeArn() {
        return bridgeArn;
    }

    /**
     * <p>
     * The name of the flow that you want to update.
     * </p>
     * 
     * @return The name of the flow that you want to update.
     */
    public final UpdateBridgeFlowSourceRequest flowSource() {
        return flowSource;
    }

    /**
     * <p>
     * The network for the bridge source.
     * </p>
     * 
     * @return The network for the bridge source.
     */
    public final UpdateBridgeNetworkSourceRequest networkSource() {
        return networkSource;
    }

    /**
     * <p>
     * The name of the source that you want to update.
     * </p>
     * 
     * @return The name of the source that you want to update.
     */
    public final String sourceName() {
        return sourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowSource());
        hashCode = 31 * hashCode + Objects.hashCode(networkSource());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeSourceRequest)) {
            return false;
        }
        UpdateBridgeSourceRequest other = (UpdateBridgeSourceRequest) obj;
        return Objects.equals(bridgeArn(), other.bridgeArn()) && Objects.equals(flowSource(), other.flowSource())
                && Objects.equals(networkSource(), other.networkSource()) && Objects.equals(sourceName(), other.sourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBridgeSourceRequest").add("BridgeArn", bridgeArn()).add("FlowSource", flowSource())
                .add("NetworkSource", networkSource()).add("SourceName", sourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgeArn":
            return Optional.ofNullable(clazz.cast(bridgeArn()));
        case "FlowSource":
            return Optional.ofNullable(clazz.cast(flowSource()));
        case "NetworkSource":
            return Optional.ofNullable(clazz.cast(networkSource()));
        case "SourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BridgeArn", BRIDGE_ARN_FIELD);
        map.put("flowSource", FLOW_SOURCE_FIELD);
        map.put("networkSource", NETWORK_SOURCE_FIELD);
        map.put("SourceName", SOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeSourceRequest, T> g) {
        return obj -> g.apply((UpdateBridgeSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBridgeSourceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the bridge that you want to update.
         * </p>
         * 
         * @param bridgeArn
         *        The Amazon Resource Name (ARN) of the bridge that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeArn(String bridgeArn);

        /**
         * <p>
         * The name of the flow that you want to update.
         * </p>
         * 
         * @param flowSource
         *        The name of the flow that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowSource(UpdateBridgeFlowSourceRequest flowSource);

        /**
         * <p>
         * The name of the flow that you want to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateBridgeFlowSourceRequest.Builder}
         * avoiding the need to create one manually via {@link UpdateBridgeFlowSourceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateBridgeFlowSourceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #flowSource(UpdateBridgeFlowSourceRequest)}.
         * 
         * @param flowSource
         *        a consumer that will call methods on {@link UpdateBridgeFlowSourceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowSource(UpdateBridgeFlowSourceRequest)
         */
        default Builder flowSource(Consumer<UpdateBridgeFlowSourceRequest.Builder> flowSource) {
            return flowSource(UpdateBridgeFlowSourceRequest.builder().applyMutation(flowSource).build());
        }

        /**
         * <p>
         * The network for the bridge source.
         * </p>
         * 
         * @param networkSource
         *        The network for the bridge source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSource(UpdateBridgeNetworkSourceRequest networkSource);

        /**
         * <p>
         * The network for the bridge source.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateBridgeNetworkSourceRequest.Builder}
         * avoiding the need to create one manually via {@link UpdateBridgeNetworkSourceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateBridgeNetworkSourceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #networkSource(UpdateBridgeNetworkSourceRequest)}.
         * 
         * @param networkSource
         *        a consumer that will call methods on {@link UpdateBridgeNetworkSourceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSource(UpdateBridgeNetworkSourceRequest)
         */
        default Builder networkSource(Consumer<UpdateBridgeNetworkSourceRequest.Builder> networkSource) {
            return networkSource(UpdateBridgeNetworkSourceRequest.builder().applyMutation(networkSource).build());
        }

        /**
         * <p>
         * The name of the source that you want to update.
         * </p>
         * 
         * @param sourceName
         *        The name of the source that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String bridgeArn;

        private UpdateBridgeFlowSourceRequest flowSource;

        private UpdateBridgeNetworkSourceRequest networkSource;

        private String sourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeSourceRequest model) {
            super(model);
            bridgeArn(model.bridgeArn);
            flowSource(model.flowSource);
            networkSource(model.networkSource);
            sourceName(model.sourceName);
        }

        public final String getBridgeArn() {
            return bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final UpdateBridgeFlowSourceRequest.Builder getFlowSource() {
            return flowSource != null ? flowSource.toBuilder() : null;
        }

        public final void setFlowSource(UpdateBridgeFlowSourceRequest.BuilderImpl flowSource) {
            this.flowSource = flowSource != null ? flowSource.build() : null;
        }

        @Override
        public final Builder flowSource(UpdateBridgeFlowSourceRequest flowSource) {
            this.flowSource = flowSource;
            return this;
        }

        public final UpdateBridgeNetworkSourceRequest.Builder getNetworkSource() {
            return networkSource != null ? networkSource.toBuilder() : null;
        }

        public final void setNetworkSource(UpdateBridgeNetworkSourceRequest.BuilderImpl networkSource) {
            this.networkSource = networkSource != null ? networkSource.build() : null;
        }

        @Override
        public final Builder networkSource(UpdateBridgeNetworkSourceRequest networkSource) {
            this.networkSource = networkSource;
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBridgeSourceRequest build() {
            return new UpdateBridgeSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
