/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata of the transport stream in the current flow's source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransportMediaInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<TransportMediaInfo.Builder, TransportMediaInfo> {
    private static final SdkField<List<TransportStreamProgram>> PROGRAMS_FIELD = SdkField
            .<List<TransportStreamProgram>> builder(MarshallingType.LIST)
            .memberName("Programs")
            .getter(getter(TransportMediaInfo::programs))
            .setter(setter(Builder::programs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransportStreamProgram> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransportStreamProgram::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRAMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TransportStreamProgram> programs;

    private TransportMediaInfo(BuilderImpl builder) {
        this.programs = builder.programs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Programs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrograms() {
        return programs != null && !(programs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of transport stream programs in the current flow's source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrograms} method.
     * </p>
     * 
     * @return The list of transport stream programs in the current flow's source.
     */
    public final List<TransportStreamProgram> programs() {
        return programs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPrograms() ? programs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransportMediaInfo)) {
            return false;
        }
        TransportMediaInfo other = (TransportMediaInfo) obj;
        return hasPrograms() == other.hasPrograms() && Objects.equals(programs(), other.programs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransportMediaInfo").add("Programs", hasPrograms() ? programs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Programs":
            return Optional.ofNullable(clazz.cast(programs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("programs", PROGRAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransportMediaInfo, T> g) {
        return obj -> g.apply((TransportMediaInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransportMediaInfo> {
        /**
         * <p>
         * The list of transport stream programs in the current flow's source.
         * </p>
         * 
         * @param programs
         *        The list of transport stream programs in the current flow's source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(Collection<TransportStreamProgram> programs);

        /**
         * <p>
         * The list of transport stream programs in the current flow's source.
         * </p>
         * 
         * @param programs
         *        The list of transport stream programs in the current flow's source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(TransportStreamProgram... programs);

        /**
         * <p>
         * The list of transport stream programs in the current flow's source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.TransportStreamProgram.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.TransportStreamProgram#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.TransportStreamProgram.Builder#build()} is called
         * immediately and its result is passed to {@link #programs(List<TransportStreamProgram>)}.
         * 
         * @param programs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.TransportStreamProgram.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programs(java.util.Collection<TransportStreamProgram>)
         */
        Builder programs(Consumer<TransportStreamProgram.Builder>... programs);
    }

    static final class BuilderImpl implements Builder {
        private List<TransportStreamProgram> programs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransportMediaInfo model) {
            programs(model.programs);
        }

        public final List<TransportStreamProgram.Builder> getPrograms() {
            List<TransportStreamProgram.Builder> result = ___listOfTransportStreamProgramCopier.copyToBuilder(this.programs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrograms(Collection<TransportStreamProgram.BuilderImpl> programs) {
            this.programs = ___listOfTransportStreamProgramCopier.copyFromBuilder(programs);
        }

        @Override
        public final Builder programs(Collection<TransportStreamProgram> programs) {
            this.programs = ___listOfTransportStreamProgramCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(TransportStreamProgram... programs) {
            programs(Arrays.asList(programs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(Consumer<TransportStreamProgram.Builder>... programs) {
            programs(Stream.of(programs).map(c -> TransportStreamProgram.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransportMediaInfo build() {
            return new TransportMediaInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
