/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details for a standard router output stream type. Contains information about the destination IP address
 * and connection state for basic output routing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardRouterOutputStreamDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardRouterOutputStreamDetails.Builder, StandardRouterOutputStreamDetails> {
    private static final SdkField<String> DESTINATION_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIpAddress").getter(getter(StandardRouterOutputStreamDetails::destinationIpAddress))
            .setter(setter(Builder::destinationIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationIpAddress").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationIpAddress;

    private StandardRouterOutputStreamDetails(BuilderImpl builder) {
        this.destinationIpAddress = builder.destinationIpAddress;
    }

    /**
     * <p>
     * The IP address where the output stream will be sent. This is the destination address that will receive the routed
     * media content.
     * </p>
     * 
     * @return The IP address where the output stream will be sent. This is the destination address that will receive
     *         the routed media content.
     */
    public final String destinationIpAddress() {
        return destinationIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardRouterOutputStreamDetails)) {
            return false;
        }
        StandardRouterOutputStreamDetails other = (StandardRouterOutputStreamDetails) obj;
        return Objects.equals(destinationIpAddress(), other.destinationIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandardRouterOutputStreamDetails").add("DestinationIpAddress", destinationIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationIpAddress":
            return Optional.ofNullable(clazz.cast(destinationIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationIpAddress", DESTINATION_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardRouterOutputStreamDetails, T> g) {
        return obj -> g.apply((StandardRouterOutputStreamDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardRouterOutputStreamDetails> {
        /**
         * <p>
         * The IP address where the output stream will be sent. This is the destination address that will receive the
         * routed media content.
         * </p>
         * 
         * @param destinationIpAddress
         *        The IP address where the output stream will be sent. This is the destination address that will receive
         *        the routed media content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpAddress(String destinationIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String destinationIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardRouterOutputStreamDetails model) {
            destinationIpAddress(model.destinationIpAddress);
        }

        public final String getDestinationIpAddress() {
            return destinationIpAddress;
        }

        public final void setDestinationIpAddress(String destinationIpAddress) {
            this.destinationIpAddress = destinationIpAddress;
        }

        @Override
        public final Builder destinationIpAddress(String destinationIpAddress) {
            this.destinationIpAddress = destinationIpAddress;
            return this;
        }

        @Override
        public StandardRouterOutputStreamDetails build() {
            return new StandardRouterOutputStreamDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
