/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in listener mode,
 * including the port, minimum latency, and decryption key configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtListenerRouterInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtListenerRouterInputConfiguration.Builder, SrtListenerRouterInputConfiguration> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(SrtListenerRouterInputConfiguration::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<Long> MINIMUM_LATENCY_MILLISECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MinimumLatencyMilliseconds")
            .getter(getter(SrtListenerRouterInputConfiguration::minimumLatencyMilliseconds))
            .setter(setter(Builder::minimumLatencyMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatencyMilliseconds").build())
            .build();

    private static final SdkField<SrtDecryptionConfiguration> DECRYPTION_CONFIGURATION_FIELD = SdkField
            .<SrtDecryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("DecryptionConfiguration")
            .getter(getter(SrtListenerRouterInputConfiguration::decryptionConfiguration))
            .setter(setter(Builder::decryptionConfiguration)).constructor(SrtDecryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD,
            MINIMUM_LATENCY_MILLISECONDS_FIELD, DECRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final Long minimumLatencyMilliseconds;

    private final SrtDecryptionConfiguration decryptionConfiguration;

    private SrtListenerRouterInputConfiguration(BuilderImpl builder) {
        this.port = builder.port;
        this.minimumLatencyMilliseconds = builder.minimumLatencyMilliseconds;
        this.decryptionConfiguration = builder.decryptionConfiguration;
    }

    /**
     * <p>
     * The port number for the SRT protocol in listener mode.
     * </p>
     * 
     * @return The port number for the SRT protocol in listener mode.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The minimum latency in milliseconds for the SRT protocol in listener mode.
     * </p>
     * 
     * @return The minimum latency in milliseconds for the SRT protocol in listener mode.
     */
    public final Long minimumLatencyMilliseconds() {
        return minimumLatencyMilliseconds;
    }

    /**
     * <p>
     * Specifies the decryption settings for an SRT listener input, including the encryption key configuration and
     * associated parameters.
     * </p>
     * 
     * @return Specifies the decryption settings for an SRT listener input, including the encryption key configuration
     *         and associated parameters.
     */
    public final SrtDecryptionConfiguration decryptionConfiguration() {
        return decryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(minimumLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(decryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtListenerRouterInputConfiguration)) {
            return false;
        }
        SrtListenerRouterInputConfiguration other = (SrtListenerRouterInputConfiguration) obj;
        return Objects.equals(port(), other.port())
                && Objects.equals(minimumLatencyMilliseconds(), other.minimumLatencyMilliseconds())
                && Objects.equals(decryptionConfiguration(), other.decryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtListenerRouterInputConfiguration").add("Port", port())
                .add("MinimumLatencyMilliseconds", minimumLatencyMilliseconds())
                .add("DecryptionConfiguration", decryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "MinimumLatencyMilliseconds":
            return Optional.ofNullable(clazz.cast(minimumLatencyMilliseconds()));
        case "DecryptionConfiguration":
            return Optional.ofNullable(clazz.cast(decryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("port", PORT_FIELD);
        map.put("minimumLatencyMilliseconds", MINIMUM_LATENCY_MILLISECONDS_FIELD);
        map.put("decryptionConfiguration", DECRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtListenerRouterInputConfiguration, T> g) {
        return obj -> g.apply((SrtListenerRouterInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtListenerRouterInputConfiguration> {
        /**
         * <p>
         * The port number for the SRT protocol in listener mode.
         * </p>
         * 
         * @param port
         *        The port number for the SRT protocol in listener mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The minimum latency in milliseconds for the SRT protocol in listener mode.
         * </p>
         * 
         * @param minimumLatencyMilliseconds
         *        The minimum latency in milliseconds for the SRT protocol in listener mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds);

        /**
         * <p>
         * Specifies the decryption settings for an SRT listener input, including the encryption key configuration and
         * associated parameters.
         * </p>
         * 
         * @param decryptionConfiguration
         *        Specifies the decryption settings for an SRT listener input, including the encryption key
         *        configuration and associated parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryptionConfiguration(SrtDecryptionConfiguration decryptionConfiguration);

        /**
         * <p>
         * Specifies the decryption settings for an SRT listener input, including the encryption key configuration and
         * associated parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link SrtDecryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link SrtDecryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SrtDecryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #decryptionConfiguration(SrtDecryptionConfiguration)}.
         * 
         * @param decryptionConfiguration
         *        a consumer that will call methods on {@link SrtDecryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decryptionConfiguration(SrtDecryptionConfiguration)
         */
        default Builder decryptionConfiguration(Consumer<SrtDecryptionConfiguration.Builder> decryptionConfiguration) {
            return decryptionConfiguration(SrtDecryptionConfiguration.builder().applyMutation(decryptionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private Long minimumLatencyMilliseconds;

        private SrtDecryptionConfiguration decryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtListenerRouterInputConfiguration model) {
            port(model.port);
            minimumLatencyMilliseconds(model.minimumLatencyMilliseconds);
            decryptionConfiguration(model.decryptionConfiguration);
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Long getMinimumLatencyMilliseconds() {
            return minimumLatencyMilliseconds;
        }

        public final void setMinimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
        }

        @Override
        public final Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
            return this;
        }

        public final SrtDecryptionConfiguration.Builder getDecryptionConfiguration() {
            return decryptionConfiguration != null ? decryptionConfiguration.toBuilder() : null;
        }

        public final void setDecryptionConfiguration(SrtDecryptionConfiguration.BuilderImpl decryptionConfiguration) {
            this.decryptionConfiguration = decryptionConfiguration != null ? decryptionConfiguration.build() : null;
        }

        @Override
        public final Builder decryptionConfiguration(SrtDecryptionConfiguration decryptionConfiguration) {
            this.decryptionConfiguration = decryptionConfiguration;
            return this;
        }

        @Override
        public SrtListenerRouterInputConfiguration build() {
            return new SrtListenerRouterInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
