/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration settings for encrypting SRT streams, including the encryption key details and encryption
 * parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtEncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtEncryptionConfiguration.Builder, SrtEncryptionConfiguration> {
    private static final SdkField<SecretsManagerEncryptionKeyConfiguration> ENCRYPTION_KEY_FIELD = SdkField
            .<SecretsManagerEncryptionKeyConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionKey")
            .getter(getter(SrtEncryptionConfiguration::encryptionKey)).setter(setter(Builder::encryptionKey))
            .constructor(SecretsManagerEncryptionKeyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SecretsManagerEncryptionKeyConfiguration encryptionKey;

    private SrtEncryptionConfiguration(BuilderImpl builder) {
        this.encryptionKey = builder.encryptionKey;
    }

    /**
     * <p>
     * Specifies the encryption key configuration used for encrypting SRT streams, including the key source and
     * associated credentials.
     * </p>
     * 
     * @return Specifies the encryption key configuration used for encrypting SRT streams, including the key source and
     *         associated credentials.
     */
    public final SecretsManagerEncryptionKeyConfiguration encryptionKey() {
        return encryptionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtEncryptionConfiguration)) {
            return false;
        }
        SrtEncryptionConfiguration other = (SrtEncryptionConfiguration) obj;
        return Objects.equals(encryptionKey(), other.encryptionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtEncryptionConfiguration").add("EncryptionKey", encryptionKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encryptionKey", ENCRYPTION_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtEncryptionConfiguration, T> g) {
        return obj -> g.apply((SrtEncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtEncryptionConfiguration> {
        /**
         * <p>
         * Specifies the encryption key configuration used for encrypting SRT streams, including the key source and
         * associated credentials.
         * </p>
         * 
         * @param encryptionKey
         *        Specifies the encryption key configuration used for encrypting SRT streams, including the key source
         *        and associated credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(SecretsManagerEncryptionKeyConfiguration encryptionKey);

        /**
         * <p>
         * Specifies the encryption key configuration used for encrypting SRT streams, including the key source and
         * associated credentials.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SecretsManagerEncryptionKeyConfiguration.Builder} avoiding the need to create one manually via
         * {@link SecretsManagerEncryptionKeyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManagerEncryptionKeyConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #encryptionKey(SecretsManagerEncryptionKeyConfiguration)}.
         * 
         * @param encryptionKey
         *        a consumer that will call methods on {@link SecretsManagerEncryptionKeyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionKey(SecretsManagerEncryptionKeyConfiguration)
         */
        default Builder encryptionKey(Consumer<SecretsManagerEncryptionKeyConfiguration.Builder> encryptionKey) {
            return encryptionKey(SecretsManagerEncryptionKeyConfiguration.builder().applyMutation(encryptionKey).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SecretsManagerEncryptionKeyConfiguration encryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtEncryptionConfiguration model) {
            encryptionKey(model.encryptionKey);
        }

        public final SecretsManagerEncryptionKeyConfiguration.Builder getEncryptionKey() {
            return encryptionKey != null ? encryptionKey.toBuilder() : null;
        }

        public final void setEncryptionKey(SecretsManagerEncryptionKeyConfiguration.BuilderImpl encryptionKey) {
            this.encryptionKey = encryptionKey != null ? encryptionKey.build() : null;
        }

        @Override
        public final Builder encryptionKey(SecretsManagerEncryptionKeyConfiguration encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        @Override
        public SrtEncryptionConfiguration build() {
            return new SrtEncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
