/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the router output's stream, including connection state and destination details. The specific
 * details provided vary based on the router output type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterOutputStreamDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterOutputStreamDetails.Builder, RouterOutputStreamDetails> {
    private static final SdkField<StandardRouterOutputStreamDetails> STANDARD_FIELD = SdkField
            .<StandardRouterOutputStreamDetails> builder(MarshallingType.SDK_POJO).memberName("Standard")
            .getter(getter(RouterOutputStreamDetails::standard)).setter(setter(Builder::standard))
            .constructor(StandardRouterOutputStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standard").build()).build();

    private static final SdkField<MediaConnectFlowRouterOutputStreamDetails> MEDIA_CONNECT_FLOW_FIELD = SdkField
            .<MediaConnectFlowRouterOutputStreamDetails> builder(MarshallingType.SDK_POJO).memberName("MediaConnectFlow")
            .getter(getter(RouterOutputStreamDetails::mediaConnectFlow)).setter(setter(Builder::mediaConnectFlow))
            .constructor(MediaConnectFlowRouterOutputStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlow").build()).build();

    private static final SdkField<MediaLiveInputRouterOutputStreamDetails> MEDIA_LIVE_INPUT_FIELD = SdkField
            .<MediaLiveInputRouterOutputStreamDetails> builder(MarshallingType.SDK_POJO).memberName("MediaLiveInput")
            .getter(getter(RouterOutputStreamDetails::mediaLiveInput)).setter(setter(Builder::mediaLiveInput))
            .constructor(MediaLiveInputRouterOutputStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaLiveInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_FIELD,
            MEDIA_CONNECT_FLOW_FIELD, MEDIA_LIVE_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StandardRouterOutputStreamDetails standard;

    private final MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow;

    private final MediaLiveInputRouterOutputStreamDetails mediaLiveInput;

    private final Type type;

    private RouterOutputStreamDetails(BuilderImpl builder) {
        this.standard = builder.standard;
        this.mediaConnectFlow = builder.mediaConnectFlow;
        this.mediaLiveInput = builder.mediaLiveInput;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Standard property for this object.
     * 
     * @return The value of the Standard property for this object.
     */
    public final StandardRouterOutputStreamDetails standard() {
        return standard;
    }

    /**
     * Returns the value of the MediaConnectFlow property for this object.
     * 
     * @return The value of the MediaConnectFlow property for this object.
     */
    public final MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow() {
        return mediaConnectFlow;
    }

    /**
     * Returns the value of the MediaLiveInput property for this object.
     * 
     * @return The value of the MediaLiveInput property for this object.
     */
    public final MediaLiveInputRouterOutputStreamDetails mediaLiveInput() {
        return mediaLiveInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standard());
        hashCode = 31 * hashCode + Objects.hashCode(mediaConnectFlow());
        hashCode = 31 * hashCode + Objects.hashCode(mediaLiveInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterOutputStreamDetails)) {
            return false;
        }
        RouterOutputStreamDetails other = (RouterOutputStreamDetails) obj;
        return Objects.equals(standard(), other.standard()) && Objects.equals(mediaConnectFlow(), other.mediaConnectFlow())
                && Objects.equals(mediaLiveInput(), other.mediaLiveInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterOutputStreamDetails").add("Standard", standard())
                .add("MediaConnectFlow", mediaConnectFlow()).add("MediaLiveInput", mediaLiveInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Standard":
            return Optional.ofNullable(clazz.cast(standard()));
        case "MediaConnectFlow":
            return Optional.ofNullable(clazz.cast(mediaConnectFlow()));
        case "MediaLiveInput":
            return Optional.ofNullable(clazz.cast(mediaLiveInput()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #standard()} initialized to the given value.
     *
     * Sets the value of the Standard property for this object.
     *
     * @param standard
     *        The new value for the Standard property for this object.
     */
    public static RouterOutputStreamDetails fromStandard(StandardRouterOutputStreamDetails standard) {
        return builder().standard(standard).build();
    }

    /**
     * Create an instance of this class with {@link #standard()} initialized to the given value.
     *
     * Sets the value of the Standard property for this object.
     *
     * @param standard
     *        The new value for the Standard property for this object.
     */
    public static RouterOutputStreamDetails fromStandard(Consumer<StandardRouterOutputStreamDetails.Builder> standard) {
        StandardRouterOutputStreamDetails.Builder builder = StandardRouterOutputStreamDetails.builder();
        standard.accept(builder);
        return fromStandard(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mediaConnectFlow()} initialized to the given value.
     *
     * Sets the value of the MediaConnectFlow property for this object.
     *
     * @param mediaConnectFlow
     *        The new value for the MediaConnectFlow property for this object.
     */
    public static RouterOutputStreamDetails fromMediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow) {
        return builder().mediaConnectFlow(mediaConnectFlow).build();
    }

    /**
     * Create an instance of this class with {@link #mediaConnectFlow()} initialized to the given value.
     *
     * Sets the value of the MediaConnectFlow property for this object.
     *
     * @param mediaConnectFlow
     *        The new value for the MediaConnectFlow property for this object.
     */
    public static RouterOutputStreamDetails fromMediaConnectFlow(
            Consumer<MediaConnectFlowRouterOutputStreamDetails.Builder> mediaConnectFlow) {
        MediaConnectFlowRouterOutputStreamDetails.Builder builder = MediaConnectFlowRouterOutputStreamDetails.builder();
        mediaConnectFlow.accept(builder);
        return fromMediaConnectFlow(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mediaLiveInput()} initialized to the given value.
     *
     * Sets the value of the MediaLiveInput property for this object.
     *
     * @param mediaLiveInput
     *        The new value for the MediaLiveInput property for this object.
     */
    public static RouterOutputStreamDetails fromMediaLiveInput(MediaLiveInputRouterOutputStreamDetails mediaLiveInput) {
        return builder().mediaLiveInput(mediaLiveInput).build();
    }

    /**
     * Create an instance of this class with {@link #mediaLiveInput()} initialized to the given value.
     *
     * Sets the value of the MediaLiveInput property for this object.
     *
     * @param mediaLiveInput
     *        The new value for the MediaLiveInput property for this object.
     */
    public static RouterOutputStreamDetails fromMediaLiveInput(
            Consumer<MediaLiveInputRouterOutputStreamDetails.Builder> mediaLiveInput) {
        MediaLiveInputRouterOutputStreamDetails.Builder builder = MediaLiveInputRouterOutputStreamDetails.builder();
        mediaLiveInput.accept(builder);
        return fromMediaLiveInput(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("standard", STANDARD_FIELD);
        map.put("mediaConnectFlow", MEDIA_CONNECT_FLOW_FIELD);
        map.put("mediaLiveInput", MEDIA_LIVE_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterOutputStreamDetails, T> g) {
        return obj -> g.apply((RouterOutputStreamDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterOutputStreamDetails> {
        /**
         * Sets the value of the Standard property for this object.
         *
         * @param standard
         *        The new value for the Standard property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standard(StandardRouterOutputStreamDetails standard);

        /**
         * Sets the value of the Standard property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link StandardRouterOutputStreamDetails.Builder} avoiding the need to create one manually via
         * {@link StandardRouterOutputStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardRouterOutputStreamDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #standard(StandardRouterOutputStreamDetails)}.
         * 
         * @param standard
         *        a consumer that will call methods on {@link StandardRouterOutputStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standard(StandardRouterOutputStreamDetails)
         */
        default Builder standard(Consumer<StandardRouterOutputStreamDetails.Builder> standard) {
            return standard(StandardRouterOutputStreamDetails.builder().applyMutation(standard).build());
        }

        /**
         * Sets the value of the MediaConnectFlow property for this object.
         *
         * @param mediaConnectFlow
         *        The new value for the MediaConnectFlow property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow);

        /**
         * Sets the value of the MediaConnectFlow property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link MediaConnectFlowRouterOutputStreamDetails.Builder} avoiding the need to create one manually via
         * {@link MediaConnectFlowRouterOutputStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaConnectFlowRouterOutputStreamDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails)}.
         * 
         * @param mediaConnectFlow
         *        a consumer that will call methods on {@link MediaConnectFlowRouterOutputStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails)
         */
        default Builder mediaConnectFlow(Consumer<MediaConnectFlowRouterOutputStreamDetails.Builder> mediaConnectFlow) {
            return mediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails.builder().applyMutation(mediaConnectFlow).build());
        }

        /**
         * Sets the value of the MediaLiveInput property for this object.
         *
         * @param mediaLiveInput
         *        The new value for the MediaLiveInput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaLiveInput(MediaLiveInputRouterOutputStreamDetails mediaLiveInput);

        /**
         * Sets the value of the MediaLiveInput property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link MediaLiveInputRouterOutputStreamDetails.Builder} avoiding the need to create one manually via
         * {@link MediaLiveInputRouterOutputStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaLiveInputRouterOutputStreamDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mediaLiveInput(MediaLiveInputRouterOutputStreamDetails)}.
         * 
         * @param mediaLiveInput
         *        a consumer that will call methods on {@link MediaLiveInputRouterOutputStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaLiveInput(MediaLiveInputRouterOutputStreamDetails)
         */
        default Builder mediaLiveInput(Consumer<MediaLiveInputRouterOutputStreamDetails.Builder> mediaLiveInput) {
            return mediaLiveInput(MediaLiveInputRouterOutputStreamDetails.builder().applyMutation(mediaLiveInput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StandardRouterOutputStreamDetails standard;

        private MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow;

        private MediaLiveInputRouterOutputStreamDetails mediaLiveInput;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterOutputStreamDetails model) {
            standard(model.standard);
            mediaConnectFlow(model.mediaConnectFlow);
            mediaLiveInput(model.mediaLiveInput);
        }

        public final StandardRouterOutputStreamDetails.Builder getStandard() {
            return standard != null ? standard.toBuilder() : null;
        }

        public final void setStandard(StandardRouterOutputStreamDetails.BuilderImpl standard) {
            Object oldValue = this.standard;
            this.standard = standard != null ? standard.build() : null;
            handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
        }

        @Override
        public final Builder standard(StandardRouterOutputStreamDetails standard) {
            Object oldValue = this.standard;
            this.standard = standard;
            handleUnionValueChange(Type.STANDARD, oldValue, this.standard);
            return this;
        }

        public final MediaConnectFlowRouterOutputStreamDetails.Builder getMediaConnectFlow() {
            return mediaConnectFlow != null ? mediaConnectFlow.toBuilder() : null;
        }

        public final void setMediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails.BuilderImpl mediaConnectFlow) {
            Object oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow != null ? mediaConnectFlow.build() : null;
            handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
        }

        @Override
        public final Builder mediaConnectFlow(MediaConnectFlowRouterOutputStreamDetails mediaConnectFlow) {
            Object oldValue = this.mediaConnectFlow;
            this.mediaConnectFlow = mediaConnectFlow;
            handleUnionValueChange(Type.MEDIA_CONNECT_FLOW, oldValue, this.mediaConnectFlow);
            return this;
        }

        public final MediaLiveInputRouterOutputStreamDetails.Builder getMediaLiveInput() {
            return mediaLiveInput != null ? mediaLiveInput.toBuilder() : null;
        }

        public final void setMediaLiveInput(MediaLiveInputRouterOutputStreamDetails.BuilderImpl mediaLiveInput) {
            Object oldValue = this.mediaLiveInput;
            this.mediaLiveInput = mediaLiveInput != null ? mediaLiveInput.build() : null;
            handleUnionValueChange(Type.MEDIA_LIVE_INPUT, oldValue, this.mediaLiveInput);
        }

        @Override
        public final Builder mediaLiveInput(MediaLiveInputRouterOutputStreamDetails mediaLiveInput) {
            Object oldValue = this.mediaLiveInput;
            this.mediaLiveInput = mediaLiveInput;
            handleUnionValueChange(Type.MEDIA_LIVE_INPUT, oldValue, this.mediaLiveInput);
            return this;
        }

        @Override
        public RouterOutputStreamDetails build() {
            return new RouterOutputStreamDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RouterOutputStreamDetails#type()
     */
    public enum Type {
        STANDARD,

        MEDIA_CONNECT_FLOW,

        MEDIA_LIVE_INPUT,

        UNKNOWN_TO_SDK_VERSION
    }
}
