/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a thumbnail associated with a router input, including the thumbnail messages, the thumbnail image, the
 * timecode, and the timestamp.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterInputThumbnailDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterInputThumbnailDetails.Builder, RouterInputThumbnailDetails> {
    private static final SdkField<List<RouterInputMessage>> THUMBNAIL_MESSAGES_FIELD = SdkField
            .<List<RouterInputMessage>> builder(MarshallingType.LIST)
            .memberName("ThumbnailMessages")
            .getter(getter(RouterInputThumbnailDetails::thumbnailMessages))
            .setter(setter(Builder::thumbnailMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouterInputMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouterInputMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SdkBytes> THUMBNAIL_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Thumbnail").getter(getter(RouterInputThumbnailDetails::thumbnail)).setter(setter(Builder::thumbnail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnail").build()).build();

    private static final SdkField<String> TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timecode").getter(getter(RouterInputThumbnailDetails::timecode)).setter(setter(Builder::timecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecode").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp")
            .getter(getter(RouterInputThumbnailDetails::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THUMBNAIL_MESSAGES_FIELD,
            THUMBNAIL_FIELD, TIMECODE_FIELD, TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RouterInputMessage> thumbnailMessages;

    private final SdkBytes thumbnail;

    private final String timecode;

    private final Instant timestamp;

    private RouterInputThumbnailDetails(BuilderImpl builder) {
        this.thumbnailMessages = builder.thumbnailMessages;
        this.thumbnail = builder.thumbnail;
        this.timecode = builder.timecode;
        this.timestamp = builder.timestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThumbnailMessages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasThumbnailMessages() {
        return thumbnailMessages != null && !(thumbnailMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The messages associated with the router input thumbnail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThumbnailMessages} method.
     * </p>
     * 
     * @return The messages associated with the router input thumbnail.
     */
    public final List<RouterInputMessage> thumbnailMessages() {
        return thumbnailMessages;
    }

    /**
     * <p>
     * The thumbnail image, encoded as a Base64-encoded binary data object.
     * </p>
     * 
     * @return The thumbnail image, encoded as a Base64-encoded binary data object.
     */
    public final SdkBytes thumbnail() {
        return thumbnail;
    }

    /**
     * <p>
     * The timecode associated with the thumbnail.
     * </p>
     * 
     * @return The timecode associated with the thumbnail.
     */
    public final String timecode() {
        return timecode;
    }

    /**
     * <p>
     * The timestamp associated with the thumbnail.
     * </p>
     * 
     * @return The timestamp associated with the thumbnail.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasThumbnailMessages() ? thumbnailMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(thumbnail());
        hashCode = 31 * hashCode + Objects.hashCode(timecode());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputThumbnailDetails)) {
            return false;
        }
        RouterInputThumbnailDetails other = (RouterInputThumbnailDetails) obj;
        return hasThumbnailMessages() == other.hasThumbnailMessages()
                && Objects.equals(thumbnailMessages(), other.thumbnailMessages())
                && Objects.equals(thumbnail(), other.thumbnail()) && Objects.equals(timecode(), other.timecode())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterInputThumbnailDetails")
                .add("ThumbnailMessages", hasThumbnailMessages() ? thumbnailMessages() : null).add("Thumbnail", thumbnail())
                .add("Timecode", timecode()).add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThumbnailMessages":
            return Optional.ofNullable(clazz.cast(thumbnailMessages()));
        case "Thumbnail":
            return Optional.ofNullable(clazz.cast(thumbnail()));
        case "Timecode":
            return Optional.ofNullable(clazz.cast(timecode()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thumbnailMessages", THUMBNAIL_MESSAGES_FIELD);
        map.put("thumbnail", THUMBNAIL_FIELD);
        map.put("timecode", TIMECODE_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputThumbnailDetails, T> g) {
        return obj -> g.apply((RouterInputThumbnailDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterInputThumbnailDetails> {
        /**
         * <p>
         * The messages associated with the router input thumbnail.
         * </p>
         * 
         * @param thumbnailMessages
         *        The messages associated with the router input thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailMessages(Collection<RouterInputMessage> thumbnailMessages);

        /**
         * <p>
         * The messages associated with the router input thumbnail.
         * </p>
         * 
         * @param thumbnailMessages
         *        The messages associated with the router input thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailMessages(RouterInputMessage... thumbnailMessages);

        /**
         * <p>
         * The messages associated with the router input thumbnail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage.Builder#build()} is called
         * immediately and its result is passed to {@link #thumbnailMessages(List<RouterInputMessage>)}.
         * 
         * @param thumbnailMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailMessages(java.util.Collection<RouterInputMessage>)
         */
        Builder thumbnailMessages(Consumer<RouterInputMessage.Builder>... thumbnailMessages);

        /**
         * <p>
         * The thumbnail image, encoded as a Base64-encoded binary data object.
         * </p>
         * 
         * @param thumbnail
         *        The thumbnail image, encoded as a Base64-encoded binary data object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnail(SdkBytes thumbnail);

        /**
         * <p>
         * The timecode associated with the thumbnail.
         * </p>
         * 
         * @param timecode
         *        The timecode associated with the thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecode(String timecode);

        /**
         * <p>
         * The timestamp associated with the thumbnail.
         * </p>
         * 
         * @param timestamp
         *        The timestamp associated with the thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private List<RouterInputMessage> thumbnailMessages = DefaultSdkAutoConstructList.getInstance();

        private SdkBytes thumbnail;

        private String timecode;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputThumbnailDetails model) {
            thumbnailMessages(model.thumbnailMessages);
            thumbnail(model.thumbnail);
            timecode(model.timecode);
            timestamp(model.timestamp);
        }

        public final List<RouterInputMessage.Builder> getThumbnailMessages() {
            List<RouterInputMessage.Builder> result = RouterInputMessagesCopier.copyToBuilder(this.thumbnailMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThumbnailMessages(Collection<RouterInputMessage.BuilderImpl> thumbnailMessages) {
            this.thumbnailMessages = RouterInputMessagesCopier.copyFromBuilder(thumbnailMessages);
        }

        @Override
        public final Builder thumbnailMessages(Collection<RouterInputMessage> thumbnailMessages) {
            this.thumbnailMessages = RouterInputMessagesCopier.copy(thumbnailMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailMessages(RouterInputMessage... thumbnailMessages) {
            thumbnailMessages(Arrays.asList(thumbnailMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailMessages(Consumer<RouterInputMessage.Builder>... thumbnailMessages) {
            thumbnailMessages(Stream.of(thumbnailMessages).map(c -> RouterInputMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ByteBuffer getThumbnail() {
            return thumbnail == null ? null : thumbnail.asByteBuffer();
        }

        public final void setThumbnail(ByteBuffer thumbnail) {
            thumbnail(thumbnail == null ? null : SdkBytes.fromByteBuffer(thumbnail));
        }

        @Override
        public final Builder thumbnail(SdkBytes thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public final String getTimecode() {
            return timecode;
        }

        public final void setTimecode(String timecode) {
            this.timecode = timecode;
        }

        @Override
        public final Builder timecode(String timecode) {
            this.timecode = timecode;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public RouterInputThumbnailDetails build() {
            return new RouterInputThumbnailDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
