/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed metadata information about a router input source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterInputSourceMetadataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterInputSourceMetadataDetails.Builder, RouterInputSourceMetadataDetails> {
    private static final SdkField<List<RouterInputMessage>> SOURCE_METADATA_MESSAGES_FIELD = SdkField
            .<List<RouterInputMessage>> builder(MarshallingType.LIST)
            .memberName("SourceMetadataMessages")
            .getter(getter(RouterInputSourceMetadataDetails::sourceMetadataMessages))
            .setter(setter(Builder::sourceMetadataMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceMetadataMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouterInputMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouterInputMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp")
            .getter(getter(RouterInputSourceMetadataDetails::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<RouterInputMetadata> ROUTER_INPUT_METADATA_FIELD = SdkField
            .<RouterInputMetadata> builder(MarshallingType.SDK_POJO).memberName("RouterInputMetadata")
            .getter(getter(RouterInputSourceMetadataDetails::routerInputMetadata)).setter(setter(Builder::routerInputMetadata))
            .constructor(RouterInputMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInputMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_METADATA_MESSAGES_FIELD, TIMESTAMP_FIELD, ROUTER_INPUT_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RouterInputMessage> sourceMetadataMessages;

    private final Instant timestamp;

    private final RouterInputMetadata routerInputMetadata;

    private RouterInputSourceMetadataDetails(BuilderImpl builder) {
        this.sourceMetadataMessages = builder.sourceMetadataMessages;
        this.timestamp = builder.timestamp;
        this.routerInputMetadata = builder.routerInputMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceMetadataMessages property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceMetadataMessages() {
        return sourceMetadataMessages != null && !(sourceMetadataMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Collection of metadata messages associated with the router input source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceMetadataMessages} method.
     * </p>
     * 
     * @return Collection of metadata messages associated with the router input source.
     */
    public final List<RouterInputMessage> sourceMetadataMessages() {
        return sourceMetadataMessages;
    }

    /**
     * <p>
     * The timestamp when the metadata was last updated.
     * </p>
     * 
     * @return The timestamp when the metadata was last updated.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Metadata information specific to the router input configuration and state.
     * </p>
     * 
     * @return Metadata information specific to the router input configuration and state.
     */
    public final RouterInputMetadata routerInputMetadata() {
        return routerInputMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceMetadataMessages() ? sourceMetadataMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(routerInputMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputSourceMetadataDetails)) {
            return false;
        }
        RouterInputSourceMetadataDetails other = (RouterInputSourceMetadataDetails) obj;
        return hasSourceMetadataMessages() == other.hasSourceMetadataMessages()
                && Objects.equals(sourceMetadataMessages(), other.sourceMetadataMessages())
                && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(routerInputMetadata(), other.routerInputMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterInputSourceMetadataDetails")
                .add("SourceMetadataMessages", hasSourceMetadataMessages() ? sourceMetadataMessages() : null)
                .add("Timestamp", timestamp()).add("RouterInputMetadata", routerInputMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceMetadataMessages":
            return Optional.ofNullable(clazz.cast(sourceMetadataMessages()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "RouterInputMetadata":
            return Optional.ofNullable(clazz.cast(routerInputMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceMetadataMessages", SOURCE_METADATA_MESSAGES_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("routerInputMetadata", ROUTER_INPUT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputSourceMetadataDetails, T> g) {
        return obj -> g.apply((RouterInputSourceMetadataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterInputSourceMetadataDetails> {
        /**
         * <p>
         * Collection of metadata messages associated with the router input source.
         * </p>
         * 
         * @param sourceMetadataMessages
         *        Collection of metadata messages associated with the router input source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMetadataMessages(Collection<RouterInputMessage> sourceMetadataMessages);

        /**
         * <p>
         * Collection of metadata messages associated with the router input source.
         * </p>
         * 
         * @param sourceMetadataMessages
         *        Collection of metadata messages associated with the router input source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMetadataMessages(RouterInputMessage... sourceMetadataMessages);

        /**
         * <p>
         * Collection of metadata messages associated with the router input source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceMetadataMessages(List<RouterInputMessage>)}.
         * 
         * @param sourceMetadataMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceMetadataMessages(java.util.Collection<RouterInputMessage>)
         */
        Builder sourceMetadataMessages(Consumer<RouterInputMessage.Builder>... sourceMetadataMessages);

        /**
         * <p>
         * The timestamp when the metadata was last updated.
         * </p>
         * 
         * @param timestamp
         *        The timestamp when the metadata was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * Metadata information specific to the router input configuration and state.
         * </p>
         * 
         * @param routerInputMetadata
         *        Metadata information specific to the router input configuration and state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerInputMetadata(RouterInputMetadata routerInputMetadata);

        /**
         * <p>
         * Metadata information specific to the router input configuration and state.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouterInputMetadata.Builder} avoiding the
         * need to create one manually via {@link RouterInputMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterInputMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #routerInputMetadata(RouterInputMetadata)}.
         * 
         * @param routerInputMetadata
         *        a consumer that will call methods on {@link RouterInputMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routerInputMetadata(RouterInputMetadata)
         */
        default Builder routerInputMetadata(Consumer<RouterInputMetadata.Builder> routerInputMetadata) {
            return routerInputMetadata(RouterInputMetadata.builder().applyMutation(routerInputMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<RouterInputMessage> sourceMetadataMessages = DefaultSdkAutoConstructList.getInstance();

        private Instant timestamp;

        private RouterInputMetadata routerInputMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputSourceMetadataDetails model) {
            sourceMetadataMessages(model.sourceMetadataMessages);
            timestamp(model.timestamp);
            routerInputMetadata(model.routerInputMetadata);
        }

        public final List<RouterInputMessage.Builder> getSourceMetadataMessages() {
            List<RouterInputMessage.Builder> result = RouterInputMessagesCopier.copyToBuilder(this.sourceMetadataMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceMetadataMessages(Collection<RouterInputMessage.BuilderImpl> sourceMetadataMessages) {
            this.sourceMetadataMessages = RouterInputMessagesCopier.copyFromBuilder(sourceMetadataMessages);
        }

        @Override
        public final Builder sourceMetadataMessages(Collection<RouterInputMessage> sourceMetadataMessages) {
            this.sourceMetadataMessages = RouterInputMessagesCopier.copy(sourceMetadataMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceMetadataMessages(RouterInputMessage... sourceMetadataMessages) {
            sourceMetadataMessages(Arrays.asList(sourceMetadataMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceMetadataMessages(Consumer<RouterInputMessage.Builder>... sourceMetadataMessages) {
            sourceMetadataMessages(Stream.of(sourceMetadataMessages)
                    .map(c -> RouterInputMessage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final RouterInputMetadata.Builder getRouterInputMetadata() {
            return routerInputMetadata != null ? routerInputMetadata.toBuilder() : null;
        }

        public final void setRouterInputMetadata(RouterInputMetadata.BuilderImpl routerInputMetadata) {
            this.routerInputMetadata = routerInputMetadata != null ? routerInputMetadata.build() : null;
        }

        @Override
        public final Builder routerInputMetadata(RouterInputMetadata routerInputMetadata) {
            this.routerInputMetadata = routerInputMetadata;
            return this;
        }

        @Override
        public RouterInputSourceMetadataDetails build() {
            return new RouterInputSourceMetadataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
