/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata information associated with the router input, including stream details and connection state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterInputMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterInputMetadata.Builder, RouterInputMetadata> {
    private static final SdkField<TransportMediaInfo> TRANSPORT_STREAM_MEDIA_INFO_FIELD = SdkField
            .<TransportMediaInfo> builder(MarshallingType.SDK_POJO).memberName("TransportStreamMediaInfo")
            .getter(getter(RouterInputMetadata::transportStreamMediaInfo)).setter(setter(Builder::transportStreamMediaInfo))
            .constructor(TransportMediaInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamMediaInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSPORT_STREAM_MEDIA_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TransportMediaInfo transportStreamMediaInfo;

    private final Type type;

    private RouterInputMetadata(BuilderImpl builder) {
        this.transportStreamMediaInfo = builder.transportStreamMediaInfo;
        this.type = builder.type;
    }

    /**
     * Returns the value of the TransportStreamMediaInfo property for this object.
     * 
     * @return The value of the TransportStreamMediaInfo property for this object.
     */
    public final TransportMediaInfo transportStreamMediaInfo() {
        return transportStreamMediaInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transportStreamMediaInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputMetadata)) {
            return false;
        }
        RouterInputMetadata other = (RouterInputMetadata) obj;
        return Objects.equals(transportStreamMediaInfo(), other.transportStreamMediaInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterInputMetadata").add("TransportStreamMediaInfo", transportStreamMediaInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransportStreamMediaInfo":
            return Optional.ofNullable(clazz.cast(transportStreamMediaInfo()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #transportStreamMediaInfo()} initialized to the given value.
     *
     * Sets the value of the TransportStreamMediaInfo property for this object.
     *
     * @param transportStreamMediaInfo
     *        The new value for the TransportStreamMediaInfo property for this object.
     */
    public static RouterInputMetadata fromTransportStreamMediaInfo(TransportMediaInfo transportStreamMediaInfo) {
        return builder().transportStreamMediaInfo(transportStreamMediaInfo).build();
    }

    /**
     * Create an instance of this class with {@link #transportStreamMediaInfo()} initialized to the given value.
     *
     * Sets the value of the TransportStreamMediaInfo property for this object.
     *
     * @param transportStreamMediaInfo
     *        The new value for the TransportStreamMediaInfo property for this object.
     */
    public static RouterInputMetadata fromTransportStreamMediaInfo(Consumer<TransportMediaInfo.Builder> transportStreamMediaInfo) {
        TransportMediaInfo.Builder builder = TransportMediaInfo.builder();
        transportStreamMediaInfo.accept(builder);
        return fromTransportStreamMediaInfo(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transportStreamMediaInfo", TRANSPORT_STREAM_MEDIA_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputMetadata, T> g) {
        return obj -> g.apply((RouterInputMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterInputMetadata> {
        /**
         * Sets the value of the TransportStreamMediaInfo property for this object.
         *
         * @param transportStreamMediaInfo
         *        The new value for the TransportStreamMediaInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportStreamMediaInfo(TransportMediaInfo transportStreamMediaInfo);

        /**
         * Sets the value of the TransportStreamMediaInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TransportMediaInfo.Builder} avoiding the
         * need to create one manually via {@link TransportMediaInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransportMediaInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #transportStreamMediaInfo(TransportMediaInfo)}.
         * 
         * @param transportStreamMediaInfo
         *        a consumer that will call methods on {@link TransportMediaInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transportStreamMediaInfo(TransportMediaInfo)
         */
        default Builder transportStreamMediaInfo(Consumer<TransportMediaInfo.Builder> transportStreamMediaInfo) {
            return transportStreamMediaInfo(TransportMediaInfo.builder().applyMutation(transportStreamMediaInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TransportMediaInfo transportStreamMediaInfo;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputMetadata model) {
            transportStreamMediaInfo(model.transportStreamMediaInfo);
        }

        public final TransportMediaInfo.Builder getTransportStreamMediaInfo() {
            return transportStreamMediaInfo != null ? transportStreamMediaInfo.toBuilder() : null;
        }

        public final void setTransportStreamMediaInfo(TransportMediaInfo.BuilderImpl transportStreamMediaInfo) {
            Object oldValue = this.transportStreamMediaInfo;
            this.transportStreamMediaInfo = transportStreamMediaInfo != null ? transportStreamMediaInfo.build() : null;
            handleUnionValueChange(Type.TRANSPORT_STREAM_MEDIA_INFO, oldValue, this.transportStreamMediaInfo);
        }

        @Override
        public final Builder transportStreamMediaInfo(TransportMediaInfo transportStreamMediaInfo) {
            Object oldValue = this.transportStreamMediaInfo;
            this.transportStreamMediaInfo = transportStreamMediaInfo;
            handleUnionValueChange(Type.TRANSPORT_STREAM_MEDIA_INFO, oldValue, this.transportStreamMediaInfo);
            return this;
        }

        @Override
        public RouterInputMetadata build() {
            return new RouterInputMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RouterInputMetadata#type()
     */
    public enum Type {
        TRANSPORT_STREAM_MEDIA_INFO,

        UNKNOWN_TO_SDK_VERSION
    }
}
