/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration settings for individual NDI discovery servers. A maximum of 3 servers is allowed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NdiDiscoveryServerConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<NdiDiscoveryServerConfig.Builder, NdiDiscoveryServerConfig> {
    private static final SdkField<String> DISCOVERY_SERVER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryServerAddress").getter(getter(NdiDiscoveryServerConfig::discoveryServerAddress))
            .setter(setter(Builder::discoveryServerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryServerAddress").build())
            .build();

    private static final SdkField<Integer> DISCOVERY_SERVER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DiscoveryServerPort").getter(getter(NdiDiscoveryServerConfig::discoveryServerPort))
            .setter(setter(Builder::discoveryServerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryServerPort").build())
            .build();

    private static final SdkField<String> VPC_INTERFACE_ADAPTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcInterfaceAdapter").getter(getter(NdiDiscoveryServerConfig::vpcInterfaceAdapter))
            .setter(setter(Builder::vpcInterfaceAdapter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceAdapter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DISCOVERY_SERVER_ADDRESS_FIELD, DISCOVERY_SERVER_PORT_FIELD, VPC_INTERFACE_ADAPTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String discoveryServerAddress;

    private final Integer discoveryServerPort;

    private final String vpcInterfaceAdapter;

    private NdiDiscoveryServerConfig(BuilderImpl builder) {
        this.discoveryServerAddress = builder.discoveryServerAddress;
        this.discoveryServerPort = builder.discoveryServerPort;
        this.vpcInterfaceAdapter = builder.vpcInterfaceAdapter;
    }

    /**
     * <p>
     * The unique network address of the NDI discovery server.
     * </p>
     * 
     * @return The unique network address of the NDI discovery server.
     */
    public final String discoveryServerAddress() {
        return discoveryServerAddress;
    }

    /**
     * <p>
     * The port for the NDI discovery server. Defaults to 5959 if a custom port isn't specified.
     * </p>
     * 
     * @return The port for the NDI discovery server. Defaults to 5959 if a custom port isn't specified.
     */
    public final Integer discoveryServerPort() {
        return discoveryServerPort;
    }

    /**
     * <p>
     * The identifier for the Virtual Private Cloud (VPC) network interface used by the flow.
     * </p>
     * 
     * @return The identifier for the Virtual Private Cloud (VPC) network interface used by the flow.
     */
    public final String vpcInterfaceAdapter() {
        return vpcInterfaceAdapter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(discoveryServerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryServerPort());
        hashCode = 31 * hashCode + Objects.hashCode(vpcInterfaceAdapter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NdiDiscoveryServerConfig)) {
            return false;
        }
        NdiDiscoveryServerConfig other = (NdiDiscoveryServerConfig) obj;
        return Objects.equals(discoveryServerAddress(), other.discoveryServerAddress())
                && Objects.equals(discoveryServerPort(), other.discoveryServerPort())
                && Objects.equals(vpcInterfaceAdapter(), other.vpcInterfaceAdapter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NdiDiscoveryServerConfig").add("DiscoveryServerAddress", discoveryServerAddress())
                .add("DiscoveryServerPort", discoveryServerPort()).add("VpcInterfaceAdapter", vpcInterfaceAdapter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscoveryServerAddress":
            return Optional.ofNullable(clazz.cast(discoveryServerAddress()));
        case "DiscoveryServerPort":
            return Optional.ofNullable(clazz.cast(discoveryServerPort()));
        case "VpcInterfaceAdapter":
            return Optional.ofNullable(clazz.cast(vpcInterfaceAdapter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("discoveryServerAddress", DISCOVERY_SERVER_ADDRESS_FIELD);
        map.put("discoveryServerPort", DISCOVERY_SERVER_PORT_FIELD);
        map.put("vpcInterfaceAdapter", VPC_INTERFACE_ADAPTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NdiDiscoveryServerConfig, T> g) {
        return obj -> g.apply((NdiDiscoveryServerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NdiDiscoveryServerConfig> {
        /**
         * <p>
         * The unique network address of the NDI discovery server.
         * </p>
         * 
         * @param discoveryServerAddress
         *        The unique network address of the NDI discovery server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryServerAddress(String discoveryServerAddress);

        /**
         * <p>
         * The port for the NDI discovery server. Defaults to 5959 if a custom port isn't specified.
         * </p>
         * 
         * @param discoveryServerPort
         *        The port for the NDI discovery server. Defaults to 5959 if a custom port isn't specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryServerPort(Integer discoveryServerPort);

        /**
         * <p>
         * The identifier for the Virtual Private Cloud (VPC) network interface used by the flow.
         * </p>
         * 
         * @param vpcInterfaceAdapter
         *        The identifier for the Virtual Private Cloud (VPC) network interface used by the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceAdapter(String vpcInterfaceAdapter);
    }

    static final class BuilderImpl implements Builder {
        private String discoveryServerAddress;

        private Integer discoveryServerPort;

        private String vpcInterfaceAdapter;

        private BuilderImpl() {
        }

        private BuilderImpl(NdiDiscoveryServerConfig model) {
            discoveryServerAddress(model.discoveryServerAddress);
            discoveryServerPort(model.discoveryServerPort);
            vpcInterfaceAdapter(model.vpcInterfaceAdapter);
        }

        public final String getDiscoveryServerAddress() {
            return discoveryServerAddress;
        }

        public final void setDiscoveryServerAddress(String discoveryServerAddress) {
            this.discoveryServerAddress = discoveryServerAddress;
        }

        @Override
        public final Builder discoveryServerAddress(String discoveryServerAddress) {
            this.discoveryServerAddress = discoveryServerAddress;
            return this;
        }

        public final Integer getDiscoveryServerPort() {
            return discoveryServerPort;
        }

        public final void setDiscoveryServerPort(Integer discoveryServerPort) {
            this.discoveryServerPort = discoveryServerPort;
        }

        @Override
        public final Builder discoveryServerPort(Integer discoveryServerPort) {
            this.discoveryServerPort = discoveryServerPort;
            return this;
        }

        public final String getVpcInterfaceAdapter() {
            return vpcInterfaceAdapter;
        }

        public final void setVpcInterfaceAdapter(String vpcInterfaceAdapter) {
            this.vpcInterfaceAdapter = vpcInterfaceAdapter;
        }

        @Override
        public final Builder vpcInterfaceAdapter(String vpcInterfaceAdapter) {
            this.vpcInterfaceAdapter = vpcInterfaceAdapter;
            return this;
        }

        @Override
        public NdiDiscoveryServerConfig build() {
            return new NdiDiscoveryServerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
