/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NdiConfig implements SdkPojo, Serializable, ToCopyableBuilder<NdiConfig.Builder, NdiConfig> {
    private static final SdkField<String> NDI_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NdiState").getter(getter(NdiConfig::ndiStateAsString)).setter(setter(Builder::ndiState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ndiState").build()).build();

    private static final SdkField<String> MACHINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MachineName").getter(getter(NdiConfig::machineName)).setter(setter(Builder::machineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("machineName").build()).build();

    private static final SdkField<List<NdiDiscoveryServerConfig>> NDI_DISCOVERY_SERVERS_FIELD = SdkField
            .<List<NdiDiscoveryServerConfig>> builder(MarshallingType.LIST)
            .memberName("NdiDiscoveryServers")
            .getter(getter(NdiConfig::ndiDiscoveryServers))
            .setter(setter(Builder::ndiDiscoveryServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ndiDiscoveryServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NdiDiscoveryServerConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(NdiDiscoveryServerConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NDI_STATE_FIELD,
            MACHINE_NAME_FIELD, NDI_DISCOVERY_SERVERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ndiState;

    private final String machineName;

    private final List<NdiDiscoveryServerConfig> ndiDiscoveryServers;

    private NdiConfig(BuilderImpl builder) {
        this.ndiState = builder.ndiState;
        this.machineName = builder.machineName;
        this.ndiDiscoveryServers = builder.ndiDiscoveryServers;
    }

    /**
     * <p>
     * A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs. Default
     * is DISABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ndiState} will
     * return {@link NdiState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ndiStateAsString}.
     * </p>
     * 
     * @return A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs.
     *         Default is DISABLED.
     * @see NdiState
     */
    public final NdiState ndiState() {
        return NdiState.fromValue(ndiState);
    }

    /**
     * <p>
     * A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs. Default
     * is DISABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ndiState} will
     * return {@link NdiState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ndiStateAsString}.
     * </p>
     * 
     * @return A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs.
     *         Default is DISABLED.
     * @see NdiState
     */
    public final String ndiStateAsString() {
        return ndiState;
    }

    /**
     * <p>
     * A prefix for the names of the NDI sources that the flow creates. If a custom name isn't specified, MediaConnect
     * generates a unique 12-character ID as the prefix.
     * </p>
     * 
     * @return A prefix for the names of the NDI sources that the flow creates. If a custom name isn't specified,
     *         MediaConnect generates a unique 12-character ID as the prefix.
     */
    public final String machineName() {
        return machineName;
    }

    /**
     * For responses, this returns true if the service returned a value for the NdiDiscoveryServers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNdiDiscoveryServers() {
        return ndiDiscoveryServers != null && !(ndiDiscoveryServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to three NDI discovery server configurations. While not required by the API, this configuration is
     * necessary for NDI functionality to work properly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNdiDiscoveryServers} method.
     * </p>
     * 
     * @return A list of up to three NDI discovery server configurations. While not required by the API, this
     *         configuration is necessary for NDI functionality to work properly.
     */
    public final List<NdiDiscoveryServerConfig> ndiDiscoveryServers() {
        return ndiDiscoveryServers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ndiStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(machineName());
        hashCode = 31 * hashCode + Objects.hashCode(hasNdiDiscoveryServers() ? ndiDiscoveryServers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NdiConfig)) {
            return false;
        }
        NdiConfig other = (NdiConfig) obj;
        return Objects.equals(ndiStateAsString(), other.ndiStateAsString()) && Objects.equals(machineName(), other.machineName())
                && hasNdiDiscoveryServers() == other.hasNdiDiscoveryServers()
                && Objects.equals(ndiDiscoveryServers(), other.ndiDiscoveryServers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NdiConfig").add("NdiState", ndiStateAsString()).add("MachineName", machineName())
                .add("NdiDiscoveryServers", hasNdiDiscoveryServers() ? ndiDiscoveryServers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NdiState":
            return Optional.ofNullable(clazz.cast(ndiStateAsString()));
        case "MachineName":
            return Optional.ofNullable(clazz.cast(machineName()));
        case "NdiDiscoveryServers":
            return Optional.ofNullable(clazz.cast(ndiDiscoveryServers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ndiState", NDI_STATE_FIELD);
        map.put("machineName", MACHINE_NAME_FIELD);
        map.put("ndiDiscoveryServers", NDI_DISCOVERY_SERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NdiConfig, T> g) {
        return obj -> g.apply((NdiConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NdiConfig> {
        /**
         * <p>
         * A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs.
         * Default is DISABLED.
         * </p>
         * 
         * @param ndiState
         *        A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI
         *        outputs. Default is DISABLED.
         * @see NdiState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NdiState
         */
        Builder ndiState(String ndiState);

        /**
         * <p>
         * A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI outputs.
         * Default is DISABLED.
         * </p>
         * 
         * @param ndiState
         *        A setting that controls whether NDI outputs can be used in the flow. Must be ENABLED to add NDI
         *        outputs. Default is DISABLED.
         * @see NdiState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NdiState
         */
        Builder ndiState(NdiState ndiState);

        /**
         * <p>
         * A prefix for the names of the NDI sources that the flow creates. If a custom name isn't specified,
         * MediaConnect generates a unique 12-character ID as the prefix.
         * </p>
         * 
         * @param machineName
         *        A prefix for the names of the NDI sources that the flow creates. If a custom name isn't specified,
         *        MediaConnect generates a unique 12-character ID as the prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder machineName(String machineName);

        /**
         * <p>
         * A list of up to three NDI discovery server configurations. While not required by the API, this configuration
         * is necessary for NDI functionality to work properly.
         * </p>
         * 
         * @param ndiDiscoveryServers
         *        A list of up to three NDI discovery server configurations. While not required by the API, this
         *        configuration is necessary for NDI functionality to work properly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ndiDiscoveryServers(Collection<NdiDiscoveryServerConfig> ndiDiscoveryServers);

        /**
         * <p>
         * A list of up to three NDI discovery server configurations. While not required by the API, this configuration
         * is necessary for NDI functionality to work properly.
         * </p>
         * 
         * @param ndiDiscoveryServers
         *        A list of up to three NDI discovery server configurations. While not required by the API, this
         *        configuration is necessary for NDI functionality to work properly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ndiDiscoveryServers(NdiDiscoveryServerConfig... ndiDiscoveryServers);

        /**
         * <p>
         * A list of up to three NDI discovery server configurations. While not required by the API, this configuration
         * is necessary for NDI functionality to work properly.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.NdiDiscoveryServerConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.NdiDiscoveryServerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.NdiDiscoveryServerConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #ndiDiscoveryServers(List<NdiDiscoveryServerConfig>)}.
         * 
         * @param ndiDiscoveryServers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.NdiDiscoveryServerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ndiDiscoveryServers(java.util.Collection<NdiDiscoveryServerConfig>)
         */
        Builder ndiDiscoveryServers(Consumer<NdiDiscoveryServerConfig.Builder>... ndiDiscoveryServers);
    }

    static final class BuilderImpl implements Builder {
        private String ndiState;

        private String machineName;

        private List<NdiDiscoveryServerConfig> ndiDiscoveryServers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NdiConfig model) {
            ndiState(model.ndiState);
            machineName(model.machineName);
            ndiDiscoveryServers(model.ndiDiscoveryServers);
        }

        public final String getNdiState() {
            return ndiState;
        }

        public final void setNdiState(String ndiState) {
            this.ndiState = ndiState;
        }

        @Override
        public final Builder ndiState(String ndiState) {
            this.ndiState = ndiState;
            return this;
        }

        @Override
        public final Builder ndiState(NdiState ndiState) {
            this.ndiState(ndiState == null ? null : ndiState.toString());
            return this;
        }

        public final String getMachineName() {
            return machineName;
        }

        public final void setMachineName(String machineName) {
            this.machineName = machineName;
        }

        @Override
        public final Builder machineName(String machineName) {
            this.machineName = machineName;
            return this;
        }

        public final List<NdiDiscoveryServerConfig.Builder> getNdiDiscoveryServers() {
            List<NdiDiscoveryServerConfig.Builder> result = ___listOfNdiDiscoveryServerConfigCopier
                    .copyToBuilder(this.ndiDiscoveryServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNdiDiscoveryServers(Collection<NdiDiscoveryServerConfig.BuilderImpl> ndiDiscoveryServers) {
            this.ndiDiscoveryServers = ___listOfNdiDiscoveryServerConfigCopier.copyFromBuilder(ndiDiscoveryServers);
        }

        @Override
        public final Builder ndiDiscoveryServers(Collection<NdiDiscoveryServerConfig> ndiDiscoveryServers) {
            this.ndiDiscoveryServers = ___listOfNdiDiscoveryServerConfigCopier.copy(ndiDiscoveryServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ndiDiscoveryServers(NdiDiscoveryServerConfig... ndiDiscoveryServers) {
            ndiDiscoveryServers(Arrays.asList(ndiDiscoveryServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ndiDiscoveryServers(Consumer<NdiDiscoveryServerConfig.Builder>... ndiDiscoveryServers) {
            ndiDiscoveryServers(Stream.of(ndiDiscoveryServers)
                    .map(c -> NdiDiscoveryServerConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public NdiConfig build() {
            return new NdiConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
