/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for a merge router input that combines two input sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeRouterInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MergeRouterInputConfiguration.Builder, MergeRouterInputConfiguration> {
    private static final SdkField<String> NETWORK_INTERFACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceArn").getter(getter(MergeRouterInputConfiguration::networkInterfaceArn))
            .setter(setter(Builder::networkInterfaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArn").build())
            .build();

    private static final SdkField<List<MergeRouterInputProtocolConfiguration>> PROTOCOL_CONFIGURATIONS_FIELD = SdkField
            .<List<MergeRouterInputProtocolConfiguration>> builder(MarshallingType.LIST)
            .memberName("ProtocolConfigurations")
            .getter(getter(MergeRouterInputConfiguration::protocolConfigurations))
            .setter(setter(Builder::protocolConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MergeRouterInputProtocolConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(MergeRouterInputProtocolConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> MERGE_RECOVERY_WINDOW_MILLISECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MergeRecoveryWindowMilliseconds")
            .getter(getter(MergeRouterInputConfiguration::mergeRecoveryWindowMilliseconds))
            .setter(setter(Builder::mergeRecoveryWindowMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeRecoveryWindowMilliseconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ARN_FIELD,
            PROTOCOL_CONFIGURATIONS_FIELD, MERGE_RECOVERY_WINDOW_MILLISECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String networkInterfaceArn;

    private final List<MergeRouterInputProtocolConfiguration> protocolConfigurations;

    private final Long mergeRecoveryWindowMilliseconds;

    private MergeRouterInputConfiguration(BuilderImpl builder) {
        this.networkInterfaceArn = builder.networkInterfaceArn;
        this.protocolConfigurations = builder.protocolConfigurations;
        this.mergeRecoveryWindowMilliseconds = builder.mergeRecoveryWindowMilliseconds;
    }

    /**
     * <p>
     * The ARN of the network interface to use for this merge router input.
     * </p>
     * 
     * @return The ARN of the network interface to use for this merge router input.
     */
    public final String networkInterfaceArn() {
        return networkInterfaceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtocolConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProtocolConfigurations() {
        return protocolConfigurations != null && !(protocolConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of exactly two protocol configurations for the merge input sources. Both must use the same protocol type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocolConfigurations} method.
     * </p>
     * 
     * @return A list of exactly two protocol configurations for the merge input sources. Both must use the same
     *         protocol type.
     */
    public final List<MergeRouterInputProtocolConfiguration> protocolConfigurations() {
        return protocolConfigurations;
    }

    /**
     * <p>
     * The time window in milliseconds for merging the two input sources.
     * </p>
     * 
     * @return The time window in milliseconds for merging the two input sources.
     */
    public final Long mergeRecoveryWindowMilliseconds() {
        return mergeRecoveryWindowMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocolConfigurations() ? protocolConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mergeRecoveryWindowMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeRouterInputConfiguration)) {
            return false;
        }
        MergeRouterInputConfiguration other = (MergeRouterInputConfiguration) obj;
        return Objects.equals(networkInterfaceArn(), other.networkInterfaceArn())
                && hasProtocolConfigurations() == other.hasProtocolConfigurations()
                && Objects.equals(protocolConfigurations(), other.protocolConfigurations())
                && Objects.equals(mergeRecoveryWindowMilliseconds(), other.mergeRecoveryWindowMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeRouterInputConfiguration").add("NetworkInterfaceArn", networkInterfaceArn())
                .add("ProtocolConfigurations", hasProtocolConfigurations() ? protocolConfigurations() : null)
                .add("MergeRecoveryWindowMilliseconds", mergeRecoveryWindowMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceArn":
            return Optional.ofNullable(clazz.cast(networkInterfaceArn()));
        case "ProtocolConfigurations":
            return Optional.ofNullable(clazz.cast(protocolConfigurations()));
        case "MergeRecoveryWindowMilliseconds":
            return Optional.ofNullable(clazz.cast(mergeRecoveryWindowMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("networkInterfaceArn", NETWORK_INTERFACE_ARN_FIELD);
        map.put("protocolConfigurations", PROTOCOL_CONFIGURATIONS_FIELD);
        map.put("mergeRecoveryWindowMilliseconds", MERGE_RECOVERY_WINDOW_MILLISECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeRouterInputConfiguration, T> g) {
        return obj -> g.apply((MergeRouterInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MergeRouterInputConfiguration> {
        /**
         * <p>
         * The ARN of the network interface to use for this merge router input.
         * </p>
         * 
         * @param networkInterfaceArn
         *        The ARN of the network interface to use for this merge router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceArn(String networkInterfaceArn);

        /**
         * <p>
         * A list of exactly two protocol configurations for the merge input sources. Both must use the same protocol
         * type.
         * </p>
         * 
         * @param protocolConfigurations
         *        A list of exactly two protocol configurations for the merge input sources. Both must use the same
         *        protocol type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolConfigurations(Collection<MergeRouterInputProtocolConfiguration> protocolConfigurations);

        /**
         * <p>
         * A list of exactly two protocol configurations for the merge input sources. Both must use the same protocol
         * type.
         * </p>
         * 
         * @param protocolConfigurations
         *        A list of exactly two protocol configurations for the merge input sources. Both must use the same
         *        protocol type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolConfigurations(MergeRouterInputProtocolConfiguration... protocolConfigurations);

        /**
         * <p>
         * A list of exactly two protocol configurations for the merge input sources. Both must use the same protocol
         * type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.MergeRouterInputProtocolConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.MergeRouterInputProtocolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.MergeRouterInputProtocolConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #protocolConfigurations(List<MergeRouterInputProtocolConfiguration>)}.
         * 
         * @param protocolConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.MergeRouterInputProtocolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocolConfigurations(java.util.Collection<MergeRouterInputProtocolConfiguration>)
         */
        Builder protocolConfigurations(Consumer<MergeRouterInputProtocolConfiguration.Builder>... protocolConfigurations);

        /**
         * <p>
         * The time window in milliseconds for merging the two input sources.
         * </p>
         * 
         * @param mergeRecoveryWindowMilliseconds
         *        The time window in milliseconds for merging the two input sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeRecoveryWindowMilliseconds(Long mergeRecoveryWindowMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfaceArn;

        private List<MergeRouterInputProtocolConfiguration> protocolConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Long mergeRecoveryWindowMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeRouterInputConfiguration model) {
            networkInterfaceArn(model.networkInterfaceArn);
            protocolConfigurations(model.protocolConfigurations);
            mergeRecoveryWindowMilliseconds(model.mergeRecoveryWindowMilliseconds);
        }

        public final String getNetworkInterfaceArn() {
            return networkInterfaceArn;
        }

        public final void setNetworkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
        }

        @Override
        public final Builder networkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
            return this;
        }

        public final List<MergeRouterInputProtocolConfiguration.Builder> getProtocolConfigurations() {
            List<MergeRouterInputProtocolConfiguration.Builder> result = MergeRouterInputProtocolConfigurationListCopier
                    .copyToBuilder(this.protocolConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtocolConfigurations(
                Collection<MergeRouterInputProtocolConfiguration.BuilderImpl> protocolConfigurations) {
            this.protocolConfigurations = MergeRouterInputProtocolConfigurationListCopier.copyFromBuilder(protocolConfigurations);
        }

        @Override
        public final Builder protocolConfigurations(Collection<MergeRouterInputProtocolConfiguration> protocolConfigurations) {
            this.protocolConfigurations = MergeRouterInputProtocolConfigurationListCopier.copy(protocolConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolConfigurations(MergeRouterInputProtocolConfiguration... protocolConfigurations) {
            protocolConfigurations(Arrays.asList(protocolConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolConfigurations(
                Consumer<MergeRouterInputProtocolConfiguration.Builder>... protocolConfigurations) {
            protocolConfigurations(Stream.of(protocolConfigurations)
                    .map(c -> MergeRouterInputProtocolConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getMergeRecoveryWindowMilliseconds() {
            return mergeRecoveryWindowMilliseconds;
        }

        public final void setMergeRecoveryWindowMilliseconds(Long mergeRecoveryWindowMilliseconds) {
            this.mergeRecoveryWindowMilliseconds = mergeRecoveryWindowMilliseconds;
        }

        @Override
        public final Builder mergeRecoveryWindowMilliseconds(Long mergeRecoveryWindowMilliseconds) {
            this.mergeRecoveryWindowMilliseconds = mergeRecoveryWindowMilliseconds;
            return this;
        }

        @Override
        public MergeRouterInputConfiguration build() {
            return new MergeRouterInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
