/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for connecting a router output to a MediaConnect flow source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaConnectFlowRouterOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaConnectFlowRouterOutputConfiguration.Builder, MediaConnectFlowRouterOutputConfiguration> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(MediaConnectFlowRouterOutputConfiguration::flowArn))
            .setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> FLOW_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowSourceArn").getter(getter(MediaConnectFlowRouterOutputConfiguration::flowSourceArn))
            .setter(setter(Builder::flowSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSourceArn").build()).build();

    private static final SdkField<FlowTransitEncryption> DESTINATION_TRANSIT_ENCRYPTION_FIELD = SdkField
            .<FlowTransitEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationTransitEncryption")
            .getter(getter(MediaConnectFlowRouterOutputConfiguration::destinationTransitEncryption))
            .setter(setter(Builder::destinationTransitEncryption))
            .constructor(FlowTransitEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTransitEncryption")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            FLOW_SOURCE_ARN_FIELD, DESTINATION_TRANSIT_ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private final String flowSourceArn;

    private final FlowTransitEncryption destinationTransitEncryption;

    private MediaConnectFlowRouterOutputConfiguration(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.flowSourceArn = builder.flowSourceArn;
        this.destinationTransitEncryption = builder.destinationTransitEncryption;
    }

    /**
     * <p>
     * The ARN of the flow to connect to this router output.
     * </p>
     * 
     * @return The ARN of the flow to connect to this router output.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * <p>
     * The ARN of the flow source to connect to this router output.
     * </p>
     * 
     * @return The ARN of the flow source to connect to this router output.
     */
    public final String flowSourceArn() {
        return flowSourceArn;
    }

    /**
     * <p>
     * The encryption configuration for the flow destination when connected to this router output.
     * </p>
     * 
     * @return The encryption configuration for the flow destination when connected to this router output.
     */
    public final FlowTransitEncryption destinationTransitEncryption() {
        return destinationTransitEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTransitEncryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConnectFlowRouterOutputConfiguration)) {
            return false;
        }
        MediaConnectFlowRouterOutputConfiguration other = (MediaConnectFlowRouterOutputConfiguration) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(flowSourceArn(), other.flowSourceArn())
                && Objects.equals(destinationTransitEncryption(), other.destinationTransitEncryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaConnectFlowRouterOutputConfiguration").add("FlowArn", flowArn())
                .add("FlowSourceArn", flowSourceArn()).add("DestinationTransitEncryption", destinationTransitEncryption())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "FlowSourceArn":
            return Optional.ofNullable(clazz.cast(flowSourceArn()));
        case "DestinationTransitEncryption":
            return Optional.ofNullable(clazz.cast(destinationTransitEncryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("flowSourceArn", FLOW_SOURCE_ARN_FIELD);
        map.put("destinationTransitEncryption", DESTINATION_TRANSIT_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaConnectFlowRouterOutputConfiguration, T> g) {
        return obj -> g.apply((MediaConnectFlowRouterOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaConnectFlowRouterOutputConfiguration> {
        /**
         * <p>
         * The ARN of the flow to connect to this router output.
         * </p>
         * 
         * @param flowArn
         *        The ARN of the flow to connect to this router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * <p>
         * The ARN of the flow source to connect to this router output.
         * </p>
         * 
         * @param flowSourceArn
         *        The ARN of the flow source to connect to this router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowSourceArn(String flowSourceArn);

        /**
         * <p>
         * The encryption configuration for the flow destination when connected to this router output.
         * </p>
         * 
         * @param destinationTransitEncryption
         *        The encryption configuration for the flow destination when connected to this router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTransitEncryption(FlowTransitEncryption destinationTransitEncryption);

        /**
         * <p>
         * The encryption configuration for the flow destination when connected to this router output.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTransitEncryption.Builder} avoiding
         * the need to create one manually via {@link FlowTransitEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTransitEncryption.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationTransitEncryption(FlowTransitEncryption)}.
         * 
         * @param destinationTransitEncryption
         *        a consumer that will call methods on {@link FlowTransitEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationTransitEncryption(FlowTransitEncryption)
         */
        default Builder destinationTransitEncryption(Consumer<FlowTransitEncryption.Builder> destinationTransitEncryption) {
            return destinationTransitEncryption(FlowTransitEncryption.builder().applyMutation(destinationTransitEncryption)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private String flowSourceArn;

        private FlowTransitEncryption destinationTransitEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConnectFlowRouterOutputConfiguration model) {
            flowArn(model.flowArn);
            flowSourceArn(model.flowSourceArn);
            destinationTransitEncryption(model.destinationTransitEncryption);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getFlowSourceArn() {
            return flowSourceArn;
        }

        public final void setFlowSourceArn(String flowSourceArn) {
            this.flowSourceArn = flowSourceArn;
        }

        @Override
        public final Builder flowSourceArn(String flowSourceArn) {
            this.flowSourceArn = flowSourceArn;
            return this;
        }

        public final FlowTransitEncryption.Builder getDestinationTransitEncryption() {
            return destinationTransitEncryption != null ? destinationTransitEncryption.toBuilder() : null;
        }

        public final void setDestinationTransitEncryption(FlowTransitEncryption.BuilderImpl destinationTransitEncryption) {
            this.destinationTransitEncryption = destinationTransitEncryption != null ? destinationTransitEncryption.build()
                    : null;
        }

        @Override
        public final Builder destinationTransitEncryption(FlowTransitEncryption destinationTransitEncryption) {
            this.destinationTransitEncryption = destinationTransitEncryption;
            return this;
        }

        @Override
        public MediaConnectFlowRouterOutputConfiguration build() {
            return new MediaConnectFlowRouterOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
