/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a router input, including its name, type, ARN, ID, state, and other key details. This structure is used
 * in the response of the ListRouterInputs operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedRouterInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ListedRouterInput.Builder, ListedRouterInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListedRouterInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListedRouterInput::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ListedRouterInput::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputType").getter(getter(ListedRouterInput::inputTypeAsString)).setter(setter(Builder::inputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListedRouterInput::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Integer> ROUTED_OUTPUTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RoutedOutputs").getter(getter(ListedRouterInput::routedOutputs)).setter(setter(Builder::routedOutputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedOutputs").build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(ListedRouterInput::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ListedRouterInput::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<Long> MAXIMUM_BITRATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaximumBitrate").getter(getter(ListedRouterInput::maximumBitrate))
            .setter(setter(Builder::maximumBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()).build();

    private static final SdkField<String> ROUTING_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingScope").getter(getter(ListedRouterInput::routingScopeAsString))
            .setter(setter(Builder::routingScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScope").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(ListedRouterInput::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(ListedRouterInput::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MESSAGE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MessageCount").getter(getter(ListedRouterInput::messageCount)).setter(setter(Builder::messageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageCount").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceArn").getter(getter(ListedRouterInput::networkInterfaceArn))
            .setter(setter(Builder::networkInterfaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArn").build())
            .build();

    private static final SdkField<String> MAINTENANCE_SCHEDULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceScheduleType").getter(getter(ListedRouterInput::maintenanceScheduleTypeAsString))
            .setter(setter(Builder::maintenanceScheduleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceScheduleType").build())
            .build();

    private static final SdkField<MaintenanceSchedule> MAINTENANCE_SCHEDULE_FIELD = SdkField
            .<MaintenanceSchedule> builder(MarshallingType.SDK_POJO).memberName("MaintenanceSchedule")
            .getter(getter(ListedRouterInput::maintenanceSchedule)).setter(setter(Builder::maintenanceSchedule))
            .constructor(MaintenanceSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceSchedule").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            ID_FIELD, INPUT_TYPE_FIELD, STATE_FIELD, ROUTED_OUTPUTS_FIELD, REGION_NAME_FIELD, AVAILABILITY_ZONE_FIELD,
            MAXIMUM_BITRATE_FIELD, ROUTING_SCOPE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, MESSAGE_COUNT_FIELD,
            NETWORK_INTERFACE_ARN_FIELD, MAINTENANCE_SCHEDULE_TYPE_FIELD, MAINTENANCE_SCHEDULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String id;

    private final String inputType;

    private final String state;

    private final Integer routedOutputs;

    private final String regionName;

    private final String availabilityZone;

    private final Long maximumBitrate;

    private final String routingScope;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Integer messageCount;

    private final String networkInterfaceArn;

    private final String maintenanceScheduleType;

    private final MaintenanceSchedule maintenanceSchedule;

    private ListedRouterInput(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.inputType = builder.inputType;
        this.state = builder.state;
        this.routedOutputs = builder.routedOutputs;
        this.regionName = builder.regionName;
        this.availabilityZone = builder.availabilityZone;
        this.maximumBitrate = builder.maximumBitrate;
        this.routingScope = builder.routingScope;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.messageCount = builder.messageCount;
        this.networkInterfaceArn = builder.networkInterfaceArn;
        this.maintenanceScheduleType = builder.maintenanceScheduleType;
        this.maintenanceSchedule = builder.maintenanceSchedule;
    }

    /**
     * <p>
     * The name of the router input.
     * </p>
     * 
     * @return The name of the router input.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the router input.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the router input.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the router input.
     * </p>
     * 
     * @return The unique identifier of the router input.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the router input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link RouterInputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return The type of the router input.
     * @see RouterInputType
     */
    public final RouterInputType inputType() {
        return RouterInputType.fromValue(inputType);
    }

    /**
     * <p>
     * The type of the router input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link RouterInputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return The type of the router input.
     * @see RouterInputType
     */
    public final String inputTypeAsString() {
        return inputType;
    }

    /**
     * <p>
     * The overall state of the router input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouterInputState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The overall state of the router input.
     * @see RouterInputState
     */
    public final RouterInputState state() {
        return RouterInputState.fromValue(state);
    }

    /**
     * <p>
     * The overall state of the router input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouterInputState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The overall state of the router input.
     * @see RouterInputState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The number of router outputs that are associated with this router input.
     * </p>
     * 
     * @return The number of router outputs that are associated with this router input.
     */
    public final Integer routedOutputs() {
        return routedOutputs;
    }

    /**
     * <p>
     * The AWS Region where the router input is located.
     * </p>
     * 
     * @return The AWS Region where the router input is located.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The Availability Zone of the router input.
     * </p>
     * 
     * @return The Availability Zone of the router input.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The maximum bitrate of the router input.
     * </p>
     * 
     * @return The maximum bitrate of the router input.
     */
    public final Long maximumBitrate() {
        return maximumBitrate;
    }

    /**
     * <p>
     * Indicates whether the router input is configured for Regional or global routing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingScope} will
     * return {@link RoutingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingScopeAsString}.
     * </p>
     * 
     * @return Indicates whether the router input is configured for Regional or global routing.
     * @see RoutingScope
     */
    public final RoutingScope routingScope() {
        return RoutingScope.fromValue(routingScope);
    }

    /**
     * <p>
     * Indicates whether the router input is configured for Regional or global routing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingScope} will
     * return {@link RoutingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingScopeAsString}.
     * </p>
     * 
     * @return Indicates whether the router input is configured for Regional or global routing.
     * @see RoutingScope
     */
    public final String routingScopeAsString() {
        return routingScope;
    }

    /**
     * <p>
     * The timestamp when the router input was created.
     * </p>
     * 
     * @return The timestamp when the router input was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the router input was last updated.
     * </p>
     * 
     * @return The timestamp when the router input was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The number of messages associated with the router input.
     * </p>
     * 
     * @return The number of messages associated with the router input.
     */
    public final Integer messageCount() {
        return messageCount;
    }

    /**
     * <p>
     * The ARN of the network interface associated with the router input.
     * </p>
     * 
     * @return The ARN of the network interface associated with the router input.
     */
    public final String networkInterfaceArn() {
        return networkInterfaceArn;
    }

    /**
     * <p>
     * The type of maintenance schedule currently associated with the listed router input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maintenanceScheduleType} will return {@link MaintenanceScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maintenanceScheduleTypeAsString}.
     * </p>
     * 
     * @return The type of maintenance schedule currently associated with the listed router input.
     * @see MaintenanceScheduleType
     */
    public final MaintenanceScheduleType maintenanceScheduleType() {
        return MaintenanceScheduleType.fromValue(maintenanceScheduleType);
    }

    /**
     * <p>
     * The type of maintenance schedule currently associated with the listed router input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maintenanceScheduleType} will return {@link MaintenanceScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maintenanceScheduleTypeAsString}.
     * </p>
     * 
     * @return The type of maintenance schedule currently associated with the listed router input.
     * @see MaintenanceScheduleType
     */
    public final String maintenanceScheduleTypeAsString() {
        return maintenanceScheduleType;
    }

    /**
     * <p>
     * The details of the maintenance schedule for the listed router input.
     * </p>
     * 
     * @return The details of the maintenance schedule for the listed router input.
     */
    public final MaintenanceSchedule maintenanceSchedule() {
        return maintenanceSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(inputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routedOutputs());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(routingScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(messageCount());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceScheduleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceSchedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedRouterInput)) {
            return false;
        }
        ListedRouterInput other = (ListedRouterInput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(inputTypeAsString(), other.inputTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(routedOutputs(), other.routedOutputs()) && Objects.equals(regionName(), other.regionName())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(maximumBitrate(), other.maximumBitrate())
                && Objects.equals(routingScopeAsString(), other.routingScopeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(messageCount(), other.messageCount())
                && Objects.equals(networkInterfaceArn(), other.networkInterfaceArn())
                && Objects.equals(maintenanceScheduleTypeAsString(), other.maintenanceScheduleTypeAsString())
                && Objects.equals(maintenanceSchedule(), other.maintenanceSchedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedRouterInput").add("Name", name()).add("Arn", arn()).add("Id", id())
                .add("InputType", inputTypeAsString()).add("State", stateAsString()).add("RoutedOutputs", routedOutputs())
                .add("RegionName", regionName()).add("AvailabilityZone", availabilityZone())
                .add("MaximumBitrate", maximumBitrate()).add("RoutingScope", routingScopeAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("MessageCount", messageCount())
                .add("NetworkInterfaceArn", networkInterfaceArn())
                .add("MaintenanceScheduleType", maintenanceScheduleTypeAsString())
                .add("MaintenanceSchedule", maintenanceSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InputType":
            return Optional.ofNullable(clazz.cast(inputTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "RoutedOutputs":
            return Optional.ofNullable(clazz.cast(routedOutputs()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "MaximumBitrate":
            return Optional.ofNullable(clazz.cast(maximumBitrate()));
        case "RoutingScope":
            return Optional.ofNullable(clazz.cast(routingScopeAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "MessageCount":
            return Optional.ofNullable(clazz.cast(messageCount()));
        case "NetworkInterfaceArn":
            return Optional.ofNullable(clazz.cast(networkInterfaceArn()));
        case "MaintenanceScheduleType":
            return Optional.ofNullable(clazz.cast(maintenanceScheduleTypeAsString()));
        case "MaintenanceSchedule":
            return Optional.ofNullable(clazz.cast(maintenanceSchedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("inputType", INPUT_TYPE_FIELD);
        map.put("state", STATE_FIELD);
        map.put("routedOutputs", ROUTED_OUTPUTS_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("maximumBitrate", MAXIMUM_BITRATE_FIELD);
        map.put("routingScope", ROUTING_SCOPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("messageCount", MESSAGE_COUNT_FIELD);
        map.put("networkInterfaceArn", NETWORK_INTERFACE_ARN_FIELD);
        map.put("maintenanceScheduleType", MAINTENANCE_SCHEDULE_TYPE_FIELD);
        map.put("maintenanceSchedule", MAINTENANCE_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedRouterInput, T> g) {
        return obj -> g.apply((ListedRouterInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedRouterInput> {
        /**
         * <p>
         * The name of the router input.
         * </p>
         * 
         * @param name
         *        The name of the router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the router input.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the router input.
         * </p>
         * 
         * @param id
         *        The unique identifier of the router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the router input.
         * </p>
         * 
         * @param inputType
         *        The type of the router input.
         * @see RouterInputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterInputType
         */
        Builder inputType(String inputType);

        /**
         * <p>
         * The type of the router input.
         * </p>
         * 
         * @param inputType
         *        The type of the router input.
         * @see RouterInputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterInputType
         */
        Builder inputType(RouterInputType inputType);

        /**
         * <p>
         * The overall state of the router input.
         * </p>
         * 
         * @param state
         *        The overall state of the router input.
         * @see RouterInputState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterInputState
         */
        Builder state(String state);

        /**
         * <p>
         * The overall state of the router input.
         * </p>
         * 
         * @param state
         *        The overall state of the router input.
         * @see RouterInputState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterInputState
         */
        Builder state(RouterInputState state);

        /**
         * <p>
         * The number of router outputs that are associated with this router input.
         * </p>
         * 
         * @param routedOutputs
         *        The number of router outputs that are associated with this router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routedOutputs(Integer routedOutputs);

        /**
         * <p>
         * The AWS Region where the router input is located.
         * </p>
         * 
         * @param regionName
         *        The AWS Region where the router input is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The Availability Zone of the router input.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The maximum bitrate of the router input.
         * </p>
         * 
         * @param maximumBitrate
         *        The maximum bitrate of the router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBitrate(Long maximumBitrate);

        /**
         * <p>
         * Indicates whether the router input is configured for Regional or global routing.
         * </p>
         * 
         * @param routingScope
         *        Indicates whether the router input is configured for Regional or global routing.
         * @see RoutingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingScope
         */
        Builder routingScope(String routingScope);

        /**
         * <p>
         * Indicates whether the router input is configured for Regional or global routing.
         * </p>
         * 
         * @param routingScope
         *        Indicates whether the router input is configured for Regional or global routing.
         * @see RoutingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingScope
         */
        Builder routingScope(RoutingScope routingScope);

        /**
         * <p>
         * The timestamp when the router input was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the router input was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the router input was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the router input was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The number of messages associated with the router input.
         * </p>
         * 
         * @param messageCount
         *        The number of messages associated with the router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageCount(Integer messageCount);

        /**
         * <p>
         * The ARN of the network interface associated with the router input.
         * </p>
         * 
         * @param networkInterfaceArn
         *        The ARN of the network interface associated with the router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceArn(String networkInterfaceArn);

        /**
         * <p>
         * The type of maintenance schedule currently associated with the listed router input.
         * </p>
         * 
         * @param maintenanceScheduleType
         *        The type of maintenance schedule currently associated with the listed router input.
         * @see MaintenanceScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceScheduleType
         */
        Builder maintenanceScheduleType(String maintenanceScheduleType);

        /**
         * <p>
         * The type of maintenance schedule currently associated with the listed router input.
         * </p>
         * 
         * @param maintenanceScheduleType
         *        The type of maintenance schedule currently associated with the listed router input.
         * @see MaintenanceScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceScheduleType
         */
        Builder maintenanceScheduleType(MaintenanceScheduleType maintenanceScheduleType);

        /**
         * <p>
         * The details of the maintenance schedule for the listed router input.
         * </p>
         * 
         * @param maintenanceSchedule
         *        The details of the maintenance schedule for the listed router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceSchedule(MaintenanceSchedule maintenanceSchedule);

        /**
         * <p>
         * The details of the maintenance schedule for the listed router input.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceSchedule.Builder} avoiding the
         * need to create one manually via {@link MaintenanceSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceSchedule.Builder#build()} is called immediately and
         * its result is passed to {@link #maintenanceSchedule(MaintenanceSchedule)}.
         * 
         * @param maintenanceSchedule
         *        a consumer that will call methods on {@link MaintenanceSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceSchedule(MaintenanceSchedule)
         */
        default Builder maintenanceSchedule(Consumer<MaintenanceSchedule.Builder> maintenanceSchedule) {
            return maintenanceSchedule(MaintenanceSchedule.builder().applyMutation(maintenanceSchedule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String id;

        private String inputType;

        private String state;

        private Integer routedOutputs;

        private String regionName;

        private String availabilityZone;

        private Long maximumBitrate;

        private String routingScope;

        private Instant createdAt;

        private Instant updatedAt;

        private Integer messageCount;

        private String networkInterfaceArn;

        private String maintenanceScheduleType;

        private MaintenanceSchedule maintenanceSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedRouterInput model) {
            name(model.name);
            arn(model.arn);
            id(model.id);
            inputType(model.inputType);
            state(model.state);
            routedOutputs(model.routedOutputs);
            regionName(model.regionName);
            availabilityZone(model.availabilityZone);
            maximumBitrate(model.maximumBitrate);
            routingScope(model.routingScope);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            messageCount(model.messageCount);
            networkInterfaceArn(model.networkInterfaceArn);
            maintenanceScheduleType(model.maintenanceScheduleType);
            maintenanceSchedule(model.maintenanceSchedule);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInputType() {
            return inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(RouterInputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouterInputState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getRoutedOutputs() {
            return routedOutputs;
        }

        public final void setRoutedOutputs(Integer routedOutputs) {
            this.routedOutputs = routedOutputs;
        }

        @Override
        public final Builder routedOutputs(Integer routedOutputs) {
            this.routedOutputs = routedOutputs;
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getMaximumBitrate() {
            return maximumBitrate;
        }

        public final void setMaximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final String getRoutingScope() {
            return routingScope;
        }

        public final void setRoutingScope(String routingScope) {
            this.routingScope = routingScope;
        }

        @Override
        public final Builder routingScope(String routingScope) {
            this.routingScope = routingScope;
            return this;
        }

        @Override
        public final Builder routingScope(RoutingScope routingScope) {
            this.routingScope(routingScope == null ? null : routingScope.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Integer getMessageCount() {
            return messageCount;
        }

        public final void setMessageCount(Integer messageCount) {
            this.messageCount = messageCount;
        }

        @Override
        public final Builder messageCount(Integer messageCount) {
            this.messageCount = messageCount;
            return this;
        }

        public final String getNetworkInterfaceArn() {
            return networkInterfaceArn;
        }

        public final void setNetworkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
        }

        @Override
        public final Builder networkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
            return this;
        }

        public final String getMaintenanceScheduleType() {
            return maintenanceScheduleType;
        }

        public final void setMaintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
        }

        @Override
        public final Builder maintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
            return this;
        }

        @Override
        public final Builder maintenanceScheduleType(MaintenanceScheduleType maintenanceScheduleType) {
            this.maintenanceScheduleType(maintenanceScheduleType == null ? null : maintenanceScheduleType.toString());
            return this;
        }

        public final MaintenanceSchedule.Builder getMaintenanceSchedule() {
            return maintenanceSchedule != null ? maintenanceSchedule.toBuilder() : null;
        }

        public final void setMaintenanceSchedule(MaintenanceSchedule.BuilderImpl maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule != null ? maintenanceSchedule.build() : null;
        }

        @Override
        public final Builder maintenanceSchedule(MaintenanceSchedule maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule;
            return this;
        }

        @Override
        public ListedRouterInput build() {
            return new ListedRouterInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
