/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedGatewayInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<ListedGatewayInstance.Builder, ListedGatewayInstance> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayArn").getter(getter(ListedGatewayInstance::gatewayArn)).setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()).build();

    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayInstanceArn").getter(getter(ListedGatewayInstance::gatewayInstanceArn))
            .setter(setter(Builder::gatewayInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayInstanceArn").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ListedGatewayInstance::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceState").getter(getter(ListedGatewayInstance::instanceStateAsString))
            .setter(setter(Builder::instanceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            GATEWAY_INSTANCE_ARN_FIELD, INSTANCE_ID_FIELD, INSTANCE_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String gatewayArn;

    private final String gatewayInstanceArn;

    private final String instanceId;

    private final String instanceState;

    private ListedGatewayInstance(BuilderImpl builder) {
        this.gatewayArn = builder.gatewayArn;
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
        this.instanceId = builder.instanceId;
        this.instanceState = builder.instanceState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instance.
     */
    public final String gatewayInstanceArn() {
        return gatewayInstanceArn;
    }

    /**
     * <p>
     * The managed instance ID generated by the SSM install. This will begin with "mi-".
     * </p>
     * 
     * @return The managed instance ID generated by the SSM install. This will begin with "mi-".
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The status of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceState}
     * will return {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceStateAsString}.
     * </p>
     * 
     * @return The status of the instance.
     * @see InstanceState
     */
    public final InstanceState instanceState() {
        return InstanceState.fromValue(instanceState);
    }

    /**
     * <p>
     * The status of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceState}
     * will return {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceStateAsString}.
     * </p>
     * 
     * @return The status of the instance.
     * @see InstanceState
     */
    public final String instanceStateAsString() {
        return instanceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedGatewayInstance)) {
            return false;
        }
        ListedGatewayInstance other = (ListedGatewayInstance) obj;
        return Objects.equals(gatewayArn(), other.gatewayArn())
                && Objects.equals(gatewayInstanceArn(), other.gatewayInstanceArn())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceStateAsString(), other.instanceStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedGatewayInstance").add("GatewayArn", gatewayArn())
                .add("GatewayInstanceArn", gatewayInstanceArn()).add("InstanceId", instanceId())
                .add("InstanceState", instanceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "GatewayInstanceArn":
            return Optional.ofNullable(clazz.cast(gatewayInstanceArn()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceState":
            return Optional.ofNullable(clazz.cast(instanceStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("gatewayInstanceArn", GATEWAY_INSTANCE_ARN_FIELD);
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("instanceState", INSTANCE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedGatewayInstance, T> g) {
        return obj -> g.apply((ListedGatewayInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedGatewayInstance> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway.
         * </p>
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param gatewayInstanceArn
         *        The Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayInstanceArn(String gatewayInstanceArn);

        /**
         * <p>
         * The managed instance ID generated by the SSM install. This will begin with "mi-".
         * </p>
         * 
         * @param instanceId
         *        The managed instance ID generated by the SSM install. This will begin with "mi-".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * 
         * @param instanceState
         *        The status of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder instanceState(String instanceState);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * 
         * @param instanceState
         *        The status of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder instanceState(InstanceState instanceState);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayArn;

        private String gatewayInstanceArn;

        private String instanceId;

        private String instanceState;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedGatewayInstance model) {
            gatewayArn(model.gatewayArn);
            gatewayInstanceArn(model.gatewayInstanceArn);
            instanceId(model.instanceId);
            instanceState(model.instanceState);
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getGatewayInstanceArn() {
            return gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceState() {
            return instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState(instanceState == null ? null : instanceState.toString());
            return this;
        }

        @Override
        public ListedGatewayInstance build() {
            return new ListedGatewayInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
