/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGatewayInstancesRequest extends MediaConnectRequest implements
        ToCopyableBuilder<ListGatewayInstancesRequest.Builder, ListGatewayInstancesRequest> {
    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterArn").getter(getter(ListGatewayInstancesRequest::filterArn)).setter(setter(Builder::filterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filterArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListGatewayInstancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGatewayInstancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ARN_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String filterArn;

    private final Integer maxResults;

    private final String nextToken;

    private ListGatewayInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.filterArn = builder.filterArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Filter the list results to display only the instances associated with the selected Gateway ARN.
     * </p>
     * 
     * @return Filter the list results to display only the instances associated with the selected Gateway ARN.
     */
    public final String filterArn() {
        return filterArn;
    }

    /**
     * <p>
     * The maximum number of results to return per API request.
     * </p>
     * <p>
     * For example, you submit a ListInstances request with <code>MaxResults</code> set at 5. Although 20 items match
     * your request, the service returns no more than the first 5 items. (The service also returns a
     * <code>NextToken</code> value that you can use to fetch the next batch of results.)
     * </p>
     * <p>
     * The service might return fewer results than the <code>MaxResults</code> value. If <code>MaxResults</code> is not
     * included in the request, the service defaults to pagination with a maximum of 10 results per page.
     * </p>
     * 
     * @return The maximum number of results to return per API request. </p>
     *         <p>
     *         For example, you submit a ListInstances request with <code>MaxResults</code> set at 5. Although 20 items
     *         match your request, the service returns no more than the first 5 items. (The service also returns a
     *         <code>NextToken</code> value that you can use to fetch the next batch of results.)
     *         </p>
     *         <p>
     *         The service might return fewer results than the <code>MaxResults</code> value. If <code>MaxResults</code>
     *         is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token that identifies the batch of results that you want to see.
     * </p>
     * <p>
     * For example, you submit a <code>ListInstances</code> request with <code>MaxResults</code> set at 5. The service
     * returns the first batch of results (up to 5) and a <code>NextToken</code> value. To see the next batch of
     * results, you can submit the <code>ListInstances</code> request a second time and specify the
     * <code>NextToken</code> value.
     * </p>
     * 
     * @return The token that identifies the batch of results that you want to see. </p>
     *         <p>
     *         For example, you submit a <code>ListInstances</code> request with <code>MaxResults</code> set at 5. The
     *         service returns the first batch of results (up to 5) and a <code>NextToken</code> value. To see the next
     *         batch of results, you can submit the <code>ListInstances</code> request a second time and specify the
     *         <code>NextToken</code> value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewayInstancesRequest)) {
            return false;
        }
        ListGatewayInstancesRequest other = (ListGatewayInstancesRequest) obj;
        return Objects.equals(filterArn(), other.filterArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGatewayInstancesRequest").add("FilterArn", filterArn()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterArn":
            return Optional.ofNullable(clazz.cast(filterArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterArn", FILTER_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGatewayInstancesRequest, T> g) {
        return obj -> g.apply((ListGatewayInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListGatewayInstancesRequest> {
        /**
         * <p>
         * Filter the list results to display only the instances associated with the selected Gateway ARN.
         * </p>
         * 
         * @param filterArn
         *        Filter the list results to display only the instances associated with the selected Gateway ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterArn(String filterArn);

        /**
         * <p>
         * The maximum number of results to return per API request.
         * </p>
         * <p>
         * For example, you submit a ListInstances request with <code>MaxResults</code> set at 5. Although 20 items
         * match your request, the service returns no more than the first 5 items. (The service also returns a
         * <code>NextToken</code> value that you can use to fetch the next batch of results.)
         * </p>
         * <p>
         * The service might return fewer results than the <code>MaxResults</code> value. If <code>MaxResults</code> is
         * not included in the request, the service defaults to pagination with a maximum of 10 results per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per API request. </p>
         *        <p>
         *        For example, you submit a ListInstances request with <code>MaxResults</code> set at 5. Although 20
         *        items match your request, the service returns no more than the first 5 items. (The service also
         *        returns a <code>NextToken</code> value that you can use to fetch the next batch of results.)
         *        </p>
         *        <p>
         *        The service might return fewer results than the <code>MaxResults</code> value. If
         *        <code>MaxResults</code> is not included in the request, the service defaults to pagination with a
         *        maximum of 10 results per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token that identifies the batch of results that you want to see.
         * </p>
         * <p>
         * For example, you submit a <code>ListInstances</code> request with <code>MaxResults</code> set at 5. The
         * service returns the first batch of results (up to 5) and a <code>NextToken</code> value. To see the next
         * batch of results, you can submit the <code>ListInstances</code> request a second time and specify the
         * <code>NextToken</code> value.
         * </p>
         * 
         * @param nextToken
         *        The token that identifies the batch of results that you want to see. </p>
         *        <p>
         *        For example, you submit a <code>ListInstances</code> request with <code>MaxResults</code> set at 5.
         *        The service returns the first batch of results (up to 5) and a <code>NextToken</code> value. To see
         *        the next batch of results, you can submit the <code>ListInstances</code> request a second time and
         *        specify the <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String filterArn;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewayInstancesRequest model) {
            super(model);
            filterArn(model.filterArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getFilterArn() {
            return filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGatewayInstancesRequest build() {
            return new ListGatewayInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
