/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Create a bridge with the ingress bridge type. An ingress bridge is a ground-to-cloud bridge. The content originates
 * at your premises and is delivered to the cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressGatewayBridge implements SdkPojo, Serializable,
        ToCopyableBuilder<IngressGatewayBridge.Builder, IngressGatewayBridge> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(IngressGatewayBridge::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(IngressGatewayBridge::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MAX_OUTPUTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxOutputs").getter(getter(IngressGatewayBridge::maxOutputs)).setter(setter(Builder::maxOutputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxOutputs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            MAX_BITRATE_FIELD, MAX_OUTPUTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final Integer maxBitrate;

    private final Integer maxOutputs;

    private IngressGatewayBridge(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.maxBitrate = builder.maxBitrate;
        this.maxOutputs = builder.maxOutputs;
    }

    /**
     * <p>
     * The ID of the instance running this bridge.
     * </p>
     * 
     * @return The ID of the instance running this bridge.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The maximum expected bitrate (in bps) of the ingress bridge.
     * </p>
     * 
     * @return The maximum expected bitrate (in bps) of the ingress bridge.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * <p>
     * The maximum number of outputs on the ingress bridge.
     * </p>
     * 
     * @return The maximum number of outputs on the ingress bridge.
     */
    public final Integer maxOutputs() {
        return maxOutputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(maxOutputs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressGatewayBridge)) {
            return false;
        }
        IngressGatewayBridge other = (IngressGatewayBridge) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(maxBitrate(), other.maxBitrate())
                && Objects.equals(maxOutputs(), other.maxOutputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressGatewayBridge").add("InstanceId", instanceId()).add("MaxBitrate", maxBitrate())
                .add("MaxOutputs", maxOutputs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MaxOutputs":
            return Optional.ofNullable(clazz.cast(maxOutputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("maxBitrate", MAX_BITRATE_FIELD);
        map.put("maxOutputs", MAX_OUTPUTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressGatewayBridge, T> g) {
        return obj -> g.apply((IngressGatewayBridge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressGatewayBridge> {
        /**
         * <p>
         * The ID of the instance running this bridge.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance running this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The maximum expected bitrate (in bps) of the ingress bridge.
         * </p>
         * 
         * @param maxBitrate
         *        The maximum expected bitrate (in bps) of the ingress bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * <p>
         * The maximum number of outputs on the ingress bridge.
         * </p>
         * 
         * @param maxOutputs
         *        The maximum number of outputs on the ingress bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxOutputs(Integer maxOutputs);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private Integer maxBitrate;

        private Integer maxOutputs;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressGatewayBridge model) {
            instanceId(model.instanceId);
            maxBitrate(model.maxBitrate);
            maxOutputs(model.maxOutputs);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMaxOutputs() {
            return maxOutputs;
        }

        public final void setMaxOutputs(Integer maxOutputs) {
            this.maxOutputs = maxOutputs;
        }

        @Override
        public final Builder maxOutputs(Integer maxOutputs) {
            this.maxOutputs = maxOutputs;
            return this;
        }

        @Override
        public IngressGatewayBridge build() {
            return new IngressGatewayBridge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
