/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The frame resolution used by the video stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameResolution implements SdkPojo, Serializable, ToCopyableBuilder<FrameResolution.Builder, FrameResolution> {
    private static final SdkField<Integer> FRAME_HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FrameHeight").getter(getter(FrameResolution::frameHeight)).setter(setter(Builder::frameHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameHeight").build()).build();

    private static final SdkField<Integer> FRAME_WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FrameWidth").getter(getter(FrameResolution::frameWidth)).setter(setter(Builder::frameWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameWidth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_HEIGHT_FIELD,
            FRAME_WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer frameHeight;

    private final Integer frameWidth;

    private FrameResolution(BuilderImpl builder) {
        this.frameHeight = builder.frameHeight;
        this.frameWidth = builder.frameWidth;
    }

    /**
     * <p>
     * The number of pixels in the height of the video frame.
     * </p>
     * 
     * @return The number of pixels in the height of the video frame.
     */
    public final Integer frameHeight() {
        return frameHeight;
    }

    /**
     * <p>
     * The number of pixels in the width of the video frame.
     * </p>
     * 
     * @return The number of pixels in the width of the video frame.
     */
    public final Integer frameWidth() {
        return frameWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frameHeight());
        hashCode = 31 * hashCode + Objects.hashCode(frameWidth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameResolution)) {
            return false;
        }
        FrameResolution other = (FrameResolution) obj;
        return Objects.equals(frameHeight(), other.frameHeight()) && Objects.equals(frameWidth(), other.frameWidth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrameResolution").add("FrameHeight", frameHeight()).add("FrameWidth", frameWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FrameHeight":
            return Optional.ofNullable(clazz.cast(frameHeight()));
        case "FrameWidth":
            return Optional.ofNullable(clazz.cast(frameWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("frameHeight", FRAME_HEIGHT_FIELD);
        map.put("frameWidth", FRAME_WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FrameResolution, T> g) {
        return obj -> g.apply((FrameResolution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameResolution> {
        /**
         * <p>
         * The number of pixels in the height of the video frame.
         * </p>
         * 
         * @param frameHeight
         *        The number of pixels in the height of the video frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameHeight(Integer frameHeight);

        /**
         * <p>
         * The number of pixels in the width of the video frame.
         * </p>
         * 
         * @param frameWidth
         *        The number of pixels in the width of the video frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameWidth(Integer frameWidth);
    }

    static final class BuilderImpl implements Builder {
        private Integer frameHeight;

        private Integer frameWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameResolution model) {
            frameHeight(model.frameHeight);
            frameWidth(model.frameWidth);
        }

        public final Integer getFrameHeight() {
            return frameHeight;
        }

        public final void setFrameHeight(Integer frameHeight) {
            this.frameHeight = frameHeight;
        }

        @Override
        public final Builder frameHeight(Integer frameHeight) {
            this.frameHeight = frameHeight;
            return this;
        }

        public final Integer getFrameWidth() {
            return frameWidth;
        }

        public final void setFrameWidth(Integer frameWidth) {
            this.frameWidth = frameWidth;
        }

        @Override
        public final Builder frameWidth(Integer frameWidth) {
            this.frameWidth = frameWidth;
            return this;
        }

        @Override
        public FrameResolution build() {
            return new FrameResolution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
