/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGatewayResponse extends MediaConnectResponse implements
        ToCopyableBuilder<CreateGatewayResponse.Builder, CreateGatewayResponse> {
    private static final SdkField<Gateway> GATEWAY_FIELD = SdkField.<Gateway> builder(MarshallingType.SDK_POJO)
            .memberName("Gateway").getter(getter(CreateGatewayResponse::gateway)).setter(setter(Builder::gateway))
            .constructor(Gateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Gateway gateway;

    private CreateGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.gateway = builder.gateway;
    }

    /**
     * <p>
     * The gateway that you created.
     * </p>
     * 
     * @return The gateway that you created.
     */
    public final Gateway gateway() {
        return gateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayResponse)) {
            return false;
        }
        CreateGatewayResponse other = (CreateGatewayResponse) obj;
        return Objects.equals(gateway(), other.gateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGatewayResponse").add("Gateway", gateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gateway":
            return Optional.ofNullable(clazz.cast(gateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gateway", GATEWAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayResponse, T> g) {
        return obj -> g.apply((CreateGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGatewayResponse> {
        /**
         * <p>
         * The gateway that you created.
         * </p>
         * 
         * @param gateway
         *        The gateway that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gateway(Gateway gateway);

        /**
         * <p>
         * The gateway that you created.
         * </p>
         * This is a convenience method that creates an instance of the {@link Gateway.Builder} avoiding the need to
         * create one manually via {@link Gateway#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Gateway.Builder#build()} is called immediately and its result is
         * passed to {@link #gateway(Gateway)}.
         * 
         * @param gateway
         *        a consumer that will call methods on {@link Gateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gateway(Gateway)
         */
        default Builder gateway(Consumer<Gateway.Builder> gateway) {
            return gateway(Gateway.builder().applyMutation(gateway).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private Gateway gateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayResponse model) {
            super(model);
            gateway(model.gateway);
        }

        public final Gateway.Builder getGateway() {
            return gateway != null ? gateway.toBuilder() : null;
        }

        public final void setGateway(Gateway.BuilderImpl gateway) {
            this.gateway = gateway != null ? gateway.build() : null;
        }

        @Override
        public final Builder gateway(Gateway gateway) {
            this.gateway = gateway;
            return this;
        }

        @Override
        public CreateGatewayResponse build() {
            return new CreateGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
