/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Bridge is the connection between your data center's Instances and the Amazon Web Services cloud. A bridge can be
 * used to send video from the Amazon Web Services cloud to your data center or from your data center to the Amazon Web
 * Services cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Bridge implements SdkPojo, Serializable, ToCopyableBuilder<Bridge.Builder, Bridge> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeArn").getter(getter(Bridge::bridgeArn)).setter(setter(Builder::bridgeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()).build();

    private static final SdkField<List<MessageDetail>> BRIDGE_MESSAGES_FIELD = SdkField
            .<List<MessageDetail>> builder(MarshallingType.LIST)
            .memberName("BridgeMessages")
            .getter(getter(Bridge::bridgeMessages))
            .setter(setter(Builder::bridgeMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BRIDGE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeState").getter(getter(Bridge::bridgeStateAsString)).setter(setter(Builder::bridgeState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeState").build()).build();

    private static final SdkField<EgressGatewayBridge> EGRESS_GATEWAY_BRIDGE_FIELD = SdkField
            .<EgressGatewayBridge> builder(MarshallingType.SDK_POJO).memberName("EgressGatewayBridge")
            .getter(getter(Bridge::egressGatewayBridge)).setter(setter(Builder::egressGatewayBridge))
            .constructor(EgressGatewayBridge::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressGatewayBridge").build())
            .build();

    private static final SdkField<IngressGatewayBridge> INGRESS_GATEWAY_BRIDGE_FIELD = SdkField
            .<IngressGatewayBridge> builder(MarshallingType.SDK_POJO).memberName("IngressGatewayBridge")
            .getter(getter(Bridge::ingressGatewayBridge)).setter(setter(Builder::ingressGatewayBridge))
            .constructor(IngressGatewayBridge::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressGatewayBridge").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Bridge::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<BridgeOutput>> OUTPUTS_FIELD = SdkField
            .<List<BridgeOutput>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(Bridge::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BridgeOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(BridgeOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLACEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementArn").getter(getter(Bridge::placementArn)).setter(setter(Builder::placementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementArn").build()).build();

    private static final SdkField<FailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField
            .<FailoverConfig> builder(MarshallingType.SDK_POJO).memberName("SourceFailoverConfig")
            .getter(getter(Bridge::sourceFailoverConfig)).setter(setter(Builder::sourceFailoverConfig))
            .constructor(FailoverConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build())
            .build();

    private static final SdkField<List<BridgeSource>> SOURCES_FIELD = SdkField
            .<List<BridgeSource>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(Bridge::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BridgeSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(BridgeSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD,
            BRIDGE_MESSAGES_FIELD, BRIDGE_STATE_FIELD, EGRESS_GATEWAY_BRIDGE_FIELD, INGRESS_GATEWAY_BRIDGE_FIELD, NAME_FIELD,
            OUTPUTS_FIELD, PLACEMENT_ARN_FIELD, SOURCE_FAILOVER_CONFIG_FIELD, SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bridgeArn;

    private final List<MessageDetail> bridgeMessages;

    private final String bridgeState;

    private final EgressGatewayBridge egressGatewayBridge;

    private final IngressGatewayBridge ingressGatewayBridge;

    private final String name;

    private final List<BridgeOutput> outputs;

    private final String placementArn;

    private final FailoverConfig sourceFailoverConfig;

    private final List<BridgeSource> sources;

    private Bridge(BuilderImpl builder) {
        this.bridgeArn = builder.bridgeArn;
        this.bridgeMessages = builder.bridgeMessages;
        this.bridgeState = builder.bridgeState;
        this.egressGatewayBridge = builder.egressGatewayBridge;
        this.ingressGatewayBridge = builder.ingressGatewayBridge;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.placementArn = builder.placementArn;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the bridge.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the bridge.
     */
    public final String bridgeArn() {
        return bridgeArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the BridgeMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBridgeMessages() {
        return bridgeMessages != null && !(bridgeMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Messages with details about the bridge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBridgeMessages} method.
     * </p>
     * 
     * @return Messages with details about the bridge.
     */
    public final List<MessageDetail> bridgeMessages() {
        return bridgeMessages;
    }

    /**
     * <p>
     * The state of the bridge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bridgeState} will
     * return {@link BridgeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bridgeStateAsString}.
     * </p>
     * 
     * @return The state of the bridge.
     * @see BridgeState
     */
    public final BridgeState bridgeState() {
        return BridgeState.fromValue(bridgeState);
    }

    /**
     * <p>
     * The state of the bridge.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bridgeState} will
     * return {@link BridgeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bridgeStateAsString}.
     * </p>
     * 
     * @return The state of the bridge.
     * @see BridgeState
     */
    public final String bridgeStateAsString() {
        return bridgeState;
    }

    /**
     * <p>
     * An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is
     * delivered to your premises.
     * </p>
     * 
     * @return An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is
     *         delivered to your premises.
     */
    public final EgressGatewayBridge egressGatewayBridge() {
        return egressGatewayBridge;
    }

    /**
     * <p>
     * An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the
     * cloud.
     * </p>
     * 
     * @return An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered
     *         to the cloud.
     */
    public final IngressGatewayBridge ingressGatewayBridge() {
        return ingressGatewayBridge;
    }

    /**
     * <p>
     * The name of the bridge.
     * </p>
     * 
     * @return The name of the bridge.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outputs on this bridge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The outputs on this bridge.
     */
    public final List<BridgeOutput> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The placement Amazon Resource Number (ARN) of the bridge.
     * </p>
     * 
     * @return The placement Amazon Resource Number (ARN) of the bridge.
     */
    public final String placementArn() {
        return placementArn;
    }

    /**
     * <p>
     * The settings for source failover.
     * </p>
     * 
     * @return The settings for source failover.
     */
    public final FailoverConfig sourceFailoverConfig() {
        return sourceFailoverConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources on this bridge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The sources on this bridge.
     */
    public final List<BridgeSource> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasBridgeMessages() ? bridgeMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(bridgeStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(egressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(ingressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(placementArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bridge)) {
            return false;
        }
        Bridge other = (Bridge) obj;
        return Objects.equals(bridgeArn(), other.bridgeArn()) && hasBridgeMessages() == other.hasBridgeMessages()
                && Objects.equals(bridgeMessages(), other.bridgeMessages())
                && Objects.equals(bridgeStateAsString(), other.bridgeStateAsString())
                && Objects.equals(egressGatewayBridge(), other.egressGatewayBridge())
                && Objects.equals(ingressGatewayBridge(), other.ingressGatewayBridge()) && Objects.equals(name(), other.name())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(placementArn(), other.placementArn())
                && Objects.equals(sourceFailoverConfig(), other.sourceFailoverConfig()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Bridge").add("BridgeArn", bridgeArn())
                .add("BridgeMessages", hasBridgeMessages() ? bridgeMessages() : null).add("BridgeState", bridgeStateAsString())
                .add("EgressGatewayBridge", egressGatewayBridge()).add("IngressGatewayBridge", ingressGatewayBridge())
                .add("Name", name()).add("Outputs", hasOutputs() ? outputs() : null).add("PlacementArn", placementArn())
                .add("SourceFailoverConfig", sourceFailoverConfig()).add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgeArn":
            return Optional.ofNullable(clazz.cast(bridgeArn()));
        case "BridgeMessages":
            return Optional.ofNullable(clazz.cast(bridgeMessages()));
        case "BridgeState":
            return Optional.ofNullable(clazz.cast(bridgeStateAsString()));
        case "EgressGatewayBridge":
            return Optional.ofNullable(clazz.cast(egressGatewayBridge()));
        case "IngressGatewayBridge":
            return Optional.ofNullable(clazz.cast(ingressGatewayBridge()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "PlacementArn":
            return Optional.ofNullable(clazz.cast(placementArn()));
        case "SourceFailoverConfig":
            return Optional.ofNullable(clazz.cast(sourceFailoverConfig()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("bridgeMessages", BRIDGE_MESSAGES_FIELD);
        map.put("bridgeState", BRIDGE_STATE_FIELD);
        map.put("egressGatewayBridge", EGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("ingressGatewayBridge", INGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("placementArn", PLACEMENT_ARN_FIELD);
        map.put("sourceFailoverConfig", SOURCE_FAILOVER_CONFIG_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Bridge, T> g) {
        return obj -> g.apply((Bridge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Bridge> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the bridge.
         * </p>
         * 
         * @param bridgeArn
         *        The Amazon Resource Number (ARN) of the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeArn(String bridgeArn);

        /**
         * <p>
         * Messages with details about the bridge.
         * </p>
         * 
         * @param bridgeMessages
         *        Messages with details about the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeMessages(Collection<MessageDetail> bridgeMessages);

        /**
         * <p>
         * Messages with details about the bridge.
         * </p>
         * 
         * @param bridgeMessages
         *        Messages with details about the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeMessages(MessageDetail... bridgeMessages);

        /**
         * <p>
         * Messages with details about the bridge.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #bridgeMessages(List<MessageDetail>)}.
         * 
         * @param bridgeMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bridgeMessages(java.util.Collection<MessageDetail>)
         */
        Builder bridgeMessages(Consumer<MessageDetail.Builder>... bridgeMessages);

        /**
         * <p>
         * The state of the bridge.
         * </p>
         * 
         * @param bridgeState
         *        The state of the bridge.
         * @see BridgeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BridgeState
         */
        Builder bridgeState(String bridgeState);

        /**
         * <p>
         * The state of the bridge.
         * </p>
         * 
         * @param bridgeState
         *        The state of the bridge.
         * @see BridgeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BridgeState
         */
        Builder bridgeState(BridgeState bridgeState);

        /**
         * <p>
         * An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is
         * delivered to your premises.
         * </p>
         * 
         * @param egressGatewayBridge
         *        An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and
         *        is delivered to your premises.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressGatewayBridge(EgressGatewayBridge egressGatewayBridge);

        /**
         * <p>
         * An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is
         * delivered to your premises.
         * </p>
         * This is a convenience method that creates an instance of the {@link EgressGatewayBridge.Builder} avoiding the
         * need to create one manually via {@link EgressGatewayBridge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EgressGatewayBridge.Builder#build()} is called immediately and
         * its result is passed to {@link #egressGatewayBridge(EgressGatewayBridge)}.
         * 
         * @param egressGatewayBridge
         *        a consumer that will call methods on {@link EgressGatewayBridge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressGatewayBridge(EgressGatewayBridge)
         */
        default Builder egressGatewayBridge(Consumer<EgressGatewayBridge.Builder> egressGatewayBridge) {
            return egressGatewayBridge(EgressGatewayBridge.builder().applyMutation(egressGatewayBridge).build());
        }

        /**
         * <p>
         * An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to
         * the cloud.
         * </p>
         * 
         * @param ingressGatewayBridge
         *        An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is
         *        delivered to the cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressGatewayBridge(IngressGatewayBridge ingressGatewayBridge);

        /**
         * <p>
         * An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to
         * the cloud.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressGatewayBridge.Builder} avoiding
         * the need to create one manually via {@link IngressGatewayBridge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressGatewayBridge.Builder#build()} is called immediately and
         * its result is passed to {@link #ingressGatewayBridge(IngressGatewayBridge)}.
         * 
         * @param ingressGatewayBridge
         *        a consumer that will call methods on {@link IngressGatewayBridge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressGatewayBridge(IngressGatewayBridge)
         */
        default Builder ingressGatewayBridge(Consumer<IngressGatewayBridge.Builder> ingressGatewayBridge) {
            return ingressGatewayBridge(IngressGatewayBridge.builder().applyMutation(ingressGatewayBridge).build());
        }

        /**
         * <p>
         * The name of the bridge.
         * </p>
         * 
         * @param name
         *        The name of the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The outputs on this bridge.
         * </p>
         * 
         * @param outputs
         *        The outputs on this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<BridgeOutput> outputs);

        /**
         * <p>
         * The outputs on this bridge.
         * </p>
         * 
         * @param outputs
         *        The outputs on this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(BridgeOutput... outputs);

        /**
         * <p>
         * The outputs on this bridge.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.BridgeOutput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.BridgeOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.BridgeOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #outputs(List<BridgeOutput>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.BridgeOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<BridgeOutput>)
         */
        Builder outputs(Consumer<BridgeOutput.Builder>... outputs);

        /**
         * <p>
         * The placement Amazon Resource Number (ARN) of the bridge.
         * </p>
         * 
         * @param placementArn
         *        The placement Amazon Resource Number (ARN) of the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementArn(String placementArn);

        /**
         * <p>
         * The settings for source failover.
         * </p>
         * 
         * @param sourceFailoverConfig
         *        The settings for source failover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig);

        /**
         * <p>
         * The settings for source failover.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailoverConfig.Builder} avoiding the need
         * to create one manually via {@link FailoverConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailoverConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceFailoverConfig(FailoverConfig)}.
         * 
         * @param sourceFailoverConfig
         *        a consumer that will call methods on {@link FailoverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFailoverConfig(FailoverConfig)
         */
        default Builder sourceFailoverConfig(Consumer<FailoverConfig.Builder> sourceFailoverConfig) {
            return sourceFailoverConfig(FailoverConfig.builder().applyMutation(sourceFailoverConfig).build());
        }

        /**
         * <p>
         * The sources on this bridge.
         * </p>
         * 
         * @param sources
         *        The sources on this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<BridgeSource> sources);

        /**
         * <p>
         * The sources on this bridge.
         * </p>
         * 
         * @param sources
         *        The sources on this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(BridgeSource... sources);

        /**
         * <p>
         * The sources on this bridge.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.BridgeSource.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.BridgeSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.BridgeSource.Builder#build()} is called immediately
         * and its result is passed to {@link #sources(List<BridgeSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.BridgeSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<BridgeSource>)
         */
        Builder sources(Consumer<BridgeSource.Builder>... sources);
    }

    static final class BuilderImpl implements Builder {
        private String bridgeArn;

        private List<MessageDetail> bridgeMessages = DefaultSdkAutoConstructList.getInstance();

        private String bridgeState;

        private EgressGatewayBridge egressGatewayBridge;

        private IngressGatewayBridge ingressGatewayBridge;

        private String name;

        private List<BridgeOutput> outputs = DefaultSdkAutoConstructList.getInstance();

        private String placementArn;

        private FailoverConfig sourceFailoverConfig;

        private List<BridgeSource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Bridge model) {
            bridgeArn(model.bridgeArn);
            bridgeMessages(model.bridgeMessages);
            bridgeState(model.bridgeState);
            egressGatewayBridge(model.egressGatewayBridge);
            ingressGatewayBridge(model.ingressGatewayBridge);
            name(model.name);
            outputs(model.outputs);
            placementArn(model.placementArn);
            sourceFailoverConfig(model.sourceFailoverConfig);
            sources(model.sources);
        }

        public final String getBridgeArn() {
            return bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final List<MessageDetail.Builder> getBridgeMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.bridgeMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBridgeMessages(Collection<MessageDetail.BuilderImpl> bridgeMessages) {
            this.bridgeMessages = ___listOfMessageDetailCopier.copyFromBuilder(bridgeMessages);
        }

        @Override
        public final Builder bridgeMessages(Collection<MessageDetail> bridgeMessages) {
            this.bridgeMessages = ___listOfMessageDetailCopier.copy(bridgeMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bridgeMessages(MessageDetail... bridgeMessages) {
            bridgeMessages(Arrays.asList(bridgeMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bridgeMessages(Consumer<MessageDetail.Builder>... bridgeMessages) {
            bridgeMessages(Stream.of(bridgeMessages).map(c -> MessageDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getBridgeState() {
            return bridgeState;
        }

        public final void setBridgeState(String bridgeState) {
            this.bridgeState = bridgeState;
        }

        @Override
        public final Builder bridgeState(String bridgeState) {
            this.bridgeState = bridgeState;
            return this;
        }

        @Override
        public final Builder bridgeState(BridgeState bridgeState) {
            this.bridgeState(bridgeState == null ? null : bridgeState.toString());
            return this;
        }

        public final EgressGatewayBridge.Builder getEgressGatewayBridge() {
            return egressGatewayBridge != null ? egressGatewayBridge.toBuilder() : null;
        }

        public final void setEgressGatewayBridge(EgressGatewayBridge.BuilderImpl egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge != null ? egressGatewayBridge.build() : null;
        }

        @Override
        public final Builder egressGatewayBridge(EgressGatewayBridge egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge;
            return this;
        }

        public final IngressGatewayBridge.Builder getIngressGatewayBridge() {
            return ingressGatewayBridge != null ? ingressGatewayBridge.toBuilder() : null;
        }

        public final void setIngressGatewayBridge(IngressGatewayBridge.BuilderImpl ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge != null ? ingressGatewayBridge.build() : null;
        }

        @Override
        public final Builder ingressGatewayBridge(IngressGatewayBridge ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<BridgeOutput.Builder> getOutputs() {
            List<BridgeOutput.Builder> result = ___listOfBridgeOutputCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<BridgeOutput.BuilderImpl> outputs) {
            this.outputs = ___listOfBridgeOutputCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<BridgeOutput> outputs) {
            this.outputs = ___listOfBridgeOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(BridgeOutput... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<BridgeOutput.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> BridgeOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlacementArn() {
            return placementArn;
        }

        public final void setPlacementArn(String placementArn) {
            this.placementArn = placementArn;
        }

        @Override
        public final Builder placementArn(String placementArn) {
            this.placementArn = placementArn;
            return this;
        }

        public final FailoverConfig.Builder getSourceFailoverConfig() {
            return sourceFailoverConfig != null ? sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(FailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final List<BridgeSource.Builder> getSources() {
            List<BridgeSource.Builder> result = ___listOfBridgeSourceCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<BridgeSource.BuilderImpl> sources) {
            this.sources = ___listOfBridgeSourceCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<BridgeSource> sources) {
            this.sources = ___listOfBridgeSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(BridgeSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<BridgeSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> BridgeSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Bridge build() {
            return new Bridge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
