/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The media stream that you want to add to the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddMediaStreamRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AddMediaStreamRequest.Builder, AddMediaStreamRequest> {
    private static final SdkField<MediaStreamAttributesRequest> ATTRIBUTES_FIELD = SdkField
            .<MediaStreamAttributesRequest> builder(MarshallingType.SDK_POJO).memberName("Attributes")
            .getter(getter(AddMediaStreamRequest::attributes)).setter(setter(Builder::attributes))
            .constructor(MediaStreamAttributesRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<Integer> CLOCK_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClockRate").getter(getter(AddMediaStreamRequest::clockRate)).setter(setter(Builder::clockRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clockRate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AddMediaStreamRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> MEDIA_STREAM_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaStreamId").getter(getter(AddMediaStreamRequest::mediaStreamId))
            .setter(setter(Builder::mediaStreamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamId").build()).build();

    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamName").getter(getter(AddMediaStreamRequest::mediaStreamName))
            .setter(setter(Builder::mediaStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamName").build()).build();

    private static final SdkField<String> MEDIA_STREAM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamType").getter(getter(AddMediaStreamRequest::mediaStreamTypeAsString))
            .setter(setter(Builder::mediaStreamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamType").build()).build();

    private static final SdkField<String> VIDEO_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VideoFormat").getter(getter(AddMediaStreamRequest::videoFormat)).setter(setter(Builder::videoFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoFormat").build()).build();

    private static final SdkField<Map<String, String>> MEDIA_STREAM_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("MediaStreamTags")
            .getter(getter(AddMediaStreamRequest::mediaStreamTags))
            .setter(setter(Builder::mediaStreamTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            CLOCK_RATE_FIELD, DESCRIPTION_FIELD, MEDIA_STREAM_ID_FIELD, MEDIA_STREAM_NAME_FIELD, MEDIA_STREAM_TYPE_FIELD,
            VIDEO_FORMAT_FIELD, MEDIA_STREAM_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MediaStreamAttributesRequest attributes;

    private final Integer clockRate;

    private final String description;

    private final Integer mediaStreamId;

    private final String mediaStreamName;

    private final String mediaStreamType;

    private final String videoFormat;

    private final Map<String, String> mediaStreamTags;

    private AddMediaStreamRequest(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.clockRate = builder.clockRate;
        this.description = builder.description;
        this.mediaStreamId = builder.mediaStreamId;
        this.mediaStreamName = builder.mediaStreamName;
        this.mediaStreamType = builder.mediaStreamType;
        this.videoFormat = builder.videoFormat;
        this.mediaStreamTags = builder.mediaStreamTags;
    }

    /**
     * <p>
     * The attributes that you want to assign to the new media stream.
     * </p>
     * 
     * @return The attributes that you want to assign to the new media stream.
     */
    public final MediaStreamAttributesRequest attributes() {
        return attributes;
    }

    /**
     * <p>
     * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to
     * 90000. If the media stream type is audio, set this value to either 48000 or 96000.
     * </p>
     * 
     * @return The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this
     *         value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
     */
    public final Integer clockRate() {
        return clockRate;
    }

    /**
     * <p>
     * A description that can help you quickly identify what your media stream is used for.
     * </p>
     * 
     * @return A description that can help you quickly identify what your media stream is used for.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique identifier for the media stream.
     * </p>
     * 
     * @return A unique identifier for the media stream.
     */
    public final Integer mediaStreamId() {
        return mediaStreamId;
    }

    /**
     * <p>
     * A name that helps you distinguish one media stream from another.
     * </p>
     * 
     * @return A name that helps you distinguish one media stream from another.
     */
    public final String mediaStreamName() {
        return mediaStreamName;
    }

    /**
     * <p>
     * The type of media stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaStreamType}
     * will return {@link MediaStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mediaStreamTypeAsString}.
     * </p>
     * 
     * @return The type of media stream.
     * @see MediaStreamType
     */
    public final MediaStreamType mediaStreamType() {
        return MediaStreamType.fromValue(mediaStreamType);
    }

    /**
     * <p>
     * The type of media stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaStreamType}
     * will return {@link MediaStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mediaStreamTypeAsString}.
     * </p>
     * 
     * @return The type of media stream.
     * @see MediaStreamType
     */
    public final String mediaStreamTypeAsString() {
        return mediaStreamType;
    }

    /**
     * <p>
     * The resolution of the video.
     * </p>
     * 
     * @return The resolution of the video.
     */
    public final String videoFormat() {
        return videoFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaStreamTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaStreamTags() {
        return mediaStreamTags != null && !(mediaStreamTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs that can be used to tag and organize the media stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaStreamTags} method.
     * </p>
     * 
     * @return The key-value pairs that can be used to tag and organize the media stream.
     */
    public final Map<String, String> mediaStreamTags() {
        return mediaStreamTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(clockRate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(videoFormat());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaStreamTags() ? mediaStreamTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddMediaStreamRequest)) {
            return false;
        }
        AddMediaStreamRequest other = (AddMediaStreamRequest) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(clockRate(), other.clockRate())
                && Objects.equals(description(), other.description()) && Objects.equals(mediaStreamId(), other.mediaStreamId())
                && Objects.equals(mediaStreamName(), other.mediaStreamName())
                && Objects.equals(mediaStreamTypeAsString(), other.mediaStreamTypeAsString())
                && Objects.equals(videoFormat(), other.videoFormat()) && hasMediaStreamTags() == other.hasMediaStreamTags()
                && Objects.equals(mediaStreamTags(), other.mediaStreamTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddMediaStreamRequest").add("Attributes", attributes()).add("ClockRate", clockRate())
                .add("Description", description()).add("MediaStreamId", mediaStreamId())
                .add("MediaStreamName", mediaStreamName()).add("MediaStreamType", mediaStreamTypeAsString())
                .add("VideoFormat", videoFormat()).add("MediaStreamTags", hasMediaStreamTags() ? mediaStreamTags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ClockRate":
            return Optional.ofNullable(clazz.cast(clockRate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MediaStreamId":
            return Optional.ofNullable(clazz.cast(mediaStreamId()));
        case "MediaStreamName":
            return Optional.ofNullable(clazz.cast(mediaStreamName()));
        case "MediaStreamType":
            return Optional.ofNullable(clazz.cast(mediaStreamTypeAsString()));
        case "VideoFormat":
            return Optional.ofNullable(clazz.cast(videoFormat()));
        case "MediaStreamTags":
            return Optional.ofNullable(clazz.cast(mediaStreamTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("clockRate", CLOCK_RATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("mediaStreamId", MEDIA_STREAM_ID_FIELD);
        map.put("mediaStreamName", MEDIA_STREAM_NAME_FIELD);
        map.put("mediaStreamType", MEDIA_STREAM_TYPE_FIELD);
        map.put("videoFormat", VIDEO_FORMAT_FIELD);
        map.put("mediaStreamTags", MEDIA_STREAM_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddMediaStreamRequest, T> g) {
        return obj -> g.apply((AddMediaStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddMediaStreamRequest> {
        /**
         * <p>
         * The attributes that you want to assign to the new media stream.
         * </p>
         * 
         * @param attributes
         *        The attributes that you want to assign to the new media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(MediaStreamAttributesRequest attributes);

        /**
         * <p>
         * The attributes that you want to assign to the new media stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaStreamAttributesRequest.Builder}
         * avoiding the need to create one manually via {@link MediaStreamAttributesRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaStreamAttributesRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(MediaStreamAttributesRequest)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link MediaStreamAttributesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(MediaStreamAttributesRequest)
         */
        default Builder attributes(Consumer<MediaStreamAttributesRequest.Builder> attributes) {
            return attributes(MediaStreamAttributesRequest.builder().applyMutation(attributes).build());
        }

        /**
         * <p>
         * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value
         * to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
         * </p>
         * 
         * @param clockRate
         *        The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this
         *        value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clockRate(Integer clockRate);

        /**
         * <p>
         * A description that can help you quickly identify what your media stream is used for.
         * </p>
         * 
         * @param description
         *        A description that can help you quickly identify what your media stream is used for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique identifier for the media stream.
         * </p>
         * 
         * @param mediaStreamId
         *        A unique identifier for the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamId(Integer mediaStreamId);

        /**
         * <p>
         * A name that helps you distinguish one media stream from another.
         * </p>
         * 
         * @param mediaStreamName
         *        A name that helps you distinguish one media stream from another.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamName(String mediaStreamName);

        /**
         * <p>
         * The type of media stream.
         * </p>
         * 
         * @param mediaStreamType
         *        The type of media stream.
         * @see MediaStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamType
         */
        Builder mediaStreamType(String mediaStreamType);

        /**
         * <p>
         * The type of media stream.
         * </p>
         * 
         * @param mediaStreamType
         *        The type of media stream.
         * @see MediaStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamType
         */
        Builder mediaStreamType(MediaStreamType mediaStreamType);

        /**
         * <p>
         * The resolution of the video.
         * </p>
         * 
         * @param videoFormat
         *        The resolution of the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoFormat(String videoFormat);

        /**
         * <p>
         * The key-value pairs that can be used to tag and organize the media stream.
         * </p>
         * 
         * @param mediaStreamTags
         *        The key-value pairs that can be used to tag and organize the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamTags(Map<String, String> mediaStreamTags);
    }

    static final class BuilderImpl implements Builder {
        private MediaStreamAttributesRequest attributes;

        private Integer clockRate;

        private String description;

        private Integer mediaStreamId;

        private String mediaStreamName;

        private String mediaStreamType;

        private String videoFormat;

        private Map<String, String> mediaStreamTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddMediaStreamRequest model) {
            attributes(model.attributes);
            clockRate(model.clockRate);
            description(model.description);
            mediaStreamId(model.mediaStreamId);
            mediaStreamName(model.mediaStreamName);
            mediaStreamType(model.mediaStreamType);
            videoFormat(model.videoFormat);
            mediaStreamTags(model.mediaStreamTags);
        }

        public final MediaStreamAttributesRequest.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(MediaStreamAttributesRequest.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(MediaStreamAttributesRequest attributes) {
            this.attributes = attributes;
            return this;
        }

        public final Integer getClockRate() {
            return clockRate;
        }

        public final void setClockRate(Integer clockRate) {
            this.clockRate = clockRate;
        }

        @Override
        public final Builder clockRate(Integer clockRate) {
            this.clockRate = clockRate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getMediaStreamId() {
            return mediaStreamId;
        }

        public final void setMediaStreamId(Integer mediaStreamId) {
            this.mediaStreamId = mediaStreamId;
        }

        @Override
        public final Builder mediaStreamId(Integer mediaStreamId) {
            this.mediaStreamId = mediaStreamId;
            return this;
        }

        public final String getMediaStreamName() {
            return mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        public final String getMediaStreamType() {
            return mediaStreamType;
        }

        public final void setMediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
        }

        @Override
        public final Builder mediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
            return this;
        }

        @Override
        public final Builder mediaStreamType(MediaStreamType mediaStreamType) {
            this.mediaStreamType(mediaStreamType == null ? null : mediaStreamType.toString());
            return this;
        }

        public final String getVideoFormat() {
            return videoFormat;
        }

        public final void setVideoFormat(String videoFormat) {
            this.videoFormat = videoFormat;
        }

        @Override
        public final Builder videoFormat(String videoFormat) {
            this.videoFormat = videoFormat;
            return this;
        }

        public final Map<String, String> getMediaStreamTags() {
            if (mediaStreamTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return mediaStreamTags;
        }

        public final void setMediaStreamTags(Map<String, String> mediaStreamTags) {
            this.mediaStreamTags = ___mapOfStringCopier.copy(mediaStreamTags);
        }

        @Override
        public final Builder mediaStreamTags(Map<String, String> mediaStreamTags) {
            this.mediaStreamTags = ___mapOfStringCopier.copy(mediaStreamTags);
            return this;
        }

        @Override
        public AddMediaStreamRequest build() {
            return new AddMediaStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
