/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputs420Exception;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.BadRequestException;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.ConflictException;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridge420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlow420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateGateway420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationResponse;
import software.amazon.awssdk.services.mediaconnect.model.ForbiddenException;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlements420Exception;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectException;
import software.amazon.awssdk.services.mediaconnect.model.NotFoundException;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.ServiceUnavailableException;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.TooManyRequestsException;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesIterable;
import software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable;
import software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable;
import software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesIterable;
import software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysIterable;
import software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsIterable;
import software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsIterable;
import software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsIterable;
import software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesIterable;
import software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsIterable;
import software.amazon.awssdk.services.mediaconnect.waiters.MediaConnectWaiter;

/**
 * Service client for accessing AWS MediaConnect. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Welcome to the Elemental MediaConnect API reference.
 * </p>
 * <p>
 * MediaConnect is a service that lets you ingest live video content into the cloud and distribute it to destinations
 * all over the world, both inside and outside the Amazon Web Services cloud. This API reference provides descriptions,
 * syntax, and usage examples for each of the actions and data types that are supported by MediaConnect.
 * </p>
 * <p>
 * Use the following links to get started with the MediaConnect API:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/API_Operations.html">Actions</a>: An alphabetical list
 * of all MediaConnect API operations.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/API_Types.html">Data types</a>: An alphabetical list of
 * all MediaConnect data types.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/CommonParameters.html">Common parameters</a>: Parameters
 * that all operations can use.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/CommonErrors.html">Common errors</a>: Client and server
 * errors that all operations can return.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaConnectClient extends AwsClient {
    String SERVICE_NAME = "mediaconnect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mediaconnect";

    /**
     * <p>
     * Adds outputs to an existing bridge.
     * </p>
     *
     * @param addBridgeOutputsRequest
     * @return Result of the AddBridgeOutputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddBridgeOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default AddBridgeOutputsResponse addBridgeOutputs(AddBridgeOutputsRequest addBridgeOutputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds outputs to an existing bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddBridgeOutputsRequest.Builder} avoiding the need
     * to create one manually via {@link AddBridgeOutputsRequest#builder()}
     * </p>
     *
     * @param addBridgeOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsRequest.Builder} to create a
     *        request.
     * @return Result of the AddBridgeOutputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddBridgeOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default AddBridgeOutputsResponse addBridgeOutputs(Consumer<AddBridgeOutputsRequest.Builder> addBridgeOutputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return addBridgeOutputs(AddBridgeOutputsRequest.builder().applyMutation(addBridgeOutputsRequest).build());
    }

    /**
     * <p>
     * Adds sources to an existing bridge.
     * </p>
     *
     * @param addBridgeSourcesRequest
     * @return Result of the AddBridgeSources operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddBridgeSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeSources" target="_top">AWS
     *      API Documentation</a>
     */
    default AddBridgeSourcesResponse addBridgeSources(AddBridgeSourcesRequest addBridgeSourcesRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds sources to an existing bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddBridgeSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link AddBridgeSourcesRequest#builder()}
     * </p>
     *
     * @param addBridgeSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesRequest.Builder} to create a
     *        request.
     * @return Result of the AddBridgeSources operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddBridgeSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeSources" target="_top">AWS
     *      API Documentation</a>
     */
    default AddBridgeSourcesResponse addBridgeSources(Consumer<AddBridgeSourcesRequest.Builder> addBridgeSourcesRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return addBridgeSources(AddBridgeSourcesRequest.builder().applyMutation(addBridgeSourcesRequest).build());
    }

    /**
     * <p>
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a
     * source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     * </p>
     *
     * @param addFlowMediaStreamsRequest
     * @return Result of the AddFlowMediaStreams operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowMediaStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowMediaStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default AddFlowMediaStreamsResponse addFlowMediaStreams(AddFlowMediaStreamsRequest addFlowMediaStreamsRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a
     * source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddFlowMediaStreamsRequest.Builder} avoiding the
     * need to create one manually via {@link AddFlowMediaStreamsRequest#builder()}
     * </p>
     *
     * @param addFlowMediaStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsRequest.Builder} to create a
     *        request.
     * @return Result of the AddFlowMediaStreams operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowMediaStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowMediaStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default AddFlowMediaStreamsResponse addFlowMediaStreams(
            Consumer<AddFlowMediaStreamsRequest.Builder> addFlowMediaStreamsRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return addFlowMediaStreams(AddFlowMediaStreamsRequest.builder().applyMutation(addFlowMediaStreamsRequest).build());
    }

    /**
     * <p>
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     * </p>
     *
     * @param addFlowOutputsRequest
     * @return Result of the AddFlowOutputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws AddFlowOutputs420Exception
     *         Exception raised by Elemental MediaConnect when adding the flow output. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default AddFlowOutputsResponse addFlowOutputs(AddFlowOutputsRequest addFlowOutputsRequest) throws BadRequestException,
            AddFlowOutputs420Exception, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddFlowOutputsRequest.Builder} avoiding the need to
     * create one manually via {@link AddFlowOutputsRequest#builder()}
     * </p>
     *
     * @param addFlowOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsRequest.Builder} to create a
     *        request.
     * @return Result of the AddFlowOutputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws AddFlowOutputs420Exception
     *         Exception raised by Elemental MediaConnect when adding the flow output. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default AddFlowOutputsResponse addFlowOutputs(Consumer<AddFlowOutputsRequest.Builder> addFlowOutputsRequest)
            throws BadRequestException, AddFlowOutputs420Exception, TooManyRequestsException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return addFlowOutputs(AddFlowOutputsRequest.builder().applyMutation(addFlowOutputsRequest).build());
    }

    /**
     * <p>
     * Adds sources to a flow.
     * </p>
     *
     * @param addFlowSourcesRequest
     * @return Result of the AddFlowSources operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources" target="_top">AWS
     *      API Documentation</a>
     */
    default AddFlowSourcesResponse addFlowSources(AddFlowSourcesRequest addFlowSourcesRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds sources to a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddFlowSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link AddFlowSourcesRequest#builder()}
     * </p>
     *
     * @param addFlowSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesRequest.Builder} to create a
     *        request.
     * @return Result of the AddFlowSources operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources" target="_top">AWS
     *      API Documentation</a>
     */
    default AddFlowSourcesResponse addFlowSources(Consumer<AddFlowSourcesRequest.Builder> addFlowSourcesRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return addFlowSources(AddFlowSourcesRequest.builder().applyMutation(addFlowSourcesRequest).build());
    }

    /**
     * <p>
     * Adds VPC interfaces to a flow.
     * </p>
     *
     * @param addFlowVpcInterfacesRequest
     * @return Result of the AddFlowVpcInterfaces operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowVpcInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default AddFlowVpcInterfacesResponse addFlowVpcInterfaces(AddFlowVpcInterfacesRequest addFlowVpcInterfacesRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds VPC interfaces to a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddFlowVpcInterfacesRequest.Builder} avoiding the
     * need to create one manually via {@link AddFlowVpcInterfacesRequest#builder()}
     * </p>
     *
     * @param addFlowVpcInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesRequest.Builder} to create a
     *        request.
     * @return Result of the AddFlowVpcInterfaces operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowVpcInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default AddFlowVpcInterfacesResponse addFlowVpcInterfaces(
            Consumer<AddFlowVpcInterfacesRequest.Builder> addFlowVpcInterfacesRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return addFlowVpcInterfaces(AddFlowVpcInterfacesRequest.builder().applyMutation(addFlowVpcInterfacesRequest).build());
    }

    /**
     * <p>
     * Retrieves information about multiple router inputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterInputRequest
     * @return Result of the BatchGetRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.BatchGetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetRouterInputResponse batchGetRouterInput(BatchGetRouterInputRequest batchGetRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about multiple router inputs in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetRouterInputRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetRouterInputRequest#builder()}
     * </p>
     *
     * @param batchGetRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.BatchGetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetRouterInputResponse batchGetRouterInput(
            Consumer<BatchGetRouterInputRequest.Builder> batchGetRouterInputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return batchGetRouterInput(BatchGetRouterInputRequest.builder().applyMutation(batchGetRouterInputRequest).build());
    }

    /**
     * <p>
     * Retrieves information about multiple router network interfaces in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterNetworkInterfaceRequest
     * @return Result of the BatchGetRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.BatchGetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetRouterNetworkInterfaceResponse batchGetRouterNetworkInterface(
            BatchGetRouterNetworkInterfaceRequest batchGetRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about multiple router network interfaces in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetRouterNetworkInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param batchGetRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceRequest.Builder}
     *        to create a request.
     * @return Result of the BatchGetRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.BatchGetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetRouterNetworkInterfaceResponse batchGetRouterNetworkInterface(
            Consumer<BatchGetRouterNetworkInterfaceRequest.Builder> batchGetRouterNetworkInterfaceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return batchGetRouterNetworkInterface(BatchGetRouterNetworkInterfaceRequest.builder()
                .applyMutation(batchGetRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about multiple router outputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterOutputRequest
     * @return Result of the BatchGetRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.BatchGetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetRouterOutputResponse batchGetRouterOutput(BatchGetRouterOutputRequest batchGetRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about multiple router outputs in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetRouterOutputRequest#builder()}
     * </p>
     *
     * @param batchGetRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.BatchGetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetRouterOutputResponse batchGetRouterOutput(
            Consumer<BatchGetRouterOutputRequest.Builder> batchGetRouterOutputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return batchGetRouterOutput(BatchGetRouterOutputRequest.builder().applyMutation(batchGetRouterOutputRequest).build());
    }

    /**
     * <p>
     * Creates a new bridge. The request must include one source.
     * </p>
     *
     * @param createBridgeRequest
     * @return Result of the CreateBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws CreateBridge420Exception
     *         Exception raised by Elemental MediaConnect when creating the bridge. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBridgeResponse createBridge(CreateBridgeRequest createBridgeRequest) throws BadRequestException,
            CreateBridge420Exception, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new bridge. The request must include one source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBridgeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBridgeRequest#builder()}
     * </p>
     *
     * @param createBridgeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateBridgeRequest.Builder} to create a
     *        request.
     * @return Result of the CreateBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws CreateBridge420Exception
     *         Exception raised by Elemental MediaConnect when creating the bridge. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBridgeResponse createBridge(Consumer<CreateBridgeRequest.Builder> createBridgeRequest)
            throws BadRequestException, CreateBridge420Exception, TooManyRequestsException, ConflictException,
            ForbiddenException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return createBridge(CreateBridgeRequest.builder().applyMutation(createBridgeRequest).build());
    }

    /**
     * <p>
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50)
     * and entitlements (up to 50).
     * </p>
     *
     * @param createFlowRequest
     * @return Result of the CreateFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws CreateFlow420Exception
     *         Exception raised by Elemental MediaConnect when creating the flow. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFlowResponse createFlow(CreateFlowRequest createFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, ServiceUnavailableException,
            CreateFlow420Exception, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50)
     * and entitlements (up to 50).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFlowRequest#builder()}
     * </p>
     *
     * @param createFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateFlowRequest.Builder} to create a request.
     * @return Result of the CreateFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws CreateFlow420Exception
     *         Exception raised by Elemental MediaConnect when creating the flow. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFlowResponse createFlow(Consumer<CreateFlowRequest.Builder> createFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, ServiceUnavailableException,
            CreateFlow420Exception, AwsServiceException, SdkClientException, MediaConnectException {
        return createFlow(CreateFlowRequest.builder().applyMutation(createFlowRequest).build());
    }

    /**
     * <p>
     * Creates a new gateway. The request must include at least one network (up to four).
     * </p>
     *
     * @param createGatewayRequest
     * @return Result of the CreateGateway operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws CreateGateway420Exception
     *         Exception raised by Elemental MediaConnect when creating the gateway. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGatewayResponse createGateway(CreateGatewayRequest createGatewayRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, CreateGateway420Exception, ForbiddenException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new gateway. The request must include at least one network (up to four).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGatewayRequest#builder()}
     * </p>
     *
     * @param createGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGateway operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws CreateGateway420Exception
     *         Exception raised by Elemental MediaConnect when creating the gateway. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateGatewayResponse createGateway(Consumer<CreateGatewayRequest.Builder> createGatewayRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, CreateGateway420Exception,
            ForbiddenException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return createGateway(CreateGatewayRequest.builder().applyMutation(createGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a new router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterInputRequest
     * @return Result of the CreateRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws RouterInputServiceQuotaExceededException
     *         The request to create a new router input would exceed the service quotas for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRouterInputResponse createRouterInput(CreateRouterInputRequest createRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, ServiceUnavailableException, RouterInputServiceQuotaExceededException,
            AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRouterInputRequest#builder()}
     * </p>
     *
     * @param createRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws RouterInputServiceQuotaExceededException
     *         The request to create a new router input would exceed the service quotas for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRouterInputResponse createRouterInput(Consumer<CreateRouterInputRequest.Builder> createRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, ServiceUnavailableException, RouterInputServiceQuotaExceededException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return createRouterInput(CreateRouterInputRequest.builder().applyMutation(createRouterInputRequest).build());
    }

    /**
     * <p>
     * Creates a new router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterNetworkInterfaceRequest
     * @return Result of the CreateRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws RouterNetworkInterfaceServiceQuotaExceededException
     *         The request to create a new router network interface would exceed the service quotas (limits) set for the
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRouterNetworkInterfaceResponse createRouterNetworkInterface(
            CreateRouterNetworkInterfaceRequest createRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException,
            ServiceUnavailableException, RouterNetworkInterfaceServiceQuotaExceededException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new router network interface in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouterNetworkInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param createRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceRequest.Builder} to
     *        create a request.
     * @return Result of the CreateRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws RouterNetworkInterfaceServiceQuotaExceededException
     *         The request to create a new router network interface would exceed the service quotas (limits) set for the
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRouterNetworkInterfaceResponse createRouterNetworkInterface(
            Consumer<CreateRouterNetworkInterfaceRequest.Builder> createRouterNetworkInterfaceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, ServiceUnavailableException, RouterNetworkInterfaceServiceQuotaExceededException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return createRouterNetworkInterface(CreateRouterNetworkInterfaceRequest.builder()
                .applyMutation(createRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Creates a new router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterOutputRequest
     * @return Result of the CreateRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws RouterOutputServiceQuotaExceededException
     *         The request to create a new router output would exceed the service quotas (limits) set for the account.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRouterOutputResponse createRouterOutput(CreateRouterOutputRequest createRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, RouterOutputServiceQuotaExceededException,
            ForbiddenException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRouterOutputRequest#builder()}
     * </p>
     *
     * @param createRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws RouterOutputServiceQuotaExceededException
     *         The request to create a new router output would exceed the service quotas (limits) set for the account.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRouterOutputResponse createRouterOutput(Consumer<CreateRouterOutputRequest.Builder> createRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, RouterOutputServiceQuotaExceededException,
            ForbiddenException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return createRouterOutput(CreateRouterOutputRequest.builder().applyMutation(createRouterOutputRequest).build());
    }

    /**
     * <p>
     * Deletes a bridge. Before you can delete a bridge, you must stop the bridge.
     * </p>
     *
     * @param deleteBridgeRequest
     * @return Result of the DeleteBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBridgeResponse deleteBridge(DeleteBridgeRequest deleteBridgeRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a bridge. Before you can delete a bridge, you must stop the bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBridgeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBridgeRequest#builder()}
     * </p>
     *
     * @param deleteBridgeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBridgeResponse deleteBridge(Consumer<DeleteBridgeRequest.Builder> deleteBridgeRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return deleteBridge(DeleteBridgeRequest.builder().applyMutation(deleteBridgeRequest).build());
    }

    /**
     * <p>
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     * </p>
     *
     * @param deleteFlowRequest
     * @return Result of the DeleteFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFlowResponse deleteFlow(DeleteFlowRequest deleteFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFlowRequest#builder()}
     * </p>
     *
     * @param deleteFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteFlowRequest.Builder} to create a request.
     * @return Result of the DeleteFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFlowResponse deleteFlow(Consumer<DeleteFlowRequest.Builder> deleteFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return deleteFlow(DeleteFlowRequest.builder().applyMutation(deleteFlowRequest).build());
    }

    /**
     * <p>
     * Deletes a gateway. Before you can delete a gateway, you must deregister its instances and delete its bridges.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a gateway. Before you can delete a gateway, you must deregister its instances and delete its bridges.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGatewayRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(Consumer<DeleteGatewayRequest.Builder> deleteGatewayRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return deleteGateway(DeleteGatewayRequest.builder().applyMutation(deleteGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a router input from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterInputRequest
     * @return Result of the DeleteRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRouterInputResponse deleteRouterInput(DeleteRouterInputRequest deleteRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a router input from AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRouterInputRequest#builder()}
     * </p>
     *
     * @param deleteRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRouterInputResponse deleteRouterInput(Consumer<DeleteRouterInputRequest.Builder> deleteRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return deleteRouterInput(DeleteRouterInputRequest.builder().applyMutation(deleteRouterInputRequest).build());
    }

    /**
     * <p>
     * Deletes a router network interface from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterNetworkInterfaceRequest
     * @return Result of the DeleteRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRouterNetworkInterfaceResponse deleteRouterNetworkInterface(
            DeleteRouterNetworkInterfaceRequest deleteRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a router network interface from AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouterNetworkInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param deleteRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRouterNetworkInterfaceResponse deleteRouterNetworkInterface(
            Consumer<DeleteRouterNetworkInterfaceRequest.Builder> deleteRouterNetworkInterfaceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return deleteRouterNetworkInterface(DeleteRouterNetworkInterfaceRequest.builder()
                .applyMutation(deleteRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Deletes a router output from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterOutputRequest
     * @return Result of the DeleteRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRouterOutputResponse deleteRouterOutput(DeleteRouterOutputRequest deleteRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a router output from AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRouterOutputRequest#builder()}
     * </p>
     *
     * @param deleteRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRouterOutputResponse deleteRouterOutput(Consumer<DeleteRouterOutputRequest.Builder> deleteRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return deleteRouterOutput(DeleteRouterOutputRequest.builder().applyMutation(deleteRouterOutputRequest).build());
    }

    /**
     * <p>
     * Deregisters an instance. Before you deregister an instance, all bridges running on the instance must be stopped.
     * If you want to deregister an instance without stopping the bridges, you must use the --force option.
     * </p>
     *
     * @param deregisterGatewayInstanceRequest
     * @return Result of the DeregisterGatewayInstance operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeregisterGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeregisterGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterGatewayInstanceResponse deregisterGatewayInstance(
            DeregisterGatewayInstanceRequest deregisterGatewayInstanceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an instance. Before you deregister an instance, all bridges running on the instance must be stopped.
     * If you want to deregister an instance without stopping the bridges, you must use the --force option.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterGatewayInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterGatewayInstanceRequest#builder()}
     * </p>
     *
     * @param deregisterGatewayInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceRequest.Builder} to
     *        create a request.
     * @return Result of the DeregisterGatewayInstance operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeregisterGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeregisterGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterGatewayInstanceResponse deregisterGatewayInstance(
            Consumer<DeregisterGatewayInstanceRequest.Builder> deregisterGatewayInstanceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return deregisterGatewayInstance(DeregisterGatewayInstanceRequest.builder()
                .applyMutation(deregisterGatewayInstanceRequest).build());
    }

    /**
     * <p>
     * Displays the details of a bridge.
     * </p>
     *
     * @param describeBridgeRequest
     * @return Result of the DescribeBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeBridge" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeBridgeResponse describeBridge(DescribeBridgeRequest describeBridgeRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of a bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBridgeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBridgeRequest#builder()}
     * </p>
     *
     * @param describeBridgeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeBridge" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeBridgeResponse describeBridge(Consumer<DescribeBridgeRequest.Builder> describeBridgeRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return describeBridge(DescribeBridgeRequest.builder().applyMutation(describeBridgeRequest).build());
    }

    /**
     * <p>
     * Displays the details of a flow. The response includes the flow Amazon Resource Name (ARN), name, and Availability
     * Zone, as well as details about the source, outputs, and entitlements.
     * </p>
     *
     * @param describeFlowRequest
     * @return Result of the DescribeFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFlowResponse describeFlow(DescribeFlowRequest describeFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of a flow. The response includes the flow Amazon Resource Name (ARN), name, and Availability
     * Zone, as well as details about the source, outputs, and entitlements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFlowRequest#builder()}
     * </p>
     *
     * @param describeFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFlowResponse describeFlow(Consumer<DescribeFlowRequest.Builder> describeFlowRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return describeFlow(DescribeFlowRequest.builder().applyMutation(describeFlowRequest).build());
    }

    /**
     * <p>
     * The <code>DescribeFlowSourceMetadata</code> API is used to view information about the flow's source transport
     * stream and programs. This API displays status messages about the flow's source as well as details about the
     * program's video, audio, and other data.
     * </p>
     *
     * @param describeFlowSourceMetadataRequest
     * @return Result of the DescribeFlowSourceMetadata operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeFlowSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowSourceMetadataResponse describeFlowSourceMetadata(
            DescribeFlowSourceMetadataRequest describeFlowSourceMetadataRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DescribeFlowSourceMetadata</code> API is used to view information about the flow's source transport
     * stream and programs. This API displays status messages about the flow's source as well as details about the
     * program's video, audio, and other data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowSourceMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFlowSourceMetadataRequest#builder()}
     * </p>
     *
     * @param describeFlowSourceMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeFlowSourceMetadata operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeFlowSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowSourceMetadataResponse describeFlowSourceMetadata(
            Consumer<DescribeFlowSourceMetadataRequest.Builder> describeFlowSourceMetadataRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return describeFlowSourceMetadata(DescribeFlowSourceMetadataRequest.builder()
                .applyMutation(describeFlowSourceMetadataRequest).build());
    }

    /**
     * <p>
     * Describes the thumbnail for the flow source.
     * </p>
     *
     * @param describeFlowSourceThumbnailRequest
     * @return Result of the DescribeFlowSourceThumbnail operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeFlowSourceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowSourceThumbnailResponse describeFlowSourceThumbnail(
            DescribeFlowSourceThumbnailRequest describeFlowSourceThumbnailRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the thumbnail for the flow source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowSourceThumbnailRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFlowSourceThumbnailRequest#builder()}
     * </p>
     *
     * @param describeFlowSourceThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeFlowSourceThumbnail operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeFlowSourceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFlowSourceThumbnailResponse describeFlowSourceThumbnail(
            Consumer<DescribeFlowSourceThumbnailRequest.Builder> describeFlowSourceThumbnailRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return describeFlowSourceThumbnail(DescribeFlowSourceThumbnailRequest.builder()
                .applyMutation(describeFlowSourceThumbnailRequest).build());
    }

    /**
     * <p>
     * Displays the details of a gateway. The response includes the gateway Amazon Resource Name (ARN), name, and CIDR
     * blocks, as well as details about the networks.
     * </p>
     *
     * @param describeGatewayRequest
     * @return Result of the DescribeGateway operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGatewayResponse describeGateway(DescribeGatewayRequest describeGatewayRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of a gateway. The response includes the gateway Amazon Resource Name (ARN), name, and CIDR
     * blocks, as well as details about the networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeGatewayRequest#builder()}
     * </p>
     *
     * @param describeGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeGateway operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGatewayResponse describeGateway(Consumer<DescribeGatewayRequest.Builder> describeGatewayRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return describeGateway(DescribeGatewayRequest.builder().applyMutation(describeGatewayRequest).build());
    }

    /**
     * <p>
     * Displays the details of an instance.
     * </p>
     *
     * @param describeGatewayInstanceRequest
     * @return Result of the DescribeGatewayInstance operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGatewayInstanceResponse describeGatewayInstance(DescribeGatewayInstanceRequest describeGatewayInstanceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of an instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGatewayInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGatewayInstanceRequest#builder()}
     * </p>
     *
     * @param describeGatewayInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeGatewayInstance operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGatewayInstanceResponse describeGatewayInstance(
            Consumer<DescribeGatewayInstanceRequest.Builder> describeGatewayInstanceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return describeGatewayInstance(DescribeGatewayInstanceRequest.builder().applyMutation(describeGatewayInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Displays the details of an offering. The response includes the offering description, duration, outbound
     * bandwidth, price, and Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeOfferingRequest
     * @return Result of the DescribeOffering operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeOfferingResponse describeOffering(DescribeOfferingRequest describeOfferingRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of an offering. The response includes the offering description, duration, outbound
     * bandwidth, price, and Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOfferingRequest#builder()}
     * </p>
     *
     * @param describeOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeOffering operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeOfferingResponse describeOffering(Consumer<DescribeOfferingRequest.Builder> describeOfferingRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return describeOffering(DescribeOfferingRequest.builder().applyMutation(describeOfferingRequest).build());
    }

    /**
     * <p>
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time,
     * and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound
     * bandwidth).
     * </p>
     *
     * @param describeReservationRequest
     * @return Result of the DescribeReservation operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservationResponse describeReservation(DescribeReservationRequest describeReservationRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time,
     * and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound
     * bandwidth).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservationRequest#builder()}
     * </p>
     *
     * @param describeReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeReservationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeReservation operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservationResponse describeReservation(
            Consumer<DescribeReservationRequest.Builder> describeReservationRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, NotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return describeReservation(DescribeReservationRequest.builder().applyMutation(describeReservationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterInputRequest
     * @return Result of the GetRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default GetRouterInputResponse getRouterInput(GetRouterInputRequest getRouterInputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterInputRequest.Builder} avoiding the need to
     * create one manually via {@link GetRouterInputRequest#builder()}
     * </p>
     *
     * @param getRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterInputRequest.Builder} to create a
     *        request.
     * @return Result of the GetRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default GetRouterInputResponse getRouterInput(Consumer<GetRouterInputRequest.Builder> getRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return getRouterInput(GetRouterInputRequest.builder().applyMutation(getRouterInputRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed metadata information about a specific router input source, including stream details and
     * connection state.
     * </p>
     *
     * @param getRouterInputSourceMetadataRequest
     * @return Result of the GetRouterInputSourceMetadata operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterInputSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRouterInputSourceMetadataResponse getRouterInputSourceMetadata(
            GetRouterInputSourceMetadataRequest getRouterInputSourceMetadataRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed metadata information about a specific router input source, including stream details and
     * connection state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterInputSourceMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetRouterInputSourceMetadataRequest#builder()}
     * </p>
     *
     * @param getRouterInputSourceMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the GetRouterInputSourceMetadata operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterInputSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRouterInputSourceMetadataResponse getRouterInputSourceMetadata(
            Consumer<GetRouterInputSourceMetadataRequest.Builder> getRouterInputSourceMetadataRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return getRouterInputSourceMetadata(GetRouterInputSourceMetadataRequest.builder()
                .applyMutation(getRouterInputSourceMetadataRequest).build());
    }

    /**
     * <p>
     * Retrieves the thumbnail for a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterInputThumbnailRequest
     * @return Result of the GetRouterInputThumbnail operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterInputThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRouterInputThumbnailResponse getRouterInputThumbnail(GetRouterInputThumbnailRequest getRouterInputThumbnailRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the thumbnail for a router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterInputThumbnailRequest.Builder} avoiding
     * the need to create one manually via {@link GetRouterInputThumbnailRequest#builder()}
     * </p>
     *
     * @param getRouterInputThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailRequest.Builder} to
     *        create a request.
     * @return Result of the GetRouterInputThumbnail operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterInputThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRouterInputThumbnailResponse getRouterInputThumbnail(
            Consumer<GetRouterInputThumbnailRequest.Builder> getRouterInputThumbnailRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return getRouterInputThumbnail(GetRouterInputThumbnailRequest.builder().applyMutation(getRouterInputThumbnailRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a specific router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterNetworkInterfaceRequest
     * @return Result of the GetRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRouterNetworkInterfaceResponse getRouterNetworkInterface(
            GetRouterNetworkInterfaceRequest getRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific router network interface in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterNetworkInterfaceRequest.Builder} avoiding
     * the need to create one manually via {@link GetRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param getRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceRequest.Builder} to
     *        create a request.
     * @return Result of the GetRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRouterNetworkInterfaceResponse getRouterNetworkInterface(
            Consumer<GetRouterNetworkInterfaceRequest.Builder> getRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return getRouterNetworkInterface(GetRouterNetworkInterfaceRequest.builder()
                .applyMutation(getRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterOutputRequest
     * @return Result of the GetRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default GetRouterOutputResponse getRouterOutput(GetRouterOutputRequest getRouterOutputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterOutputRequest.Builder} avoiding the need
     * to create one manually via {@link GetRouterOutputRequest#builder()}
     * </p>
     *
     * @param getRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputRequest.Builder} to create a
     *        request.
     * @return Result of the GetRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default GetRouterOutputResponse getRouterOutput(Consumer<GetRouterOutputRequest.Builder> getRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return getRouterOutput(GetRouterOutputRequest.builder().applyMutation(getRouterOutputRequest).build());
    }

    /**
     * <p>
     * Grants entitlements to an existing flow.
     * </p>
     *
     * @param grantFlowEntitlementsRequest
     * @return Result of the GrantFlowEntitlements operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws GrantFlowEntitlements420Exception
     *         Exception raised by Elemental MediaConnect when granting the entitlement. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GrantFlowEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default GrantFlowEntitlementsResponse grantFlowEntitlements(GrantFlowEntitlementsRequest grantFlowEntitlementsRequest)
            throws BadRequestException, GrantFlowEntitlements420Exception, TooManyRequestsException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants entitlements to an existing flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GrantFlowEntitlementsRequest.Builder} avoiding the
     * need to create one manually via {@link GrantFlowEntitlementsRequest#builder()}
     * </p>
     *
     * @param grantFlowEntitlementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsRequest.Builder} to create
     *        a request.
     * @return Result of the GrantFlowEntitlements operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws GrantFlowEntitlements420Exception
     *         Exception raised by Elemental MediaConnect when granting the entitlement. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GrantFlowEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default GrantFlowEntitlementsResponse grantFlowEntitlements(
            Consumer<GrantFlowEntitlementsRequest.Builder> grantFlowEntitlementsRequest) throws BadRequestException,
            GrantFlowEntitlements420Exception, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return grantFlowEntitlements(GrantFlowEntitlementsRequest.builder().applyMutation(grantFlowEntitlementsRequest).build());
    }

    /**
     * <p>
     * Displays a list of bridges that are associated with this account and an optionally specified Amazon Resource Name
     * (ARN). This request returns a paginated result.
     * </p>
     *
     * @param listBridgesRequest
     * @return Result of the ListBridges operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBridgesResponse listBridges(ListBridgesRequest listBridgesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of bridges that are associated with this account and an optionally specified Amazon Resource Name
     * (ARN). This request returns a paginated result.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBridgesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBridgesRequest#builder()}
     * </p>
     *
     * @param listBridgesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest.Builder} to create a request.
     * @return Result of the ListBridges operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBridgesResponse listBridges(Consumer<ListBridgesRequest.Builder> listBridgesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listBridges(ListBridgesRequest.builder().applyMutation(listBridgesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBridges(software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesIterable responses = client.listBridgesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesIterable responses = client.listBridgesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesIterable responses = client.listBridgesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBridges(software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest)} operation.</b>
     * </p>
     *
     * @param listBridgesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBridgesIterable listBridgesPaginator(ListBridgesRequest listBridgesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return new ListBridgesIterable(this, listBridgesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listBridges(software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesIterable responses = client.listBridgesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesIterable responses = client.listBridgesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesIterable responses = client.listBridgesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBridges(software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBridgesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBridgesRequest#builder()}
     * </p>
     *
     * @param listBridgesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBridgesIterable listBridgesPaginator(Consumer<ListBridgesRequest.Builder> listBridgesRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return listBridgesPaginator(ListBridgesRequest.builder().applyMutation(listBridgesRequest).build());
    }

    /**
     * <p>
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per
     * page.
     * </p>
     *
     * @param listEntitlementsRequest
     * @return Result of the ListEntitlements operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEntitlementsResponse listEntitlements(ListEntitlementsRequest listEntitlementsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per
     * page.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitlementsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEntitlementsRequest#builder()}
     * </p>
     *
     * @param listEntitlementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEntitlements operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEntitlementsResponse listEntitlements(Consumer<ListEntitlementsRequest.Builder> listEntitlementsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listEntitlements(ListEntitlementsRequest.builder().applyMutation(listEntitlementsRequest).build());
    }

    /**
     * <p>
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per
     * page.
     * </p>
     *
     * @return Result of the ListEntitlements operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListEntitlements
     * @see #listEntitlements(ListEntitlementsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEntitlementsResponse listEntitlements() throws BadRequestException, TooManyRequestsException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        return listEntitlements(ListEntitlementsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable responses = client.listEntitlementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable responses = client
     *             .listEntitlementsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable responses = client.listEntitlementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListEntitlements
     * @see #listEntitlementsPaginator(ListEntitlementsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEntitlementsIterable listEntitlementsPaginator() throws BadRequestException, TooManyRequestsException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        return listEntitlementsPaginator(ListEntitlementsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable responses = client.listEntitlementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable responses = client
     *             .listEntitlementsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable responses = client.listEntitlementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitlementsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEntitlementsIterable listEntitlementsPaginator(ListEntitlementsRequest listEntitlementsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return new ListEntitlementsIterable(this, listEntitlementsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable responses = client.listEntitlementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable responses = client
     *             .listEntitlementsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsIterable responses = client.listEntitlementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitlementsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEntitlementsRequest#builder()}
     * </p>
     *
     * @param listEntitlementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEntitlementsIterable listEntitlementsPaginator(Consumer<ListEntitlementsRequest.Builder> listEntitlementsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listEntitlementsPaginator(ListEntitlementsRequest.builder().applyMutation(listEntitlementsRequest).build());
    }

    /**
     * <p>
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @param listFlowsRequest
     * @return Result of the ListFlows operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsResponse listFlows(ListFlowsRequest listFlowsRequest) throws BadRequestException, TooManyRequestsException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlowsRequest#builder()}
     * </p>
     *
     * @param listFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest.Builder} to create a request.
     * @return Result of the ListFlows operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsResponse listFlows(Consumer<ListFlowsRequest.Builder> listFlowsRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return listFlows(ListFlowsRequest.builder().applyMutation(listFlowsRequest).build());
    }

    /**
     * <p>
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @return Result of the ListFlows operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListFlows
     * @see #listFlows(ListFlowsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsResponse listFlows() throws BadRequestException, TooManyRequestsException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return listFlows(ListFlowsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListFlows
     * @see #listFlowsPaginator(ListFlowsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsIterable listFlowsPaginator() throws BadRequestException, TooManyRequestsException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        return listFlowsPaginator(ListFlowsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)} operation.</b>
     * </p>
     *
     * @param listFlowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsIterable listFlowsPaginator(ListFlowsRequest listFlowsRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return new ListFlowsIterable(this, listFlowsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsIterable responses = client.listFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlowsRequest#builder()}
     * </p>
     *
     * @param listFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsIterable listFlowsPaginator(Consumer<ListFlowsRequest.Builder> listFlowsRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return listFlowsPaginator(ListFlowsRequest.builder().applyMutation(listFlowsRequest).build());
    }

    /**
     * <p>
     * Displays a list of instances associated with the Amazon Web Services account. This request returns a paginated
     * result. You can use the filterArn property to display only the instances associated with the selected Gateway
     * Amazon Resource Name (ARN).
     * </p>
     *
     * @param listGatewayInstancesRequest
     * @return Result of the ListGatewayInstances operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayInstancesResponse listGatewayInstances(ListGatewayInstancesRequest listGatewayInstancesRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of instances associated with the Amazon Web Services account. This request returns a paginated
     * result. You can use the filterArn property to display only the instances associated with the selected Gateway
     * Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGatewayInstancesRequest#builder()}
     * </p>
     *
     * @param listGatewayInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the ListGatewayInstances operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayInstancesResponse listGatewayInstances(
            Consumer<ListGatewayInstancesRequest.Builder> listGatewayInstancesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listGatewayInstances(ListGatewayInstancesRequest.builder().applyMutation(listGatewayInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGatewayInstances(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesIterable responses = client.listGatewayInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesIterable responses = client
     *             .listGatewayInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesIterable responses = client.listGatewayInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayInstances(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewayInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayInstancesIterable listGatewayInstancesPaginator(ListGatewayInstancesRequest listGatewayInstancesRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return new ListGatewayInstancesIterable(this, listGatewayInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGatewayInstances(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesIterable responses = client.listGatewayInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesIterable responses = client
     *             .listGatewayInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesIterable responses = client.listGatewayInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayInstances(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGatewayInstancesRequest#builder()}
     * </p>
     *
     * @param listGatewayInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayInstancesIterable listGatewayInstancesPaginator(
            Consumer<ListGatewayInstancesRequest.Builder> listGatewayInstancesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listGatewayInstancesPaginator(ListGatewayInstancesRequest.builder().applyMutation(listGatewayInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Displays a list of gateways that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of gateways that are associated with this account. This request returns a paginated result.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest.Builder} to create a
     *        request.
     * @return Result of the ListGateways operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysResponse listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return new ListGatewaysIterable(this, listGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Displays a list of all offerings that are available to this account in the current Amazon Web Services Region. If
     * you have an active reservation (which means you've purchased an offering that has already started and hasn't
     * expired yet), your account isn't eligible for other offerings.
     * </p>
     *
     * @param listOfferingsRequest
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOfferingsResponse listOfferings(ListOfferingsRequest listOfferingsRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of all offerings that are available to this account in the current Amazon Web Services Region. If
     * you have an active reservation (which means you've purchased an offering that has already started and hasn't
     * expired yet), your account isn't eligible for other offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest.Builder} to create a
     *        request.
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOfferingsResponse listOfferings(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listOfferings(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsIterable responses = client
     *             .listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return new ListOfferingsIterable(this, listOfferingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsIterable responses = client
     *             .listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listOfferingsPaginator(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * <p>
     * Displays a list of all reservations that have been purchased by this account in the current Amazon Web Services
     * Region. This list includes all reservations in all states (such as active and expired).
     * </p>
     *
     * @param listReservationsRequest
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsResponse listReservations(ListReservationsRequest listReservationsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of all reservations that have been purchased by this account in the current Amazon Web Services
     * Region. This list includes all reservations in all states (such as active and expired).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsResponse listReservations(Consumer<ListReservationsRequest.Builder> listReservationsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listReservations(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsIterable responses = client
     *             .listReservationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReservationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsIterable listReservationsPaginator(ListReservationsRequest listReservationsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return new ListReservationsIterable(this, listReservationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsIterable responses = client
     *             .listReservationsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsIterable listReservationsPaginator(Consumer<ListReservationsRequest.Builder> listReservationsRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listReservationsPaginator(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of router inputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterInputsRequest
     * @return Result of the ListRouterInputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouterInputsResponse listRouterInputs(ListRouterInputsRequest listRouterInputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of router inputs in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterInputsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRouterInputsRequest#builder()}
     * </p>
     *
     * @param listRouterInputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRouterInputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouterInputsResponse listRouterInputs(Consumer<ListRouterInputsRequest.Builder> listRouterInputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return listRouterInputs(ListRouterInputsRequest.builder().applyMutation(listRouterInputsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterInputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsIterable responses = client.listRouterInputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsIterable responses = client
     *             .listRouterInputsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsIterable responses = client.listRouterInputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterInputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRouterInputsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouterInputsIterable listRouterInputsPaginator(ListRouterInputsRequest listRouterInputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return new ListRouterInputsIterable(this, listRouterInputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterInputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsIterable responses = client.listRouterInputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsIterable responses = client
     *             .listRouterInputsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsIterable responses = client.listRouterInputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterInputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterInputsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRouterInputsRequest#builder()}
     * </p>
     *
     * @param listRouterInputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouterInputsIterable listRouterInputsPaginator(Consumer<ListRouterInputsRequest.Builder> listRouterInputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return listRouterInputsPaginator(ListRouterInputsRequest.builder().applyMutation(listRouterInputsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of router network interfaces in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     * @return Result of the ListRouterNetworkInterfaces operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterNetworkInterfacesResponse listRouterNetworkInterfaces(
            ListRouterNetworkInterfacesRequest listRouterNetworkInterfacesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of router network interfaces in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterNetworkInterfacesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRouterNetworkInterfacesRequest#builder()}
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest.Builder} to
     *        create a request.
     * @return Result of the ListRouterNetworkInterfaces operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterNetworkInterfacesResponse listRouterNetworkInterfaces(
            Consumer<ListRouterNetworkInterfacesRequest.Builder> listRouterNetworkInterfacesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listRouterNetworkInterfaces(ListRouterNetworkInterfacesRequest.builder()
                .applyMutation(listRouterNetworkInterfacesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterNetworkInterfaces(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesIterable responses = client.listRouterNetworkInterfacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesIterable responses = client
     *             .listRouterNetworkInterfacesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesIterable responses = client.listRouterNetworkInterfacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterNetworkInterfaces(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterNetworkInterfacesIterable listRouterNetworkInterfacesPaginator(
            ListRouterNetworkInterfacesRequest listRouterNetworkInterfacesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return new ListRouterNetworkInterfacesIterable(this, listRouterNetworkInterfacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterNetworkInterfaces(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesIterable responses = client.listRouterNetworkInterfacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesIterable responses = client
     *             .listRouterNetworkInterfacesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesIterable responses = client.listRouterNetworkInterfacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterNetworkInterfaces(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterNetworkInterfacesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRouterNetworkInterfacesRequest#builder()}
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterNetworkInterfacesIterable listRouterNetworkInterfacesPaginator(
            Consumer<ListRouterNetworkInterfacesRequest.Builder> listRouterNetworkInterfacesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listRouterNetworkInterfacesPaginator(ListRouterNetworkInterfacesRequest.builder()
                .applyMutation(listRouterNetworkInterfacesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of router outputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterOutputsRequest
     * @return Result of the ListRouterOutputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterOutputsResponse listRouterOutputs(ListRouterOutputsRequest listRouterOutputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of router outputs in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterOutputsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRouterOutputsRequest#builder()}
     * </p>
     *
     * @param listRouterOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRouterOutputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterOutputsResponse listRouterOutputs(Consumer<ListRouterOutputsRequest.Builder> listRouterOutputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return listRouterOutputs(ListRouterOutputsRequest.builder().applyMutation(listRouterOutputsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterOutputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsIterable responses = client.listRouterOutputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsIterable responses = client
     *             .listRouterOutputsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsIterable responses = client.listRouterOutputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterOutputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRouterOutputsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterOutputsIterable listRouterOutputsPaginator(ListRouterOutputsRequest listRouterOutputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return new ListRouterOutputsIterable(this, listRouterOutputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterOutputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsIterable responses = client.listRouterOutputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsIterable responses = client
     *             .listRouterOutputsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsIterable responses = client.listRouterOutputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterOutputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterOutputsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRouterOutputsRequest#builder()}
     * </p>
     *
     * @param listRouterOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterOutputsIterable listRouterOutputsPaginator(
            Consumer<ListRouterOutputsRequest.Builder> listRouterOutputsRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        return listRouterOutputsPaginator(ListRouterOutputsRequest.builder().applyMutation(listRouterOutputsRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with a global resource in AWS Elemental MediaConnect. The API supports the following
     * global resources: router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param listTagsForGlobalResourceRequest
     * @return Result of the ListTagsForGlobalResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListTagsForGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForGlobalResourceResponse listTagsForGlobalResource(
            ListTagsForGlobalResourceRequest listTagsForGlobalResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with a global resource in AWS Elemental MediaConnect. The API supports the following
     * global resources: router inputs, router outputs and router network interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForGlobalResourceRequest.Builder} avoiding
     * the need to create one manually via {@link ListTagsForGlobalResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForGlobalResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForGlobalResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListTagsForGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForGlobalResourceResponse listTagsForGlobalResource(
            Consumer<ListTagsForGlobalResourceRequest.Builder> listTagsForGlobalResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        return listTagsForGlobalResource(ListTagsForGlobalResourceRequest.builder()
                .applyMutation(listTagsForGlobalResourceRequest).build());
    }

    /**
     * <p>
     * List all tags on a MediaConnect resource in the current region.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException,
            MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags on a MediaConnect resource in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another
     * offering.
     * </p>
     *
     * @param purchaseOfferingRequest
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default PurchaseOfferingResponse purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another
     * offering.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link PurchaseOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingRequest.Builder} to create a
     *        request.
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default PurchaseOfferingResponse purchaseOffering(Consumer<PurchaseOfferingRequest.Builder> purchaseOfferingRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return purchaseOffering(PurchaseOfferingRequest.builder().applyMutation(purchaseOfferingRequest).build());
    }

    /**
     * <p>
     * Removes an output from a bridge.
     * </p>
     *
     * @param removeBridgeOutputRequest
     * @return Result of the RemoveBridgeOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveBridgeOutputResponse removeBridgeOutput(RemoveBridgeOutputRequest removeBridgeOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an output from a bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveBridgeOutputRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveBridgeOutputRequest#builder()}
     * </p>
     *
     * @param removeBridgeOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveBridgeOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveBridgeOutputResponse removeBridgeOutput(Consumer<RemoveBridgeOutputRequest.Builder> removeBridgeOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return removeBridgeOutput(RemoveBridgeOutputRequest.builder().applyMutation(removeBridgeOutputRequest).build());
    }

    /**
     * <p>
     * Removes a source from a bridge.
     * </p>
     *
     * @param removeBridgeSourceRequest
     * @return Result of the RemoveBridgeSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveBridgeSourceResponse removeBridgeSource(RemoveBridgeSourceRequest removeBridgeSourceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a source from a bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveBridgeSourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveBridgeSourceRequest#builder()}
     * </p>
     *
     * @param removeBridgeSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveBridgeSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveBridgeSourceResponse removeBridgeSource(Consumer<RemoveBridgeSourceRequest.Builder> removeBridgeSourceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return removeBridgeSource(RemoveBridgeSourceRequest.builder().applyMutation(removeBridgeSourceRequest).build());
    }

    /**
     * <p>
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a
     * source or output.
     * </p>
     *
     * @param removeFlowMediaStreamRequest
     * @return Result of the RemoveFlowMediaStream operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveFlowMediaStreamResponse removeFlowMediaStream(RemoveFlowMediaStreamRequest removeFlowMediaStreamRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a
     * source or output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFlowMediaStreamRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveFlowMediaStreamRequest#builder()}
     * </p>
     *
     * @param removeFlowMediaStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamRequest.Builder} to create
     *        a request.
     * @return Result of the RemoveFlowMediaStream operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveFlowMediaStreamResponse removeFlowMediaStream(
            Consumer<RemoveFlowMediaStreamRequest.Builder> removeFlowMediaStreamRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return removeFlowMediaStream(RemoveFlowMediaStreamRequest.builder().applyMutation(removeFlowMediaStreamRequest).build());
    }

    /**
     * <p>
     * Removes an output from an existing flow. This request can be made only on an output that does not have an
     * entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When
     * an entitlement is revoked from a flow, the service automatically removes the associated output.
     * </p>
     *
     * @param removeFlowOutputRequest
     * @return Result of the RemoveFlowOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveFlowOutputResponse removeFlowOutput(RemoveFlowOutputRequest removeFlowOutputRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an output from an existing flow. This request can be made only on an output that does not have an
     * entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When
     * an entitlement is revoked from a flow, the service automatically removes the associated output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFlowOutputRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveFlowOutputRequest#builder()}
     * </p>
     *
     * @param removeFlowOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveFlowOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveFlowOutputResponse removeFlowOutput(Consumer<RemoveFlowOutputRequest.Builder> removeFlowOutputRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return removeFlowOutput(RemoveFlowOutputRequest.builder().applyMutation(removeFlowOutputRequest).build());
    }

    /**
     * <p>
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the
     * flow.
     * </p>
     *
     * @param removeFlowSourceRequest
     * @return Result of the RemoveFlowSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveFlowSourceResponse removeFlowSource(RemoveFlowSourceRequest removeFlowSourceRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the
     * flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFlowSourceRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveFlowSourceRequest#builder()}
     * </p>
     *
     * @param removeFlowSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveFlowSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveFlowSourceResponse removeFlowSource(Consumer<RemoveFlowSourceRequest.Builder> removeFlowSourceRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return removeFlowSource(RemoveFlowSourceRequest.builder().applyMutation(removeFlowSourceRequest).build());
    }

    /**
     * <p>
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not
     * have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must
     * first delete or update the Source or Output to no longer reference the VPC interface.
     * </p>
     *
     * @param removeFlowVpcInterfaceRequest
     * @return Result of the RemoveFlowVpcInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowVpcInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveFlowVpcInterfaceResponse removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest removeFlowVpcInterfaceRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not
     * have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must
     * first delete or update the Source or Output to no longer reference the VPC interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFlowVpcInterfaceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveFlowVpcInterfaceRequest#builder()}
     * </p>
     *
     * @param removeFlowVpcInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest.Builder} to create
     *        a request.
     * @return Result of the RemoveFlowVpcInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowVpcInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveFlowVpcInterfaceResponse removeFlowVpcInterface(
            Consumer<RemoveFlowVpcInterfaceRequest.Builder> removeFlowVpcInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest.builder().applyMutation(removeFlowVpcInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Restarts a router input. This operation can be used to recover from errors or refresh the input state.
     * </p>
     *
     * @param restartRouterInputRequest
     * @return Result of the RestartRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RestartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default RestartRouterInputResponse restartRouterInput(RestartRouterInputRequest restartRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a router input. This operation can be used to recover from errors or refresh the input state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartRouterInputRequest.Builder} avoiding the
     * need to create one manually via {@link RestartRouterInputRequest#builder()}
     * </p>
     *
     * @param restartRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputRequest.Builder} to create a
     *        request.
     * @return Result of the RestartRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RestartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default RestartRouterInputResponse restartRouterInput(Consumer<RestartRouterInputRequest.Builder> restartRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return restartRouterInput(RestartRouterInputRequest.builder().applyMutation(restartRouterInputRequest).build());
    }

    /**
     * <p>
     * Restarts a router output. This operation can be used to recover from errors or refresh the output state.
     * </p>
     *
     * @param restartRouterOutputRequest
     * @return Result of the RestartRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RestartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default RestartRouterOutputResponse restartRouterOutput(RestartRouterOutputRequest restartRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a router output. This operation can be used to recover from errors or refresh the output state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link RestartRouterOutputRequest#builder()}
     * </p>
     *
     * @param restartRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputRequest.Builder} to create a
     *        request.
     * @return Result of the RestartRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RestartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default RestartRouterOutputResponse restartRouterOutput(
            Consumer<RestartRouterOutputRequest.Builder> restartRouterOutputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return restartRouterOutput(RestartRouterOutputRequest.builder().applyMutation(restartRouterOutputRequest).build());
    }

    /**
     * <p>
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the
     * subscriber and the associated output is removed.
     * </p>
     *
     * @param revokeFlowEntitlementRequest
     * @return Result of the RevokeFlowEntitlement operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RevokeFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokeFlowEntitlementResponse revokeFlowEntitlement(RevokeFlowEntitlementRequest revokeFlowEntitlementRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the
     * subscriber and the associated output is removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeFlowEntitlementRequest.Builder} avoiding the
     * need to create one manually via {@link RevokeFlowEntitlementRequest#builder()}
     * </p>
     *
     * @param revokeFlowEntitlementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementRequest.Builder} to create
     *        a request.
     * @return Result of the RevokeFlowEntitlement operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RevokeFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokeFlowEntitlementResponse revokeFlowEntitlement(
            Consumer<RevokeFlowEntitlementRequest.Builder> revokeFlowEntitlementRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return revokeFlowEntitlement(RevokeFlowEntitlementRequest.builder().applyMutation(revokeFlowEntitlementRequest).build());
    }

    /**
     * <p>
     * Starts a flow.
     * </p>
     *
     * @param startFlowRequest
     * @return Result of the StartFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFlowResponse startFlow(StartFlowRequest startFlowRequest) throws BadRequestException, TooManyRequestsException,
            ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFlowRequest.Builder} avoiding the need to
     * create one manually via {@link StartFlowRequest#builder()}
     * </p>
     *
     * @param startFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StartFlowRequest.Builder} to create a request.
     * @return Result of the StartFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFlowResponse startFlow(Consumer<StartFlowRequest.Builder> startFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return startFlow(StartFlowRequest.builder().applyMutation(startFlowRequest).build());
    }

    /**
     * <p>
     * Starts a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param startRouterInputRequest
     * @return Result of the StartRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default StartRouterInputResponse startRouterInput(StartRouterInputRequest startRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link StartRouterInputRequest#builder()}
     * </p>
     *
     * @param startRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StartRouterInputRequest.Builder} to create a
     *        request.
     * @return Result of the StartRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default StartRouterInputResponse startRouterInput(Consumer<StartRouterInputRequest.Builder> startRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return startRouterInput(StartRouterInputRequest.builder().applyMutation(startRouterInputRequest).build());
    }

    /**
     * <p>
     * Starts a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param startRouterOutputRequest
     * @return Result of the StartRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRouterOutputResponse startRouterOutput(StartRouterOutputRequest startRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRouterOutputRequest.Builder} avoiding the need
     * to create one manually via {@link StartRouterOutputRequest#builder()}
     * </p>
     *
     * @param startRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputRequest.Builder} to create a
     *        request.
     * @return Result of the StartRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRouterOutputResponse startRouterOutput(Consumer<StartRouterOutputRequest.Builder> startRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return startRouterOutput(StartRouterOutputRequest.builder().applyMutation(startRouterOutputRequest).build());
    }

    /**
     * <p>
     * Stops a flow.
     * </p>
     *
     * @param stopFlowRequest
     * @return Result of the StopFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFlowResponse stopFlow(StopFlowRequest stopFlowRequest) throws BadRequestException, TooManyRequestsException,
            ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFlowRequest.Builder} avoiding the need to
     * create one manually via {@link StopFlowRequest#builder()}
     * </p>
     *
     * @param stopFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StopFlowRequest.Builder} to create a request.
     * @return Result of the StopFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFlowResponse stopFlow(Consumer<StopFlowRequest.Builder> stopFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return stopFlow(StopFlowRequest.builder().applyMutation(stopFlowRequest).build());
    }

    /**
     * <p>
     * Stops a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param stopRouterInputRequest
     * @return Result of the StopRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StopRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default StopRouterInputResponse stopRouterInput(StopRouterInputRequest stopRouterInputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link StopRouterInputRequest#builder()}
     * </p>
     *
     * @param stopRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StopRouterInputRequest.Builder} to create a
     *        request.
     * @return Result of the StopRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StopRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default StopRouterInputResponse stopRouterInput(Consumer<StopRouterInputRequest.Builder> stopRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return stopRouterInput(StopRouterInputRequest.builder().applyMutation(stopRouterInputRequest).build());
    }

    /**
     * <p>
     * Stops a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param stopRouterOutputRequest
     * @return Result of the StopRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StopRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default StopRouterOutputResponse stopRouterOutput(StopRouterOutputRequest stopRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRouterOutputRequest.Builder} avoiding the need
     * to create one manually via {@link StopRouterOutputRequest#builder()}
     * </p>
     *
     * @param stopRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputRequest.Builder} to create a
     *        request.
     * @return Result of the StopRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StopRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default StopRouterOutputResponse stopRouterOutput(Consumer<StopRouterOutputRequest.Builder> stopRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return stopRouterOutput(StopRouterOutputRequest.builder().applyMutation(stopRouterOutputRequest).build());
    }

    /**
     * <p>
     * Adds tags to a global resource in AWS Elemental MediaConnect. The API supports the following global resources:
     * router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param tagGlobalResourceRequest
     * @return Result of the TagGlobalResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.TagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagGlobalResourceResponse tagGlobalResource(TagGlobalResourceRequest tagGlobalResourceRequest)
            throws BadRequestException, InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException,
            MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a global resource in AWS Elemental MediaConnect. The API supports the following global resources:
     * router inputs, router outputs and router network interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagGlobalResourceRequest.Builder} avoiding the need
     * to create one manually via {@link TagGlobalResourceRequest#builder()}
     * </p>
     *
     * @param tagGlobalResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagGlobalResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.TagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagGlobalResourceResponse tagGlobalResource(Consumer<TagGlobalResourceRequest.Builder> tagGlobalResourceRequest)
            throws BadRequestException, InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException,
            MediaConnectException {
        return tagGlobalResource(TagGlobalResourceRequest.builder().applyMutation(tagGlobalResourceRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code> in the current region. If
     * existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is
     * deleted, the tags associated with that resource are deleted as well.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code> in the current region. If
     * existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is
     * deleted, the tags associated with that resource are deleted as well.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Associates a router input with a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param takeRouterInputRequest
     * @return Result of the TakeRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.TakeRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TakeRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default TakeRouterInputResponse takeRouterInput(TakeRouterInputRequest takeRouterInputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a router input with a router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TakeRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link TakeRouterInputRequest#builder()}
     * </p>
     *
     * @param takeRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputRequest.Builder} to create a
     *        request.
     * @return Result of the TakeRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.TakeRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TakeRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default TakeRouterInputResponse takeRouterInput(Consumer<TakeRouterInputRequest.Builder> takeRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return takeRouterInput(TakeRouterInputRequest.builder().applyMutation(takeRouterInputRequest).build());
    }

    /**
     * <p>
     * Removes tags from a global resource in AWS Elemental MediaConnect. The API supports the following global
     * resources: router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param untagGlobalResourceRequest
     * @return Result of the UntagGlobalResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UntagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagGlobalResourceResponse untagGlobalResource(UntagGlobalResourceRequest untagGlobalResourceRequest)
            throws BadRequestException, InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException,
            MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a global resource in AWS Elemental MediaConnect. The API supports the following global
     * resources: router inputs, router outputs and router network interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagGlobalResourceRequest.Builder} avoiding the
     * need to create one manually via {@link UntagGlobalResourceRequest#builder()}
     * </p>
     *
     * @param untagGlobalResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagGlobalResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UntagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagGlobalResourceResponse untagGlobalResource(
            Consumer<UntagGlobalResourceRequest.Builder> untagGlobalResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        return untagGlobalResource(UntagGlobalResourceRequest.builder().applyMutation(untagGlobalResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource in the current region.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException,
            MediaConnectException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the bridge.
     * </p>
     *
     * @param updateBridgeRequest
     * @return Result of the UpdateBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBridgeResponse updateBridge(UpdateBridgeRequest updateBridgeRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBridgeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBridgeRequest#builder()}
     * </p>
     *
     * @param updateBridgeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBridgeResponse updateBridge(Consumer<UpdateBridgeRequest.Builder> updateBridgeRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return updateBridge(UpdateBridgeRequest.builder().applyMutation(updateBridgeRequest).build());
    }

    /**
     * <p>
     * Updates an existing bridge output.
     * </p>
     *
     * @param updateBridgeOutputRequest
     * @return Result of the UpdateBridgeOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBridgeOutputResponse updateBridgeOutput(UpdateBridgeOutputRequest updateBridgeOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bridge output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBridgeOutputRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBridgeOutputRequest#builder()}
     * </p>
     *
     * @param updateBridgeOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateBridgeOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBridgeOutputResponse updateBridgeOutput(Consumer<UpdateBridgeOutputRequest.Builder> updateBridgeOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return updateBridgeOutput(UpdateBridgeOutputRequest.builder().applyMutation(updateBridgeOutputRequest).build());
    }

    /**
     * <p>
     * Updates an existing bridge source.
     * </p>
     *
     * @param updateBridgeSourceRequest
     * @return Result of the UpdateBridgeSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBridgeSourceResponse updateBridgeSource(UpdateBridgeSourceRequest updateBridgeSourceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bridge source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBridgeSourceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBridgeSourceRequest#builder()}
     * </p>
     *
     * @param updateBridgeSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateBridgeSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBridgeSourceResponse updateBridgeSource(Consumer<UpdateBridgeSourceRequest.Builder> updateBridgeSourceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return updateBridgeSource(UpdateBridgeSourceRequest.builder().applyMutation(updateBridgeSourceRequest).build());
    }

    /**
     * <p>
     * Updates the bridge state.
     * </p>
     *
     * @param updateBridgeStateRequest
     * @return Result of the UpdateBridgeState operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridgeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeState"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBridgeStateResponse updateBridgeState(UpdateBridgeStateRequest updateBridgeStateRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the bridge state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBridgeStateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBridgeStateRequest#builder()}
     * </p>
     *
     * @param updateBridgeStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateBridgeState operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridgeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeState"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBridgeStateResponse updateBridgeState(Consumer<UpdateBridgeStateRequest.Builder> updateBridgeStateRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return updateBridgeState(UpdateBridgeStateRequest.builder().applyMutation(updateBridgeStateRequest).build());
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     *
     * @param updateFlowRequest
     * @return Result of the UpdateFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFlowResponse updateFlow(UpdateFlowRequest updateFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFlowRequest#builder()}
     * </p>
     *
     * @param updateFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowRequest.Builder} to create a request.
     * @return Result of the UpdateFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFlowResponse updateFlow(Consumer<UpdateFlowRequest.Builder> updateFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return updateFlow(UpdateFlowRequest.builder().applyMutation(updateFlowRequest).build());
    }

    /**
     * <p>
     * Updates an entitlement. You can change an entitlement's description, subscribers, and encryption. If you change
     * the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     * </p>
     *
     * @param updateFlowEntitlementRequest
     * @return Result of the UpdateFlowEntitlement operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFlowEntitlementResponse updateFlowEntitlement(UpdateFlowEntitlementRequest updateFlowEntitlementRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an entitlement. You can change an entitlement's description, subscribers, and encryption. If you change
     * the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowEntitlementRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFlowEntitlementRequest#builder()}
     * </p>
     *
     * @param updateFlowEntitlementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateFlowEntitlement operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFlowEntitlementResponse updateFlowEntitlement(
            Consumer<UpdateFlowEntitlementRequest.Builder> updateFlowEntitlementRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return updateFlowEntitlement(UpdateFlowEntitlementRequest.builder().applyMutation(updateFlowEntitlementRequest).build());
    }

    /**
     * <p>
     * Updates an existing media stream.
     * </p>
     *
     * @param updateFlowMediaStreamRequest
     * @return Result of the UpdateFlowMediaStream operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFlowMediaStreamResponse updateFlowMediaStream(UpdateFlowMediaStreamRequest updateFlowMediaStreamRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing media stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowMediaStreamRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFlowMediaStreamRequest#builder()}
     * </p>
     *
     * @param updateFlowMediaStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateFlowMediaStream operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFlowMediaStreamResponse updateFlowMediaStream(
            Consumer<UpdateFlowMediaStreamRequest.Builder> updateFlowMediaStreamRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return updateFlowMediaStream(UpdateFlowMediaStreamRequest.builder().applyMutation(updateFlowMediaStreamRequest).build());
    }

    /**
     * <p>
     * Updates an existing flow output.
     * </p>
     *
     * @param updateFlowOutputRequest
     * @return Result of the UpdateFlowOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFlowOutputResponse updateFlowOutput(UpdateFlowOutputRequest updateFlowOutputRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing flow output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowOutputRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFlowOutputRequest#builder()}
     * </p>
     *
     * @param updateFlowOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFlowOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFlowOutputResponse updateFlowOutput(Consumer<UpdateFlowOutputRequest.Builder> updateFlowOutputRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return updateFlowOutput(UpdateFlowOutputRequest.builder().applyMutation(updateFlowOutputRequest).build());
    }

    /**
     * <p>
     * Updates the source of a flow.
     * </p>
     *
     * @param updateFlowSourceRequest
     * @return Result of the UpdateFlowSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFlowSourceResponse updateFlowSource(UpdateFlowSourceRequest updateFlowSourceRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the source of a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFlowSourceRequest#builder()}
     * </p>
     *
     * @param updateFlowSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFlowSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFlowSourceResponse updateFlowSource(Consumer<UpdateFlowSourceRequest.Builder> updateFlowSourceRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return updateFlowSource(UpdateFlowSourceRequest.builder().applyMutation(updateFlowSourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing gateway instance.
     * </p>
     *
     * @param updateGatewayInstanceRequest
     * @return Result of the UpdateGatewayInstance operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayInstanceResponse updateGatewayInstance(UpdateGatewayInstanceRequest updateGatewayInstanceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing gateway instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGatewayInstanceRequest#builder()}
     * </p>
     *
     * @param updateGatewayInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateGatewayInstance operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayInstanceResponse updateGatewayInstance(
            Consumer<UpdateGatewayInstanceRequest.Builder> updateGatewayInstanceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        return updateGatewayInstance(UpdateGatewayInstanceRequest.builder().applyMutation(updateGatewayInstanceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterInputRequest
     * @return Result of the UpdateRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRouterInputResponse updateRouterInput(UpdateRouterInputRequest updateRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRouterInputRequest#builder()}
     * </p>
     *
     * @param updateRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRouterInputResponse updateRouterInput(Consumer<UpdateRouterInputRequest.Builder> updateRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return updateRouterInput(UpdateRouterInputRequest.builder().applyMutation(updateRouterInputRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterNetworkInterfaceRequest
     * @return Result of the UpdateRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRouterNetworkInterfaceResponse updateRouterNetworkInterface(
            UpdateRouterNetworkInterfaceRequest updateRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing router network interface in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouterNetworkInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param updateRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRouterNetworkInterfaceResponse updateRouterNetworkInterface(
            Consumer<UpdateRouterNetworkInterfaceRequest.Builder> updateRouterNetworkInterfaceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        return updateRouterNetworkInterface(UpdateRouterNetworkInterfaceRequest.builder()
                .applyMutation(updateRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterOutputRequest
     * @return Result of the UpdateRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRouterOutputResponse updateRouterOutput(UpdateRouterOutputRequest updateRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRouterOutputRequest#builder()}
     * </p>
     *
     * @param updateRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRouterOutputResponse updateRouterOutput(Consumer<UpdateRouterOutputRequest.Builder> updateRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        return updateRouterOutput(UpdateRouterOutputRequest.builder().applyMutation(updateRouterOutputRequest).build());
    }

    /**
     * Create an instance of {@link MediaConnectWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link MediaConnectWaiter}
     */
    default MediaConnectWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MediaConnectClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaConnectClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaConnectClient}.
     */
    static MediaConnectClientBuilder builder() {
        return new DefaultMediaConnectClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MediaConnectServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
