/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesPublisher;
import software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsPublisher;
import software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsPublisher;
import software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesPublisher;
import software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysPublisher;
import software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsPublisher;
import software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsPublisher;
import software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsPublisher;
import software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesPublisher;
import software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsPublisher;
import software.amazon.awssdk.services.mediaconnect.waiters.MediaConnectAsyncWaiter;

/**
 * Service client for accessing AWS MediaConnect asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Welcome to the Elemental MediaConnect API reference.
 * </p>
 * <p>
 * MediaConnect is a service that lets you ingest live video content into the cloud and distribute it to destinations
 * all over the world, both inside and outside the Amazon Web Services cloud. This API reference provides descriptions,
 * syntax, and usage examples for each of the actions and data types that are supported by MediaConnect.
 * </p>
 * <p>
 * Use the following links to get started with the MediaConnect API:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/API_Operations.html">Actions</a>: An alphabetical list
 * of all MediaConnect API operations.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/API_Types.html">Data types</a>: An alphabetical list of
 * all MediaConnect data types.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/CommonParameters.html">Common parameters</a>: Parameters
 * that all operations can use.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/mediaconnect/latest/api/CommonErrors.html">Common errors</a>: Client and server
 * errors that all operations can return.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaConnectAsyncClient extends AwsClient {
    String SERVICE_NAME = "mediaconnect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mediaconnect";

    /**
     * <p>
     * Adds outputs to an existing bridge.
     * </p>
     *
     * @param addBridgeOutputsRequest
     * @return A Java Future containing the result of the AddBridgeOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddBridgeOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddBridgeOutputsResponse> addBridgeOutputs(AddBridgeOutputsRequest addBridgeOutputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds outputs to an existing bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddBridgeOutputsRequest.Builder} avoiding the need
     * to create one manually via {@link AddBridgeOutputsRequest#builder()}
     * </p>
     *
     * @param addBridgeOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddBridgeOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddBridgeOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddBridgeOutputsResponse> addBridgeOutputs(
            Consumer<AddBridgeOutputsRequest.Builder> addBridgeOutputsRequest) {
        return addBridgeOutputs(AddBridgeOutputsRequest.builder().applyMutation(addBridgeOutputsRequest).build());
    }

    /**
     * <p>
     * Adds sources to an existing bridge.
     * </p>
     *
     * @param addBridgeSourcesRequest
     * @return A Java Future containing the result of the AddBridgeSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddBridgeSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddBridgeSourcesResponse> addBridgeSources(AddBridgeSourcesRequest addBridgeSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds sources to an existing bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddBridgeSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link AddBridgeSourcesRequest#builder()}
     * </p>
     *
     * @param addBridgeSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddBridgeSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddBridgeSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddBridgeSourcesResponse> addBridgeSources(
            Consumer<AddBridgeSourcesRequest.Builder> addBridgeSourcesRequest) {
        return addBridgeSources(AddBridgeSourcesRequest.builder().applyMutation(addBridgeSourcesRequest).build());
    }

    /**
     * <p>
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a
     * source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     * </p>
     *
     * @param addFlowMediaStreamsRequest
     * @return A Java Future containing the result of the AddFlowMediaStreams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowMediaStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowMediaStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddFlowMediaStreamsResponse> addFlowMediaStreams(
            AddFlowMediaStreamsRequest addFlowMediaStreamsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a
     * source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddFlowMediaStreamsRequest.Builder} avoiding the
     * need to create one manually via {@link AddFlowMediaStreamsRequest#builder()}
     * </p>
     *
     * @param addFlowMediaStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddFlowMediaStreams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowMediaStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowMediaStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddFlowMediaStreamsResponse> addFlowMediaStreams(
            Consumer<AddFlowMediaStreamsRequest.Builder> addFlowMediaStreamsRequest) {
        return addFlowMediaStreams(AddFlowMediaStreamsRequest.builder().applyMutation(addFlowMediaStreamsRequest).build());
    }

    /**
     * <p>
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     * </p>
     *
     * @param addFlowOutputsRequest
     * @return A Java Future containing the result of the AddFlowOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>AddFlowOutputs420Exception Exception raised by Elemental MediaConnect when adding the flow output.
     *         See the error message for the operation for more information on the cause of this exception.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddFlowOutputsResponse> addFlowOutputs(AddFlowOutputsRequest addFlowOutputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddFlowOutputsRequest.Builder} avoiding the need to
     * create one manually via {@link AddFlowOutputsRequest#builder()}
     * </p>
     *
     * @param addFlowOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddFlowOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>AddFlowOutputs420Exception Exception raised by Elemental MediaConnect when adding the flow output.
     *         See the error message for the operation for more information on the cause of this exception.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddFlowOutputsResponse> addFlowOutputs(Consumer<AddFlowOutputsRequest.Builder> addFlowOutputsRequest) {
        return addFlowOutputs(AddFlowOutputsRequest.builder().applyMutation(addFlowOutputsRequest).build());
    }

    /**
     * <p>
     * Adds sources to a flow.
     * </p>
     *
     * @param addFlowSourcesRequest
     * @return A Java Future containing the result of the AddFlowSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddFlowSourcesResponse> addFlowSources(AddFlowSourcesRequest addFlowSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds sources to a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddFlowSourcesRequest.Builder} avoiding the need to
     * create one manually via {@link AddFlowSourcesRequest#builder()}
     * </p>
     *
     * @param addFlowSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddFlowSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AddFlowSourcesResponse> addFlowSources(Consumer<AddFlowSourcesRequest.Builder> addFlowSourcesRequest) {
        return addFlowSources(AddFlowSourcesRequest.builder().applyMutation(addFlowSourcesRequest).build());
    }

    /**
     * <p>
     * Adds VPC interfaces to a flow.
     * </p>
     *
     * @param addFlowVpcInterfacesRequest
     * @return A Java Future containing the result of the AddFlowVpcInterfaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowVpcInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddFlowVpcInterfacesResponse> addFlowVpcInterfaces(
            AddFlowVpcInterfacesRequest addFlowVpcInterfacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds VPC interfaces to a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddFlowVpcInterfacesRequest.Builder} avoiding the
     * need to create one manually via {@link AddFlowVpcInterfacesRequest#builder()}
     * </p>
     *
     * @param addFlowVpcInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddFlowVpcInterfaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.AddFlowVpcInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddFlowVpcInterfacesResponse> addFlowVpcInterfaces(
            Consumer<AddFlowVpcInterfacesRequest.Builder> addFlowVpcInterfacesRequest) {
        return addFlowVpcInterfaces(AddFlowVpcInterfacesRequest.builder().applyMutation(addFlowVpcInterfacesRequest).build());
    }

    /**
     * <p>
     * Retrieves information about multiple router inputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterInputRequest
     * @return A Java Future containing the result of the BatchGetRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.BatchGetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRouterInputResponse> batchGetRouterInput(
            BatchGetRouterInputRequest batchGetRouterInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about multiple router inputs in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetRouterInputRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetRouterInputRequest#builder()}
     * </p>
     *
     * @param batchGetRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.BatchGetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRouterInputResponse> batchGetRouterInput(
            Consumer<BatchGetRouterInputRequest.Builder> batchGetRouterInputRequest) {
        return batchGetRouterInput(BatchGetRouterInputRequest.builder().applyMutation(batchGetRouterInputRequest).build());
    }

    /**
     * <p>
     * Retrieves information about multiple router network interfaces in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the BatchGetRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.BatchGetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRouterNetworkInterfaceResponse> batchGetRouterNetworkInterface(
            BatchGetRouterNetworkInterfaceRequest batchGetRouterNetworkInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about multiple router network interfaces in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetRouterNetworkInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param batchGetRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchGetRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.BatchGetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRouterNetworkInterfaceResponse> batchGetRouterNetworkInterface(
            Consumer<BatchGetRouterNetworkInterfaceRequest.Builder> batchGetRouterNetworkInterfaceRequest) {
        return batchGetRouterNetworkInterface(BatchGetRouterNetworkInterfaceRequest.builder()
                .applyMutation(batchGetRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about multiple router outputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterOutputRequest
     * @return A Java Future containing the result of the BatchGetRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.BatchGetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRouterOutputResponse> batchGetRouterOutput(
            BatchGetRouterOutputRequest batchGetRouterOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about multiple router outputs in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetRouterOutputRequest#builder()}
     * </p>
     *
     * @param batchGetRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.BatchGetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRouterOutputResponse> batchGetRouterOutput(
            Consumer<BatchGetRouterOutputRequest.Builder> batchGetRouterOutputRequest) {
        return batchGetRouterOutput(BatchGetRouterOutputRequest.builder().applyMutation(batchGetRouterOutputRequest).build());
    }

    /**
     * <p>
     * Creates a new bridge. The request must include one source.
     * </p>
     *
     * @param createBridgeRequest
     * @return A Java Future containing the result of the CreateBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>CreateBridge420Exception Exception raised by Elemental MediaConnect when creating the bridge. See the
     *         error message for the operation for more information on the cause of this exception.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBridgeResponse> createBridge(CreateBridgeRequest createBridgeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new bridge. The request must include one source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBridgeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBridgeRequest#builder()}
     * </p>
     *
     * @param createBridgeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateBridgeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>CreateBridge420Exception Exception raised by Elemental MediaConnect when creating the bridge. See the
     *         error message for the operation for more information on the cause of this exception.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBridgeResponse> createBridge(Consumer<CreateBridgeRequest.Builder> createBridgeRequest) {
        return createBridge(CreateBridgeRequest.builder().applyMutation(createBridgeRequest).build());
    }

    /**
     * <p>
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50)
     * and entitlements (up to 50).
     * </p>
     *
     * @param createFlowRequest
     * @return A Java Future containing the result of the CreateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>CreateFlow420Exception Exception raised by Elemental MediaConnect when creating the flow. See the
     *         error message for the operation for more information on the cause of this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFlowResponse> createFlow(CreateFlowRequest createFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50)
     * and entitlements (up to 50).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFlowRequest#builder()}
     * </p>
     *
     * @param createFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>CreateFlow420Exception Exception raised by Elemental MediaConnect when creating the flow. See the
     *         error message for the operation for more information on the cause of this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFlowResponse> createFlow(Consumer<CreateFlowRequest.Builder> createFlowRequest) {
        return createFlow(CreateFlowRequest.builder().applyMutation(createFlowRequest).build());
    }

    /**
     * <p>
     * Creates a new gateway. The request must include at least one network (up to four).
     * </p>
     *
     * @param createGatewayRequest
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>CreateGateway420Exception Exception raised by Elemental MediaConnect when creating the gateway. See
     *         the error message for the operation for more information on the cause of this exception.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGatewayResponse> createGateway(CreateGatewayRequest createGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new gateway. The request must include at least one network (up to four).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGatewayRequest#builder()}
     * </p>
     *
     * @param createGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>CreateGateway420Exception Exception raised by Elemental MediaConnect when creating the gateway. See
     *         the error message for the operation for more information on the cause of this exception.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGatewayResponse> createGateway(Consumer<CreateGatewayRequest.Builder> createGatewayRequest) {
        return createGateway(CreateGatewayRequest.builder().applyMutation(createGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a new router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterInputRequest
     * @return A Java Future containing the result of the CreateRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>RouterInputServiceQuotaExceededException The request to create a new router input would exceed the
     *         service quotas for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRouterInputResponse> createRouterInput(CreateRouterInputRequest createRouterInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRouterInputRequest#builder()}
     * </p>
     *
     * @param createRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>RouterInputServiceQuotaExceededException The request to create a new router input would exceed the
     *         service quotas for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRouterInputResponse> createRouterInput(
            Consumer<CreateRouterInputRequest.Builder> createRouterInputRequest) {
        return createRouterInput(CreateRouterInputRequest.builder().applyMutation(createRouterInputRequest).build());
    }

    /**
     * <p>
     * Creates a new router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the CreateRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>RouterNetworkInterfaceServiceQuotaExceededException The request to create a new router network
     *         interface would exceed the service quotas (limits) set for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRouterNetworkInterfaceResponse> createRouterNetworkInterface(
            CreateRouterNetworkInterfaceRequest createRouterNetworkInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new router network interface in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouterNetworkInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param createRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>RouterNetworkInterfaceServiceQuotaExceededException The request to create a new router network
     *         interface would exceed the service quotas (limits) set for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRouterNetworkInterfaceResponse> createRouterNetworkInterface(
            Consumer<CreateRouterNetworkInterfaceRequest.Builder> createRouterNetworkInterfaceRequest) {
        return createRouterNetworkInterface(CreateRouterNetworkInterfaceRequest.builder()
                .applyMutation(createRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Creates a new router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterOutputRequest
     * @return A Java Future containing the result of the CreateRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>RouterOutputServiceQuotaExceededException The request to create a new router output would exceed the
     *         service quotas (limits) set for the account.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRouterOutputResponse> createRouterOutput(CreateRouterOutputRequest createRouterOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRouterOutputRequest#builder()}
     * </p>
     *
     * @param createRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>RouterOutputServiceQuotaExceededException The request to create a new router output would exceed the
     *         service quotas (limits) set for the account.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.CreateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRouterOutputResponse> createRouterOutput(
            Consumer<CreateRouterOutputRequest.Builder> createRouterOutputRequest) {
        return createRouterOutput(CreateRouterOutputRequest.builder().applyMutation(createRouterOutputRequest).build());
    }

    /**
     * <p>
     * Deletes a bridge. Before you can delete a bridge, you must stop the bridge.
     * </p>
     *
     * @param deleteBridgeRequest
     * @return A Java Future containing the result of the DeleteBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBridgeResponse> deleteBridge(DeleteBridgeRequest deleteBridgeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a bridge. Before you can delete a bridge, you must stop the bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBridgeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBridgeRequest#builder()}
     * </p>
     *
     * @param deleteBridgeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBridgeResponse> deleteBridge(Consumer<DeleteBridgeRequest.Builder> deleteBridgeRequest) {
        return deleteBridge(DeleteBridgeRequest.builder().applyMutation(deleteBridgeRequest).build());
    }

    /**
     * <p>
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     * </p>
     *
     * @param deleteFlowRequest
     * @return A Java Future containing the result of the DeleteFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFlowResponse> deleteFlow(DeleteFlowRequest deleteFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFlowRequest#builder()}
     * </p>
     *
     * @param deleteFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFlowResponse> deleteFlow(Consumer<DeleteFlowRequest.Builder> deleteFlowRequest) {
        return deleteFlow(DeleteFlowRequest.builder().applyMutation(deleteFlowRequest).build());
    }

    /**
     * <p>
     * Deletes a gateway. Before you can delete a gateway, you must deregister its instances and delete its bridges.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a gateway. Before you can delete a gateway, you must deregister its instances and delete its bridges.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGatewayRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayResponse> deleteGateway(Consumer<DeleteGatewayRequest.Builder> deleteGatewayRequest) {
        return deleteGateway(DeleteGatewayRequest.builder().applyMutation(deleteGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a router input from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterInputRequest
     * @return A Java Future containing the result of the DeleteRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRouterInputResponse> deleteRouterInput(DeleteRouterInputRequest deleteRouterInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a router input from AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRouterInputRequest#builder()}
     * </p>
     *
     * @param deleteRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRouterInputResponse> deleteRouterInput(
            Consumer<DeleteRouterInputRequest.Builder> deleteRouterInputRequest) {
        return deleteRouterInput(DeleteRouterInputRequest.builder().applyMutation(deleteRouterInputRequest).build());
    }

    /**
     * <p>
     * Deletes a router network interface from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the DeleteRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRouterNetworkInterfaceResponse> deleteRouterNetworkInterface(
            DeleteRouterNetworkInterfaceRequest deleteRouterNetworkInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a router network interface from AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouterNetworkInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param deleteRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRouterNetworkInterfaceResponse> deleteRouterNetworkInterface(
            Consumer<DeleteRouterNetworkInterfaceRequest.Builder> deleteRouterNetworkInterfaceRequest) {
        return deleteRouterNetworkInterface(DeleteRouterNetworkInterfaceRequest.builder()
                .applyMutation(deleteRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Deletes a router output from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterOutputRequest
     * @return A Java Future containing the result of the DeleteRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRouterOutputResponse> deleteRouterOutput(DeleteRouterOutputRequest deleteRouterOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a router output from AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRouterOutputRequest#builder()}
     * </p>
     *
     * @param deleteRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeleteRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRouterOutputResponse> deleteRouterOutput(
            Consumer<DeleteRouterOutputRequest.Builder> deleteRouterOutputRequest) {
        return deleteRouterOutput(DeleteRouterOutputRequest.builder().applyMutation(deleteRouterOutputRequest).build());
    }

    /**
     * <p>
     * Deregisters an instance. Before you deregister an instance, all bridges running on the instance must be stopped.
     * If you want to deregister an instance without stopping the bridges, you must use the --force option.
     * </p>
     *
     * @param deregisterGatewayInstanceRequest
     * @return A Java Future containing the result of the DeregisterGatewayInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeregisterGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeregisterGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterGatewayInstanceResponse> deregisterGatewayInstance(
            DeregisterGatewayInstanceRequest deregisterGatewayInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an instance. Before you deregister an instance, all bridges running on the instance must be stopped.
     * If you want to deregister an instance without stopping the bridges, you must use the --force option.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterGatewayInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterGatewayInstanceRequest#builder()}
     * </p>
     *
     * @param deregisterGatewayInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeregisterGatewayInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DeregisterGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeregisterGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterGatewayInstanceResponse> deregisterGatewayInstance(
            Consumer<DeregisterGatewayInstanceRequest.Builder> deregisterGatewayInstanceRequest) {
        return deregisterGatewayInstance(DeregisterGatewayInstanceRequest.builder()
                .applyMutation(deregisterGatewayInstanceRequest).build());
    }

    /**
     * <p>
     * Displays the details of a bridge.
     * </p>
     *
     * @param describeBridgeRequest
     * @return A Java Future containing the result of the DescribeBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeBridge" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeBridgeResponse> describeBridge(DescribeBridgeRequest describeBridgeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of a bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBridgeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBridgeRequest#builder()}
     * </p>
     *
     * @param describeBridgeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeBridge" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeBridgeResponse> describeBridge(Consumer<DescribeBridgeRequest.Builder> describeBridgeRequest) {
        return describeBridge(DescribeBridgeRequest.builder().applyMutation(describeBridgeRequest).build());
    }

    /**
     * <p>
     * Displays the details of a flow. The response includes the flow Amazon Resource Name (ARN), name, and Availability
     * Zone, as well as details about the source, outputs, and entitlements.
     * </p>
     *
     * @param describeFlowRequest
     * @return A Java Future containing the result of the DescribeFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFlowResponse> describeFlow(DescribeFlowRequest describeFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of a flow. The response includes the flow Amazon Resource Name (ARN), name, and Availability
     * Zone, as well as details about the source, outputs, and entitlements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFlowRequest#builder()}
     * </p>
     *
     * @param describeFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFlowResponse> describeFlow(Consumer<DescribeFlowRequest.Builder> describeFlowRequest) {
        return describeFlow(DescribeFlowRequest.builder().applyMutation(describeFlowRequest).build());
    }

    /**
     * <p>
     * The <code>DescribeFlowSourceMetadata</code> API is used to view information about the flow's source transport
     * stream and programs. This API displays status messages about the flow's source as well as details about the
     * program's video, audio, and other data.
     * </p>
     *
     * @param describeFlowSourceMetadataRequest
     * @return A Java Future containing the result of the DescribeFlowSourceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeFlowSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFlowSourceMetadataResponse> describeFlowSourceMetadata(
            DescribeFlowSourceMetadataRequest describeFlowSourceMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DescribeFlowSourceMetadata</code> API is used to view information about the flow's source transport
     * stream and programs. This API displays status messages about the flow's source as well as details about the
     * program's video, audio, and other data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowSourceMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFlowSourceMetadataRequest#builder()}
     * </p>
     *
     * @param describeFlowSourceMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeFlowSourceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeFlowSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFlowSourceMetadataResponse> describeFlowSourceMetadata(
            Consumer<DescribeFlowSourceMetadataRequest.Builder> describeFlowSourceMetadataRequest) {
        return describeFlowSourceMetadata(DescribeFlowSourceMetadataRequest.builder()
                .applyMutation(describeFlowSourceMetadataRequest).build());
    }

    /**
     * <p>
     * Describes the thumbnail for the flow source.
     * </p>
     *
     * @param describeFlowSourceThumbnailRequest
     * @return A Java Future containing the result of the DescribeFlowSourceThumbnail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeFlowSourceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFlowSourceThumbnailResponse> describeFlowSourceThumbnail(
            DescribeFlowSourceThumbnailRequest describeFlowSourceThumbnailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the thumbnail for the flow source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowSourceThumbnailRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFlowSourceThumbnailRequest#builder()}
     * </p>
     *
     * @param describeFlowSourceThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeFlowSourceThumbnail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeFlowSourceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFlowSourceThumbnailResponse> describeFlowSourceThumbnail(
            Consumer<DescribeFlowSourceThumbnailRequest.Builder> describeFlowSourceThumbnailRequest) {
        return describeFlowSourceThumbnail(DescribeFlowSourceThumbnailRequest.builder()
                .applyMutation(describeFlowSourceThumbnailRequest).build());
    }

    /**
     * <p>
     * Displays the details of a gateway. The response includes the gateway Amazon Resource Name (ARN), name, and CIDR
     * blocks, as well as details about the networks.
     * </p>
     *
     * @param describeGatewayRequest
     * @return A Java Future containing the result of the DescribeGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayResponse> describeGateway(DescribeGatewayRequest describeGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of a gateway. The response includes the gateway Amazon Resource Name (ARN), name, and CIDR
     * blocks, as well as details about the networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeGatewayRequest#builder()}
     * </p>
     *
     * @param describeGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayResponse> describeGateway(
            Consumer<DescribeGatewayRequest.Builder> describeGatewayRequest) {
        return describeGateway(DescribeGatewayRequest.builder().applyMutation(describeGatewayRequest).build());
    }

    /**
     * <p>
     * Displays the details of an instance.
     * </p>
     *
     * @param describeGatewayInstanceRequest
     * @return A Java Future containing the result of the DescribeGatewayInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayInstanceResponse> describeGatewayInstance(
            DescribeGatewayInstanceRequest describeGatewayInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of an instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGatewayInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGatewayInstanceRequest#builder()}
     * </p>
     *
     * @param describeGatewayInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeGatewayInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGatewayInstanceResponse> describeGatewayInstance(
            Consumer<DescribeGatewayInstanceRequest.Builder> describeGatewayInstanceRequest) {
        return describeGatewayInstance(DescribeGatewayInstanceRequest.builder().applyMutation(describeGatewayInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Displays the details of an offering. The response includes the offering description, duration, outbound
     * bandwidth, price, and Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeOfferingRequest
     * @return A Java Future containing the result of the DescribeOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeOfferingResponse> describeOffering(DescribeOfferingRequest describeOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of an offering. The response includes the offering description, duration, outbound
     * bandwidth, price, and Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOfferingRequest#builder()}
     * </p>
     *
     * @param describeOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeOfferingResponse> describeOffering(
            Consumer<DescribeOfferingRequest.Builder> describeOfferingRequest) {
        return describeOffering(DescribeOfferingRequest.builder().applyMutation(describeOfferingRequest).build());
    }

    /**
     * <p>
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time,
     * and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound
     * bandwidth).
     * </p>
     *
     * @param describeReservationRequest
     * @return A Java Future containing the result of the DescribeReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservationResponse> describeReservation(
            DescribeReservationRequest describeReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time,
     * and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound
     * bandwidth).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservationRequest#builder()}
     * </p>
     *
     * @param describeReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.DescribeReservationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservationResponse> describeReservation(
            Consumer<DescribeReservationRequest.Builder> describeReservationRequest) {
        return describeReservation(DescribeReservationRequest.builder().applyMutation(describeReservationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterInputRequest
     * @return A Java Future containing the result of the GetRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRouterInputResponse> getRouterInput(GetRouterInputRequest getRouterInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterInputRequest.Builder} avoiding the need to
     * create one manually via {@link GetRouterInputRequest#builder()}
     * </p>
     *
     * @param getRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRouterInputResponse> getRouterInput(Consumer<GetRouterInputRequest.Builder> getRouterInputRequest) {
        return getRouterInput(GetRouterInputRequest.builder().applyMutation(getRouterInputRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed metadata information about a specific router input source, including stream details and
     * connection state.
     * </p>
     *
     * @param getRouterInputSourceMetadataRequest
     * @return A Java Future containing the result of the GetRouterInputSourceMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterInputSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRouterInputSourceMetadataResponse> getRouterInputSourceMetadata(
            GetRouterInputSourceMetadataRequest getRouterInputSourceMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed metadata information about a specific router input source, including stream details and
     * connection state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterInputSourceMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetRouterInputSourceMetadataRequest#builder()}
     * </p>
     *
     * @param getRouterInputSourceMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRouterInputSourceMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterInputSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRouterInputSourceMetadataResponse> getRouterInputSourceMetadata(
            Consumer<GetRouterInputSourceMetadataRequest.Builder> getRouterInputSourceMetadataRequest) {
        return getRouterInputSourceMetadata(GetRouterInputSourceMetadataRequest.builder()
                .applyMutation(getRouterInputSourceMetadataRequest).build());
    }

    /**
     * <p>
     * Retrieves the thumbnail for a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterInputThumbnailRequest
     * @return A Java Future containing the result of the GetRouterInputThumbnail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterInputThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRouterInputThumbnailResponse> getRouterInputThumbnail(
            GetRouterInputThumbnailRequest getRouterInputThumbnailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the thumbnail for a router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterInputThumbnailRequest.Builder} avoiding
     * the need to create one manually via {@link GetRouterInputThumbnailRequest#builder()}
     * </p>
     *
     * @param getRouterInputThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRouterInputThumbnail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterInputThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRouterInputThumbnailResponse> getRouterInputThumbnail(
            Consumer<GetRouterInputThumbnailRequest.Builder> getRouterInputThumbnailRequest) {
        return getRouterInputThumbnail(GetRouterInputThumbnailRequest.builder().applyMutation(getRouterInputThumbnailRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a specific router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the GetRouterNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRouterNetworkInterfaceResponse> getRouterNetworkInterface(
            GetRouterNetworkInterfaceRequest getRouterNetworkInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific router network interface in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterNetworkInterfaceRequest.Builder} avoiding
     * the need to create one manually via {@link GetRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param getRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRouterNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRouterNetworkInterfaceResponse> getRouterNetworkInterface(
            Consumer<GetRouterNetworkInterfaceRequest.Builder> getRouterNetworkInterfaceRequest) {
        return getRouterNetworkInterface(GetRouterNetworkInterfaceRequest.builder()
                .applyMutation(getRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterOutputRequest
     * @return A Java Future containing the result of the GetRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRouterOutputResponse> getRouterOutput(GetRouterOutputRequest getRouterOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRouterOutputRequest.Builder} avoiding the need
     * to create one manually via {@link GetRouterOutputRequest#builder()}
     * </p>
     *
     * @param getRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRouterOutputResponse> getRouterOutput(
            Consumer<GetRouterOutputRequest.Builder> getRouterOutputRequest) {
        return getRouterOutput(GetRouterOutputRequest.builder().applyMutation(getRouterOutputRequest).build());
    }

    /**
     * <p>
     * Grants entitlements to an existing flow.
     * </p>
     *
     * @param grantFlowEntitlementsRequest
     * @return A Java Future containing the result of the GrantFlowEntitlements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>GrantFlowEntitlements420Exception Exception raised by Elemental MediaConnect when granting the
     *         entitlement. See the error message for the operation for more information on the cause of this exception.
     *         </li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GrantFlowEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GrantFlowEntitlementsResponse> grantFlowEntitlements(
            GrantFlowEntitlementsRequest grantFlowEntitlementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants entitlements to an existing flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GrantFlowEntitlementsRequest.Builder} avoiding the
     * need to create one manually via {@link GrantFlowEntitlementsRequest#builder()}
     * </p>
     *
     * @param grantFlowEntitlementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GrantFlowEntitlements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>GrantFlowEntitlements420Exception Exception raised by Elemental MediaConnect when granting the
     *         entitlement. See the error message for the operation for more information on the cause of this exception.
     *         </li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.GrantFlowEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GrantFlowEntitlementsResponse> grantFlowEntitlements(
            Consumer<GrantFlowEntitlementsRequest.Builder> grantFlowEntitlementsRequest) {
        return grantFlowEntitlements(GrantFlowEntitlementsRequest.builder().applyMutation(grantFlowEntitlementsRequest).build());
    }

    /**
     * <p>
     * Displays a list of bridges that are associated with this account and an optionally specified Amazon Resource Name
     * (ARN). This request returns a paginated result.
     * </p>
     *
     * @param listBridgesRequest
     * @return A Java Future containing the result of the ListBridges operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBridgesResponse> listBridges(ListBridgesRequest listBridgesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of bridges that are associated with this account and an optionally specified Amazon Resource Name
     * (ARN). This request returns a paginated result.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBridgesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBridgesRequest#builder()}
     * </p>
     *
     * @param listBridgesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBridges operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBridgesResponse> listBridges(Consumer<ListBridgesRequest.Builder> listBridgesRequest) {
        return listBridges(ListBridgesRequest.builder().applyMutation(listBridgesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBridges(software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesPublisher publisher = client.listBridgesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesPublisher publisher = client.listBridgesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBridges(software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest)} operation.</b>
     * </p>
     *
     * @param listBridgesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBridgesPublisher listBridgesPaginator(ListBridgesRequest listBridgesRequest) {
        return new ListBridgesPublisher(this, listBridgesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listBridges(software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesPublisher publisher = client.listBridgesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListBridgesPublisher publisher = client.listBridgesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBridges(software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBridgesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBridgesRequest#builder()}
     * </p>
     *
     * @param listBridgesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBridgesPublisher listBridgesPaginator(Consumer<ListBridgesRequest.Builder> listBridgesRequest) {
        return listBridgesPaginator(ListBridgesRequest.builder().applyMutation(listBridgesRequest).build());
    }

    /**
     * <p>
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per
     * page.
     * </p>
     *
     * @param listEntitlementsRequest
     * @return A Java Future containing the result of the ListEntitlements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEntitlementsResponse> listEntitlements(ListEntitlementsRequest listEntitlementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per
     * page.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitlementsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEntitlementsRequest#builder()}
     * </p>
     *
     * @param listEntitlementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEntitlements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEntitlementsResponse> listEntitlements(
            Consumer<ListEntitlementsRequest.Builder> listEntitlementsRequest) {
        return listEntitlements(ListEntitlementsRequest.builder().applyMutation(listEntitlementsRequest).build());
    }

    /**
     * <p>
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per
     * page.
     * </p>
     *
     * @return A Java Future containing the result of the ListEntitlements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEntitlementsResponse> listEntitlements() {
        return listEntitlements(ListEntitlementsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsPublisher publisher = client.listEntitlementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsPublisher publisher = client.listEntitlementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEntitlementsPublisher listEntitlementsPaginator() {
        return listEntitlementsPaginator(ListEntitlementsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsPublisher publisher = client.listEntitlementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsPublisher publisher = client.listEntitlementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitlementsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEntitlementsPublisher listEntitlementsPaginator(ListEntitlementsRequest listEntitlementsRequest) {
        return new ListEntitlementsPublisher(this, listEntitlementsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsPublisher publisher = client.listEntitlementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListEntitlementsPublisher publisher = client.listEntitlementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitlements(software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitlementsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEntitlementsRequest#builder()}
     * </p>
     *
     * @param listEntitlementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEntitlementsPublisher listEntitlementsPaginator(Consumer<ListEntitlementsRequest.Builder> listEntitlementsRequest) {
        return listEntitlementsPaginator(ListEntitlementsRequest.builder().applyMutation(listEntitlementsRequest).build());
    }

    /**
     * <p>
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @param listFlowsRequest
     * @return A Java Future containing the result of the ListFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFlowsResponse> listFlows(ListFlowsRequest listFlowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlowsRequest#builder()}
     * </p>
     *
     * @param listFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFlowsResponse> listFlows(Consumer<ListFlowsRequest.Builder> listFlowsRequest) {
        return listFlows(ListFlowsRequest.builder().applyMutation(listFlowsRequest).build());
    }

    /**
     * <p>
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @return A Java Future containing the result of the ListFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFlowsResponse> listFlows() {
        return listFlows(ListFlowsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsPublisher listFlowsPaginator() {
        return listFlowsPaginator(ListFlowsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)} operation.</b>
     * </p>
     *
     * @param listFlowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsPublisher listFlowsPaginator(ListFlowsRequest listFlowsRequest) {
        return new ListFlowsPublisher(this, listFlowsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListFlowsPublisher publisher = client.listFlowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlows(software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFlowsRequest#builder()}
     * </p>
     *
     * @param listFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFlowsPublisher listFlowsPaginator(Consumer<ListFlowsRequest.Builder> listFlowsRequest) {
        return listFlowsPaginator(ListFlowsRequest.builder().applyMutation(listFlowsRequest).build());
    }

    /**
     * <p>
     * Displays a list of instances associated with the Amazon Web Services account. This request returns a paginated
     * result. You can use the filterArn property to display only the instances associated with the selected Gateway
     * Amazon Resource Name (ARN).
     * </p>
     *
     * @param listGatewayInstancesRequest
     * @return A Java Future containing the result of the ListGatewayInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGatewayInstancesResponse> listGatewayInstances(
            ListGatewayInstancesRequest listGatewayInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of instances associated with the Amazon Web Services account. This request returns a paginated
     * result. You can use the filterArn property to display only the instances associated with the selected Gateway
     * Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGatewayInstancesRequest#builder()}
     * </p>
     *
     * @param listGatewayInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGatewayInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGatewayInstancesResponse> listGatewayInstances(
            Consumer<ListGatewayInstancesRequest.Builder> listGatewayInstancesRequest) {
        return listGatewayInstances(ListGatewayInstancesRequest.builder().applyMutation(listGatewayInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGatewayInstances(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesPublisher publisher = client.listGatewayInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesPublisher publisher = client.listGatewayInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayInstances(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewayInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayInstancesPublisher listGatewayInstancesPaginator(ListGatewayInstancesRequest listGatewayInstancesRequest) {
        return new ListGatewayInstancesPublisher(this, listGatewayInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGatewayInstances(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesPublisher publisher = client.listGatewayInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewayInstancesPublisher publisher = client.listGatewayInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayInstances(software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGatewayInstancesRequest#builder()}
     * </p>
     *
     * @param listGatewayInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayInstancesPublisher listGatewayInstancesPaginator(
            Consumer<ListGatewayInstancesRequest.Builder> listGatewayInstancesRequest) {
        return listGatewayInstancesPaginator(ListGatewayInstancesRequest.builder().applyMutation(listGatewayInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Displays a list of gateways that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @param listGatewaysRequest
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of gateways that are associated with this account. This request returns a paginated result.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) {
        return new ListGatewaysPublisher(this, listGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Displays a list of all offerings that are available to this account in the current Amazon Web Services Region. If
     * you have an active reservation (which means you've purchased an offering that has already started and hasn't
     * expired yet), your account isn't eligible for other offerings.
     * </p>
     *
     * @param listOfferingsRequest
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings(ListOfferingsRequest listOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of all offerings that are available to this account in the current Amazon Web Services Region. If
     * you have an active reservation (which means you've purchased an offering that has already started and hasn't
     * expired yet), your account isn't eligible for other offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest) {
        return listOfferings(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) {
        return new ListOfferingsPublisher(this, listOfferingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest) {
        return listOfferingsPaginator(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * <p>
     * Displays a list of all reservations that have been purchased by this account in the current Amazon Web Services
     * Region. This list includes all reservations in all states (such as active and expired).
     * </p>
     *
     * @param listReservationsRequest
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations(ListReservationsRequest listReservationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of all reservations that have been purchased by this account in the current Amazon Web Services
     * Region. This list includes all reservations in all states (such as active and expired).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations(
            Consumer<ListReservationsRequest.Builder> listReservationsRequest) {
        return listReservations(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator(ListReservationsRequest listReservationsRequest) {
        return new ListReservationsPublisher(this, listReservationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator(Consumer<ListReservationsRequest.Builder> listReservationsRequest) {
        return listReservationsPaginator(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of router inputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterInputsRequest
     * @return A Java Future containing the result of the ListRouterInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRouterInputsResponse> listRouterInputs(ListRouterInputsRequest listRouterInputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of router inputs in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterInputsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRouterInputsRequest#builder()}
     * </p>
     *
     * @param listRouterInputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRouterInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRouterInputsResponse> listRouterInputs(
            Consumer<ListRouterInputsRequest.Builder> listRouterInputsRequest) {
        return listRouterInputs(ListRouterInputsRequest.builder().applyMutation(listRouterInputsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterInputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsPublisher publisher = client.listRouterInputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsPublisher publisher = client.listRouterInputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterInputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRouterInputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouterInputsPublisher listRouterInputsPaginator(ListRouterInputsRequest listRouterInputsRequest) {
        return new ListRouterInputsPublisher(this, listRouterInputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterInputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsPublisher publisher = client.listRouterInputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterInputsPublisher publisher = client.listRouterInputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterInputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterInputsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRouterInputsRequest#builder()}
     * </p>
     *
     * @param listRouterInputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRouterInputsPublisher listRouterInputsPaginator(Consumer<ListRouterInputsRequest.Builder> listRouterInputsRequest) {
        return listRouterInputsPaginator(ListRouterInputsRequest.builder().applyMutation(listRouterInputsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of router network interfaces in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     * @return A Java Future containing the result of the ListRouterNetworkInterfaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRouterNetworkInterfacesResponse> listRouterNetworkInterfaces(
            ListRouterNetworkInterfacesRequest listRouterNetworkInterfacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of router network interfaces in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterNetworkInterfacesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRouterNetworkInterfacesRequest#builder()}
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRouterNetworkInterfaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRouterNetworkInterfacesResponse> listRouterNetworkInterfaces(
            Consumer<ListRouterNetworkInterfacesRequest.Builder> listRouterNetworkInterfacesRequest) {
        return listRouterNetworkInterfaces(ListRouterNetworkInterfacesRequest.builder()
                .applyMutation(listRouterNetworkInterfacesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterNetworkInterfaces(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesPublisher publisher = client.listRouterNetworkInterfacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesPublisher publisher = client.listRouterNetworkInterfacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterNetworkInterfaces(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterNetworkInterfacesPublisher listRouterNetworkInterfacesPaginator(
            ListRouterNetworkInterfacesRequest listRouterNetworkInterfacesRequest) {
        return new ListRouterNetworkInterfacesPublisher(this, listRouterNetworkInterfacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterNetworkInterfaces(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesPublisher publisher = client.listRouterNetworkInterfacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterNetworkInterfacesPublisher publisher = client.listRouterNetworkInterfacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterNetworkInterfaces(software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterNetworkInterfacesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRouterNetworkInterfacesRequest#builder()}
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterNetworkInterfacesPublisher listRouterNetworkInterfacesPaginator(
            Consumer<ListRouterNetworkInterfacesRequest.Builder> listRouterNetworkInterfacesRequest) {
        return listRouterNetworkInterfacesPaginator(ListRouterNetworkInterfacesRequest.builder()
                .applyMutation(listRouterNetworkInterfacesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of router outputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterOutputsRequest
     * @return A Java Future containing the result of the ListRouterOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRouterOutputsResponse> listRouterOutputs(ListRouterOutputsRequest listRouterOutputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of router outputs in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterOutputsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRouterOutputsRequest#builder()}
     * </p>
     *
     * @param listRouterOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRouterOutputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRouterOutputsResponse> listRouterOutputs(
            Consumer<ListRouterOutputsRequest.Builder> listRouterOutputsRequest) {
        return listRouterOutputs(ListRouterOutputsRequest.builder().applyMutation(listRouterOutputsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterOutputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsPublisher publisher = client.listRouterOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsPublisher publisher = client.listRouterOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterOutputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRouterOutputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterOutputsPublisher listRouterOutputsPaginator(ListRouterOutputsRequest listRouterOutputsRequest) {
        return new ListRouterOutputsPublisher(this, listRouterOutputsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRouterOutputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsPublisher publisher = client.listRouterOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconnect.paginators.ListRouterOutputsPublisher publisher = client.listRouterOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRouterOutputs(software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRouterOutputsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRouterOutputsRequest#builder()}
     * </p>
     *
     * @param listRouterOutputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRouterOutputsPublisher listRouterOutputsPaginator(
            Consumer<ListRouterOutputsRequest.Builder> listRouterOutputsRequest) {
        return listRouterOutputsPaginator(ListRouterOutputsRequest.builder().applyMutation(listRouterOutputsRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with a global resource in AWS Elemental MediaConnect. The API supports the following
     * global resources: router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param listTagsForGlobalResourceRequest
     * @return A Java Future containing the result of the ListTagsForGlobalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListTagsForGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForGlobalResourceResponse> listTagsForGlobalResource(
            ListTagsForGlobalResourceRequest listTagsForGlobalResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with a global resource in AWS Elemental MediaConnect. The API supports the following
     * global resources: router inputs, router outputs and router network interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForGlobalResourceRequest.Builder} avoiding
     * the need to create one manually via {@link ListTagsForGlobalResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForGlobalResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForGlobalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListTagsForGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForGlobalResourceResponse> listTagsForGlobalResource(
            Consumer<ListTagsForGlobalResourceRequest.Builder> listTagsForGlobalResourceRequest) {
        return listTagsForGlobalResource(ListTagsForGlobalResourceRequest.builder()
                .applyMutation(listTagsForGlobalResourceRequest).build());
    }

    /**
     * <p>
     * List all tags on a MediaConnect resource in the current region.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags on a MediaConnect resource in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another
     * offering.
     * </p>
     *
     * @param purchaseOfferingRequest
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PurchaseOfferingResponse> purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another
     * offering.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link PurchaseOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PurchaseOfferingResponse> purchaseOffering(
            Consumer<PurchaseOfferingRequest.Builder> purchaseOfferingRequest) {
        return purchaseOffering(PurchaseOfferingRequest.builder().applyMutation(purchaseOfferingRequest).build());
    }

    /**
     * <p>
     * Removes an output from a bridge.
     * </p>
     *
     * @param removeBridgeOutputRequest
     * @return A Java Future containing the result of the RemoveBridgeOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveBridgeOutputResponse> removeBridgeOutput(RemoveBridgeOutputRequest removeBridgeOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an output from a bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveBridgeOutputRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveBridgeOutputRequest#builder()}
     * </p>
     *
     * @param removeBridgeOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveBridgeOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveBridgeOutputResponse> removeBridgeOutput(
            Consumer<RemoveBridgeOutputRequest.Builder> removeBridgeOutputRequest) {
        return removeBridgeOutput(RemoveBridgeOutputRequest.builder().applyMutation(removeBridgeOutputRequest).build());
    }

    /**
     * <p>
     * Removes a source from a bridge.
     * </p>
     *
     * @param removeBridgeSourceRequest
     * @return A Java Future containing the result of the RemoveBridgeSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveBridgeSourceResponse> removeBridgeSource(RemoveBridgeSourceRequest removeBridgeSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a source from a bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveBridgeSourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveBridgeSourceRequest#builder()}
     * </p>
     *
     * @param removeBridgeSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveBridgeSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveBridgeSourceResponse> removeBridgeSource(
            Consumer<RemoveBridgeSourceRequest.Builder> removeBridgeSourceRequest) {
        return removeBridgeSource(RemoveBridgeSourceRequest.builder().applyMutation(removeBridgeSourceRequest).build());
    }

    /**
     * <p>
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a
     * source or output.
     * </p>
     *
     * @param removeFlowMediaStreamRequest
     * @return A Java Future containing the result of the RemoveFlowMediaStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveFlowMediaStreamResponse> removeFlowMediaStream(
            RemoveFlowMediaStreamRequest removeFlowMediaStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a
     * source or output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFlowMediaStreamRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveFlowMediaStreamRequest#builder()}
     * </p>
     *
     * @param removeFlowMediaStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RemoveFlowMediaStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveFlowMediaStreamResponse> removeFlowMediaStream(
            Consumer<RemoveFlowMediaStreamRequest.Builder> removeFlowMediaStreamRequest) {
        return removeFlowMediaStream(RemoveFlowMediaStreamRequest.builder().applyMutation(removeFlowMediaStreamRequest).build());
    }

    /**
     * <p>
     * Removes an output from an existing flow. This request can be made only on an output that does not have an
     * entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When
     * an entitlement is revoked from a flow, the service automatically removes the associated output.
     * </p>
     *
     * @param removeFlowOutputRequest
     * @return A Java Future containing the result of the RemoveFlowOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveFlowOutputResponse> removeFlowOutput(RemoveFlowOutputRequest removeFlowOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an output from an existing flow. This request can be made only on an output that does not have an
     * entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When
     * an entitlement is revoked from a flow, the service automatically removes the associated output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFlowOutputRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveFlowOutputRequest#builder()}
     * </p>
     *
     * @param removeFlowOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveFlowOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveFlowOutputResponse> removeFlowOutput(
            Consumer<RemoveFlowOutputRequest.Builder> removeFlowOutputRequest) {
        return removeFlowOutput(RemoveFlowOutputRequest.builder().applyMutation(removeFlowOutputRequest).build());
    }

    /**
     * <p>
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the
     * flow.
     * </p>
     *
     * @param removeFlowSourceRequest
     * @return A Java Future containing the result of the RemoveFlowSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveFlowSourceResponse> removeFlowSource(RemoveFlowSourceRequest removeFlowSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the
     * flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFlowSourceRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveFlowSourceRequest#builder()}
     * </p>
     *
     * @param removeFlowSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveFlowSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveFlowSourceResponse> removeFlowSource(
            Consumer<RemoveFlowSourceRequest.Builder> removeFlowSourceRequest) {
        return removeFlowSource(RemoveFlowSourceRequest.builder().applyMutation(removeFlowSourceRequest).build());
    }

    /**
     * <p>
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not
     * have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must
     * first delete or update the Source or Output to no longer reference the VPC interface.
     * </p>
     *
     * @param removeFlowVpcInterfaceRequest
     * @return A Java Future containing the result of the RemoveFlowVpcInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowVpcInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveFlowVpcInterfaceResponse> removeFlowVpcInterface(
            RemoveFlowVpcInterfaceRequest removeFlowVpcInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not
     * have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must
     * first delete or update the Source or Output to no longer reference the VPC interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveFlowVpcInterfaceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveFlowVpcInterfaceRequest#builder()}
     * </p>
     *
     * @param removeFlowVpcInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RemoveFlowVpcInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RemoveFlowVpcInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveFlowVpcInterfaceResponse> removeFlowVpcInterface(
            Consumer<RemoveFlowVpcInterfaceRequest.Builder> removeFlowVpcInterfaceRequest) {
        return removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest.builder().applyMutation(removeFlowVpcInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Restarts a router input. This operation can be used to recover from errors or refresh the input state.
     * </p>
     *
     * @param restartRouterInputRequest
     * @return A Java Future containing the result of the RestartRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RestartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartRouterInputResponse> restartRouterInput(RestartRouterInputRequest restartRouterInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a router input. This operation can be used to recover from errors or refresh the input state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartRouterInputRequest.Builder} avoiding the
     * need to create one manually via {@link RestartRouterInputRequest#builder()}
     * </p>
     *
     * @param restartRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestartRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RestartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartRouterInputResponse> restartRouterInput(
            Consumer<RestartRouterInputRequest.Builder> restartRouterInputRequest) {
        return restartRouterInput(RestartRouterInputRequest.builder().applyMutation(restartRouterInputRequest).build());
    }

    /**
     * <p>
     * Restarts a router output. This operation can be used to recover from errors or refresh the output state.
     * </p>
     *
     * @param restartRouterOutputRequest
     * @return A Java Future containing the result of the RestartRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RestartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartRouterOutputResponse> restartRouterOutput(
            RestartRouterOutputRequest restartRouterOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a router output. This operation can be used to recover from errors or refresh the output state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link RestartRouterOutputRequest#builder()}
     * </p>
     *
     * @param restartRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestartRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RestartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartRouterOutputResponse> restartRouterOutput(
            Consumer<RestartRouterOutputRequest.Builder> restartRouterOutputRequest) {
        return restartRouterOutput(RestartRouterOutputRequest.builder().applyMutation(restartRouterOutputRequest).build());
    }

    /**
     * <p>
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the
     * subscriber and the associated output is removed.
     * </p>
     *
     * @param revokeFlowEntitlementRequest
     * @return A Java Future containing the result of the RevokeFlowEntitlement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RevokeFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RevokeFlowEntitlementResponse> revokeFlowEntitlement(
            RevokeFlowEntitlementRequest revokeFlowEntitlementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the
     * subscriber and the associated output is removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeFlowEntitlementRequest.Builder} avoiding the
     * need to create one manually via {@link RevokeFlowEntitlementRequest#builder()}
     * </p>
     *
     * @param revokeFlowEntitlementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RevokeFlowEntitlement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.RevokeFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RevokeFlowEntitlementResponse> revokeFlowEntitlement(
            Consumer<RevokeFlowEntitlementRequest.Builder> revokeFlowEntitlementRequest) {
        return revokeFlowEntitlement(RevokeFlowEntitlementRequest.builder().applyMutation(revokeFlowEntitlementRequest).build());
    }

    /**
     * <p>
     * Starts a flow.
     * </p>
     *
     * @param startFlowRequest
     * @return A Java Future containing the result of the StartFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartFlowResponse> startFlow(StartFlowRequest startFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFlowRequest.Builder} avoiding the need to
     * create one manually via {@link StartFlowRequest#builder()}
     * </p>
     *
     * @param startFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StartFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartFlowResponse> startFlow(Consumer<StartFlowRequest.Builder> startFlowRequest) {
        return startFlow(StartFlowRequest.builder().applyMutation(startFlowRequest).build());
    }

    /**
     * <p>
     * Starts a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param startRouterInputRequest
     * @return A Java Future containing the result of the StartRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartRouterInputResponse> startRouterInput(StartRouterInputRequest startRouterInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link StartRouterInputRequest#builder()}
     * </p>
     *
     * @param startRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StartRouterInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartRouterInputResponse> startRouterInput(
            Consumer<StartRouterInputRequest.Builder> startRouterInputRequest) {
        return startRouterInput(StartRouterInputRequest.builder().applyMutation(startRouterInputRequest).build());
    }

    /**
     * <p>
     * Starts a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param startRouterOutputRequest
     * @return A Java Future containing the result of the StartRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRouterOutputResponse> startRouterOutput(StartRouterOutputRequest startRouterOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRouterOutputRequest.Builder} avoiding the need
     * to create one manually via {@link StartRouterOutputRequest#builder()}
     * </p>
     *
     * @param startRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRouterOutputResponse> startRouterOutput(
            Consumer<StartRouterOutputRequest.Builder> startRouterOutputRequest) {
        return startRouterOutput(StartRouterOutputRequest.builder().applyMutation(startRouterOutputRequest).build());
    }

    /**
     * <p>
     * Stops a flow.
     * </p>
     *
     * @param stopFlowRequest
     * @return A Java Future containing the result of the StopFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopFlowResponse> stopFlow(StopFlowRequest stopFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFlowRequest.Builder} avoiding the need to
     * create one manually via {@link StopFlowRequest#builder()}
     * </p>
     *
     * @param stopFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StopFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopFlowResponse> stopFlow(Consumer<StopFlowRequest.Builder> stopFlowRequest) {
        return stopFlow(StopFlowRequest.builder().applyMutation(stopFlowRequest).build());
    }

    /**
     * <p>
     * Stops a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param stopRouterInputRequest
     * @return A Java Future containing the result of the StopRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StopRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopRouterInputResponse> stopRouterInput(StopRouterInputRequest stopRouterInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link StopRouterInputRequest#builder()}
     * </p>
     *
     * @param stopRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StopRouterInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StopRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopRouterInputResponse> stopRouterInput(
            Consumer<StopRouterInputRequest.Builder> stopRouterInputRequest) {
        return stopRouterInput(StopRouterInputRequest.builder().applyMutation(stopRouterInputRequest).build());
    }

    /**
     * <p>
     * Stops a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param stopRouterOutputRequest
     * @return A Java Future containing the result of the StopRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StopRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopRouterOutputResponse> stopRouterOutput(StopRouterOutputRequest stopRouterOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRouterOutputRequest.Builder} avoiding the need
     * to create one manually via {@link StopRouterOutputRequest#builder()}
     * </p>
     *
     * @param stopRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.StopRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopRouterOutputResponse> stopRouterOutput(
            Consumer<StopRouterOutputRequest.Builder> stopRouterOutputRequest) {
        return stopRouterOutput(StopRouterOutputRequest.builder().applyMutation(stopRouterOutputRequest).build());
    }

    /**
     * <p>
     * Adds tags to a global resource in AWS Elemental MediaConnect. The API supports the following global resources:
     * router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param tagGlobalResourceRequest
     * @return A Java Future containing the result of the TagGlobalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.TagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagGlobalResourceResponse> tagGlobalResource(TagGlobalResourceRequest tagGlobalResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a global resource in AWS Elemental MediaConnect. The API supports the following global resources:
     * router inputs, router outputs and router network interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagGlobalResourceRequest.Builder} avoiding the need
     * to create one manually via {@link TagGlobalResourceRequest#builder()}
     * </p>
     *
     * @param tagGlobalResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagGlobalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.TagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagGlobalResourceResponse> tagGlobalResource(
            Consumer<TagGlobalResourceRequest.Builder> tagGlobalResourceRequest) {
        return tagGlobalResource(TagGlobalResourceRequest.builder().applyMutation(tagGlobalResourceRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code> in the current region. If
     * existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is
     * deleted, the tags associated with that resource are deleted as well.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code> in the current region. If
     * existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is
     * deleted, the tags associated with that resource are deleted as well.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Associates a router input with a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param takeRouterInputRequest
     * @return A Java Future containing the result of the TakeRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.TakeRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TakeRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TakeRouterInputResponse> takeRouterInput(TakeRouterInputRequest takeRouterInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a router input with a router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TakeRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link TakeRouterInputRequest#builder()}
     * </p>
     *
     * @param takeRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TakeRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.TakeRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TakeRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TakeRouterInputResponse> takeRouterInput(
            Consumer<TakeRouterInputRequest.Builder> takeRouterInputRequest) {
        return takeRouterInput(TakeRouterInputRequest.builder().applyMutation(takeRouterInputRequest).build());
    }

    /**
     * <p>
     * Removes tags from a global resource in AWS Elemental MediaConnect. The API supports the following global
     * resources: router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param untagGlobalResourceRequest
     * @return A Java Future containing the result of the UntagGlobalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UntagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagGlobalResourceResponse> untagGlobalResource(
            UntagGlobalResourceRequest untagGlobalResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a global resource in AWS Elemental MediaConnect. The API supports the following global
     * resources: router inputs, router outputs and router network interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagGlobalResourceRequest.Builder} avoiding the
     * need to create one manually via {@link UntagGlobalResourceRequest#builder()}
     * </p>
     *
     * @param untagGlobalResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagGlobalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UntagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagGlobalResourceResponse> untagGlobalResource(
            Consumer<UntagGlobalResourceRequest.Builder> untagGlobalResourceRequest) {
        return untagGlobalResource(UntagGlobalResourceRequest.builder().applyMutation(untagGlobalResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource in the current region.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the bridge.
     * </p>
     *
     * @param updateBridgeRequest
     * @return A Java Future containing the result of the UpdateBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBridgeResponse> updateBridge(UpdateBridgeRequest updateBridgeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the bridge.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBridgeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBridgeRequest#builder()}
     * </p>
     *
     * @param updateBridgeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBridge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBridgeResponse> updateBridge(Consumer<UpdateBridgeRequest.Builder> updateBridgeRequest) {
        return updateBridge(UpdateBridgeRequest.builder().applyMutation(updateBridgeRequest).build());
    }

    /**
     * <p>
     * Updates an existing bridge output.
     * </p>
     *
     * @param updateBridgeOutputRequest
     * @return A Java Future containing the result of the UpdateBridgeOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBridgeOutputResponse> updateBridgeOutput(UpdateBridgeOutputRequest updateBridgeOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bridge output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBridgeOutputRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBridgeOutputRequest#builder()}
     * </p>
     *
     * @param updateBridgeOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBridgeOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBridgeOutputResponse> updateBridgeOutput(
            Consumer<UpdateBridgeOutputRequest.Builder> updateBridgeOutputRequest) {
        return updateBridgeOutput(UpdateBridgeOutputRequest.builder().applyMutation(updateBridgeOutputRequest).build());
    }

    /**
     * <p>
     * Updates an existing bridge source.
     * </p>
     *
     * @param updateBridgeSourceRequest
     * @return A Java Future containing the result of the UpdateBridgeSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBridgeSourceResponse> updateBridgeSource(UpdateBridgeSourceRequest updateBridgeSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing bridge source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBridgeSourceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBridgeSourceRequest#builder()}
     * </p>
     *
     * @param updateBridgeSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBridgeSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBridgeSourceResponse> updateBridgeSource(
            Consumer<UpdateBridgeSourceRequest.Builder> updateBridgeSourceRequest) {
        return updateBridgeSource(UpdateBridgeSourceRequest.builder().applyMutation(updateBridgeSourceRequest).build());
    }

    /**
     * <p>
     * Updates the bridge state.
     * </p>
     *
     * @param updateBridgeStateRequest
     * @return A Java Future containing the result of the UpdateBridgeState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridgeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBridgeStateResponse> updateBridgeState(UpdateBridgeStateRequest updateBridgeStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the bridge state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBridgeStateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBridgeStateRequest#builder()}
     * </p>
     *
     * @param updateBridgeStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBridgeState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateBridgeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBridgeStateResponse> updateBridgeState(
            Consumer<UpdateBridgeStateRequest.Builder> updateBridgeStateRequest) {
        return updateBridgeState(UpdateBridgeStateRequest.builder().applyMutation(updateBridgeStateRequest).build());
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     *
     * @param updateFlowRequest
     * @return A Java Future containing the result of the UpdateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFlowResponse> updateFlow(UpdateFlowRequest updateFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFlowRequest#builder()}
     * </p>
     *
     * @param updateFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFlowResponse> updateFlow(Consumer<UpdateFlowRequest.Builder> updateFlowRequest) {
        return updateFlow(UpdateFlowRequest.builder().applyMutation(updateFlowRequest).build());
    }

    /**
     * <p>
     * Updates an entitlement. You can change an entitlement's description, subscribers, and encryption. If you change
     * the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     * </p>
     *
     * @param updateFlowEntitlementRequest
     * @return A Java Future containing the result of the UpdateFlowEntitlement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFlowEntitlementResponse> updateFlowEntitlement(
            UpdateFlowEntitlementRequest updateFlowEntitlementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an entitlement. You can change an entitlement's description, subscribers, and encryption. If you change
     * the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowEntitlementRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFlowEntitlementRequest#builder()}
     * </p>
     *
     * @param updateFlowEntitlementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateFlowEntitlement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFlowEntitlementResponse> updateFlowEntitlement(
            Consumer<UpdateFlowEntitlementRequest.Builder> updateFlowEntitlementRequest) {
        return updateFlowEntitlement(UpdateFlowEntitlementRequest.builder().applyMutation(updateFlowEntitlementRequest).build());
    }

    /**
     * <p>
     * Updates an existing media stream.
     * </p>
     *
     * @param updateFlowMediaStreamRequest
     * @return A Java Future containing the result of the UpdateFlowMediaStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFlowMediaStreamResponse> updateFlowMediaStream(
            UpdateFlowMediaStreamRequest updateFlowMediaStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing media stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowMediaStreamRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFlowMediaStreamRequest#builder()}
     * </p>
     *
     * @param updateFlowMediaStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateFlowMediaStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFlowMediaStreamResponse> updateFlowMediaStream(
            Consumer<UpdateFlowMediaStreamRequest.Builder> updateFlowMediaStreamRequest) {
        return updateFlowMediaStream(UpdateFlowMediaStreamRequest.builder().applyMutation(updateFlowMediaStreamRequest).build());
    }

    /**
     * <p>
     * Updates an existing flow output.
     * </p>
     *
     * @param updateFlowOutputRequest
     * @return A Java Future containing the result of the UpdateFlowOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFlowOutputResponse> updateFlowOutput(UpdateFlowOutputRequest updateFlowOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing flow output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowOutputRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFlowOutputRequest#builder()}
     * </p>
     *
     * @param updateFlowOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFlowOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFlowOutputResponse> updateFlowOutput(
            Consumer<UpdateFlowOutputRequest.Builder> updateFlowOutputRequest) {
        return updateFlowOutput(UpdateFlowOutputRequest.builder().applyMutation(updateFlowOutputRequest).build());
    }

    /**
     * <p>
     * Updates the source of a flow.
     * </p>
     *
     * @param updateFlowSourceRequest
     * @return A Java Future containing the result of the UpdateFlowSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFlowSourceResponse> updateFlowSource(UpdateFlowSourceRequest updateFlowSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the source of a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFlowSourceRequest#builder()}
     * </p>
     *
     * @param updateFlowSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFlowSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFlowSourceResponse> updateFlowSource(
            Consumer<UpdateFlowSourceRequest.Builder> updateFlowSourceRequest) {
        return updateFlowSource(UpdateFlowSourceRequest.builder().applyMutation(updateFlowSourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing gateway instance.
     * </p>
     *
     * @param updateGatewayInstanceRequest
     * @return A Java Future containing the result of the UpdateGatewayInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayInstanceResponse> updateGatewayInstance(
            UpdateGatewayInstanceRequest updateGatewayInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing gateway instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGatewayInstanceRequest#builder()}
     * </p>
     *
     * @param updateGatewayInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateGatewayInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayInstanceResponse> updateGatewayInstance(
            Consumer<UpdateGatewayInstanceRequest.Builder> updateGatewayInstanceRequest) {
        return updateGatewayInstance(UpdateGatewayInstanceRequest.builder().applyMutation(updateGatewayInstanceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterInputRequest
     * @return A Java Future containing the result of the UpdateRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRouterInputResponse> updateRouterInput(UpdateRouterInputRequest updateRouterInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing router input in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouterInputRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRouterInputRequest#builder()}
     * </p>
     *
     * @param updateRouterInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRouterInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRouterInputResponse> updateRouterInput(
            Consumer<UpdateRouterInputRequest.Builder> updateRouterInputRequest) {
        return updateRouterInput(UpdateRouterInputRequest.builder().applyMutation(updateRouterInputRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterNetworkInterfaceRequest
     * @return A Java Future containing the result of the UpdateRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRouterNetworkInterfaceResponse> updateRouterNetworkInterface(
            UpdateRouterNetworkInterfaceRequest updateRouterNetworkInterfaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing router network interface in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouterNetworkInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRouterNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param updateRouterNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateRouterNetworkInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRouterNetworkInterfaceResponse> updateRouterNetworkInterface(
            Consumer<UpdateRouterNetworkInterfaceRequest.Builder> updateRouterNetworkInterfaceRequest) {
        return updateRouterNetworkInterface(UpdateRouterNetworkInterfaceRequest.builder()
                .applyMutation(updateRouterNetworkInterfaceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterOutputRequest
     * @return A Java Future containing the result of the UpdateRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRouterOutputResponse> updateRouterOutput(UpdateRouterOutputRequest updateRouterOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing router output in AWS Elemental MediaConnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRouterOutputRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRouterOutputRequest#builder()}
     * </p>
     *
     * @param updateRouterOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRouterOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This exception is thrown if the request contains a semantic error. The precise
     *         meaning depends on the API, and is documented in the error message.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ForbiddenException You do not have sufficient access to perform this action.</li>
     *         <li>InternalServerErrorException The server encountered an internal error and is unable to complete the
     *         request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable or busy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaConnectAsyncClient.UpdateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRouterOutputResponse> updateRouterOutput(
            Consumer<UpdateRouterOutputRequest.Builder> updateRouterOutputRequest) {
        return updateRouterOutput(UpdateRouterOutputRequest.builder().applyMutation(updateRouterOutputRequest).build());
    }

    /**
     * Create an instance of {@link MediaConnectAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link MediaConnectAsyncWaiter}
     */
    default MediaConnectAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default MediaConnectServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MediaConnectAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaConnectAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaConnectAsyncClient}.
     */
    static MediaConnectAsyncClientBuilder builder() {
        return new DefaultMediaConnectAsyncClientBuilder();
    }
}
