/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.mediaconnect.internal.MediaConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.mediaconnect.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputs420Exception;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.BadRequestException;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.ConflictException;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridge420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlow420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateGateway420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationResponse;
import software.amazon.awssdk.services.mediaconnect.model.ForbiddenException;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlements420Exception;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectException;
import software.amazon.awssdk.services.mediaconnect.model.NotFoundException;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.ServiceUnavailableException;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.TooManyRequestsException;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.transform.AddBridgeOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddBridgeSourcesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowMediaStreamsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowSourcesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowVpcInterfacesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.BatchGetRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.BatchGetRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.BatchGetRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeregisterGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowSourceMetadataRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowSourceThumbnailRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeOfferingRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeReservationRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterInputSourceMetadataRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterInputThumbnailRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GrantFlowEntitlementsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListBridgesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListEntitlementsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListFlowsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListGatewayInstancesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListOfferingsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListReservationsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListRouterInputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListRouterNetworkInterfacesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListRouterOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListTagsForGlobalResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.PurchaseOfferingRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveBridgeOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveBridgeSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowMediaStreamRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowVpcInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RestartRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RestartRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RevokeFlowEntitlementRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TagGlobalResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TakeRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UntagGlobalResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeStateRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowEntitlementRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowMediaStreamRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.waiters.MediaConnectWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link MediaConnectClient}.
 *
 * @see MediaConnectClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultMediaConnectClient implements MediaConnectClient {
    private static final Logger log = Logger.loggerFor(DefaultMediaConnectClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMediaConnectClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "MediaConnect" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds outputs to an existing bridge.
     * </p>
     *
     * @param addBridgeOutputsRequest
     * @return Result of the AddBridgeOutputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddBridgeOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AddBridgeOutputsResponse addBridgeOutputs(AddBridgeOutputsRequest addBridgeOutputsRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddBridgeOutputsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddBridgeOutputsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addBridgeOutputsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addBridgeOutputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddBridgeOutputs");

            return clientHandler.execute(new ClientExecutionParams<AddBridgeOutputsRequest, AddBridgeOutputsResponse>()
                    .withOperationName("AddBridgeOutputs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addBridgeOutputsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddBridgeOutputsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds sources to an existing bridge.
     * </p>
     *
     * @param addBridgeSourcesRequest
     * @return Result of the AddBridgeSources operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddBridgeSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AddBridgeSourcesResponse addBridgeSources(AddBridgeSourcesRequest addBridgeSourcesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddBridgeSourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddBridgeSourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addBridgeSourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addBridgeSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddBridgeSources");

            return clientHandler.execute(new ClientExecutionParams<AddBridgeSourcesRequest, AddBridgeSourcesResponse>()
                    .withOperationName("AddBridgeSources").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addBridgeSourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddBridgeSourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a
     * source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     * </p>
     *
     * @param addFlowMediaStreamsRequest
     * @return Result of the AddFlowMediaStreams operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowMediaStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowMediaStreams"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddFlowMediaStreamsResponse addFlowMediaStreams(AddFlowMediaStreamsRequest addFlowMediaStreamsRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddFlowMediaStreamsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddFlowMediaStreamsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addFlowMediaStreamsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addFlowMediaStreamsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddFlowMediaStreams");

            return clientHandler.execute(new ClientExecutionParams<AddFlowMediaStreamsRequest, AddFlowMediaStreamsResponse>()
                    .withOperationName("AddFlowMediaStreams").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addFlowMediaStreamsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddFlowMediaStreamsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     * </p>
     *
     * @param addFlowOutputsRequest
     * @return Result of the AddFlowOutputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws AddFlowOutputs420Exception
     *         Exception raised by Elemental MediaConnect when adding the flow output. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AddFlowOutputsResponse addFlowOutputs(AddFlowOutputsRequest addFlowOutputsRequest) throws BadRequestException,
            AddFlowOutputs420Exception, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddFlowOutputsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddFlowOutputsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addFlowOutputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addFlowOutputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddFlowOutputs");

            return clientHandler.execute(new ClientExecutionParams<AddFlowOutputsRequest, AddFlowOutputsResponse>()
                    .withOperationName("AddFlowOutputs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addFlowOutputsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddFlowOutputsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds sources to a flow.
     * </p>
     *
     * @param addFlowSourcesRequest
     * @return Result of the AddFlowSources operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AddFlowSourcesResponse addFlowSources(AddFlowSourcesRequest addFlowSourcesRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddFlowSourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddFlowSourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addFlowSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addFlowSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddFlowSources");

            return clientHandler.execute(new ClientExecutionParams<AddFlowSourcesRequest, AddFlowSourcesResponse>()
                    .withOperationName("AddFlowSources").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addFlowSourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddFlowSourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds VPC interfaces to a flow.
     * </p>
     *
     * @param addFlowVpcInterfacesRequest
     * @return Result of the AddFlowVpcInterfaces operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.AddFlowVpcInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddFlowVpcInterfacesResponse addFlowVpcInterfaces(AddFlowVpcInterfacesRequest addFlowVpcInterfacesRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddFlowVpcInterfacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddFlowVpcInterfacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addFlowVpcInterfacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addFlowVpcInterfacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddFlowVpcInterfaces");

            return clientHandler.execute(new ClientExecutionParams<AddFlowVpcInterfacesRequest, AddFlowVpcInterfacesResponse>()
                    .withOperationName("AddFlowVpcInterfaces").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addFlowVpcInterfacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddFlowVpcInterfacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about multiple router inputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterInputRequest
     * @return Result of the BatchGetRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.BatchGetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetRouterInputResponse batchGetRouterInput(BatchGetRouterInputRequest batchGetRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetRouterInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetRouterInput");

            return clientHandler.execute(new ClientExecutionParams<BatchGetRouterInputRequest, BatchGetRouterInputResponse>()
                    .withOperationName("BatchGetRouterInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetRouterInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetRouterInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about multiple router network interfaces in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterNetworkInterfaceRequest
     * @return Result of the BatchGetRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.BatchGetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetRouterNetworkInterfaceResponse batchGetRouterNetworkInterface(
            BatchGetRouterNetworkInterfaceRequest batchGetRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetRouterNetworkInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetRouterNetworkInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetRouterNetworkInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetRouterNetworkInterfaceRequest, BatchGetRouterNetworkInterfaceResponse>()
                            .withOperationName("BatchGetRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetRouterNetworkInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetRouterNetworkInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about multiple router outputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param batchGetRouterOutputRequest
     * @return Result of the BatchGetRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.BatchGetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/BatchGetRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetRouterOutputResponse batchGetRouterOutput(BatchGetRouterOutputRequest batchGetRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetRouterOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetRouterOutput");

            return clientHandler.execute(new ClientExecutionParams<BatchGetRouterOutputRequest, BatchGetRouterOutputResponse>()
                    .withOperationName("BatchGetRouterOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetRouterOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetRouterOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new bridge. The request must include one source.
     * </p>
     *
     * @param createBridgeRequest
     * @return Result of the CreateBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws CreateBridge420Exception
     *         Exception raised by Elemental MediaConnect when creating the bridge. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBridgeResponse createBridge(CreateBridgeRequest createBridgeRequest) throws BadRequestException,
            CreateBridge420Exception, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBridgeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBridgeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBridgeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBridge");

            return clientHandler.execute(new ClientExecutionParams<CreateBridgeRequest, CreateBridgeResponse>()
                    .withOperationName("CreateBridge").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBridgeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBridgeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50)
     * and entitlements (up to 50).
     * </p>
     *
     * @param createFlowRequest
     * @return Result of the CreateFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws CreateFlow420Exception
     *         Exception raised by Elemental MediaConnect when creating the flow. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFlowResponse createFlow(CreateFlowRequest createFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, ServiceUnavailableException,
            CreateFlow420Exception, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFlow");

            return clientHandler.execute(new ClientExecutionParams<CreateFlowRequest, CreateFlowResponse>()
                    .withOperationName("CreateFlow").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createFlowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new gateway. The request must include at least one network (up to four).
     * </p>
     *
     * @param createGatewayRequest
     * @return Result of the CreateGateway operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws CreateGateway420Exception
     *         Exception raised by Elemental MediaConnect when creating the gateway. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateGatewayResponse createGateway(CreateGatewayRequest createGatewayRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, CreateGateway420Exception, ForbiddenException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGateway");

            return clientHandler.execute(new ClientExecutionParams<CreateGatewayRequest, CreateGatewayResponse>()
                    .withOperationName("CreateGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterInputRequest
     * @return Result of the CreateRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws RouterInputServiceQuotaExceededException
     *         The request to create a new router input would exceed the service quotas for the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRouterInputResponse createRouterInput(CreateRouterInputRequest createRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, ServiceUnavailableException, RouterInputServiceQuotaExceededException,
            AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRouterInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouterInput");

            return clientHandler.execute(new ClientExecutionParams<CreateRouterInputRequest, CreateRouterInputResponse>()
                    .withOperationName("CreateRouterInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRouterInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRouterInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterNetworkInterfaceRequest
     * @return Result of the CreateRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws RouterNetworkInterfaceServiceQuotaExceededException
     *         The request to create a new router network interface would exceed the service quotas (limits) set for the
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRouterNetworkInterfaceResponse createRouterNetworkInterface(
            CreateRouterNetworkInterfaceRequest createRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException,
            ServiceUnavailableException, RouterNetworkInterfaceServiceQuotaExceededException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRouterNetworkInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouterNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouterNetworkInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRouterNetworkInterfaceRequest, CreateRouterNetworkInterfaceResponse>()
                            .withOperationName("CreateRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createRouterNetworkInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRouterNetworkInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param createRouterOutputRequest
     * @return Result of the CreateRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws RouterOutputServiceQuotaExceededException
     *         The request to create a new router output would exceed the service quotas (limits) set for the account.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.CreateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRouterOutputResponse createRouterOutput(CreateRouterOutputRequest createRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, RouterOutputServiceQuotaExceededException,
            ForbiddenException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRouterOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouterOutput");

            return clientHandler.execute(new ClientExecutionParams<CreateRouterOutputRequest, CreateRouterOutputResponse>()
                    .withOperationName("CreateRouterOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRouterOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRouterOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a bridge. Before you can delete a bridge, you must stop the bridge.
     * </p>
     *
     * @param deleteBridgeRequest
     * @return Result of the DeleteBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteBridge" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBridgeResponse deleteBridge(DeleteBridgeRequest deleteBridgeRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBridgeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBridgeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBridgeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBridge");

            return clientHandler.execute(new ClientExecutionParams<DeleteBridgeRequest, DeleteBridgeResponse>()
                    .withOperationName("DeleteBridge").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBridgeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBridgeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     * </p>
     *
     * @param deleteFlowRequest
     * @return Result of the DeleteFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFlowResponse deleteFlow(DeleteFlowRequest deleteFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFlow");

            return clientHandler.execute(new ClientExecutionParams<DeleteFlowRequest, DeleteFlowResponse>()
                    .withOperationName("DeleteFlow").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteFlowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a gateway. Before you can delete a gateway, you must deregister its instances and delete its bridges.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGateway");

            return clientHandler.execute(new ClientExecutionParams<DeleteGatewayRequest, DeleteGatewayResponse>()
                    .withOperationName("DeleteGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a router input from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterInputRequest
     * @return Result of the DeleteRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRouterInputResponse deleteRouterInput(DeleteRouterInputRequest deleteRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRouterInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouterInput");

            return clientHandler.execute(new ClientExecutionParams<DeleteRouterInputRequest, DeleteRouterInputResponse>()
                    .withOperationName("DeleteRouterInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRouterInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRouterInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a router network interface from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterNetworkInterfaceRequest
     * @return Result of the DeleteRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRouterNetworkInterfaceResponse deleteRouterNetworkInterface(
            DeleteRouterNetworkInterfaceRequest deleteRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRouterNetworkInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouterNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouterNetworkInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRouterNetworkInterfaceRequest, DeleteRouterNetworkInterfaceResponse>()
                            .withOperationName("DeleteRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteRouterNetworkInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRouterNetworkInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a router output from AWS Elemental MediaConnect.
     * </p>
     *
     * @param deleteRouterOutputRequest
     * @return Result of the DeleteRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeleteRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRouterOutputResponse deleteRouterOutput(DeleteRouterOutputRequest deleteRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRouterOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouterOutput");

            return clientHandler.execute(new ClientExecutionParams<DeleteRouterOutputRequest, DeleteRouterOutputResponse>()
                    .withOperationName("DeleteRouterOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRouterOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRouterOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters an instance. Before you deregister an instance, all bridges running on the instance must be stopped.
     * If you want to deregister an instance without stopping the bridges, you must use the --force option.
     * </p>
     *
     * @param deregisterGatewayInstanceRequest
     * @return Result of the DeregisterGatewayInstance operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DeregisterGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeregisterGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterGatewayInstanceResponse deregisterGatewayInstance(
            DeregisterGatewayInstanceRequest deregisterGatewayInstanceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterGatewayInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterGatewayInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterGatewayInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterGatewayInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterGatewayInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterGatewayInstanceRequest, DeregisterGatewayInstanceResponse>()
                            .withOperationName("DeregisterGatewayInstance").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deregisterGatewayInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterGatewayInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the details of a bridge.
     * </p>
     *
     * @param describeBridgeRequest
     * @return Result of the DescribeBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeBridge" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeBridgeResponse describeBridge(DescribeBridgeRequest describeBridgeRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBridgeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeBridgeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBridgeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBridge");

            return clientHandler.execute(new ClientExecutionParams<DescribeBridgeRequest, DescribeBridgeResponse>()
                    .withOperationName("DescribeBridge").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeBridgeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBridgeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the details of a flow. The response includes the flow Amazon Resource Name (ARN), name, and Availability
     * Zone, as well as details about the source, outputs, and entitlements.
     * </p>
     *
     * @param describeFlowRequest
     * @return Result of the DescribeFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeFlowResponse describeFlow(DescribeFlowRequest describeFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlow");

            return clientHandler.execute(new ClientExecutionParams<DescribeFlowRequest, DescribeFlowResponse>()
                    .withOperationName("DescribeFlow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeFlowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The <code>DescribeFlowSourceMetadata</code> API is used to view information about the flow's source transport
     * stream and programs. This API displays status messages about the flow's source as well as details about the
     * program's video, audio, and other data.
     * </p>
     *
     * @param describeFlowSourceMetadataRequest
     * @return Result of the DescribeFlowSourceMetadata operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeFlowSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFlowSourceMetadataResponse describeFlowSourceMetadata(
            DescribeFlowSourceMetadataRequest describeFlowSourceMetadataRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFlowSourceMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFlowSourceMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlowSourceMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowSourceMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlowSourceMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowSourceMetadataRequest, DescribeFlowSourceMetadataResponse>()
                            .withOperationName("DescribeFlowSourceMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeFlowSourceMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeFlowSourceMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the thumbnail for the flow source.
     * </p>
     *
     * @param describeFlowSourceThumbnailRequest
     * @return Result of the DescribeFlowSourceThumbnail operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeFlowSourceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFlowSourceThumbnailResponse describeFlowSourceThumbnail(
            DescribeFlowSourceThumbnailRequest describeFlowSourceThumbnailRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFlowSourceThumbnailResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFlowSourceThumbnailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlowSourceThumbnailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowSourceThumbnailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlowSourceThumbnail");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowSourceThumbnailRequest, DescribeFlowSourceThumbnailResponse>()
                            .withOperationName("DescribeFlowSourceThumbnail").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeFlowSourceThumbnailRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeFlowSourceThumbnailRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the details of a gateway. The response includes the gateway Amazon Resource Name (ARN), name, and CIDR
     * blocks, as well as details about the networks.
     * </p>
     *
     * @param describeGatewayRequest
     * @return Result of the DescribeGateway operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeGatewayResponse describeGateway(DescribeGatewayRequest describeGatewayRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGateway");

            return clientHandler.execute(new ClientExecutionParams<DescribeGatewayRequest, DescribeGatewayResponse>()
                    .withOperationName("DescribeGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the details of an instance.
     * </p>
     *
     * @param describeGatewayInstanceRequest
     * @return Result of the DescribeGatewayInstance operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeGatewayInstanceResponse describeGatewayInstance(DescribeGatewayInstanceRequest describeGatewayInstanceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeGatewayInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeGatewayInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGatewayInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGatewayInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGatewayInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeGatewayInstanceRequest, DescribeGatewayInstanceResponse>()
                            .withOperationName("DescribeGatewayInstance").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeGatewayInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeGatewayInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the details of an offering. The response includes the offering description, duration, outbound
     * bandwidth, price, and Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeOfferingRequest
     * @return Result of the DescribeOffering operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeOfferingResponse describeOffering(DescribeOfferingRequest describeOfferingRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, NotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOfferingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeOfferingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOffering");

            return clientHandler.execute(new ClientExecutionParams<DescribeOfferingRequest, DescribeOfferingResponse>()
                    .withOperationName("DescribeOffering").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeOfferingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time,
     * and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound
     * bandwidth).
     * </p>
     *
     * @param describeReservationRequest
     * @return Result of the DescribeReservation operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReservationResponse describeReservation(DescribeReservationRequest describeReservationRequest)
            throws BadRequestException, TooManyRequestsException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservation");

            return clientHandler.execute(new ClientExecutionParams<DescribeReservationRequest, DescribeReservationResponse>()
                    .withOperationName("DescribeReservation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeReservationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a specific router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterInputRequest
     * @return Result of the GetRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetRouterInputResponse getRouterInput(GetRouterInputRequest getRouterInputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRouterInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterInput");

            return clientHandler.execute(new ClientExecutionParams<GetRouterInputRequest, GetRouterInputResponse>()
                    .withOperationName("GetRouterInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getRouterInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRouterInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed metadata information about a specific router input source, including stream details and
     * connection state.
     * </p>
     *
     * @param getRouterInputSourceMetadataRequest
     * @return Result of the GetRouterInputSourceMetadata operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterInputSourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputSourceMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRouterInputSourceMetadataResponse getRouterInputSourceMetadata(
            GetRouterInputSourceMetadataRequest getRouterInputSourceMetadataRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRouterInputSourceMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRouterInputSourceMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterInputSourceMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterInputSourceMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterInputSourceMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRouterInputSourceMetadataRequest, GetRouterInputSourceMetadataResponse>()
                            .withOperationName("GetRouterInputSourceMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRouterInputSourceMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRouterInputSourceMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the thumbnail for a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterInputThumbnailRequest
     * @return Result of the GetRouterInputThumbnail operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterInputThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterInputThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRouterInputThumbnailResponse getRouterInputThumbnail(GetRouterInputThumbnailRequest getRouterInputThumbnailRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRouterInputThumbnailResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRouterInputThumbnailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterInputThumbnailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterInputThumbnailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterInputThumbnail");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRouterInputThumbnailRequest, GetRouterInputThumbnailResponse>()
                            .withOperationName("GetRouterInputThumbnail").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRouterInputThumbnailRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRouterInputThumbnailRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a specific router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterNetworkInterfaceRequest
     * @return Result of the GetRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRouterNetworkInterfaceResponse getRouterNetworkInterface(
            GetRouterNetworkInterfaceRequest getRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRouterNetworkInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterNetworkInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRouterNetworkInterfaceRequest, GetRouterNetworkInterfaceResponse>()
                            .withOperationName("GetRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRouterNetworkInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRouterNetworkInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a specific router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param getRouterOutputRequest
     * @return Result of the GetRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GetRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GetRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetRouterOutputResponse getRouterOutput(GetRouterOutputRequest getRouterOutputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRouterOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRouterOutput");

            return clientHandler.execute(new ClientExecutionParams<GetRouterOutputRequest, GetRouterOutputResponse>()
                    .withOperationName("GetRouterOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getRouterOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRouterOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants entitlements to an existing flow.
     * </p>
     *
     * @param grantFlowEntitlementsRequest
     * @return Result of the GrantFlowEntitlements operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws GrantFlowEntitlements420Exception
     *         Exception raised by Elemental MediaConnect when granting the entitlement. See the error message for the
     *         operation for more information on the cause of this exception.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.GrantFlowEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GrantFlowEntitlementsResponse grantFlowEntitlements(GrantFlowEntitlementsRequest grantFlowEntitlementsRequest)
            throws BadRequestException, GrantFlowEntitlements420Exception, TooManyRequestsException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GrantFlowEntitlementsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GrantFlowEntitlementsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(grantFlowEntitlementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, grantFlowEntitlementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GrantFlowEntitlements");

            return clientHandler.execute(new ClientExecutionParams<GrantFlowEntitlementsRequest, GrantFlowEntitlementsResponse>()
                    .withOperationName("GrantFlowEntitlements").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(grantFlowEntitlementsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GrantFlowEntitlementsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays a list of bridges that are associated with this account and an optionally specified Amazon Resource Name
     * (ARN). This request returns a paginated result.
     * </p>
     *
     * @param listBridgesRequest
     * @return Result of the ListBridges operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListBridges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBridgesResponse listBridges(ListBridgesRequest listBridgesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBridgesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBridgesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBridgesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBridgesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBridges");

            return clientHandler.execute(new ClientExecutionParams<ListBridgesRequest, ListBridgesResponse>()
                    .withOperationName("ListBridges").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listBridgesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBridgesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per
     * page.
     * </p>
     *
     * @param listEntitlementsRequest
     * @return Result of the ListEntitlements operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListEntitlementsResponse listEntitlements(ListEntitlementsRequest listEntitlementsRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEntitlementsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListEntitlementsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEntitlementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitlementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntitlements");

            return clientHandler.execute(new ClientExecutionParams<ListEntitlementsRequest, ListEntitlementsResponse>()
                    .withOperationName("ListEntitlements").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listEntitlementsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEntitlementsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @param listFlowsRequest
     * @return Result of the ListFlows operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFlowsResponse listFlows(ListFlowsRequest listFlowsRequest) throws BadRequestException, TooManyRequestsException,
            InternalServerErrorException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFlowsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFlowsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFlowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlows");

            return clientHandler.execute(new ClientExecutionParams<ListFlowsRequest, ListFlowsResponse>()
                    .withOperationName("ListFlows").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listFlowsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFlowsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays a list of instances associated with the Amazon Web Services account. This request returns a paginated
     * result. You can use the filterArn property to display only the instances associated with the selected Gateway
     * Amazon Resource Name (ARN).
     * </p>
     *
     * @param listGatewayInstancesRequest
     * @return Result of the ListGatewayInstances operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGatewayInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGatewayInstancesResponse listGatewayInstances(ListGatewayInstancesRequest listGatewayInstancesRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGatewayInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListGatewayInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGatewayInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewayInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGatewayInstances");

            return clientHandler.execute(new ClientExecutionParams<ListGatewayInstancesRequest, ListGatewayInstancesResponse>()
                    .withOperationName("ListGatewayInstances").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listGatewayInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGatewayInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays a list of gateways that are associated with this account. This request returns a paginated result.
     * </p>
     *
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGatewaysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGateways");

            return clientHandler.execute(new ClientExecutionParams<ListGatewaysRequest, ListGatewaysResponse>()
                    .withOperationName("ListGateways").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listGatewaysRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGatewaysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays a list of all offerings that are available to this account in the current Amazon Web Services Region. If
     * you have an active reservation (which means you've purchased an offering that has already started and hasn't
     * expired yet), your account isn't eligible for other offerings.
     * </p>
     *
     * @param listOfferingsRequest
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListOfferingsResponse listOfferings(ListOfferingsRequest listOfferingsRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOfferingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOfferingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOfferings");

            return clientHandler.execute(new ClientExecutionParams<ListOfferingsRequest, ListOfferingsResponse>()
                    .withOperationName("ListOfferings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listOfferingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOfferingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays a list of all reservations that have been purchased by this account in the current Amazon Web Services
     * Region. This list includes all reservations in all states (such as active and expired).
     * </p>
     *
     * @param listReservationsRequest
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReservationsResponse listReservations(ListReservationsRequest listReservationsRequest) throws BadRequestException,
            TooManyRequestsException, InternalServerErrorException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReservationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListReservationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReservationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReservationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReservations");

            return clientHandler.execute(new ClientExecutionParams<ListReservationsRequest, ListReservationsResponse>()
                    .withOperationName("ListReservations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listReservationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReservationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of router inputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterInputsRequest
     * @return Result of the ListRouterInputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterInputs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListRouterInputsResponse listRouterInputs(ListRouterInputsRequest listRouterInputsRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRouterInputsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRouterInputsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRouterInputsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRouterInputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRouterInputs");

            return clientHandler.execute(new ClientExecutionParams<ListRouterInputsRequest, ListRouterInputsResponse>()
                    .withOperationName("ListRouterInputs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listRouterInputsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRouterInputsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of router network interfaces in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterNetworkInterfacesRequest
     * @return Result of the ListRouterNetworkInterfaces operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterNetworkInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterNetworkInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRouterNetworkInterfacesResponse listRouterNetworkInterfaces(
            ListRouterNetworkInterfacesRequest listRouterNetworkInterfacesRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, InternalServerErrorException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRouterNetworkInterfacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRouterNetworkInterfacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRouterNetworkInterfacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRouterNetworkInterfacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRouterNetworkInterfaces");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRouterNetworkInterfacesRequest, ListRouterNetworkInterfacesResponse>()
                            .withOperationName("ListRouterNetworkInterfaces").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRouterNetworkInterfacesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRouterNetworkInterfacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of router outputs in AWS Elemental MediaConnect.
     * </p>
     *
     * @param listRouterOutputsRequest
     * @return Result of the ListRouterOutputs operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListRouterOutputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListRouterOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRouterOutputsResponse listRouterOutputs(ListRouterOutputsRequest listRouterOutputsRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRouterOutputsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRouterOutputsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRouterOutputsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRouterOutputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRouterOutputs");

            return clientHandler.execute(new ClientExecutionParams<ListRouterOutputsRequest, ListRouterOutputsResponse>()
                    .withOperationName("ListRouterOutputs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listRouterOutputsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRouterOutputsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags associated with a global resource in AWS Elemental MediaConnect. The API supports the following
     * global resources: router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param listTagsForGlobalResourceRequest
     * @return Result of the ListTagsForGlobalResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListTagsForGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForGlobalResourceResponse listTagsForGlobalResource(
            ListTagsForGlobalResourceRequest listTagsForGlobalResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForGlobalResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForGlobalResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForGlobalResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForGlobalResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForGlobalResource");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTagsForGlobalResourceRequest, ListTagsForGlobalResourceResponse>()
                            .withOperationName("ListTagsForGlobalResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listTagsForGlobalResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTagsForGlobalResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all tags on a MediaConnect resource in the current region.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException,
            MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another
     * offering.
     * </p>
     *
     * @param purchaseOfferingRequest
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PurchaseOfferingResponse purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PurchaseOfferingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PurchaseOfferingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(purchaseOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, purchaseOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseOffering");

            return clientHandler.execute(new ClientExecutionParams<PurchaseOfferingRequest, PurchaseOfferingResponse>()
                    .withOperationName("PurchaseOffering").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(purchaseOfferingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PurchaseOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes an output from a bridge.
     * </p>
     *
     * @param removeBridgeOutputRequest
     * @return Result of the RemoveBridgeOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveBridgeOutputResponse removeBridgeOutput(RemoveBridgeOutputRequest removeBridgeOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveBridgeOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveBridgeOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeBridgeOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeBridgeOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveBridgeOutput");

            return clientHandler.execute(new ClientExecutionParams<RemoveBridgeOutputRequest, RemoveBridgeOutputResponse>()
                    .withOperationName("RemoveBridgeOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(removeBridgeOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveBridgeOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a source from a bridge.
     * </p>
     *
     * @param removeBridgeSourceRequest
     * @return Result of the RemoveBridgeSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveBridgeSourceResponse removeBridgeSource(RemoveBridgeSourceRequest removeBridgeSourceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveBridgeSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveBridgeSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeBridgeSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeBridgeSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveBridgeSource");

            return clientHandler.execute(new ClientExecutionParams<RemoveBridgeSourceRequest, RemoveBridgeSourceResponse>()
                    .withOperationName("RemoveBridgeSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(removeBridgeSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveBridgeSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a
     * source or output.
     * </p>
     *
     * @param removeFlowMediaStreamRequest
     * @return Result of the RemoveFlowMediaStream operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveFlowMediaStreamResponse removeFlowMediaStream(RemoveFlowMediaStreamRequest removeFlowMediaStreamRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveFlowMediaStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveFlowMediaStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFlowMediaStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFlowMediaStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFlowMediaStream");

            return clientHandler.execute(new ClientExecutionParams<RemoveFlowMediaStreamRequest, RemoveFlowMediaStreamResponse>()
                    .withOperationName("RemoveFlowMediaStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(removeFlowMediaStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveFlowMediaStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes an output from an existing flow. This request can be made only on an output that does not have an
     * entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When
     * an entitlement is revoked from a flow, the service automatically removes the associated output.
     * </p>
     *
     * @param removeFlowOutputRequest
     * @return Result of the RemoveFlowOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RemoveFlowOutputResponse removeFlowOutput(RemoveFlowOutputRequest removeFlowOutputRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveFlowOutputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemoveFlowOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFlowOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFlowOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFlowOutput");

            return clientHandler.execute(new ClientExecutionParams<RemoveFlowOutputRequest, RemoveFlowOutputResponse>()
                    .withOperationName("RemoveFlowOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(removeFlowOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveFlowOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the
     * flow.
     * </p>
     *
     * @param removeFlowSourceRequest
     * @return Result of the RemoveFlowSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RemoveFlowSourceResponse removeFlowSource(RemoveFlowSourceRequest removeFlowSourceRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveFlowSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemoveFlowSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFlowSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFlowSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFlowSource");

            return clientHandler.execute(new ClientExecutionParams<RemoveFlowSourceRequest, RemoveFlowSourceResponse>()
                    .withOperationName("RemoveFlowSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(removeFlowSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveFlowSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not
     * have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must
     * first delete or update the Source or Output to no longer reference the VPC interface.
     * </p>
     *
     * @param removeFlowVpcInterfaceRequest
     * @return Result of the RemoveFlowVpcInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RemoveFlowVpcInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveFlowVpcInterfaceResponse removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest removeFlowVpcInterfaceRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveFlowVpcInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveFlowVpcInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeFlowVpcInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeFlowVpcInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveFlowVpcInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveFlowVpcInterfaceRequest, RemoveFlowVpcInterfaceResponse>()
                            .withOperationName("RemoveFlowVpcInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeFlowVpcInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveFlowVpcInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restarts a router input. This operation can be used to recover from errors or refresh the input state.
     * </p>
     *
     * @param restartRouterInputRequest
     * @return Result of the RestartRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RestartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestartRouterInputResponse restartRouterInput(RestartRouterInputRequest restartRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RestartRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RestartRouterInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restartRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restartRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestartRouterInput");

            return clientHandler.execute(new ClientExecutionParams<RestartRouterInputRequest, RestartRouterInputResponse>()
                    .withOperationName("RestartRouterInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(restartRouterInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RestartRouterInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restarts a router output. This operation can be used to recover from errors or refresh the output state.
     * </p>
     *
     * @param restartRouterOutputRequest
     * @return Result of the RestartRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RestartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RestartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestartRouterOutputResponse restartRouterOutput(RestartRouterOutputRequest restartRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RestartRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RestartRouterOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restartRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restartRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestartRouterOutput");

            return clientHandler.execute(new ClientExecutionParams<RestartRouterOutputRequest, RestartRouterOutputResponse>()
                    .withOperationName("RestartRouterOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(restartRouterOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RestartRouterOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the
     * subscriber and the associated output is removed.
     * </p>
     *
     * @param revokeFlowEntitlementRequest
     * @return Result of the RevokeFlowEntitlement operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.RevokeFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RevokeFlowEntitlementResponse revokeFlowEntitlement(RevokeFlowEntitlementRequest revokeFlowEntitlementRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RevokeFlowEntitlementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RevokeFlowEntitlementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeFlowEntitlementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeFlowEntitlementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeFlowEntitlement");

            return clientHandler.execute(new ClientExecutionParams<RevokeFlowEntitlementRequest, RevokeFlowEntitlementResponse>()
                    .withOperationName("RevokeFlowEntitlement").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(revokeFlowEntitlementRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RevokeFlowEntitlementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a flow.
     * </p>
     *
     * @param startFlowRequest
     * @return Result of the StartFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StartFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartFlowResponse startFlow(StartFlowRequest startFlowRequest) throws BadRequestException, TooManyRequestsException,
            ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFlow");

            return clientHandler.execute(new ClientExecutionParams<StartFlowRequest, StartFlowResponse>()
                    .withOperationName("StartFlow").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(startFlowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param startRouterInputRequest
     * @return Result of the StartRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StartRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartRouterInputResponse startRouterInput(StartRouterInputRequest startRouterInputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartRouterInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRouterInput");

            return clientHandler.execute(new ClientExecutionParams<StartRouterInputRequest, StartRouterInputResponse>()
                    .withOperationName("StartRouterInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startRouterInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartRouterInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param startRouterOutputRequest
     * @return Result of the StartRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StartRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartRouterOutputResponse startRouterOutput(StartRouterOutputRequest startRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartRouterOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRouterOutput");

            return clientHandler.execute(new ClientExecutionParams<StartRouterOutputRequest, StartRouterOutputResponse>()
                    .withOperationName("StartRouterOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startRouterOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartRouterOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a flow.
     * </p>
     *
     * @param stopFlowRequest
     * @return Result of the StopFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StopFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopFlowResponse stopFlow(StopFlowRequest stopFlowRequest) throws BadRequestException, TooManyRequestsException,
            ForbiddenException, InternalServerErrorException, NotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopFlow");

            return clientHandler.execute(new ClientExecutionParams<StopFlowRequest, StopFlowResponse>()
                    .withOperationName("StopFlow").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(stopFlowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param stopRouterInputRequest
     * @return Result of the StopRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StopRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StopRouterInputResponse stopRouterInput(StopRouterInputRequest stopRouterInputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopRouterInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopRouterInput");

            return clientHandler.execute(new ClientExecutionParams<StopRouterInputRequest, StopRouterInputResponse>()
                    .withOperationName("StopRouterInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopRouterInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopRouterInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param stopRouterOutputRequest
     * @return Result of the StopRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.StopRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopRouterOutput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StopRouterOutputResponse stopRouterOutput(StopRouterOutputRequest stopRouterOutputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopRouterOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopRouterOutput");

            return clientHandler.execute(new ClientExecutionParams<StopRouterOutputRequest, StopRouterOutputResponse>()
                    .withOperationName("StopRouterOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopRouterOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopRouterOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds tags to a global resource in AWS Elemental MediaConnect. The API supports the following global resources:
     * router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param tagGlobalResourceRequest
     * @return Result of the TagGlobalResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.TagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagGlobalResourceResponse tagGlobalResource(TagGlobalResourceRequest tagGlobalResourceRequest)
            throws BadRequestException, InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException,
            MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagGlobalResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagGlobalResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagGlobalResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagGlobalResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagGlobalResource");

            return clientHandler.execute(new ClientExecutionParams<TagGlobalResourceRequest, TagGlobalResourceResponse>()
                    .withOperationName("TagGlobalResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(tagGlobalResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagGlobalResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code> in the current region. If
     * existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is
     * deleted, the tags associated with that resource are deleted as well.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a router input with a router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param takeRouterInputRequest
     * @return Result of the TakeRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.TakeRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TakeRouterInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TakeRouterInputResponse takeRouterInput(TakeRouterInputRequest takeRouterInputRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TakeRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TakeRouterInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(takeRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, takeRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TakeRouterInput");

            return clientHandler.execute(new ClientExecutionParams<TakeRouterInputRequest, TakeRouterInputResponse>()
                    .withOperationName("TakeRouterInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(takeRouterInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TakeRouterInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tags from a global resource in AWS Elemental MediaConnect. The API supports the following global
     * resources: router inputs, router outputs and router network interfaces.
     * </p>
     *
     * @param untagGlobalResourceRequest
     * @return Result of the UntagGlobalResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UntagGlobalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagGlobalResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagGlobalResourceResponse untagGlobalResource(UntagGlobalResourceRequest untagGlobalResourceRequest)
            throws BadRequestException, InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException,
            MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagGlobalResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UntagGlobalResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagGlobalResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagGlobalResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagGlobalResource");

            return clientHandler.execute(new ClientExecutionParams<UntagGlobalResourceRequest, UntagGlobalResourceResponse>()
                    .withOperationName("UntagGlobalResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagGlobalResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagGlobalResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes specified tags from a resource in the current region.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            InternalServerErrorException, NotFoundException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the bridge.
     * </p>
     *
     * @param updateBridgeRequest
     * @return Result of the UpdateBridge operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridge" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateBridgeResponse updateBridge(UpdateBridgeRequest updateBridgeRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBridgeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBridgeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBridgeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBridge");

            return clientHandler.execute(new ClientExecutionParams<UpdateBridgeRequest, UpdateBridgeResponse>()
                    .withOperationName("UpdateBridge").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBridgeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBridgeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing bridge output.
     * </p>
     *
     * @param updateBridgeOutputRequest
     * @return Result of the UpdateBridgeOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridgeOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBridgeOutputResponse updateBridgeOutput(UpdateBridgeOutputRequest updateBridgeOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBridgeOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBridgeOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBridgeOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBridgeOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBridgeOutput");

            return clientHandler.execute(new ClientExecutionParams<UpdateBridgeOutputRequest, UpdateBridgeOutputResponse>()
                    .withOperationName("UpdateBridgeOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBridgeOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBridgeOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing bridge source.
     * </p>
     *
     * @param updateBridgeSourceRequest
     * @return Result of the UpdateBridgeSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridgeSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBridgeSourceResponse updateBridgeSource(UpdateBridgeSourceRequest updateBridgeSourceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBridgeSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBridgeSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBridgeSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBridgeSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBridgeSource");

            return clientHandler.execute(new ClientExecutionParams<UpdateBridgeSourceRequest, UpdateBridgeSourceResponse>()
                    .withOperationName("UpdateBridgeSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBridgeSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBridgeSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the bridge state.
     * </p>
     *
     * @param updateBridgeStateRequest
     * @return Result of the UpdateBridgeState operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateBridgeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBridgeStateResponse updateBridgeState(UpdateBridgeStateRequest updateBridgeStateRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBridgeStateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBridgeStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBridgeStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBridgeStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBridgeState");

            return clientHandler.execute(new ClientExecutionParams<UpdateBridgeStateRequest, UpdateBridgeStateResponse>()
                    .withOperationName("UpdateBridgeState").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBridgeStateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBridgeStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing flow.
     * </p>
     *
     * @param updateFlowRequest
     * @return Result of the UpdateFlow operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFlowResponse updateFlow(UpdateFlowRequest updateFlowRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlow");

            return clientHandler.execute(new ClientExecutionParams<UpdateFlowRequest, UpdateFlowResponse>()
                    .withOperationName("UpdateFlow").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateFlowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an entitlement. You can change an entitlement's description, subscribers, and encryption. If you change
     * the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     * </p>
     *
     * @param updateFlowEntitlementRequest
     * @return Result of the UpdateFlowEntitlement operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFlowEntitlementResponse updateFlowEntitlement(UpdateFlowEntitlementRequest updateFlowEntitlementRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFlowEntitlementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFlowEntitlementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowEntitlementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowEntitlementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlowEntitlement");

            return clientHandler.execute(new ClientExecutionParams<UpdateFlowEntitlementRequest, UpdateFlowEntitlementResponse>()
                    .withOperationName("UpdateFlowEntitlement").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFlowEntitlementRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFlowEntitlementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing media stream.
     * </p>
     *
     * @param updateFlowMediaStreamRequest
     * @return Result of the UpdateFlowMediaStream operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowMediaStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowMediaStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFlowMediaStreamResponse updateFlowMediaStream(UpdateFlowMediaStreamRequest updateFlowMediaStreamRequest)
            throws BadRequestException, TooManyRequestsException, ForbiddenException, InternalServerErrorException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFlowMediaStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFlowMediaStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowMediaStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowMediaStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlowMediaStream");

            return clientHandler.execute(new ClientExecutionParams<UpdateFlowMediaStreamRequest, UpdateFlowMediaStreamResponse>()
                    .withOperationName("UpdateFlowMediaStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFlowMediaStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFlowMediaStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing flow output.
     * </p>
     *
     * @param updateFlowOutputRequest
     * @return Result of the UpdateFlowOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateFlowOutputResponse updateFlowOutput(UpdateFlowOutputRequest updateFlowOutputRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFlowOutputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFlowOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlowOutput");

            return clientHandler.execute(new ClientExecutionParams<UpdateFlowOutputRequest, UpdateFlowOutputResponse>()
                    .withOperationName("UpdateFlowOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFlowOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFlowOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the source of a flow.
     * </p>
     *
     * @param updateFlowSourceRequest
     * @return Result of the UpdateFlowSource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateFlowSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateFlowSourceResponse updateFlowSource(UpdateFlowSourceRequest updateFlowSourceRequest) throws BadRequestException,
            TooManyRequestsException, ForbiddenException, InternalServerErrorException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFlowSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFlowSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlowSource");

            return clientHandler.execute(new ClientExecutionParams<UpdateFlowSourceRequest, UpdateFlowSourceResponse>()
                    .withOperationName("UpdateFlowSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFlowSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFlowSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing gateway instance.
     * </p>
     *
     * @param updateGatewayInstanceRequest
     * @return Result of the UpdateGatewayInstance operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateGatewayInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateGatewayInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateGatewayInstanceResponse updateGatewayInstance(UpdateGatewayInstanceRequest updateGatewayInstanceRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGatewayInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateGatewayInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGatewayInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayInstance");

            return clientHandler.execute(new ClientExecutionParams<UpdateGatewayInstanceRequest, UpdateGatewayInstanceResponse>()
                    .withOperationName("UpdateGatewayInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateGatewayInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGatewayInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing router input in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterInputRequest
     * @return Result of the UpdateRouterInput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateRouterInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterInput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRouterInputResponse updateRouterInput(UpdateRouterInputRequest updateRouterInputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRouterInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRouterInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRouterInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRouterInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRouterInput");

            return clientHandler.execute(new ClientExecutionParams<UpdateRouterInputRequest, UpdateRouterInputResponse>()
                    .withOperationName("UpdateRouterInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateRouterInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRouterInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing router network interface in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterNetworkInterfaceRequest
     * @return Result of the UpdateRouterNetworkInterface operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateRouterNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterNetworkInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRouterNetworkInterfaceResponse updateRouterNetworkInterface(
            UpdateRouterNetworkInterfaceRequest updateRouterNetworkInterfaceRequest) throws BadRequestException,
            TooManyRequestsException, ConflictException, ForbiddenException, InternalServerErrorException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRouterNetworkInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRouterNetworkInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRouterNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRouterNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRouterNetworkInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateRouterNetworkInterfaceRequest, UpdateRouterNetworkInterfaceResponse>()
                            .withOperationName("UpdateRouterNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateRouterNetworkInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateRouterNetworkInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing router output in AWS Elemental MediaConnect.
     * </p>
     *
     * @param updateRouterOutputRequest
     * @return Result of the UpdateRouterOutput operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning depends on the
     *         API, and is documented in the error message.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ForbiddenException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerErrorException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws NotFoundException
     *         One or more of the resources in the request does not exist in the system.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable or busy.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConnectClient.UpdateRouterOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateRouterOutput"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRouterOutputResponse updateRouterOutput(UpdateRouterOutputRequest updateRouterOutputRequest)
            throws BadRequestException, TooManyRequestsException, ConflictException, ForbiddenException,
            InternalServerErrorException, NotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, MediaConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRouterOutputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRouterOutputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RouterInputServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException")
                        .httpStatusCode(420).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "CreateFlow420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
            case "NotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(NotFoundException::builder).build());
            case "RouterNetworkInterfaceServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException")
                        .httpStatusCode(420)
                        .exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
            case "CreateGateway420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "GrantFlowEntitlements420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
            case "AddFlowOutputs420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "BadRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BadRequestException::builder).build());
            case "RouterOutputServiceQuotaExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException")
                                .httpStatusCode(420).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder)
                                .build());
            case "CreateBridge420Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(420)
                        .exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "InternalServerErrorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRouterOutputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRouterOutputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRouterOutput");

            return clientHandler.execute(new ClientExecutionParams<UpdateRouterOutputRequest, UpdateRouterOutputResponse>()
                    .withOperationName("UpdateRouterOutput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateRouterOutputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRouterOutputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link MediaConnectWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link MediaConnectWaiter}
     */
    @Override
    public MediaConnectWaiter waiter() {
        return MediaConnectWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MediaConnectServiceClientConfigurationBuilder serviceConfigBuilder = new MediaConnectServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(MediaConnectException::builder)
                .protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final MediaConnectServiceClientConfiguration serviceClientConfiguration() {
        return new MediaConnectServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
