/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.FrameResolution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransportStream
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransportStream> {
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Channels").getter(TransportStream.getter(TransportStream::channels)).setter(TransportStream.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()}).build();
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(TransportStream.getter(TransportStream::codec)).setter(TransportStream.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<String> FRAME_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameRate").getter(TransportStream.getter(TransportStream::frameRate)).setter(TransportStream.setter(Builder::frameRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameRate").build()}).build();
    private static final SdkField<FrameResolution> FRAME_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameResolution").getter(TransportStream.getter(TransportStream::frameResolution)).setter(TransportStream.setter(Builder::frameResolution)).constructor(FrameResolution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameResolution").build()}).build();
    private static final SdkField<Integer> PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Pid").getter(TransportStream.getter(TransportStream::pid)).setter(TransportStream.setter(Builder::pid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleRate").getter(TransportStream.getter(TransportStream::sampleRate)).setter(TransportStream.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final SdkField<Integer> SAMPLE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleSize").getter(TransportStream.getter(TransportStream::sampleSize)).setter(TransportStream.setter(Builder::sampleSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleSize").build()}).build();
    private static final SdkField<String> STREAM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamType").getter(TransportStream.getter(TransportStream::streamType)).setter(TransportStream.setter(Builder::streamType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, CODEC_FIELD, FRAME_RATE_FIELD, FRAME_RESOLUTION_FIELD, PID_FIELD, SAMPLE_RATE_FIELD, SAMPLE_SIZE_FIELD, STREAM_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransportStream.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer channels;
    private final String codec;
    private final String frameRate;
    private final FrameResolution frameResolution;
    private final Integer pid;
    private final Integer sampleRate;
    private final Integer sampleSize;
    private final String streamType;

    private TransportStream(BuilderImpl builder) {
        this.channels = builder.channels;
        this.codec = builder.codec;
        this.frameRate = builder.frameRate;
        this.frameResolution = builder.frameResolution;
        this.pid = builder.pid;
        this.sampleRate = builder.sampleRate;
        this.sampleSize = builder.sampleSize;
        this.streamType = builder.streamType;
    }

    public final Integer channels() {
        return this.channels;
    }

    public final String codec() {
        return this.codec;
    }

    public final String frameRate() {
        return this.frameRate;
    }

    public final FrameResolution frameResolution() {
        return this.frameResolution;
    }

    public final Integer pid() {
        return this.pid;
    }

    public final Integer sampleRate() {
        return this.sampleRate;
    }

    public final Integer sampleSize() {
        return this.sampleSize;
    }

    public final String streamType() {
        return this.streamType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.codec());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransportStream)) {
            return false;
        }
        TransportStream other = (TransportStream)obj;
        return Objects.equals(this.channels(), other.channels()) && Objects.equals(this.codec(), other.codec()) && Objects.equals(this.frameRate(), other.frameRate()) && Objects.equals(this.frameResolution(), other.frameResolution()) && Objects.equals(this.pid(), other.pid()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.sampleSize(), other.sampleSize()) && Objects.equals(this.streamType(), other.streamType());
    }

    public final String toString() {
        return ToString.builder((String)"TransportStream").add("Channels", (Object)this.channels()).add("Codec", (Object)this.codec()).add("FrameRate", (Object)this.frameRate()).add("FrameResolution", (Object)this.frameResolution()).add("Pid", (Object)this.pid()).add("SampleRate", (Object)this.sampleRate()).add("SampleSize", (Object)this.sampleSize()).add("StreamType", (Object)this.streamType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codec()));
            }
            case "FrameRate": {
                return Optional.ofNullable(clazz.cast(this.frameRate()));
            }
            case "FrameResolution": {
                return Optional.ofNullable(clazz.cast(this.frameResolution()));
            }
            case "Pid": {
                return Optional.ofNullable(clazz.cast(this.pid()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "SampleSize": {
                return Optional.ofNullable(clazz.cast(this.sampleSize()));
            }
            case "StreamType": {
                return Optional.ofNullable(clazz.cast(this.streamType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channels", CHANNELS_FIELD);
        map.put("codec", CODEC_FIELD);
        map.put("frameRate", FRAME_RATE_FIELD);
        map.put("frameResolution", FRAME_RESOLUTION_FIELD);
        map.put("pid", PID_FIELD);
        map.put("sampleRate", SAMPLE_RATE_FIELD);
        map.put("sampleSize", SAMPLE_SIZE_FIELD);
        map.put("streamType", STREAM_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransportStream, T> g) {
        return obj -> g.apply((TransportStream)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer channels;
        private String codec;
        private String frameRate;
        private FrameResolution frameResolution;
        private Integer pid;
        private Integer sampleRate;
        private Integer sampleSize;
        private String streamType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransportStream model) {
            this.channels(model.channels);
            this.codec(model.codec);
            this.frameRate(model.frameRate);
            this.frameResolution(model.frameResolution);
            this.pid(model.pid);
            this.sampleRate(model.sampleRate);
            this.sampleSize(model.sampleSize);
            this.streamType(model.streamType);
        }

        public final Integer getChannels() {
            return this.channels;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final String getFrameRate() {
            return this.frameRate;
        }

        public final void setFrameRate(String frameRate) {
            this.frameRate = frameRate;
        }

        @Override
        public final Builder frameRate(String frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final FrameResolution.Builder getFrameResolution() {
            return this.frameResolution != null ? this.frameResolution.toBuilder() : null;
        }

        public final void setFrameResolution(FrameResolution.BuilderImpl frameResolution) {
            this.frameResolution = frameResolution != null ? frameResolution.build() : null;
        }

        @Override
        public final Builder frameResolution(FrameResolution frameResolution) {
            this.frameResolution = frameResolution;
            return this;
        }

        public final Integer getPid() {
            return this.pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Integer getSampleSize() {
            return this.sampleSize;
        }

        public final void setSampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getStreamType() {
            return this.streamType;
        }

        public final void setStreamType(String streamType) {
            this.streamType = streamType;
        }

        @Override
        public final Builder streamType(String streamType) {
            this.streamType = streamType;
            return this;
        }

        public TransportStream build() {
            return new TransportStream(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransportStream> {
        public Builder channels(Integer var1);

        public Builder codec(String var1);

        public Builder frameRate(String var1);

        public Builder frameResolution(FrameResolution var1);

        default public Builder frameResolution(Consumer<FrameResolution.Builder> frameResolution) {
            return this.frameResolution((FrameResolution)((FrameResolution.Builder)FrameResolution.builder().applyMutation(frameResolution)).build());
        }

        public Builder pid(Integer var1);

        public Builder sampleRate(Integer var1);

        public Builder sampleSize(Integer var1);

        public Builder streamType(String var1);
    }
}

