/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Entitlement;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowEntitlementResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, UpdateFlowEntitlementResponse> {
    private static final SdkField<Entitlement> ENTITLEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Entitlement").getter(UpdateFlowEntitlementResponse.getter(UpdateFlowEntitlementResponse::entitlement)).setter(UpdateFlowEntitlementResponse.setter(Builder::entitlement)).constructor(Entitlement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlement").build()}).build();
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(UpdateFlowEntitlementResponse.getter(UpdateFlowEntitlementResponse::flowArn)).setter(UpdateFlowEntitlementResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENT_FIELD, FLOW_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFlowEntitlementResponse.memberNameToFieldInitializer();
    private final Entitlement entitlement;
    private final String flowArn;

    private UpdateFlowEntitlementResponse(BuilderImpl builder) {
        super(builder);
        this.entitlement = builder.entitlement;
        this.flowArn = builder.flowArn;
    }

    public final Entitlement entitlement() {
        return this.entitlement;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlement());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowEntitlementResponse)) {
            return false;
        }
        UpdateFlowEntitlementResponse other = (UpdateFlowEntitlementResponse)((Object)obj);
        return Objects.equals(this.entitlement(), other.entitlement()) && Objects.equals(this.flowArn(), other.flowArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowEntitlementResponse").add("Entitlement", (Object)this.entitlement()).add("FlowArn", (Object)this.flowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entitlement": {
                return Optional.ofNullable(clazz.cast(this.entitlement()));
            }
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entitlement", ENTITLEMENT_FIELD);
        map.put("flowArn", FLOW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowEntitlementResponse, T> g) {
        return obj -> g.apply((UpdateFlowEntitlementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private Entitlement entitlement;
        private String flowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowEntitlementResponse model) {
            super(model);
            this.entitlement(model.entitlement);
            this.flowArn(model.flowArn);
        }

        public final Entitlement.Builder getEntitlement() {
            return this.entitlement != null ? this.entitlement.toBuilder() : null;
        }

        public final void setEntitlement(Entitlement.BuilderImpl entitlement) {
            this.entitlement = entitlement != null ? entitlement.build() : null;
        }

        @Override
        public final Builder entitlement(Entitlement entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        @Override
        public UpdateFlowEntitlementResponse build() {
            return new UpdateFlowEntitlementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowEntitlementResponse> {
        public Builder entitlement(Entitlement var1);

        default public Builder entitlement(Consumer<Entitlement.Builder> entitlement) {
            return this.entitlement((Entitlement)((Entitlement.Builder)Entitlement.builder().applyMutation(entitlement)).build());
        }

        public Builder flowArn(String var1);
    }
}

