/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.BridgeOutput;
import software.amazon.awssdk.services.mediaconnect.model.BridgeSource;
import software.amazon.awssdk.services.mediaconnect.model.BridgeState;
import software.amazon.awssdk.services.mediaconnect.model.EgressGatewayBridge;
import software.amazon.awssdk.services.mediaconnect.model.FailoverConfig;
import software.amazon.awssdk.services.mediaconnect.model.IngressGatewayBridge;
import software.amazon.awssdk.services.mediaconnect.model.MessageDetail;
import software.amazon.awssdk.services.mediaconnect.model.___listOfBridgeOutputCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfBridgeSourceCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMessageDetailCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Bridge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Bridge> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(Bridge.getter(Bridge::bridgeArn)).setter(Bridge.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()}).build();
    private static final SdkField<List<MessageDetail>> BRIDGE_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BridgeMessages").getter(Bridge.getter(Bridge::bridgeMessages)).setter(Bridge.setter(Builder::bridgeMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BRIDGE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeState").getter(Bridge.getter(Bridge::bridgeStateAsString)).setter(Bridge.setter(Builder::bridgeState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeState").build()}).build();
    private static final SdkField<EgressGatewayBridge> EGRESS_GATEWAY_BRIDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EgressGatewayBridge").getter(Bridge.getter(Bridge::egressGatewayBridge)).setter(Bridge.setter(Builder::egressGatewayBridge)).constructor(EgressGatewayBridge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressGatewayBridge").build()}).build();
    private static final SdkField<IngressGatewayBridge> INGRESS_GATEWAY_BRIDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressGatewayBridge").getter(Bridge.getter(Bridge::ingressGatewayBridge)).setter(Bridge.setter(Builder::ingressGatewayBridge)).constructor(IngressGatewayBridge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressGatewayBridge").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Bridge.getter(Bridge::name)).setter(Bridge.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<BridgeOutput>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(Bridge.getter(Bridge::outputs)).setter(Bridge.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BridgeOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLACEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementArn").getter(Bridge.getter(Bridge::placementArn)).setter(Bridge.setter(Builder::placementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementArn").build()}).build();
    private static final SdkField<FailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceFailoverConfig").getter(Bridge.getter(Bridge::sourceFailoverConfig)).setter(Bridge.setter(Builder::sourceFailoverConfig)).constructor(FailoverConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build()}).build();
    private static final SdkField<List<BridgeSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(Bridge.getter(Bridge::sources)).setter(Bridge.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BridgeSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, BRIDGE_MESSAGES_FIELD, BRIDGE_STATE_FIELD, EGRESS_GATEWAY_BRIDGE_FIELD, INGRESS_GATEWAY_BRIDGE_FIELD, NAME_FIELD, OUTPUTS_FIELD, PLACEMENT_ARN_FIELD, SOURCE_FAILOVER_CONFIG_FIELD, SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Bridge.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bridgeArn;
    private final List<MessageDetail> bridgeMessages;
    private final String bridgeState;
    private final EgressGatewayBridge egressGatewayBridge;
    private final IngressGatewayBridge ingressGatewayBridge;
    private final String name;
    private final List<BridgeOutput> outputs;
    private final String placementArn;
    private final FailoverConfig sourceFailoverConfig;
    private final List<BridgeSource> sources;

    private Bridge(BuilderImpl builder) {
        this.bridgeArn = builder.bridgeArn;
        this.bridgeMessages = builder.bridgeMessages;
        this.bridgeState = builder.bridgeState;
        this.egressGatewayBridge = builder.egressGatewayBridge;
        this.ingressGatewayBridge = builder.ingressGatewayBridge;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.placementArn = builder.placementArn;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.sources = builder.sources;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final boolean hasBridgeMessages() {
        return this.bridgeMessages != null && !(this.bridgeMessages instanceof SdkAutoConstructList);
    }

    public final List<MessageDetail> bridgeMessages() {
        return this.bridgeMessages;
    }

    public final BridgeState bridgeState() {
        return BridgeState.fromValue(this.bridgeState);
    }

    public final String bridgeStateAsString() {
        return this.bridgeState;
    }

    public final EgressGatewayBridge egressGatewayBridge() {
        return this.egressGatewayBridge;
    }

    public final IngressGatewayBridge ingressGatewayBridge() {
        return this.ingressGatewayBridge;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<BridgeOutput> outputs() {
        return this.outputs;
    }

    public final String placementArn() {
        return this.placementArn;
    }

    public final FailoverConfig sourceFailoverConfig() {
        return this.sourceFailoverConfig;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<BridgeSource> sources() {
        return this.sources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBridgeMessages() ? this.bridgeMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.placementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bridge)) {
            return false;
        }
        Bridge other = (Bridge)obj;
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && this.hasBridgeMessages() == other.hasBridgeMessages() && Objects.equals(this.bridgeMessages(), other.bridgeMessages()) && Objects.equals(this.bridgeStateAsString(), other.bridgeStateAsString()) && Objects.equals(this.egressGatewayBridge(), other.egressGatewayBridge()) && Objects.equals(this.ingressGatewayBridge(), other.ingressGatewayBridge()) && Objects.equals(this.name(), other.name()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.placementArn(), other.placementArn()) && Objects.equals(this.sourceFailoverConfig(), other.sourceFailoverConfig()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"Bridge").add("BridgeArn", (Object)this.bridgeArn()).add("BridgeMessages", this.hasBridgeMessages() ? this.bridgeMessages() : null).add("BridgeState", (Object)this.bridgeStateAsString()).add("EgressGatewayBridge", (Object)this.egressGatewayBridge()).add("IngressGatewayBridge", (Object)this.ingressGatewayBridge()).add("Name", (Object)this.name()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("PlacementArn", (Object)this.placementArn()).add("SourceFailoverConfig", (Object)this.sourceFailoverConfig()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "BridgeMessages": {
                return Optional.ofNullable(clazz.cast(this.bridgeMessages()));
            }
            case "BridgeState": {
                return Optional.ofNullable(clazz.cast(this.bridgeStateAsString()));
            }
            case "EgressGatewayBridge": {
                return Optional.ofNullable(clazz.cast(this.egressGatewayBridge()));
            }
            case "IngressGatewayBridge": {
                return Optional.ofNullable(clazz.cast(this.ingressGatewayBridge()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "PlacementArn": {
                return Optional.ofNullable(clazz.cast(this.placementArn()));
            }
            case "SourceFailoverConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFailoverConfig()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("bridgeMessages", BRIDGE_MESSAGES_FIELD);
        map.put("bridgeState", BRIDGE_STATE_FIELD);
        map.put("egressGatewayBridge", EGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("ingressGatewayBridge", INGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("placementArn", PLACEMENT_ARN_FIELD);
        map.put("sourceFailoverConfig", SOURCE_FAILOVER_CONFIG_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Bridge, T> g) {
        return obj -> g.apply((Bridge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bridgeArn;
        private List<MessageDetail> bridgeMessages = DefaultSdkAutoConstructList.getInstance();
        private String bridgeState;
        private EgressGatewayBridge egressGatewayBridge;
        private IngressGatewayBridge ingressGatewayBridge;
        private String name;
        private List<BridgeOutput> outputs = DefaultSdkAutoConstructList.getInstance();
        private String placementArn;
        private FailoverConfig sourceFailoverConfig;
        private List<BridgeSource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Bridge model) {
            this.bridgeArn(model.bridgeArn);
            this.bridgeMessages(model.bridgeMessages);
            this.bridgeState(model.bridgeState);
            this.egressGatewayBridge(model.egressGatewayBridge);
            this.ingressGatewayBridge(model.ingressGatewayBridge);
            this.name(model.name);
            this.outputs(model.outputs);
            this.placementArn(model.placementArn);
            this.sourceFailoverConfig(model.sourceFailoverConfig);
            this.sources(model.sources);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final List<MessageDetail.Builder> getBridgeMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.bridgeMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBridgeMessages(Collection<MessageDetail.BuilderImpl> bridgeMessages) {
            this.bridgeMessages = ___listOfMessageDetailCopier.copyFromBuilder(bridgeMessages);
        }

        @Override
        public final Builder bridgeMessages(Collection<MessageDetail> bridgeMessages) {
            this.bridgeMessages = ___listOfMessageDetailCopier.copy(bridgeMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bridgeMessages(MessageDetail ... bridgeMessages) {
            this.bridgeMessages(Arrays.asList(bridgeMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bridgeMessages(Consumer<MessageDetail.Builder> ... bridgeMessages) {
            this.bridgeMessages(Stream.of(bridgeMessages).map(c -> (MessageDetail)((MessageDetail.Builder)MessageDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBridgeState() {
            return this.bridgeState;
        }

        public final void setBridgeState(String bridgeState) {
            this.bridgeState = bridgeState;
        }

        @Override
        public final Builder bridgeState(String bridgeState) {
            this.bridgeState = bridgeState;
            return this;
        }

        @Override
        public final Builder bridgeState(BridgeState bridgeState) {
            this.bridgeState(bridgeState == null ? null : bridgeState.toString());
            return this;
        }

        public final EgressGatewayBridge.Builder getEgressGatewayBridge() {
            return this.egressGatewayBridge != null ? this.egressGatewayBridge.toBuilder() : null;
        }

        public final void setEgressGatewayBridge(EgressGatewayBridge.BuilderImpl egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge != null ? egressGatewayBridge.build() : null;
        }

        @Override
        public final Builder egressGatewayBridge(EgressGatewayBridge egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge;
            return this;
        }

        public final IngressGatewayBridge.Builder getIngressGatewayBridge() {
            return this.ingressGatewayBridge != null ? this.ingressGatewayBridge.toBuilder() : null;
        }

        public final void setIngressGatewayBridge(IngressGatewayBridge.BuilderImpl ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge != null ? ingressGatewayBridge.build() : null;
        }

        @Override
        public final Builder ingressGatewayBridge(IngressGatewayBridge ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<BridgeOutput.Builder> getOutputs() {
            List<BridgeOutput.Builder> result = ___listOfBridgeOutputCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<BridgeOutput.BuilderImpl> outputs) {
            this.outputs = ___listOfBridgeOutputCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<BridgeOutput> outputs) {
            this.outputs = ___listOfBridgeOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(BridgeOutput ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<BridgeOutput.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (BridgeOutput)((BridgeOutput.Builder)BridgeOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlacementArn() {
            return this.placementArn;
        }

        public final void setPlacementArn(String placementArn) {
            this.placementArn = placementArn;
        }

        @Override
        public final Builder placementArn(String placementArn) {
            this.placementArn = placementArn;
            return this;
        }

        public final FailoverConfig.Builder getSourceFailoverConfig() {
            return this.sourceFailoverConfig != null ? this.sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(FailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final List<BridgeSource.Builder> getSources() {
            List<BridgeSource.Builder> result = ___listOfBridgeSourceCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<BridgeSource.BuilderImpl> sources) {
            this.sources = ___listOfBridgeSourceCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<BridgeSource> sources) {
            this.sources = ___listOfBridgeSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(BridgeSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<BridgeSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (BridgeSource)((BridgeSource.Builder)BridgeSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Bridge build() {
            return new Bridge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Bridge> {
        public Builder bridgeArn(String var1);

        public Builder bridgeMessages(Collection<MessageDetail> var1);

        public Builder bridgeMessages(MessageDetail ... var1);

        public Builder bridgeMessages(Consumer<MessageDetail.Builder> ... var1);

        public Builder bridgeState(String var1);

        public Builder bridgeState(BridgeState var1);

        public Builder egressGatewayBridge(EgressGatewayBridge var1);

        default public Builder egressGatewayBridge(Consumer<EgressGatewayBridge.Builder> egressGatewayBridge) {
            return this.egressGatewayBridge((EgressGatewayBridge)((EgressGatewayBridge.Builder)EgressGatewayBridge.builder().applyMutation(egressGatewayBridge)).build());
        }

        public Builder ingressGatewayBridge(IngressGatewayBridge var1);

        default public Builder ingressGatewayBridge(Consumer<IngressGatewayBridge.Builder> ingressGatewayBridge) {
            return this.ingressGatewayBridge((IngressGatewayBridge)((IngressGatewayBridge.Builder)IngressGatewayBridge.builder().applyMutation(ingressGatewayBridge)).build());
        }

        public Builder name(String var1);

        public Builder outputs(Collection<BridgeOutput> var1);

        public Builder outputs(BridgeOutput ... var1);

        public Builder outputs(Consumer<BridgeOutput.Builder> ... var1);

        public Builder placementArn(String var1);

        public Builder sourceFailoverConfig(FailoverConfig var1);

        default public Builder sourceFailoverConfig(Consumer<FailoverConfig.Builder> sourceFailoverConfig) {
            return this.sourceFailoverConfig((FailoverConfig)((FailoverConfig.Builder)FailoverConfig.builder().applyMutation(sourceFailoverConfig)).build());
        }

        public Builder sources(Collection<BridgeSource> var1);

        public Builder sources(BridgeSource ... var1);

        public Builder sources(Consumer<BridgeSource.Builder> ... var1);
    }
}

