/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Gateway;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGatewayResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, CreateGatewayResponse> {
    private static final SdkField<Gateway> GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Gateway").getter(CreateGatewayResponse.getter(CreateGatewayResponse::gateway)).setter(CreateGatewayResponse.setter(Builder::gateway)).constructor(Gateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gateway").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGatewayResponse.memberNameToFieldInitializer();
    private final Gateway gateway;

    private CreateGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.gateway = builder.gateway;
    }

    public final Gateway gateway() {
        return this.gateway;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gateway());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayResponse)) {
            return false;
        }
        CreateGatewayResponse other = (CreateGatewayResponse)((Object)obj);
        return Objects.equals(this.gateway(), other.gateway());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGatewayResponse").add("Gateway", (Object)this.gateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Gateway": {
                return Optional.ofNullable(clazz.cast(this.gateway()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Gateway>> map = new HashMap<String, SdkField<Gateway>>();
        map.put("gateway", GATEWAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayResponse, T> g) {
        return obj -> g.apply((CreateGatewayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private Gateway gateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayResponse model) {
            super(model);
            this.gateway(model.gateway);
        }

        public final Gateway.Builder getGateway() {
            return this.gateway != null ? this.gateway.toBuilder() : null;
        }

        public final void setGateway(Gateway.BuilderImpl gateway) {
            this.gateway = gateway != null ? gateway.build() : null;
        }

        @Override
        public final Builder gateway(Gateway gateway) {
            this.gateway = gateway;
            return this;
        }

        @Override
        public CreateGatewayResponse build() {
            return new CreateGatewayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGatewayResponse> {
        public Builder gateway(Gateway var1);

        default public Builder gateway(Consumer<Gateway.Builder> gateway) {
            return this.gateway((Gateway)((Gateway.Builder)Gateway.builder().applyMutation(gateway)).build());
        }
    }
}

