/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Algorithm;
import software.amazon.awssdk.services.mediaconnect.model.KeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Encryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Encryption> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Algorithm").getter(Encryption.getter(Encryption::algorithmAsString)).setter(Encryption.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConstantInitializationVector").getter(Encryption.getter(Encryption::constantInitializationVector)).setter(Encryption.setter(Builder::constantInitializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantInitializationVector").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(Encryption.getter(Encryption::deviceId)).setter(Encryption.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceId").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyType").getter(Encryption.getter(Encryption::keyTypeAsString)).setter(Encryption.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Encryption.getter(Encryption::region)).setter(Encryption.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(Encryption.getter(Encryption::resourceId)).setter(Encryption.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(Encryption.getter(Encryption::roleArn)).setter(Encryption.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(Encryption.getter(Encryption::secretArn)).setter(Encryption.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(Encryption.getter(Encryption::url)).setter(Encryption.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, CONSTANT_INITIALIZATION_VECTOR_FIELD, DEVICE_ID_FIELD, KEY_TYPE_FIELD, REGION_FIELD, RESOURCE_ID_FIELD, ROLE_ARN_FIELD, SECRET_ARN_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Encryption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String constantInitializationVector;
    private final String deviceId;
    private final String keyType;
    private final String region;
    private final String resourceId;
    private final String roleArn;
    private final String secretArn;
    private final String url;

    private Encryption(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.constantInitializationVector = builder.constantInitializationVector;
        this.deviceId = builder.deviceId;
        this.keyType = builder.keyType;
        this.region = builder.region;
        this.resourceId = builder.resourceId;
        this.roleArn = builder.roleArn;
        this.secretArn = builder.secretArn;
        this.url = builder.url;
    }

    public final Algorithm algorithm() {
        return Algorithm.fromValue(this.algorithm);
    }

    public final String algorithmAsString() {
        return this.algorithm;
    }

    public final String constantInitializationVector() {
        return this.constantInitializationVector;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final KeyType keyType() {
        return KeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public final String region() {
        return this.region;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Encryption)) {
            return false;
        }
        Encryption other = (Encryption)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.constantInitializationVector(), other.constantInitializationVector()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"Encryption").add("Algorithm", (Object)this.algorithmAsString()).add("ConstantInitializationVector", (Object)this.constantInitializationVector()).add("DeviceId", (Object)this.deviceId()).add("KeyType", (Object)this.keyTypeAsString()).add("Region", (Object)this.region()).add("ResourceId", (Object)this.resourceId()).add("RoleArn", (Object)this.roleArn()).add("SecretArn", (Object)this.secretArn()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "ConstantInitializationVector": {
                return Optional.ofNullable(clazz.cast(this.constantInitializationVector()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("algorithm", ALGORITHM_FIELD);
        map.put("constantInitializationVector", CONSTANT_INITIALIZATION_VECTOR_FIELD);
        map.put("deviceId", DEVICE_ID_FIELD);
        map.put("keyType", KEY_TYPE_FIELD);
        map.put("region", REGION_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("secretArn", SECRET_ARN_FIELD);
        map.put("url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Encryption, T> g) {
        return obj -> g.apply((Encryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String constantInitializationVector;
        private String deviceId;
        private String keyType;
        private String region;
        private String resourceId;
        private String roleArn;
        private String secretArn;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Encryption model) {
            this.algorithm(model.algorithm);
            this.constantInitializationVector(model.constantInitializationVector);
            this.deviceId(model.deviceId);
            this.keyType(model.keyType);
            this.region(model.region);
            this.resourceId(model.resourceId);
            this.roleArn(model.roleArn);
            this.secretArn(model.secretArn);
            this.url(model.url);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final String getConstantInitializationVector() {
            return this.constantInitializationVector;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public Encryption build() {
            return new Encryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Encryption> {
        public Builder algorithm(String var1);

        public Builder algorithm(Algorithm var1);

        public Builder constantInitializationVector(String var1);

        public Builder deviceId(String var1);

        public Builder keyType(String var1);

        public Builder keyType(KeyType var1);

        public Builder region(String var1);

        public Builder resourceId(String var1);

        public Builder roleArn(String var1);

        public Builder secretArn(String var1);

        public Builder url(String var1);
    }
}

