/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.DestinationConfigurationRequest;
import software.amazon.awssdk.services.mediaconnect.model.EncodingName;
import software.amazon.awssdk.services.mediaconnect.model.EncodingParametersRequest;
import software.amazon.awssdk.services.mediaconnect.model.___listOfDestinationConfigurationRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaStreamOutputConfigurationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaStreamOutputConfigurationRequest> {
    private static final SdkField<List<DestinationConfigurationRequest>> DESTINATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationConfigurations").getter(MediaStreamOutputConfigurationRequest.getter(MediaStreamOutputConfigurationRequest::destinationConfigurations)).setter(MediaStreamOutputConfigurationRequest.setter(Builder::destinationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENCODING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncodingName").getter(MediaStreamOutputConfigurationRequest.getter(MediaStreamOutputConfigurationRequest::encodingNameAsString)).setter(MediaStreamOutputConfigurationRequest.setter(Builder::encodingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingName").build()}).build();
    private static final SdkField<EncodingParametersRequest> ENCODING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncodingParameters").getter(MediaStreamOutputConfigurationRequest.getter(MediaStreamOutputConfigurationRequest::encodingParameters)).setter(MediaStreamOutputConfigurationRequest.setter(Builder::encodingParameters)).constructor(EncodingParametersRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingParameters").build()}).build();
    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamName").getter(MediaStreamOutputConfigurationRequest.getter(MediaStreamOutputConfigurationRequest::mediaStreamName)).setter(MediaStreamOutputConfigurationRequest.setter(Builder::mediaStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CONFIGURATIONS_FIELD, ENCODING_NAME_FIELD, ENCODING_PARAMETERS_FIELD, MEDIA_STREAM_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaStreamOutputConfigurationRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DestinationConfigurationRequest> destinationConfigurations;
    private final String encodingName;
    private final EncodingParametersRequest encodingParameters;
    private final String mediaStreamName;

    private MediaStreamOutputConfigurationRequest(BuilderImpl builder) {
        this.destinationConfigurations = builder.destinationConfigurations;
        this.encodingName = builder.encodingName;
        this.encodingParameters = builder.encodingParameters;
        this.mediaStreamName = builder.mediaStreamName;
    }

    public final boolean hasDestinationConfigurations() {
        return this.destinationConfigurations != null && !(this.destinationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DestinationConfigurationRequest> destinationConfigurations() {
        return this.destinationConfigurations;
    }

    public final EncodingName encodingName() {
        return EncodingName.fromValue(this.encodingName);
    }

    public final String encodingNameAsString() {
        return this.encodingName;
    }

    public final EncodingParametersRequest encodingParameters() {
        return this.encodingParameters;
    }

    public final String mediaStreamName() {
        return this.mediaStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationConfigurations() ? this.destinationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamOutputConfigurationRequest)) {
            return false;
        }
        MediaStreamOutputConfigurationRequest other = (MediaStreamOutputConfigurationRequest)obj;
        return this.hasDestinationConfigurations() == other.hasDestinationConfigurations() && Objects.equals(this.destinationConfigurations(), other.destinationConfigurations()) && Objects.equals(this.encodingNameAsString(), other.encodingNameAsString()) && Objects.equals(this.encodingParameters(), other.encodingParameters()) && Objects.equals(this.mediaStreamName(), other.mediaStreamName());
    }

    public final String toString() {
        return ToString.builder((String)"MediaStreamOutputConfigurationRequest").add("DestinationConfigurations", this.hasDestinationConfigurations() ? this.destinationConfigurations() : null).add("EncodingName", (Object)this.encodingNameAsString()).add("EncodingParameters", (Object)this.encodingParameters()).add("MediaStreamName", (Object)this.mediaStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.destinationConfigurations()));
            }
            case "EncodingName": {
                return Optional.ofNullable(clazz.cast(this.encodingNameAsString()));
            }
            case "EncodingParameters": {
                return Optional.ofNullable(clazz.cast(this.encodingParameters()));
            }
            case "MediaStreamName": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinationConfigurations", DESTINATION_CONFIGURATIONS_FIELD);
        map.put("encodingName", ENCODING_NAME_FIELD);
        map.put("encodingParameters", ENCODING_PARAMETERS_FIELD);
        map.put("mediaStreamName", MEDIA_STREAM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamOutputConfigurationRequest, T> g) {
        return obj -> g.apply((MediaStreamOutputConfigurationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DestinationConfigurationRequest> destinationConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String encodingName;
        private EncodingParametersRequest encodingParameters;
        private String mediaStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamOutputConfigurationRequest model) {
            this.destinationConfigurations(model.destinationConfigurations);
            this.encodingName(model.encodingName);
            this.encodingParameters(model.encodingParameters);
            this.mediaStreamName(model.mediaStreamName);
        }

        public final List<DestinationConfigurationRequest.Builder> getDestinationConfigurations() {
            List<DestinationConfigurationRequest.Builder> result = ___listOfDestinationConfigurationRequestCopier.copyToBuilder(this.destinationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationConfigurations(Collection<DestinationConfigurationRequest.BuilderImpl> destinationConfigurations) {
            this.destinationConfigurations = ___listOfDestinationConfigurationRequestCopier.copyFromBuilder(destinationConfigurations);
        }

        @Override
        public final Builder destinationConfigurations(Collection<DestinationConfigurationRequest> destinationConfigurations) {
            this.destinationConfigurations = ___listOfDestinationConfigurationRequestCopier.copy(destinationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(DestinationConfigurationRequest ... destinationConfigurations) {
            this.destinationConfigurations(Arrays.asList(destinationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(Consumer<DestinationConfigurationRequest.Builder> ... destinationConfigurations) {
            this.destinationConfigurations(Stream.of(destinationConfigurations).map(c -> (DestinationConfigurationRequest)((DestinationConfigurationRequest.Builder)DestinationConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEncodingName() {
            return this.encodingName;
        }

        public final void setEncodingName(String encodingName) {
            this.encodingName = encodingName;
        }

        @Override
        public final Builder encodingName(String encodingName) {
            this.encodingName = encodingName;
            return this;
        }

        @Override
        public final Builder encodingName(EncodingName encodingName) {
            this.encodingName(encodingName == null ? null : encodingName.toString());
            return this;
        }

        public final EncodingParametersRequest.Builder getEncodingParameters() {
            return this.encodingParameters != null ? this.encodingParameters.toBuilder() : null;
        }

        public final void setEncodingParameters(EncodingParametersRequest.BuilderImpl encodingParameters) {
            this.encodingParameters = encodingParameters != null ? encodingParameters.build() : null;
        }

        @Override
        public final Builder encodingParameters(EncodingParametersRequest encodingParameters) {
            this.encodingParameters = encodingParameters;
            return this;
        }

        public final String getMediaStreamName() {
            return this.mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        public MediaStreamOutputConfigurationRequest build() {
            return new MediaStreamOutputConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaStreamOutputConfigurationRequest> {
        public Builder destinationConfigurations(Collection<DestinationConfigurationRequest> var1);

        public Builder destinationConfigurations(DestinationConfigurationRequest ... var1);

        public Builder destinationConfigurations(Consumer<DestinationConfigurationRequest.Builder> ... var1);

        public Builder encodingName(String var1);

        public Builder encodingName(EncodingName var1);

        public Builder encodingParameters(EncodingParametersRequest var1);

        default public Builder encodingParameters(Consumer<EncodingParametersRequest.Builder> encodingParameters) {
            return this.encodingParameters((EncodingParametersRequest)((EncodingParametersRequest.Builder)EncodingParametersRequest.builder().applyMutation(encodingParameters)).build());
        }

        public Builder mediaStreamName(String var1);
    }
}

