/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.___listOfVpcInterfaceRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddFlowVpcInterfacesRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, AddFlowVpcInterfacesRequest> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(AddFlowVpcInterfacesRequest.getter(AddFlowVpcInterfacesRequest::flowArn)).setter(AddFlowVpcInterfacesRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FlowArn").build()}).build();
    private static final SdkField<List<VpcInterfaceRequest>> VPC_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcInterfaces").getter(AddFlowVpcInterfacesRequest.getter(AddFlowVpcInterfacesRequest::vpcInterfaces)).setter(AddFlowVpcInterfacesRequest.setter(Builder::vpcInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcInterfaceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, VPC_INTERFACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddFlowVpcInterfacesRequest.memberNameToFieldInitializer();
    private final String flowArn;
    private final List<VpcInterfaceRequest> vpcInterfaces;

    private AddFlowVpcInterfacesRequest(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.vpcInterfaces = builder.vpcInterfaces;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final boolean hasVpcInterfaces() {
        return this.vpcInterfaces != null && !(this.vpcInterfaces instanceof SdkAutoConstructList);
    }

    public final List<VpcInterfaceRequest> vpcInterfaces() {
        return this.vpcInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcInterfaces() ? this.vpcInterfaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFlowVpcInterfacesRequest)) {
            return false;
        }
        AddFlowVpcInterfacesRequest other = (AddFlowVpcInterfacesRequest)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && this.hasVpcInterfaces() == other.hasVpcInterfaces() && Objects.equals(this.vpcInterfaces(), other.vpcInterfaces());
    }

    public final String toString() {
        return ToString.builder((String)"AddFlowVpcInterfacesRequest").add("FlowArn", (Object)this.flowArn()).add("VpcInterfaces", this.hasVpcInterfaces() ? this.vpcInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "VpcInterfaces": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FlowArn", FLOW_ARN_FIELD);
        map.put("vpcInterfaces", VPC_INTERFACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddFlowVpcInterfacesRequest, T> g) {
        return obj -> g.apply((AddFlowVpcInterfacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String flowArn;
        private List<VpcInterfaceRequest> vpcInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddFlowVpcInterfacesRequest model) {
            super(model);
            this.flowArn(model.flowArn);
            this.vpcInterfaces(model.vpcInterfaces);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final List<VpcInterfaceRequest.Builder> getVpcInterfaces() {
            List<VpcInterfaceRequest.Builder> result = ___listOfVpcInterfaceRequestCopier.copyToBuilder(this.vpcInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcInterfaces(Collection<VpcInterfaceRequest.BuilderImpl> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceRequestCopier.copyFromBuilder(vpcInterfaces);
        }

        @Override
        public final Builder vpcInterfaces(Collection<VpcInterfaceRequest> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceRequestCopier.copy(vpcInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(VpcInterfaceRequest ... vpcInterfaces) {
            this.vpcInterfaces(Arrays.asList(vpcInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(Consumer<VpcInterfaceRequest.Builder> ... vpcInterfaces) {
            this.vpcInterfaces(Stream.of(vpcInterfaces).map(c -> (VpcInterfaceRequest)((VpcInterfaceRequest.Builder)VpcInterfaceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddFlowVpcInterfacesRequest build() {
            return new AddFlowVpcInterfacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddFlowVpcInterfacesRequest> {
        public Builder flowArn(String var1);

        public Builder vpcInterfaces(Collection<VpcInterfaceRequest> var1);

        public Builder vpcInterfaces(VpcInterfaceRequest ... var1);

        public Builder vpcInterfaces(Consumer<VpcInterfaceRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

