/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.TransportStream;
import software.amazon.awssdk.services.mediaconnect.model.___listOfTransportStreamCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransportStreamProgram
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransportStreamProgram> {
    private static final SdkField<Integer> PCR_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PcrPid").getter(TransportStreamProgram.getter(TransportStreamProgram::pcrPid)).setter(TransportStreamProgram.setter(Builder::pcrPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPid").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(TransportStreamProgram.getter(TransportStreamProgram::programName)).setter(TransportStreamProgram.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()}).build();
    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramNumber").getter(TransportStreamProgram.getter(TransportStreamProgram::programNumber)).setter(TransportStreamProgram.setter(Builder::programNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()}).build();
    private static final SdkField<Integer> PROGRAM_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramPid").getter(TransportStreamProgram.getter(TransportStreamProgram::programPid)).setter(TransportStreamProgram.setter(Builder::programPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programPid").build()}).build();
    private static final SdkField<List<TransportStream>> STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Streams").getter(TransportStreamProgram.getter(TransportStreamProgram::streams)).setter(TransportStreamProgram.setter(Builder::streams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransportStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PCR_PID_FIELD, PROGRAM_NAME_FIELD, PROGRAM_NUMBER_FIELD, PROGRAM_PID_FIELD, STREAMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransportStreamProgram.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer pcrPid;
    private final String programName;
    private final Integer programNumber;
    private final Integer programPid;
    private final List<TransportStream> streams;

    private TransportStreamProgram(BuilderImpl builder) {
        this.pcrPid = builder.pcrPid;
        this.programName = builder.programName;
        this.programNumber = builder.programNumber;
        this.programPid = builder.programPid;
        this.streams = builder.streams;
    }

    public final Integer pcrPid() {
        return this.pcrPid;
    }

    public final String programName() {
        return this.programName;
    }

    public final Integer programNumber() {
        return this.programNumber;
    }

    public final Integer programPid() {
        return this.programPid;
    }

    public final boolean hasStreams() {
        return this.streams != null && !(this.streams instanceof SdkAutoConstructList);
    }

    public final List<TransportStream> streams() {
        return this.streams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.programPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreams() ? this.streams() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransportStreamProgram)) {
            return false;
        }
        TransportStreamProgram other = (TransportStreamProgram)obj;
        return Objects.equals(this.pcrPid(), other.pcrPid()) && Objects.equals(this.programName(), other.programName()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.programPid(), other.programPid()) && this.hasStreams() == other.hasStreams() && Objects.equals(this.streams(), other.streams());
    }

    public final String toString() {
        return ToString.builder((String)"TransportStreamProgram").add("PcrPid", (Object)this.pcrPid()).add("ProgramName", (Object)this.programName()).add("ProgramNumber", (Object)this.programNumber()).add("ProgramPid", (Object)this.programPid()).add("Streams", this.hasStreams() ? this.streams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PcrPid": {
                return Optional.ofNullable(clazz.cast(this.pcrPid()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
            case "ProgramNumber": {
                return Optional.ofNullable(clazz.cast(this.programNumber()));
            }
            case "ProgramPid": {
                return Optional.ofNullable(clazz.cast(this.programPid()));
            }
            case "Streams": {
                return Optional.ofNullable(clazz.cast(this.streams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pcrPid", PCR_PID_FIELD);
        map.put("programName", PROGRAM_NAME_FIELD);
        map.put("programNumber", PROGRAM_NUMBER_FIELD);
        map.put("programPid", PROGRAM_PID_FIELD);
        map.put("streams", STREAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransportStreamProgram, T> g) {
        return obj -> g.apply((TransportStreamProgram)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer pcrPid;
        private String programName;
        private Integer programNumber;
        private Integer programPid;
        private List<TransportStream> streams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransportStreamProgram model) {
            this.pcrPid(model.pcrPid);
            this.programName(model.programName);
            this.programNumber(model.programNumber);
            this.programPid(model.programPid);
            this.streams(model.streams);
        }

        public final Integer getPcrPid() {
            return this.pcrPid;
        }

        public final void setPcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
        }

        @Override
        public final Builder pcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final String getProgramName() {
            return this.programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final Integer getProgramPid() {
            return this.programPid;
        }

        public final void setProgramPid(Integer programPid) {
            this.programPid = programPid;
        }

        @Override
        public final Builder programPid(Integer programPid) {
            this.programPid = programPid;
            return this;
        }

        public final List<TransportStream.Builder> getStreams() {
            List<TransportStream.Builder> result = ___listOfTransportStreamCopier.copyToBuilder(this.streams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreams(Collection<TransportStream.BuilderImpl> streams) {
            this.streams = ___listOfTransportStreamCopier.copyFromBuilder(streams);
        }

        @Override
        public final Builder streams(Collection<TransportStream> streams) {
            this.streams = ___listOfTransportStreamCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(TransportStream ... streams) {
            this.streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<TransportStream.Builder> ... streams) {
            this.streams(Stream.of(streams).map(c -> (TransportStream)((TransportStream.Builder)TransportStream.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransportStreamProgram build() {
            return new TransportStreamProgram(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransportStreamProgram> {
        public Builder pcrPid(Integer var1);

        public Builder programName(String var1);

        public Builder programNumber(Integer var1);

        public Builder programPid(Integer var1);

        public Builder streams(Collection<TransportStream> var1);

        public Builder streams(TransportStream ... var1);

        public Builder streams(Consumer<TransportStream.Builder> ... var1);
    }
}

