/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NdiDiscoveryServerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NdiDiscoveryServerConfig> {
    private static final SdkField<String> DISCOVERY_SERVER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryServerAddress").getter(NdiDiscoveryServerConfig.getter(NdiDiscoveryServerConfig::discoveryServerAddress)).setter(NdiDiscoveryServerConfig.setter(Builder::discoveryServerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryServerAddress").build()}).build();
    private static final SdkField<Integer> DISCOVERY_SERVER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DiscoveryServerPort").getter(NdiDiscoveryServerConfig.getter(NdiDiscoveryServerConfig::discoveryServerPort)).setter(NdiDiscoveryServerConfig.setter(Builder::discoveryServerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryServerPort").build()}).build();
    private static final SdkField<String> VPC_INTERFACE_ADAPTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcInterfaceAdapter").getter(NdiDiscoveryServerConfig.getter(NdiDiscoveryServerConfig::vpcInterfaceAdapter)).setter(NdiDiscoveryServerConfig.setter(Builder::vpcInterfaceAdapter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceAdapter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_SERVER_ADDRESS_FIELD, DISCOVERY_SERVER_PORT_FIELD, VPC_INTERFACE_ADAPTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NdiDiscoveryServerConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String discoveryServerAddress;
    private final Integer discoveryServerPort;
    private final String vpcInterfaceAdapter;

    private NdiDiscoveryServerConfig(BuilderImpl builder) {
        this.discoveryServerAddress = builder.discoveryServerAddress;
        this.discoveryServerPort = builder.discoveryServerPort;
        this.vpcInterfaceAdapter = builder.vpcInterfaceAdapter;
    }

    public final String discoveryServerAddress() {
        return this.discoveryServerAddress;
    }

    public final Integer discoveryServerPort() {
        return this.discoveryServerPort;
    }

    public final String vpcInterfaceAdapter() {
        return this.vpcInterfaceAdapter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryServerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryServerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcInterfaceAdapter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NdiDiscoveryServerConfig)) {
            return false;
        }
        NdiDiscoveryServerConfig other = (NdiDiscoveryServerConfig)obj;
        return Objects.equals(this.discoveryServerAddress(), other.discoveryServerAddress()) && Objects.equals(this.discoveryServerPort(), other.discoveryServerPort()) && Objects.equals(this.vpcInterfaceAdapter(), other.vpcInterfaceAdapter());
    }

    public final String toString() {
        return ToString.builder((String)"NdiDiscoveryServerConfig").add("DiscoveryServerAddress", (Object)this.discoveryServerAddress()).add("DiscoveryServerPort", (Object)this.discoveryServerPort()).add("VpcInterfaceAdapter", (Object)this.vpcInterfaceAdapter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DiscoveryServerAddress": {
                return Optional.ofNullable(clazz.cast(this.discoveryServerAddress()));
            }
            case "DiscoveryServerPort": {
                return Optional.ofNullable(clazz.cast(this.discoveryServerPort()));
            }
            case "VpcInterfaceAdapter": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaceAdapter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("discoveryServerAddress", DISCOVERY_SERVER_ADDRESS_FIELD);
        map.put("discoveryServerPort", DISCOVERY_SERVER_PORT_FIELD);
        map.put("vpcInterfaceAdapter", VPC_INTERFACE_ADAPTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NdiDiscoveryServerConfig, T> g) {
        return obj -> g.apply((NdiDiscoveryServerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String discoveryServerAddress;
        private Integer discoveryServerPort;
        private String vpcInterfaceAdapter;

        private BuilderImpl() {
        }

        private BuilderImpl(NdiDiscoveryServerConfig model) {
            this.discoveryServerAddress(model.discoveryServerAddress);
            this.discoveryServerPort(model.discoveryServerPort);
            this.vpcInterfaceAdapter(model.vpcInterfaceAdapter);
        }

        public final String getDiscoveryServerAddress() {
            return this.discoveryServerAddress;
        }

        public final void setDiscoveryServerAddress(String discoveryServerAddress) {
            this.discoveryServerAddress = discoveryServerAddress;
        }

        @Override
        public final Builder discoveryServerAddress(String discoveryServerAddress) {
            this.discoveryServerAddress = discoveryServerAddress;
            return this;
        }

        public final Integer getDiscoveryServerPort() {
            return this.discoveryServerPort;
        }

        public final void setDiscoveryServerPort(Integer discoveryServerPort) {
            this.discoveryServerPort = discoveryServerPort;
        }

        @Override
        public final Builder discoveryServerPort(Integer discoveryServerPort) {
            this.discoveryServerPort = discoveryServerPort;
            return this;
        }

        public final String getVpcInterfaceAdapter() {
            return this.vpcInterfaceAdapter;
        }

        public final void setVpcInterfaceAdapter(String vpcInterfaceAdapter) {
            this.vpcInterfaceAdapter = vpcInterfaceAdapter;
        }

        @Override
        public final Builder vpcInterfaceAdapter(String vpcInterfaceAdapter) {
            this.vpcInterfaceAdapter = vpcInterfaceAdapter;
            return this;
        }

        public NdiDiscoveryServerConfig build() {
            return new NdiDiscoveryServerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NdiDiscoveryServerConfig> {
        public Builder discoveryServerAddress(String var1);

        public Builder discoveryServerPort(Integer var1);

        public Builder vpcInterfaceAdapter(String var1);
    }
}

