/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeFlowEntitlementResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, RevokeFlowEntitlementResponse> {
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementArn").getter(RevokeFlowEntitlementResponse.getter(RevokeFlowEntitlementResponse::entitlementArn)).setter(RevokeFlowEntitlementResponse.setter(Builder::entitlementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()}).build();
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(RevokeFlowEntitlementResponse.getter(RevokeFlowEntitlementResponse::flowArn)).setter(RevokeFlowEntitlementResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENT_ARN_FIELD, FLOW_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevokeFlowEntitlementResponse.memberNameToFieldInitializer();
    private final String entitlementArn;
    private final String flowArn;

    private RevokeFlowEntitlementResponse(BuilderImpl builder) {
        super(builder);
        this.entitlementArn = builder.entitlementArn;
        this.flowArn = builder.flowArn;
    }

    public final String entitlementArn() {
        return this.entitlementArn;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeFlowEntitlementResponse)) {
            return false;
        }
        RevokeFlowEntitlementResponse other = (RevokeFlowEntitlementResponse)((Object)obj);
        return Objects.equals(this.entitlementArn(), other.entitlementArn()) && Objects.equals(this.flowArn(), other.flowArn());
    }

    public final String toString() {
        return ToString.builder((String)"RevokeFlowEntitlementResponse").add("EntitlementArn", (Object)this.entitlementArn()).add("FlowArn", (Object)this.flowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntitlementArn": {
                return Optional.ofNullable(clazz.cast(this.entitlementArn()));
            }
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("entitlementArn", ENTITLEMENT_ARN_FIELD);
        map.put("flowArn", FLOW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeFlowEntitlementResponse, T> g) {
        return obj -> g.apply((RevokeFlowEntitlementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String entitlementArn;
        private String flowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeFlowEntitlementResponse model) {
            super(model);
            this.entitlementArn(model.entitlementArn);
            this.flowArn(model.flowArn);
        }

        public final String getEntitlementArn() {
            return this.entitlementArn;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        @Override
        public RevokeFlowEntitlementResponse build() {
            return new RevokeFlowEntitlementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RevokeFlowEntitlementResponse> {
        public Builder entitlementArn(String var1);

        public Builder flowArn(String var1);
    }
}

