/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.BridgePlacement;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGatewayInstanceRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateGatewayInstanceRequest> {
    private static final SdkField<String> BRIDGE_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgePlacement").getter(UpdateGatewayInstanceRequest.getter(UpdateGatewayInstanceRequest::bridgePlacementAsString)).setter(UpdateGatewayInstanceRequest.setter(Builder::bridgePlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgePlacement").build()}).build();
    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayInstanceArn").getter(UpdateGatewayInstanceRequest.getter(UpdateGatewayInstanceRequest::gatewayInstanceArn)).setter(UpdateGatewayInstanceRequest.setter(Builder::gatewayInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayInstanceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_PLACEMENT_FIELD, GATEWAY_INSTANCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bridgePlacement", BRIDGE_PLACEMENT_FIELD);
            this.put("gatewayInstanceArn", GATEWAY_INSTANCE_ARN_FIELD);
        }
    });
    private final String bridgePlacement;
    private final String gatewayInstanceArn;

    private UpdateGatewayInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.bridgePlacement = builder.bridgePlacement;
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
    }

    public final BridgePlacement bridgePlacement() {
        return BridgePlacement.fromValue(this.bridgePlacement);
    }

    public final String bridgePlacementAsString() {
        return this.bridgePlacement;
    }

    public final String gatewayInstanceArn() {
        return this.gatewayInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgePlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayInstanceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayInstanceRequest)) {
            return false;
        }
        UpdateGatewayInstanceRequest other = (UpdateGatewayInstanceRequest)((Object)obj);
        return Objects.equals(this.bridgePlacementAsString(), other.bridgePlacementAsString()) && Objects.equals(this.gatewayInstanceArn(), other.gatewayInstanceArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGatewayInstanceRequest").add("BridgePlacement", (Object)this.bridgePlacementAsString()).add("GatewayInstanceArn", (Object)this.gatewayInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgePlacement": {
                return Optional.ofNullable(clazz.cast(this.bridgePlacementAsString()));
            }
            case "GatewayInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayInstanceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayInstanceRequest, T> g) {
        return obj -> g.apply((UpdateGatewayInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String bridgePlacement;
        private String gatewayInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayInstanceRequest model) {
            super(model);
            this.bridgePlacement(model.bridgePlacement);
            this.gatewayInstanceArn(model.gatewayInstanceArn);
        }

        public final String getBridgePlacement() {
            return this.bridgePlacement;
        }

        public final void setBridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
        }

        @Override
        public final Builder bridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
            return this;
        }

        @Override
        public final Builder bridgePlacement(BridgePlacement bridgePlacement) {
            this.bridgePlacement(bridgePlacement == null ? null : bridgePlacement.toString());
            return this;
        }

        public final String getGatewayInstanceArn() {
            return this.gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGatewayInstanceRequest build() {
            return new UpdateGatewayInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGatewayInstanceRequest> {
        public Builder bridgePlacement(String var1);

        public Builder bridgePlacement(BridgePlacement var1);

        public Builder gatewayInstanceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

