/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.BridgeOutput;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBridgeOutputResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, UpdateBridgeOutputResponse> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(UpdateBridgeOutputResponse.getter(UpdateBridgeOutputResponse::bridgeArn)).setter(UpdateBridgeOutputResponse.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()}).build();
    private static final SdkField<BridgeOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Output").getter(UpdateBridgeOutputResponse.getter(UpdateBridgeOutputResponse::output)).setter(UpdateBridgeOutputResponse.setter(Builder::output)).constructor(BridgeOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bridgeArn", BRIDGE_ARN_FIELD);
            this.put("output", OUTPUT_FIELD);
        }
    });
    private final String bridgeArn;
    private final BridgeOutput output;

    private UpdateBridgeOutputResponse(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.output = builder.output;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final BridgeOutput output() {
        return this.output;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeOutputResponse)) {
            return false;
        }
        UpdateBridgeOutputResponse other = (UpdateBridgeOutputResponse)((Object)obj);
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && Objects.equals(this.output(), other.output());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBridgeOutputResponse").add("BridgeArn", (Object)this.bridgeArn()).add("Output", (Object)this.output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeOutputResponse, T> g) {
        return obj -> g.apply((UpdateBridgeOutputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String bridgeArn;
        private BridgeOutput output;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeOutputResponse model) {
            super(model);
            this.bridgeArn(model.bridgeArn);
            this.output(model.output);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final BridgeOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(BridgeOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(BridgeOutput output) {
            this.output = output;
            return this;
        }

        @Override
        public UpdateBridgeOutputResponse build() {
            return new UpdateBridgeOutputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBridgeOutputResponse> {
        public Builder bridgeArn(String var1);

        public Builder output(BridgeOutput var1);

        default public Builder output(Consumer<BridgeOutput.Builder> output) {
            return this.output((BridgeOutput)((BridgeOutput.Builder)BridgeOutput.builder().applyMutation(output)).build());
        }
    }
}

