/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeNetworkSourceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddBridgeSourceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddBridgeSourceRequest> {
    private static final SdkField<AddBridgeFlowSourceRequest> FLOW_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowSource").getter(AddBridgeSourceRequest.getter(AddBridgeSourceRequest::flowSource)).setter(AddBridgeSourceRequest.setter(Builder::flowSource)).constructor(AddBridgeFlowSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSource").build()}).build();
    private static final SdkField<AddBridgeNetworkSourceRequest> NETWORK_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkSource").getter(AddBridgeSourceRequest.getter(AddBridgeSourceRequest::networkSource)).setter(AddBridgeSourceRequest.setter(Builder::networkSource)).constructor(AddBridgeNetworkSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_SOURCE_FIELD, NETWORK_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("flowSource", FLOW_SOURCE_FIELD);
            this.put("networkSource", NETWORK_SOURCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AddBridgeFlowSourceRequest flowSource;
    private final AddBridgeNetworkSourceRequest networkSource;

    private AddBridgeSourceRequest(BuilderImpl builder) {
        this.flowSource = builder.flowSource;
        this.networkSource = builder.networkSource;
    }

    public final AddBridgeFlowSourceRequest flowSource() {
        return this.flowSource;
    }

    public final AddBridgeNetworkSourceRequest networkSource() {
        return this.networkSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddBridgeSourceRequest)) {
            return false;
        }
        AddBridgeSourceRequest other = (AddBridgeSourceRequest)obj;
        return Objects.equals(this.flowSource(), other.flowSource()) && Objects.equals(this.networkSource(), other.networkSource());
    }

    public final String toString() {
        return ToString.builder((String)"AddBridgeSourceRequest").add("FlowSource", (Object)this.flowSource()).add("NetworkSource", (Object)this.networkSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowSource": {
                return Optional.ofNullable(clazz.cast(this.flowSource()));
            }
            case "NetworkSource": {
                return Optional.ofNullable(clazz.cast(this.networkSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AddBridgeSourceRequest, T> g) {
        return obj -> g.apply((AddBridgeSourceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AddBridgeFlowSourceRequest flowSource;
        private AddBridgeNetworkSourceRequest networkSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AddBridgeSourceRequest model) {
            this.flowSource(model.flowSource);
            this.networkSource(model.networkSource);
        }

        public final AddBridgeFlowSourceRequest.Builder getFlowSource() {
            return this.flowSource != null ? this.flowSource.toBuilder() : null;
        }

        public final void setFlowSource(AddBridgeFlowSourceRequest.BuilderImpl flowSource) {
            this.flowSource = flowSource != null ? flowSource.build() : null;
        }

        @Override
        public final Builder flowSource(AddBridgeFlowSourceRequest flowSource) {
            this.flowSource = flowSource;
            return this;
        }

        public final AddBridgeNetworkSourceRequest.Builder getNetworkSource() {
            return this.networkSource != null ? this.networkSource.toBuilder() : null;
        }

        public final void setNetworkSource(AddBridgeNetworkSourceRequest.BuilderImpl networkSource) {
            this.networkSource = networkSource != null ? networkSource.build() : null;
        }

        @Override
        public final Builder networkSource(AddBridgeNetworkSourceRequest networkSource) {
            this.networkSource = networkSource;
            return this;
        }

        public AddBridgeSourceRequest build() {
            return new AddBridgeSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddBridgeSourceRequest> {
        public Builder flowSource(AddBridgeFlowSourceRequest var1);

        default public Builder flowSource(Consumer<AddBridgeFlowSourceRequest.Builder> flowSource) {
            return this.flowSource((AddBridgeFlowSourceRequest)((AddBridgeFlowSourceRequest.Builder)AddBridgeFlowSourceRequest.builder().applyMutation(flowSource)).build());
        }

        public Builder networkSource(AddBridgeNetworkSourceRequest var1);

        default public Builder networkSource(Consumer<AddBridgeNetworkSourceRequest.Builder> networkSource) {
            return this.networkSource((AddBridgeNetworkSourceRequest)((AddBridgeNetworkSourceRequest.Builder)AddBridgeNetworkSourceRequest.builder().applyMutation(networkSource)).build());
        }
    }
}

